#!/usr/bin/env python
##########################################################################
# automatically generate html page which lists bugs tagged 'qa-hardy-list'
##########################################################################
import os
import sys
import launchpadbugs.connector as Connector
import commands
import re
import urllib
import getopt

tag = "qa-hardy-list"
title = "QA Hardy Heron Buglist"

def usage():
    print "./qa-hardy-list [options]"
    print "options:"
    print"    --help \"prints this help dialog\""
    print"    --sort=<\"status\"|\"package\"> \"generate list sorted by either status or package; the default is \"status\"\""

Bug = Connector.ConnectBug("TEXT")
htmlfile = "./%s-temp.html" % (tag)
url_sort_by_status = "https://bugs.launchpad.net/ubuntu/+bugs-text?orderby=status&field.tag=%s" % (tag)
url_sort_by_package = "https://bugs.launchpad.net/ubuntu/+bugs-text?orderby=targetname&field.tag=%s" % (tag)
sort = ""
try:
    opts, args = getopt.getopt(sys.argv[1:], "hs:", ["help", "sort="])
    for opt,arg in opts:
        if opt in ("h", "--help"):
            usage()
            sys.exit(1)
        elif opt in ("s", "--sort"):
            sort = arg
except:
    usage()
    sys.exit(1)

if sort == "package":
    url = url_sort_by_package
else:
    url = url_sort_by_status

HTML = open(htmlfile, 'w')

DICT = {}
content = urllib.urlopen(url)
count = 0

#remove duplicate bug id's from the list.
#this happens when a bug is assigned to more than one package
for line in content:
    line = line.strip('\n')
    try:
        if DICT[line]:
            continue
    except KeyError:
            DICT[line] = count
            count += 1

#sort dictionary based on value - this is because we lost the
#ordering of the list when we removed the duplicate bug id's
buglist = sorted(DICT, key=DICT.__getitem__, reverse=False)

html = "<html>\n"
html += "<head>\n"
html += "\t<title>%s</title>\n" % (title)
html += "\t<link defanghtml_rel=\"made\" defanghtml_href=\"mailto:webmaster@ubuntu.com\">\n"
html += "\t<link rel=\"stylesheet\" type=\"text/css\" charset=\"utf-8\" media=\"all\" href=\"http://www.ubuntu.com/htdocs/ubuntuweb/css/common.css\">\n"
html += "\t<link rel=\"stylesheet\" type=\"text/css\" charset=\"utf-8\" media=\"screen\" href=\"http://www.ubuntu.com/htdocs/ubuntuweb/css/screen.css\">\n"
html += "\t<link rel=\"stylesheet\" type=\"text/css\" charset=\"utf-8\" href=\"buglist.css\">\n"
html += "</head>"
html += "<body>\n"
html += "<h3>%s</h3>\n" % (title)

html_table = "<p>\n<table border=1>\n"
html_table += "<tbody><tr>\n"
html_table += "\t<th align=center>Bug</defanghtml_hd>\n"
html_table += "\t<th align=center>Summary</th>\n"
html_table += "\t<th align=center>Source Package(s)</th>\n"
html_table += "\t<th align=center>Importance</th>\n"
html_table += "\t<th align=center>Status</th>\n"
html_table += "\t<th align=center>Assignee</th>\n"
html_table += "</tr>\n"

html += html_table
html_fixed = html_table
html_fixed += "<p></p><h3>Fixed Bugs</h3>"
html_fixed_list = []

for num in buglist:
    try:
        URL = "https://bugs.launchpad.net/bugs/%s" % num
        bug = Bug(url=URL)
        packagelist = list(bug.infotable)
        length = len(packagelist)
        count = 0
        html_row_end = ""
        html_fixed_list = []
        for i in bug.infotable:
            try:
                print "    %s" % (i.affects.longname)
                metric = re.search('\(Ubuntu\)', i.affects.longname)
                if metric == None:
                    print "    Bug %d: %s package not assigned to Ubuntu.  Omitting from the list." % (bug.bugnumber, i.affects.longname)
                    continue

                if i.status == 'Invalid':
                    print "    Bug %d: %s package is marked Invalid.  Omitting from the list." % (bug.bugnumber, i.affects.longname)
                    continue
                elif i.status == 'Fix Released' or i.status == 'Fix Committed':
                    color="#c4ffc4"
                elif i.status == 'In Progress':
                    color="#fffec4"
                else:
                    color=""

                html_row = ""
                targeted_to = (i.targeted_to and " (%s)" %i.targeted_to) or ""
                if count > 0:
                    html_row += "<tr>\n"

                html_row += "\t<td>%s%s</td>\n" % (i.sourcepackage, targeted_to)
                html_row += "\t<td>%s</td>\n" % i.importance
                html_row += "\t<td bgcolor=\"%s\">%s</td>\n" % (color, i.status)
                html_row += "\t<td>%s</td>\n" % i.assignee
                html_row += "</tr>\n"
                html_row_end += html_row

                if i.status == 'Fix Released' or i.status == 'Fix Committed':
                    html_fixed_list.append(html_row)
                count += 1
            except:
                print "    Sorry:", sys.exc_type, ":", sys.exc_value
                print "    Omitting package from the list"

        html_row_start = "<tr>\n"
        html_row_start += "\t<td class=\"first\" rowspan=\"%d\"><a href=\"%s\">%d</a></td>\n" % (count, URL, bug.bugnumber)
        html_row_start += "\t<td rowspan=\"%d\">%s</td>\n" % (count, bug.summary)
        html_row_start += html_row_end
        html += html_row_start

        if len(html_fixed_list) > 0:
            html_fixed += "<tr>\n"
            html_fixed += "\t<td class=\"first\" rowspan=\"%d\"><a href=\"%s\">%d</a></td>\n" % (len(html_fixed_list), URL, bug.bugnumber)
            html_fixed += "\t<td rowspan=\"%d\">%s</td>\n" % (len(html_fixed_list), bug.summary)
            temp = re.match("<tr>(.*)", html_fixed_list[0])

            if temp:
                html_fixed_list[0] = html_fixed_list[0].lstrip("<tr>\n")

            for fixed in html_fixed_list:
                html_fixed += fixed
    except:
        print "    Sorry:", sys.exc_type, ":", sys.exc_value
        print "    Omitting bug from the list"

html += "</tbody></table>\n</p>"
html += html_fixed
html_fixed += "</table>\n</p>"
html += "</tbody></table></p></body></html>\n"
HTML.write(html)
HTML.close()
