""" Testing BugList - run this test with 'python -m testing.test_Buglist' """

import unittest
import launchpadbugs.html_buglist as Buglist


class TestCon(object):
    def __init__(self, f):
        self.text = open(f, "r").read()
        
    def get(self, url):
        class _return(object):
            def __init__(self, t):
                self.text = t
        r = _return(self.text)
        return r
        

# override url-validation function
Buglist.__dict__["utils"].valid_lp_url = lambda a,b: a

bl = Buglist.BugList("test", connection=TestCon("testing/content/bughelper.html"))
        
for b in bl:
    if b == 85152:
        a = b


class _BugListTest(unittest.TestCase):
    
    def testBugList(self):
        self.assertEqual(set(bl) ,
            set([85152, 109547, 90084, 88102, 88521, 81291, 131378, 84723, 110937, 109628, 123933]))
            
    def testBugStatus(self):
        self.assertEqual(a.status, 'Incomplete')
        
    def testBugImportance(self):
        self.assertEqual(a.importance, 'High')

    def testBugImportance(self):
        self.assertEqual(a.url, 'https://bugs.launchpad.net/bughelper/+bug/85152')
        
    def testBugSummary(self):
        self.assertEqual(a.summary, """<op bin="not">Text</op> doesn't exclude bugs containing 'Text'""")
        
    def testBugSourcepackage(self):
        self.assertEqual(a.sourcepackage, None)
        
    def testBugInt(self):
        self.assertEqual(int(a), 85152)
        
    def testBugStr(self):
        self.assertEqual(str(a), '[Bug 85152 : Incomplete/High]')

                
        


if __name__ == '__main__':
    suite = unittest.TestLoader().loadTestsFromTestCase(_BugListTest)
    unittest.TextTestRunner(verbosity=2).run(suite)
