import urllib2
import multipartpost_handler
import utils
import cookielib
import bughelper_error as Error
from tempfile import mkstemp
try:
    import sqlite3 as sqlite
except ImportError:
    try:
        from pysqlite2 import dbapi2 as sqlite
    except ImportError:
        raise ImportError, "no module named sqlite3 or pysqlite2.dbapi2"
import os

from lpconstants import BASEURL

class _result(object):
    def __init__(self, contenttype=None, text=None, url=None):
        assert contenttype or text or url, "at least one argument needed"
        self.contenttype = contenttype
        self.text = text
        self.url = url


class HTTPConnection(object):

    def __init__(self, cookiefile=None, attempts=5, content_types=["text/html","text/plain"]):
        __version = "bughelper/%s (Python-urllib2/%s)" %(utils.find_version_number(),urllib2.__version__)
        self.__cookiefile = cookiefile
        self.__cookie_handler = urllib2.HTTPCookieProcessor()
        self.__opener = urllib2.build_opener()
        self.__opener.addheaders = [('User-agent', __version)]
        self.__poster = urllib2.build_opener(multipartpost_handler.MultipartPostHandler)
        self.__poster.addheaders = [('User-agent', __version)]
        self.__attempts = attempts
        self.content_types = content_types
        self.__baseurl = None
        
    def get_auth(self):
        return self.__cookie_handler
        
    def set_auth(self, auth):
        if isinstance(auth, str):
            self.__cookiefile = auth
            return self._set_cookie_handler()
        elif isinstance(auth, dict):
            try:
                email = auth["email"]
                password = auth["password"]
            except KeyError:
                raise ValueError, "The argument of .set_auth() needs to be either a path to a valid \
mozilla cookie-file or a dict like {'email':<lp-email-address>,'password':<password>}, but it is %s" %auth
            cj = cookielib.CookieJar()
            opener = urllib2.build_opener(urllib2.HTTPCookieProcessor(cj),
                                            multipartpost_handler.MultipartPostHandler)
                                            
            # this is ugly, but AFAIK the only way to get both login-cookies (edge and lp)
            for url in ("https://bugs.launchpad.net/+login","https://bugs.edge.launchpad.net/+login"):
                r = opener.open(url, {"loginpage_email": email,
                                        "loginpage_password": password, "loginpage_submit_login":"Log In"})
            self.__cookie_handler = urllib2.HTTPCookieProcessor(cj)
            return self._cookie_helper()
        else:
            raise ValueError, "The argument of .set_auth() needs to be either a path to a valid \
mozilla cookie-file or a dict like {'email':<lp-email-address>,'password':<password>}, but it is %s" %auth
            
    def _cookie_helper(self):
        for i in [self.__opener, self.__poster]:
            if not True in [isinstance(h,urllib2.HTTPCookieProcessor) for h in i.handlers]:
                i.add_handler(self.__cookie_handler)
        self.__baseurl = None
    
    def _sqlite_to_txt(self, domain):
        match = '%%%s%%' % domain
        con = sqlite.connect(self.__cookiefile)
        cur = con.cursor()
        cur.execute("select host, path, isSecure, expiry, name, value from moz_cookies where host like ?", [match])
        ftstr = ["FALSE","TRUE"]
        (tmp, tmpname) = mkstemp()
        os.write(tmp, "# HTTP Cookie File\n")
        for item in cur.fetchall():
            str = "%s\t%s\t%s\t%s\t%s\t%s\t%s\n" % ( item[0], \
                   ftstr[item[0].startswith('.')], item[1], \
                   ftstr[item[2]], item[3], item[4], item[5])
            os.write(tmp, str)
        os.close(tmp)
        return tmpname
        
    def _set_cookie_handler(self):
        if self.__cookiefile:
            cj = cookielib.MozillaCookieJar()
            if self.__cookiefile[-6:] == "sqlite":
                cookies = self._sqlite_to_txt('launchpad.net')
                try:
                    cj.load(cookies)
                except:
                    os.unlink(cookies)
                    raise IOError, "Invalid cookie file"
                os.unlink(cookies)
            else:
                cj.load(self.__cookiefile)
            self.__cookie_handler = urllib2.HTTPCookieProcessor(cj)
            self._cookie_helper()
            return False
        else:
            raise IOError, "No cookie file given"
            
    def _get_baseurl(self):
        """ returns the redirected baseurl """
        #unfortunately "https://bugs.launchpad.net" is not redirected
        try:
            a = self.__opener.open(BASEURL.BUG_NG + "/+")
            a = a.geturl().rstrip("/+")
        except urllib2.HTTPError, e:
            a = e.geturl().rstrip("/+")
        return a
        
    def get(self, url):
        if not self.__baseurl:
            self.__baseurl = self._get_baseurl()
        url = url.replace(BASEURL.BUG_NG, self.__baseurl)
        return self._safe_urlopen(url, None, False)
        
    def post(self, url, data):
        if not self.__baseurl:
            self.__baseurl = self._get_baseurl()
        url = url.replace(BASEURL.BUG_NG, self.__baseurl)
        return self._safe_urlopen(url, data, True)
        
        
    def _safe_urlopen(self, url, data, post):
        count = 0
        text = None
        contenttype = None
        geturl = None
        sock = None
        if post:
            opener = self.__poster
        else:
            opener = self.__opener
        while count < self.__attempts:
            #print "count: %s, url: %s" %(count,url) #DEBUG
            try:
                if url[:4] != 'http':
                    url_old = url
                    url = 'https://' + url
                    print "wrong url <%s>, try <%s>" %(url_old, url)
                if data:
                    sock = opener.open(url,data)
                else:
                    sock = opener.open(url)
                contenttype = sock.info()["Content-type"]
                if sock.geturl().endswith("+login"):
                    raise Error.LPUrlError("login failed", url)
                for ct in self.content_types:
                    if contenttype.startswith(ct):
                        text = sock.read()
                        geturl = sock.geturl()
                        sock.close()
                        return _result(contenttype=contenttype,text=text, url=geturl)
                sock.close()
                raise IOError, "unsupported contenttype (%s)" %contenttype
            except urllib2.URLError, e:
                try:
                    error = e.code
                except AttributeError, e:
                    error = "unknown error"
                count += 1

        raise Error.LPUrlError(error, url)

