/* test-appinfo-manager.c generated by valac 0.14.2, the Vala compiler
 * generated from test-appinfo-manager.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */
/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <unity-internal.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <config.h>
#include <gobject/gvaluecollector.h>


#define UNITY_TEST_TYPE_APP_INFO_MANAGER_SUITE (unity_test_app_info_manager_suite_get_type ())
#define UNITY_TEST_APP_INFO_MANAGER_SUITE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TEST_TYPE_APP_INFO_MANAGER_SUITE, UnityTestAppInfoManagerSuite))
#define UNITY_TEST_APP_INFO_MANAGER_SUITE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TEST_TYPE_APP_INFO_MANAGER_SUITE, UnityTestAppInfoManagerSuiteClass))
#define UNITY_TEST_IS_APP_INFO_MANAGER_SUITE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TEST_TYPE_APP_INFO_MANAGER_SUITE))
#define UNITY_TEST_IS_APP_INFO_MANAGER_SUITE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TEST_TYPE_APP_INFO_MANAGER_SUITE))
#define UNITY_TEST_APP_INFO_MANAGER_SUITE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TEST_TYPE_APP_INFO_MANAGER_SUITE, UnityTestAppInfoManagerSuiteClass))

typedef struct _UnityTestAppInfoManagerSuite UnityTestAppInfoManagerSuite;
typedef struct _UnityTestAppInfoManagerSuiteClass UnityTestAppInfoManagerSuiteClass;
typedef struct _UnityTestAppInfoManagerSuitePrivate UnityTestAppInfoManagerSuitePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UnityTestAppInfoManagerSuiteDoTestAsyncLookupMissingData UnityTestAppInfoManagerSuiteDoTestAsyncLookupMissingData;
typedef struct _UnityTestAppInfoManagerSuiteDoTestAsyncLookupOkData UnityTestAppInfoManagerSuiteDoTestAsyncLookupOkData;
typedef struct _UnityTestParamSpecAppInfoManagerSuite UnityTestParamSpecAppInfoManagerSuite;

struct _UnityTestAppInfoManagerSuite {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UnityTestAppInfoManagerSuitePrivate * priv;
};

struct _UnityTestAppInfoManagerSuiteClass {
	GTypeClass parent_class;
	void (*finalize) (UnityTestAppInfoManagerSuite *self);
};

struct _UnityTestAppInfoManagerSuiteDoTestAsyncLookupMissingData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GMainLoop* mainloop;
	UnityAppInfoManager* _tmp0_;
	UnityAppInfoManager* manager;
	GAppInfo* _tmp1_;
	GAppInfo* appinfo;
	gint _tmp2_;
	gchar** _tmp3_;
	gint _tmp4_;
	gchar** _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GError* e;
	const gchar* _tmp8_;
	GMainLoop* _tmp9_;
	GError * _inner_error_;
};

struct _UnityTestAppInfoManagerSuiteDoTestAsyncLookupOkData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GMainLoop* mainloop;
	UnityAppInfoManager* _tmp0_;
	UnityAppInfoManager* manager;
	GAppInfo* _tmp1_;
	GAppInfo* info;
	const gchar* _tmp2_;
	GError* e;
	const gchar* _tmp3_;
	gint _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** categories;
	gint categories_length1;
	gint _categories_size_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar** keywords;
	gint keywords_length1;
	gint _keywords_size_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* path;
	GFile* _tmp20_;
	GFile* _tmp21_;
	GFile* _tmp22_;
	GFile* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* abs_path;
	GMainLoop* _tmp26_;
	GError * _inner_error_;
};

struct _UnityTestParamSpecAppInfoManagerSuite {
	GParamSpec parent_instance;
};


static gpointer unity_test_app_info_manager_suite_parent_class = NULL;

gpointer unity_test_app_info_manager_suite_ref (gpointer instance);
void unity_test_app_info_manager_suite_unref (gpointer instance);
GParamSpec* unity_test_param_spec_app_info_manager_suite (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void unity_test_value_set_app_info_manager_suite (GValue* value, gpointer v_object);
void unity_test_value_take_app_info_manager_suite (GValue* value, gpointer v_object);
gpointer unity_test_value_get_app_info_manager_suite (const GValue* value);
GType unity_test_app_info_manager_suite_get_type (void) G_GNUC_CONST;
enum  {
	UNITY_TEST_APP_INFO_MANAGER_SUITE_DUMMY_PROPERTY
};
UnityTestAppInfoManagerSuite* unity_test_app_info_manager_suite_new (void);
UnityTestAppInfoManagerSuite* unity_test_app_info_manager_suite_construct (GType object_type);
void unity_test_app_info_manager_suite_test_allocation (void);
static void _unity_test_app_info_manager_suite_test_allocation_gtest_data_func (gpointer self);
void unity_test_app_info_manager_suite_test_clear_empty (void);
static void _unity_test_app_info_manager_suite_test_clear_empty_gtest_data_func (gpointer self);
void unity_test_app_info_manager_suite_test_sync_lookup_missing (void);
static void _unity_test_app_info_manager_suite_test_sync_lookup_missing_gtest_data_func (gpointer self);
void unity_test_app_info_manager_suite_test_async_lookup_missing (void);
static void _unity_test_app_info_manager_suite_test_async_lookup_missing_gtest_data_func (gpointer self);
void unity_test_app_info_manager_suite_test_sync_lookup_ok (void);
static void _unity_test_app_info_manager_suite_test_sync_lookup_ok_gtest_data_func (gpointer self);
void unity_test_app_info_manager_suite_test_async_lookup_ok (void);
static void _unity_test_app_info_manager_suite_test_async_lookup_ok_gtest_data_func (gpointer self);
void unity_test_app_info_manager_suite_do_test_async_lookup_missing (GMainLoop* mainloop, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_test_app_info_manager_suite_do_test_async_lookup_missing_finish (GAsyncResult* _res_);
static void unity_test_app_info_manager_suite_do_test_async_lookup_missing_data_free (gpointer _data);
static gboolean unity_test_app_info_manager_suite_do_test_async_lookup_missing_co (UnityTestAppInfoManagerSuiteDoTestAsyncLookupMissingData* _data_);
static void unity_test_app_info_manager_suite_do_test_async_lookup_missing_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
void unity_test_app_info_manager_suite_do_test_async_lookup_ok (GMainLoop* mainloop, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_test_app_info_manager_suite_do_test_async_lookup_ok_finish (GAsyncResult* _res_);
static void unity_test_app_info_manager_suite_do_test_async_lookup_ok_data_free (gpointer _data);
static gboolean unity_test_app_info_manager_suite_do_test_async_lookup_ok_co (UnityTestAppInfoManagerSuiteDoTestAsyncLookupOkData* _data_);
static void unity_test_app_info_manager_suite_do_test_async_lookup_ok_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gchar** _vala_array_dup4 (gchar** self, int length);
static void unity_test_app_info_manager_suite_finalize (UnityTestAppInfoManagerSuite* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _unity_test_app_info_manager_suite_test_allocation_gtest_data_func (gpointer self) {
	unity_test_app_info_manager_suite_test_allocation ();
}


static void _unity_test_app_info_manager_suite_test_clear_empty_gtest_data_func (gpointer self) {
	unity_test_app_info_manager_suite_test_clear_empty ();
}


static void _unity_test_app_info_manager_suite_test_sync_lookup_missing_gtest_data_func (gpointer self) {
	unity_test_app_info_manager_suite_test_sync_lookup_missing ();
}


static void _unity_test_app_info_manager_suite_test_async_lookup_missing_gtest_data_func (gpointer self) {
	unity_test_app_info_manager_suite_test_async_lookup_missing ();
}


static void _unity_test_app_info_manager_suite_test_sync_lookup_ok_gtest_data_func (gpointer self) {
	unity_test_app_info_manager_suite_test_sync_lookup_ok ();
}


static void _unity_test_app_info_manager_suite_test_async_lookup_ok_gtest_data_func (gpointer self) {
	unity_test_app_info_manager_suite_test_async_lookup_ok ();
}


UnityTestAppInfoManagerSuite* unity_test_app_info_manager_suite_construct (GType object_type) {
	UnityTestAppInfoManagerSuite* self = NULL;
	self = (UnityTestAppInfoManagerSuite*) g_type_create_instance (object_type);
	g_test_add_data_func ("/Unit/AppInfoManager/Allocation", NULL, _unity_test_app_info_manager_suite_test_allocation_gtest_data_func);
	g_test_add_data_func ("/Unit/AppInfoManager/ClearEmpty", NULL, _unity_test_app_info_manager_suite_test_clear_empty_gtest_data_func);
	g_test_add_data_func ("/Unit/AppInfoManager/SyncLookupMissing", NULL, _unity_test_app_info_manager_suite_test_sync_lookup_missing_gtest_data_func);
	g_test_add_data_func ("/Unit/AppInfoManager/AsyncLookupMissing", NULL, _unity_test_app_info_manager_suite_test_async_lookup_missing_gtest_data_func);
	g_test_add_data_func ("/Unit/AppInfoManager/SyncLookupOk", NULL, _unity_test_app_info_manager_suite_test_sync_lookup_ok_gtest_data_func);
	g_test_add_data_func ("/Unit/AppInfoManager/AsyncLookupOk", NULL, _unity_test_app_info_manager_suite_test_async_lookup_ok_gtest_data_func);
	return self;
}


UnityTestAppInfoManagerSuite* unity_test_app_info_manager_suite_new (void) {
	return unity_test_app_info_manager_suite_construct (UNITY_TEST_TYPE_APP_INFO_MANAGER_SUITE);
}


void unity_test_app_info_manager_suite_test_allocation (void) {
	UnityAppInfoManager* _tmp0_ = NULL;
	UnityAppInfoManager* manager;
	_tmp0_ = unity_app_info_manager_get_default ();
	manager = _tmp0_;
	g_assert (UNITY_IS_APP_INFO_MANAGER (manager));
	_g_object_unref0 (manager);
}


void unity_test_app_info_manager_suite_test_clear_empty (void) {
	UnityAppInfoManager* _tmp0_ = NULL;
	UnityAppInfoManager* manager;
	_tmp0_ = unity_app_info_manager_get_default ();
	manager = _tmp0_;
	unity_app_info_manager_clear (manager);
	unity_app_info_manager_clear (manager);
	_g_object_unref0 (manager);
}


void unity_test_app_info_manager_suite_test_sync_lookup_missing (void) {
	UnityAppInfoManager* _tmp0_ = NULL;
	UnityAppInfoManager* manager;
	GAppInfo* _tmp1_ = NULL;
	GAppInfo* _tmp2_;
	gint _tmp3_ = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gchar** _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	_tmp0_ = unity_app_info_manager_get_default ();
	manager = _tmp0_;
	_tmp1_ = unity_app_info_manager_lookup (manager, "_foobar.desktop");
	_tmp2_ = _tmp1_;
	g_assert (_tmp2_ == NULL);
	_g_object_unref0 (_tmp2_);
	_tmp4_ = unity_app_info_manager_get_categories (manager, "_foobar.desktop", &_tmp3_);
	g_assert (_tmp4_ == NULL);
	_tmp6_ = unity_app_info_manager_get_keywords (manager, "_foobar.desktop", &_tmp5_);
	g_assert (_tmp6_ == NULL);
	_tmp7_ = unity_app_info_manager_get_path (manager, "_foobar.desktop");
	_tmp8_ = _tmp7_;
	g_assert (_tmp8_ == NULL);
	_g_free0 (_tmp8_);
	_g_object_unref0 (manager);
}


void unity_test_app_info_manager_suite_test_async_lookup_missing (void) {
	GMainLoop* _tmp0_;
	GMainLoop* mainloop;
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	mainloop = _tmp0_;
	unity_test_app_info_manager_suite_do_test_async_lookup_missing (mainloop, NULL, NULL);
	g_main_loop_run (mainloop);
	_g_main_loop_unref0 (mainloop);
}


static void unity_test_app_info_manager_suite_do_test_async_lookup_missing_data_free (gpointer _data) {
	UnityTestAppInfoManagerSuiteDoTestAsyncLookupMissingData* _data_;
	_data_ = _data;
	_g_main_loop_unref0 (_data_->mainloop);
	g_slice_free (UnityTestAppInfoManagerSuiteDoTestAsyncLookupMissingData, _data_);
}


static gpointer _g_main_loop_ref0 (gpointer self) {
	return self ? g_main_loop_ref (self) : NULL;
}


void unity_test_app_info_manager_suite_do_test_async_lookup_missing (GMainLoop* mainloop, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityTestAppInfoManagerSuiteDoTestAsyncLookupMissingData* _data_;
	GMainLoop* _tmp0_;
	GMainLoop* _tmp1_;
	_data_ = g_slice_new0 (UnityTestAppInfoManagerSuiteDoTestAsyncLookupMissingData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, unity_test_app_info_manager_suite_do_test_async_lookup_missing);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_test_app_info_manager_suite_do_test_async_lookup_missing_data_free);
	_tmp0_ = mainloop;
	_tmp1_ = _g_main_loop_ref0 (_tmp0_);
	_data_->mainloop = _tmp1_;
	unity_test_app_info_manager_suite_do_test_async_lookup_missing_co (_data_);
}


void unity_test_app_info_manager_suite_do_test_async_lookup_missing_finish (GAsyncResult* _res_) {
	UnityTestAppInfoManagerSuiteDoTestAsyncLookupMissingData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void unity_test_app_info_manager_suite_do_test_async_lookup_missing_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityTestAppInfoManagerSuiteDoTestAsyncLookupMissingData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_test_app_info_manager_suite_do_test_async_lookup_missing_co (_data_);
}


static gboolean unity_test_app_info_manager_suite_do_test_async_lookup_missing_co (UnityTestAppInfoManagerSuiteDoTestAsyncLookupMissingData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = unity_app_info_manager_get_default ();
	_data_->manager = _data_->_tmp0_;
	{
		_data_->_state_ = 1;
		unity_app_info_manager_lookup_async (_data_->manager, "_foobar.desktop", unity_test_app_info_manager_suite_do_test_async_lookup_missing_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = unity_app_info_manager_lookup_finish (_data_->manager, _data_->_res_, &_data_->_inner_error_);
		_data_->appinfo = _data_->_tmp1_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		g_assert (_data_->appinfo == NULL);
		_data_->_tmp2_ = 0;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = unity_app_info_manager_get_categories (_data_->manager, "_foobar.desktop", &_data_->_tmp2_);
		g_assert (_data_->_tmp3_ == NULL);
		_data_->_tmp4_ = 0;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = unity_app_info_manager_get_keywords (_data_->manager, "_foobar.desktop", &_data_->_tmp4_);
		g_assert (_data_->_tmp5_ == NULL);
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = unity_app_info_manager_get_path (_data_->manager, "_foobar.desktop");
		_data_->_tmp7_ = _data_->_tmp6_;
		g_assert (_data_->_tmp7_ == NULL);
		_g_free0 (_data_->_tmp7_);
		_g_object_unref0 (_data_->appinfo);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp8_ = _data_->e->message;
		g_error ("test-appinfo-manager.vala:86: Error reading desktop file: %s", _data_->_tmp8_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->manager);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp9_ = _data_->mainloop;
	g_main_loop_quit (_data_->_tmp9_);
	_g_object_unref0 (_data_->manager);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void unity_test_app_info_manager_suite_test_sync_lookup_ok (void) {
	UnityAppInfoManager* _tmp0_ = NULL;
	UnityAppInfoManager* manager;
	GAppInfo* _tmp1_ = NULL;
	GAppInfo* info;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** categories;
	gint categories_length1;
	gint _categories_size_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_ = 0;
	gchar** _tmp10_ = NULL;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar** keywords;
	gint keywords_length1;
	gint _keywords_size_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* path;
	GFile* _tmp19_ = NULL;
	GFile* _tmp20_;
	GFile* _tmp21_ = NULL;
	GFile* _tmp22_;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_;
	gchar* abs_path;
	_tmp0_ = unity_app_info_manager_get_default ();
	manager = _tmp0_;
	_tmp1_ = unity_app_info_manager_lookup (manager, "ubuntu-about.desktop");
	info = _tmp1_;
	g_assert (info != NULL);
	g_assert (G_IS_APP_INFO (info));
	_tmp2_ = g_app_info_get_name (info);
	g_assert (g_strcmp0 ("About Ubuntu", _tmp2_) == 0);
	_tmp4_ = unity_app_info_manager_get_categories (manager, "ubuntu-about.desktop", &_tmp3_);
	_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup1 (_tmp4_, _tmp3_) : ((gpointer) _tmp4_);
	_tmp5__length1 = _tmp3_;
	categories = _tmp5_;
	categories_length1 = _tmp5__length1;
	_categories_size_ = categories_length1;
	g_assert (categories != NULL);
	g_assert (categories_length1 == 3);
	_tmp6_ = categories[0];
	g_assert (g_strcmp0 (_tmp6_, "GNOME") == 0);
	_tmp7_ = categories[1];
	g_assert (g_strcmp0 (_tmp7_, "Application") == 0);
	_tmp8_ = categories[2];
	g_assert (g_strcmp0 (_tmp8_, "Core") == 0);
	_tmp10_ = unity_app_info_manager_get_keywords (manager, "ubuntu-about.desktop", &_tmp9_);
	_tmp11_ = (_tmp10_ != NULL) ? _vala_array_dup2 (_tmp10_, _tmp9_) : ((gpointer) _tmp10_);
	_tmp11__length1 = _tmp9_;
	keywords = _tmp11_;
	keywords_length1 = _tmp11__length1;
	_keywords_size_ = keywords_length1;
	g_assert (keywords != NULL);
	g_assert (keywords_length1 == 6);
	_tmp12_ = keywords[0];
	g_assert (g_strcmp0 (_tmp12_, "about") == 0);
	_tmp13_ = keywords[1];
	g_assert (g_strcmp0 (_tmp13_, "ubuntu") == 0);
	_tmp14_ = keywords[2];
	g_assert (g_strcmp0 (_tmp14_, "help") == 0);
	_tmp15_ = keywords[3];
	g_assert (g_strcmp0 (_tmp15_, "testkeyword") == 0);
	_tmp16_ = keywords[4];
	g_assert (g_strcmp0 (_tmp16_, "thisisnotthekeywordsyourelookingfor") == 0);
	_tmp17_ = keywords[5];
	g_assert (g_strcmp0 (_tmp17_, "neitheristhis") == 0);
	_tmp18_ = unity_app_info_manager_get_path (manager, "ubuntu-about.desktop");
	path = _tmp18_;
	_tmp19_ = g_file_new_for_path (TESTDIR);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_file_resolve_relative_path (_tmp20_, "data/applications/ubuntu-about.desktop");
	_tmp22_ = _tmp21_;
	_tmp23_ = g_file_get_path (_tmp22_);
	_tmp24_ = _tmp23_;
	_g_object_unref0 (_tmp22_);
	_g_object_unref0 (_tmp20_);
	abs_path = _tmp24_;
	g_assert (g_strcmp0 (path, abs_path) == 0);
	_g_free0 (abs_path);
	_g_free0 (path);
	keywords = (_vala_array_free (keywords, keywords_length1, (GDestroyNotify) g_free), NULL);
	categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (info);
	_g_object_unref0 (manager);
}


void unity_test_app_info_manager_suite_test_async_lookup_ok (void) {
	GMainLoop* _tmp0_;
	GMainLoop* mainloop;
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	mainloop = _tmp0_;
	unity_test_app_info_manager_suite_do_test_async_lookup_ok (mainloop, NULL, NULL);
	g_main_loop_run (mainloop);
	_g_main_loop_unref0 (mainloop);
}


static void unity_test_app_info_manager_suite_do_test_async_lookup_ok_data_free (gpointer _data) {
	UnityTestAppInfoManagerSuiteDoTestAsyncLookupOkData* _data_;
	_data_ = _data;
	_g_main_loop_unref0 (_data_->mainloop);
	g_slice_free (UnityTestAppInfoManagerSuiteDoTestAsyncLookupOkData, _data_);
}


void unity_test_app_info_manager_suite_do_test_async_lookup_ok (GMainLoop* mainloop, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityTestAppInfoManagerSuiteDoTestAsyncLookupOkData* _data_;
	GMainLoop* _tmp0_;
	GMainLoop* _tmp1_;
	_data_ = g_slice_new0 (UnityTestAppInfoManagerSuiteDoTestAsyncLookupOkData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, unity_test_app_info_manager_suite_do_test_async_lookup_ok);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_test_app_info_manager_suite_do_test_async_lookup_ok_data_free);
	_tmp0_ = mainloop;
	_tmp1_ = _g_main_loop_ref0 (_tmp0_);
	_data_->mainloop = _tmp1_;
	unity_test_app_info_manager_suite_do_test_async_lookup_ok_co (_data_);
}


void unity_test_app_info_manager_suite_do_test_async_lookup_ok_finish (GAsyncResult* _res_) {
	UnityTestAppInfoManagerSuiteDoTestAsyncLookupOkData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void unity_test_app_info_manager_suite_do_test_async_lookup_ok_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityTestAppInfoManagerSuiteDoTestAsyncLookupOkData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_test_app_info_manager_suite_do_test_async_lookup_ok_co (_data_);
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gboolean unity_test_app_info_manager_suite_do_test_async_lookup_ok_co (UnityTestAppInfoManagerSuiteDoTestAsyncLookupOkData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = unity_app_info_manager_get_default ();
	_data_->manager = _data_->_tmp0_;
	{
		_data_->_state_ = 1;
		unity_app_info_manager_lookup_async (_data_->manager, "ubuntu-about.desktop", unity_test_app_info_manager_suite_do_test_async_lookup_ok_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = unity_app_info_manager_lookup_finish (_data_->manager, _data_->_res_, &_data_->_inner_error_);
		_data_->info = _data_->_tmp1_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		g_assert (G_IS_APP_INFO (_data_->info));
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = g_app_info_get_name (_data_->info);
		g_assert (g_strcmp0 ("About Ubuntu", _data_->_tmp2_) == 0);
		_g_object_unref0 (_data_->info);
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp3_ = _data_->e->message;
		g_error ("test-appinfo-manager.vala:140: Error reading desktop file: %s", _data_->_tmp3_);
		_g_error_free0 (_data_->e);
	}
	__finally1:
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->manager);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp4_ = 0;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = unity_app_info_manager_get_categories (_data_->manager, "ubuntu-about.desktop", &_data_->_tmp4_);
	_data_->_tmp6_ = (_data_->_tmp5_ != NULL) ? _vala_array_dup3 (_data_->_tmp5_, _data_->_tmp4_) : ((gpointer) _data_->_tmp5_);
	_data_->_tmp6__length1 = _data_->_tmp4_;
	_data_->categories = _data_->_tmp6_;
	_data_->categories_length1 = _data_->_tmp6__length1;
	_data_->_categories_size_ = _data_->categories_length1;
	g_assert (_data_->categories != NULL);
	g_assert (_data_->categories_length1 == 3);
	_data_->_tmp7_ = _data_->categories[0];
	g_assert (g_strcmp0 (_data_->_tmp7_, "GNOME") == 0);
	_data_->_tmp8_ = _data_->categories[1];
	g_assert (g_strcmp0 (_data_->_tmp8_, "Application") == 0);
	_data_->_tmp9_ = _data_->categories[2];
	g_assert (g_strcmp0 (_data_->_tmp9_, "Core") == 0);
	_data_->_tmp10_ = 0;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = unity_app_info_manager_get_keywords (_data_->manager, "ubuntu-about.desktop", &_data_->_tmp10_);
	_data_->_tmp12_ = (_data_->_tmp11_ != NULL) ? _vala_array_dup4 (_data_->_tmp11_, _data_->_tmp10_) : ((gpointer) _data_->_tmp11_);
	_data_->_tmp12__length1 = _data_->_tmp10_;
	_data_->keywords = _data_->_tmp12_;
	_data_->keywords_length1 = _data_->_tmp12__length1;
	_data_->_keywords_size_ = _data_->keywords_length1;
	g_assert (_data_->keywords != NULL);
	g_assert (_data_->keywords_length1 == 6);
	_data_->_tmp13_ = _data_->keywords[0];
	g_assert (g_strcmp0 (_data_->_tmp13_, "about") == 0);
	_data_->_tmp14_ = _data_->keywords[1];
	g_assert (g_strcmp0 (_data_->_tmp14_, "ubuntu") == 0);
	_data_->_tmp15_ = _data_->keywords[2];
	g_assert (g_strcmp0 (_data_->_tmp15_, "help") == 0);
	_data_->_tmp16_ = _data_->keywords[3];
	g_assert (g_strcmp0 (_data_->_tmp16_, "testkeyword") == 0);
	_data_->_tmp17_ = _data_->keywords[4];
	g_assert (g_strcmp0 (_data_->_tmp17_, "thisisnotthekeywordsyourelookingfor") == 0);
	_data_->_tmp18_ = _data_->keywords[5];
	g_assert (g_strcmp0 (_data_->_tmp18_, "neitheristhis") == 0);
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = unity_app_info_manager_get_path (_data_->manager, "ubuntu-about.desktop");
	_data_->path = _data_->_tmp19_;
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = g_file_new_for_path (TESTDIR);
	_data_->_tmp21_ = _data_->_tmp20_;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = g_file_resolve_relative_path (_data_->_tmp21_, "data/applications/ubuntu-about.desktop");
	_data_->_tmp23_ = _data_->_tmp22_;
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = g_file_get_path (_data_->_tmp23_);
	_data_->_tmp25_ = _data_->_tmp24_;
	_g_object_unref0 (_data_->_tmp23_);
	_g_object_unref0 (_data_->_tmp21_);
	_data_->abs_path = _data_->_tmp25_;
	g_assert (g_strcmp0 (_data_->path, _data_->abs_path) == 0);
	_data_->_tmp26_ = _data_->mainloop;
	g_main_loop_quit (_data_->_tmp26_);
	_g_free0 (_data_->abs_path);
	_g_free0 (_data_->path);
	_data_->keywords = (_vala_array_free (_data_->keywords, _data_->keywords_length1, (GDestroyNotify) g_free), NULL);
	_data_->categories = (_vala_array_free (_data_->categories, _data_->categories_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->manager);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_test_value_app_info_manager_suite_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void unity_test_value_app_info_manager_suite_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		unity_test_app_info_manager_suite_unref (value->data[0].v_pointer);
	}
}


static void unity_test_value_app_info_manager_suite_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = unity_test_app_info_manager_suite_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer unity_test_value_app_info_manager_suite_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* unity_test_value_app_info_manager_suite_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		UnityTestAppInfoManagerSuite* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = unity_test_app_info_manager_suite_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* unity_test_value_app_info_manager_suite_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UnityTestAppInfoManagerSuite** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = unity_test_app_info_manager_suite_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* unity_test_param_spec_app_info_manager_suite (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	UnityTestParamSpecAppInfoManagerSuite* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UNITY_TEST_TYPE_APP_INFO_MANAGER_SUITE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer unity_test_value_get_app_info_manager_suite (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_TEST_TYPE_APP_INFO_MANAGER_SUITE), NULL);
	return value->data[0].v_pointer;
}


void unity_test_value_set_app_info_manager_suite (GValue* value, gpointer v_object) {
	UnityTestAppInfoManagerSuite* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_TEST_TYPE_APP_INFO_MANAGER_SUITE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_TEST_TYPE_APP_INFO_MANAGER_SUITE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		unity_test_app_info_manager_suite_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_test_app_info_manager_suite_unref (old);
	}
}


void unity_test_value_take_app_info_manager_suite (GValue* value, gpointer v_object) {
	UnityTestAppInfoManagerSuite* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_TEST_TYPE_APP_INFO_MANAGER_SUITE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_TEST_TYPE_APP_INFO_MANAGER_SUITE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_test_app_info_manager_suite_unref (old);
	}
}


static void unity_test_app_info_manager_suite_class_init (UnityTestAppInfoManagerSuiteClass * klass) {
	unity_test_app_info_manager_suite_parent_class = g_type_class_peek_parent (klass);
	UNITY_TEST_APP_INFO_MANAGER_SUITE_CLASS (klass)->finalize = unity_test_app_info_manager_suite_finalize;
}


static void unity_test_app_info_manager_suite_instance_init (UnityTestAppInfoManagerSuite * self) {
	self->ref_count = 1;
}


static void unity_test_app_info_manager_suite_finalize (UnityTestAppInfoManagerSuite* obj) {
	UnityTestAppInfoManagerSuite * self;
	self = UNITY_TEST_APP_INFO_MANAGER_SUITE (obj);
}


GType unity_test_app_info_manager_suite_get_type (void) {
	static volatile gsize unity_test_app_info_manager_suite_type_id__volatile = 0;
	if (g_once_init_enter (&unity_test_app_info_manager_suite_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { unity_test_value_app_info_manager_suite_init, unity_test_value_app_info_manager_suite_free_value, unity_test_value_app_info_manager_suite_copy_value, unity_test_value_app_info_manager_suite_peek_pointer, "p", unity_test_value_app_info_manager_suite_collect_value, "p", unity_test_value_app_info_manager_suite_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UnityTestAppInfoManagerSuiteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_test_app_info_manager_suite_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityTestAppInfoManagerSuite), 0, (GInstanceInitFunc) unity_test_app_info_manager_suite_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType unity_test_app_info_manager_suite_type_id;
		unity_test_app_info_manager_suite_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UnityTestAppInfoManagerSuite", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&unity_test_app_info_manager_suite_type_id__volatile, unity_test_app_info_manager_suite_type_id);
	}
	return unity_test_app_info_manager_suite_type_id__volatile;
}


gpointer unity_test_app_info_manager_suite_ref (gpointer instance) {
	UnityTestAppInfoManagerSuite* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void unity_test_app_info_manager_suite_unref (gpointer instance) {
	UnityTestAppInfoManagerSuite* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UNITY_TEST_APP_INFO_MANAGER_SUITE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



