/* unity-launcher.c generated by valac 0.14.2, the Vala compiler
 * generated from unity-launcher.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */
/*
 * IMPLEMENTATION NOTE:
 * We want the generated C API to be nice and not too Vala-ish. We must
 * anticipate that libunity consumers will be written in both Vala , C,
 * and through GObject Introspection
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "unity.h"
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <libdbusmenu-glib/client.h>
#include <libdbusmenu-glib/dbusmenu-glib.h>
#include <libdbusmenu-glib/enum-types.h>
#include <libdbusmenu-glib/menuitem-proxy.h>
#include <libdbusmenu-glib/menuitem.h>
#include <libdbusmenu-glib/server.h>
#include <libdbusmenu-glib/types.h>
#include <dee.h>


#define UNITY_TYPE_LAUNCHER_ENTRY_DBUS_IMPL (unity_launcher_entry_dbus_impl_get_type ())
#define UNITY_LAUNCHER_ENTRY_DBUS_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_LAUNCHER_ENTRY_DBUS_IMPL, UnityLauncherEntryDBusImpl))
#define UNITY_LAUNCHER_ENTRY_DBUS_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_LAUNCHER_ENTRY_DBUS_IMPL, UnityLauncherEntryDBusImplClass))
#define UNITY_IS_LAUNCHER_ENTRY_DBUS_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_LAUNCHER_ENTRY_DBUS_IMPL))
#define UNITY_IS_LAUNCHER_ENTRY_DBUS_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_LAUNCHER_ENTRY_DBUS_IMPL))
#define UNITY_LAUNCHER_ENTRY_DBUS_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_LAUNCHER_ENTRY_DBUS_IMPL, UnityLauncherEntryDBusImplClass))

typedef struct _UnityLauncherEntryDBusImpl UnityLauncherEntryDBusImpl;
typedef struct _UnityLauncherEntryDBusImplClass UnityLauncherEntryDBusImplClass;
typedef struct _UnityLauncherEntryDBusImplPrivate UnityLauncherEntryDBusImplPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))

struct _UnityLauncherEntryDBusImpl {
	GObject parent_instance;
	UnityLauncherEntryDBusImplPrivate * priv;
	UnityLauncherEntry* owner;
};

struct _UnityLauncherEntryDBusImplClass {
	GObjectClass parent_class;
};

struct _UnityLauncherEntryPrivate {
	gchar* _app_uri;
	gint64 _count;
	gboolean _count_visible;
	gdouble _progress;
	gboolean _progress_visible;
	gboolean _urgent;
	DbusmenuMenuitem* _quicklist;
	GHashTable* _queued_properties;
	DbusmenuServer* _quicklist_server;
	guint _property_source_id;
	GDBusConnection* _bus;
	UnityLauncherEntryDBusImpl* _dbus_impl;
};

struct _UnityLauncherFavoritesPrivate {
	GSettings* settings;
	GHashTable* fav_cache;
	gchar** fav_list;
	gint fav_list_length1;
	gint _fav_list_size_;
};


static gpointer unity_launcher_entry_dbus_impl_parent_class = NULL;
static gpointer unity_launcher_entry_parent_class = NULL;
static GHashTable* unity_launcher_entry_global_entries_map;
static GHashTable* unity_launcher_entry_global_entries_map = NULL;
static DeeSerializableIface* unity_launcher_entry_dee_serializable_parent_iface = NULL;
static gpointer unity_launcher_favorites_parent_class = NULL;
static UnityLauncherFavorites* unity_launcher_favorites_singleton;
static UnityLauncherFavorites* unity_launcher_favorites_singleton = NULL;

GType unity_launcher_entry_dbus_impl_get_type (void) G_GNUC_CONST;
guint unity_launcher_entry_dbus_impl_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
enum  {
	UNITY_LAUNCHER_ENTRY_DBUS_IMPL_DUMMY_PROPERTY
};
UnityLauncherEntryDBusImpl* unity_launcher_entry_dbus_impl_new (GDBusConnection* conn, const char* object_path, UnityLauncherEntry* owner);
UnityLauncherEntryDBusImpl* unity_launcher_entry_dbus_impl_construct (GType object_type, GDBusConnection* conn, const char* object_path, UnityLauncherEntry* owner);
GHashTable* unity_launcher_entry_dbus_impl_query (UnityLauncherEntryDBusImpl* self);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
GHashTable* unity_collect_launcher_entry_properties (UnityLauncherEntry* l);
static void g_cclosure_user_marshal_VOID__STRING_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void unity_launcher_entry_dbus_impl_finalize (GObject* obj);
static void _dbus_unity_launcher_entry_dbus_impl_query (UnityLauncherEntryDBusImpl* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void unity_launcher_entry_dbus_impl_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* unity_launcher_entry_dbus_impl_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean unity_launcher_entry_dbus_impl_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_unity_launcher_entry_dbus_impl_update (GObject* _sender, const gchar* app_uri, GHashTable* properties, gpointer* _data);
static void _unity_launcher_entry_dbus_impl_unregister_object (gpointer user_data);
#define UNITY_LAUNCHER_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_LAUNCHER_ENTRY, UnityLauncherEntryPrivate))
enum  {
	UNITY_LAUNCHER_ENTRY_DUMMY_PROPERTY,
	UNITY_LAUNCHER_ENTRY_APP_URI,
	UNITY_LAUNCHER_ENTRY_COUNT,
	UNITY_LAUNCHER_ENTRY_COUNT_VISIBLE,
	UNITY_LAUNCHER_ENTRY_PROGRESS,
	UNITY_LAUNCHER_ENTRY_PROGRESS_VISIBLE,
	UNITY_LAUNCHER_ENTRY_URGENT,
	UNITY_LAUNCHER_ENTRY_QUICKLIST
};
static UnityLauncherEntry* unity_launcher_entry_new (const gchar* app_uri);
static UnityLauncherEntry* unity_launcher_entry_construct (GType object_type, const gchar* app_uri);
static void _g_object_unref0_ (gpointer var);
static GVariant* unity_launcher_entry_real_serialize (DeeSerializable* base);
static GVariant* _variant_new1 (GHashTable* value);
static GObject* unity_launcher_entry_parse_serializable (GVariant* data);
static void unity_launcher_entry_queue_property_notification (UnityLauncherEntry* self, GObject* _self_, GParamSpec* pspec);
static GVariant* _variant_new2 (gint64 value);
static GVariant* _variant_new3 (gboolean value);
static GVariant* _variant_new4 (gdouble value);
static GVariant* _variant_new5 (gboolean value);
static GVariant* _variant_new6 (gboolean value);
static GVariant* _variant_new7 (const gchar* value);
static GVariant* _variant_new8 (const gchar* value);
static gboolean unity_launcher_entry_dispatch_property_notification (UnityLauncherEntry* self);
static gboolean _unity_launcher_entry_dispatch_property_notification_gsource_func (gpointer self);
static void unity_launcher_entry_on_unity_running_changed (UnityLauncherEntry* self, GObject* _inspector, GParamSpec* pspec);
static GObject * unity_launcher_entry_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _unity_launcher_entry_on_unity_running_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _unity_launcher_entry_queue_property_notification_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static GObject* _unity_launcher_entry_parse_serializable_dee_serializable_parse_func (GVariant* data);
static void unity_launcher_entry_finalize (GObject* obj);
static void _vala_unity_launcher_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_launcher_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static GVariant* _variant_new9 (gint64 value);
static GVariant* _variant_new10 (gboolean value);
static GVariant* _variant_new11 (gdouble value);
static GVariant* _variant_new12 (gboolean value);
static GVariant* _variant_new13 (gboolean value);
static GVariant* _variant_new14 (const char* value);
#define UNITY_LAUNCHER_FAVORITES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_LAUNCHER_FAVORITES, UnityLauncherFavoritesPrivate))
enum  {
	UNITY_LAUNCHER_FAVORITES_DUMMY_PROPERTY
};
static UnityLauncherFavorites* unity_launcher_favorites_new (void);
static UnityLauncherFavorites* unity_launcher_favorites_construct (GType object_type);
static void unity_launcher_favorites_reset_fav_cache (UnityLauncherFavorites* self);
static void _unity_launcher_favorites_reset_fav_cache_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static gchar** _vala_array_dup3 (gchar** self, int length);
static void unity_launcher_favorites_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GDBusArgInfo _unity_launcher_entry_dbus_impl_dbus_arg_info_query_result = {-1, "result", "a{sv}"};
static const GDBusArgInfo * const _unity_launcher_entry_dbus_impl_dbus_arg_info_query_in[] = {NULL};
static const GDBusArgInfo * const _unity_launcher_entry_dbus_impl_dbus_arg_info_query_out[] = {&_unity_launcher_entry_dbus_impl_dbus_arg_info_query_result, NULL};
static const GDBusMethodInfo _unity_launcher_entry_dbus_impl_dbus_method_info_query = {-1, "Query", (GDBusArgInfo **) (&_unity_launcher_entry_dbus_impl_dbus_arg_info_query_in), (GDBusArgInfo **) (&_unity_launcher_entry_dbus_impl_dbus_arg_info_query_out)};
static const GDBusMethodInfo * const _unity_launcher_entry_dbus_impl_dbus_method_info[] = {&_unity_launcher_entry_dbus_impl_dbus_method_info_query, NULL};
static const GDBusArgInfo _unity_launcher_entry_dbus_impl_dbus_arg_info_update_app_uri = {-1, "app_uri", "s"};
static const GDBusArgInfo _unity_launcher_entry_dbus_impl_dbus_arg_info_update_properties = {-1, "properties", "a{sv}"};
static const GDBusArgInfo * const _unity_launcher_entry_dbus_impl_dbus_arg_info_update[] = {&_unity_launcher_entry_dbus_impl_dbus_arg_info_update_app_uri, &_unity_launcher_entry_dbus_impl_dbus_arg_info_update_properties, NULL};
static const GDBusSignalInfo _unity_launcher_entry_dbus_impl_dbus_signal_info_update = {-1, "Update", (GDBusArgInfo **) (&_unity_launcher_entry_dbus_impl_dbus_arg_info_update)};
static const GDBusSignalInfo * const _unity_launcher_entry_dbus_impl_dbus_signal_info[] = {&_unity_launcher_entry_dbus_impl_dbus_signal_info_update, NULL};
static const GDBusPropertyInfo * const _unity_launcher_entry_dbus_impl_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _unity_launcher_entry_dbus_impl_dbus_interface_info = {-1, "com.canonical.Unity.LauncherEntry", (GDBusMethodInfo **) (&_unity_launcher_entry_dbus_impl_dbus_method_info), (GDBusSignalInfo **) (&_unity_launcher_entry_dbus_impl_dbus_signal_info), (GDBusPropertyInfo **) (&_unity_launcher_entry_dbus_impl_dbus_property_info)};
static const GDBusInterfaceVTable _unity_launcher_entry_dbus_impl_dbus_interface_vtable = {unity_launcher_entry_dbus_impl_dbus_interface_method_call, unity_launcher_entry_dbus_impl_dbus_interface_get_property, unity_launcher_entry_dbus_impl_dbus_interface_set_property};

UnityLauncherEntryDBusImpl* unity_launcher_entry_dbus_impl_construct (GType object_type, GDBusConnection* conn, const char* object_path, UnityLauncherEntry* owner) {
	UnityLauncherEntryDBusImpl * self = NULL;
	UnityLauncherEntry* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (conn != NULL, NULL);
	g_return_val_if_fail (object_path != NULL, NULL);
	g_return_val_if_fail (owner != NULL, NULL);
	self = (UnityLauncherEntryDBusImpl*) g_object_new (object_type, NULL);
	{
		GDBusConnection* _tmp0_;
		const char* _tmp1_;
		_tmp0_ = conn;
		_tmp1_ = object_path;
		unity_launcher_entry_dbus_impl_register_object (self, _tmp0_, (const gchar*) _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch14_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	goto __finally14;
	__catch14_g_io_error:
	{
		GError* e = NULL;
		const char* _tmp2_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = object_path;
		g_warning ("Unable to connecto to session bus. Unable to control " "LauncherEntry for %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally14:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp3_ = owner;
	self->owner = _tmp3_;
	return self;
}


UnityLauncherEntryDBusImpl* unity_launcher_entry_dbus_impl_new (GDBusConnection* conn, const char* object_path, UnityLauncherEntry* owner) {
	return unity_launcher_entry_dbus_impl_construct (UNITY_TYPE_LAUNCHER_ENTRY_DBUS_IMPL, conn, object_path, owner);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


GHashTable* unity_launcher_entry_dbus_impl_query (UnityLauncherEntryDBusImpl* self) {
	GHashTable* result = NULL;
	UnityLauncherEntry* _tmp0_;
	UnityLauncherEntry* _tmp4_;
	GHashTable* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->owner;
	if (_tmp0_ == NULL) {
		GHashFunc _tmp1_;
		GEqualFunc _tmp2_;
		GHashTable* _tmp3_;
		_tmp1_ = g_str_hash;
		_tmp2_ = g_str_equal;
		_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_variant_unref0_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->owner;
	_tmp5_ = unity_collect_launcher_entry_properties (_tmp4_);
	result = _tmp5_;
	return result;
}


static void g_cclosure_user_marshal_VOID__STRING_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_BOXED) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boxed (param_values + 2), data2);
}


static void unity_launcher_entry_dbus_impl_class_init (UnityLauncherEntryDBusImplClass * klass) {
	unity_launcher_entry_dbus_impl_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = unity_launcher_entry_dbus_impl_finalize;
	g_signal_new ("update", UNITY_TYPE_LAUNCHER_ENTRY_DBUS_IMPL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOXED, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_HASH_TABLE);
}


static void unity_launcher_entry_dbus_impl_instance_init (UnityLauncherEntryDBusImpl * self) {
}


static void unity_launcher_entry_dbus_impl_finalize (GObject* obj) {
	UnityLauncherEntryDBusImpl * self;
	self = UNITY_LAUNCHER_ENTRY_DBUS_IMPL (obj);
	G_OBJECT_CLASS (unity_launcher_entry_dbus_impl_parent_class)->finalize (obj);
}


GType unity_launcher_entry_dbus_impl_get_type (void) {
	static volatile gsize unity_launcher_entry_dbus_impl_type_id__volatile = 0;
	if (g_once_init_enter (&unity_launcher_entry_dbus_impl_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityLauncherEntryDBusImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_launcher_entry_dbus_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityLauncherEntryDBusImpl), 0, (GInstanceInitFunc) unity_launcher_entry_dbus_impl_instance_init, NULL };
		GType unity_launcher_entry_dbus_impl_type_id;
		unity_launcher_entry_dbus_impl_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityLauncherEntryDBusImpl", &g_define_type_info, 0);
		g_type_set_qdata (unity_launcher_entry_dbus_impl_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) unity_launcher_entry_dbus_impl_register_object);
		g_once_init_leave (&unity_launcher_entry_dbus_impl_type_id__volatile, unity_launcher_entry_dbus_impl_type_id);
	}
	return unity_launcher_entry_dbus_impl_type_id__volatile;
}


static void _dbus_unity_launcher_entry_dbus_impl_query (UnityLauncherEntryDBusImpl* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GHashTable* result;
	GVariantBuilder _tmp0_;
	GHashTableIter _tmp1_;
	gpointer _tmp2_;
	gpointer _tmp3_;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = unity_launcher_entry_dbus_impl_query (self);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_hash_table_iter_init (&_tmp1_, result);
	g_variant_builder_init (&_tmp0_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp1_, &_tmp2_, &_tmp3_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp2_;
		_value = (GVariant*) _tmp3_;
		g_variant_builder_add (&_tmp0_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp0_));
	_g_hash_table_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void unity_launcher_entry_dbus_impl_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Query") == 0) {
		_dbus_unity_launcher_entry_dbus_impl_query (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* unity_launcher_entry_dbus_impl_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean unity_launcher_entry_dbus_impl_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_unity_launcher_entry_dbus_impl_update (GObject* _sender, const gchar* app_uri, GHashTable* properties, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp4_;
	GHashTableIter _tmp5_;
	gpointer _tmp6_;
	gpointer _tmp7_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (app_uri));
	g_hash_table_iter_init (&_tmp5_, properties);
	g_variant_builder_init (&_tmp4_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp5_, &_tmp6_, &_tmp7_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp6_;
		_value = (GVariant*) _tmp7_;
		g_variant_builder_add (&_tmp4_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp4_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.canonical.Unity.LauncherEntry", "Update", _arguments, NULL);
}


guint unity_launcher_entry_dbus_impl_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_unity_launcher_entry_dbus_impl_dbus_interface_info), &_unity_launcher_entry_dbus_impl_dbus_interface_vtable, data, _unity_launcher_entry_dbus_impl_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "update", (GCallback) _dbus_unity_launcher_entry_dbus_impl_update, data);
	return result;
}


static void _unity_launcher_entry_dbus_impl_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_unity_launcher_entry_dbus_impl_update, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


/**
     * Create a new LauncherEntry for the desktop file id of your application.
     *
     * This constructor is private because consumers should create instances
     * via the static getter methods on this class to avoid duplicate entries
     * for the same application.
     *
     * The desktop file id is defined as the basename of your application's
     * .desktop file (including the extension), eg. myapp.desktop.
     */
static UnityLauncherEntry* unity_launcher_entry_construct (GType object_type, const gchar* app_uri) {
	UnityLauncherEntry * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (app_uri != NULL, NULL);
	_tmp0_ = app_uri;
	self = (UnityLauncherEntry*) g_object_new (object_type, "app-uri", _tmp0_, NULL);
	return self;
}


static UnityLauncherEntry* unity_launcher_entry_new (const gchar* app_uri) {
	return unity_launcher_entry_construct (UNITY_TYPE_LAUNCHER_ENTRY, app_uri);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


UnityLauncherEntry* unity_launcher_entry_get_for_app_uri (const gchar* app_uri) {
	UnityLauncherEntry* result = NULL;
	GHashTable* _tmp0_;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	gconstpointer _tmp6_ = NULL;
	UnityLauncherEntry* _tmp7_;
	UnityLauncherEntry* entry;
	UnityLauncherEntry* _tmp8_;
	const gchar* _tmp9_;
	UnityLauncherEntry* _tmp10_;
	GHashTable* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	UnityLauncherEntry* _tmp14_;
	UnityLauncherEntry* _tmp15_;
	g_return_val_if_fail (app_uri != NULL, NULL);
	_tmp0_ = unity_launcher_entry_global_entries_map;
	if (_tmp0_ == NULL) {
		GHashFunc _tmp1_;
		GEqualFunc _tmp2_;
		GHashTable* _tmp3_;
		_tmp1_ = g_str_hash;
		_tmp2_ = g_str_equal;
		_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_object_unref0_);
		_g_hash_table_unref0 (unity_launcher_entry_global_entries_map);
		unity_launcher_entry_global_entries_map = _tmp3_;
	}
	_tmp4_ = unity_launcher_entry_global_entries_map;
	_tmp5_ = app_uri;
	_tmp6_ = g_hash_table_lookup (_tmp4_, _tmp5_);
	_tmp7_ = _g_object_ref0 ((UnityLauncherEntry*) _tmp6_);
	entry = _tmp7_;
	_tmp8_ = entry;
	if (_tmp8_ != NULL) {
		result = entry;
		return result;
	}
	_tmp9_ = app_uri;
	_tmp10_ = unity_launcher_entry_new (_tmp9_);
	_g_object_unref0 (entry);
	entry = _tmp10_;
	_tmp11_ = unity_launcher_entry_global_entries_map;
	_tmp12_ = app_uri;
	_tmp13_ = g_strdup (_tmp12_);
	_tmp14_ = entry;
	_tmp15_ = _g_object_ref0 (_tmp14_);
	g_hash_table_insert (_tmp11_, _tmp13_, _tmp15_);
	result = entry;
	return result;
}


UnityLauncherEntry* unity_launcher_entry_get_for_desktop_id (const gchar* desktop_id) {
	UnityLauncherEntry* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	UnityLauncherEntry* _tmp3_ = NULL;
	UnityLauncherEntry* _tmp4_;
	g_return_val_if_fail (desktop_id != NULL, NULL);
	_tmp0_ = desktop_id;
	_tmp1_ = g_strconcat ("application://", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = unity_launcher_entry_get_for_app_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}


UnityLauncherEntry* unity_launcher_entry_get_for_desktop_file (const gchar* desktop_file) {
	UnityLauncherEntry* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	UnityLauncherEntry* _tmp3_ = NULL;
	UnityLauncherEntry* _tmp4_;
	g_return_val_if_fail (desktop_file != NULL, NULL);
	_tmp0_ = desktop_file;
	_tmp1_ = g_path_get_basename (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = unity_launcher_entry_get_for_desktop_id (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}


static GVariant* _variant_new1 (GHashTable* value) {
	GVariantBuilder _tmp1_;
	GHashTableIter _tmp2_;
	gpointer _tmp3_;
	gpointer _tmp4_;
	g_hash_table_iter_init (&_tmp2_, value);
	g_variant_builder_init (&_tmp1_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp2_, &_tmp3_, &_tmp4_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp3_;
		_value = (GVariant*) _tmp4_;
		g_variant_builder_add (&_tmp1_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp1_));
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static GVariant* unity_launcher_entry_real_serialize (DeeSerializable* base) {
	UnityLauncherEntry * self;
	GVariant* result = NULL;
	GHashTable* _tmp0_ = NULL;
	GVariant* _tmp5_;
	GVariant* props;
	const gchar* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	GVariant* _app_uri;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	GVariant** _tmp11_ = NULL;
	GVariant** _tmp12_;
	gint _tmp12__length1;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	GVariant* _tmp15_;
	self = (UnityLauncherEntry*) base;
	_tmp0_ = unity_collect_launcher_entry_properties (self);
	_tmp5_ = _variant_new1 (_tmp0_);
	props = _tmp5_;
	_tmp6_ = self->priv->_app_uri;
	_tmp7_ = g_variant_new_string (_tmp6_);
	_tmp8_ = g_variant_ref_sink (_tmp7_);
	_app_uri = _tmp8_;
	_tmp9_ = _g_variant_ref0 (_app_uri);
	_tmp10_ = _g_variant_ref0 (props);
	_tmp11_ = g_new0 (GVariant*, 2 + 1);
	_tmp11_[0] = _tmp9_;
	_tmp11_[1] = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 2;
	_tmp13_ = g_variant_new_tuple (_tmp12_, 2);
	_tmp14_ = g_variant_ref_sink (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_variant_unref), NULL);
	result = _tmp15_;
	_g_variant_unref0 (_app_uri);
	_g_variant_unref0 (props);
	return result;
}


static GObject* unity_launcher_entry_parse_serializable (GVariant* data) {
	GObject* result = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* app_uri;
	GVariant* _tmp6_;
	GVariant* _tmp7_ = NULL;
	GVariant* props;
	const gchar* _tmp8_;
	UnityLauncherEntry* _tmp9_ = NULL;
	UnityLauncherEntry* _self_;
	gint64 count = 0LL;
	GVariant* _tmp10_;
	gboolean _tmp11_ = FALSE;
	gboolean visible = FALSE;
	GVariant* _tmp14_;
	gboolean _tmp15_ = FALSE;
	gdouble progress = 0.0;
	GVariant* _tmp18_;
	gboolean _tmp19_ = FALSE;
	GVariant* _tmp22_;
	gboolean _tmp23_ = FALSE;
	gboolean urgent = FALSE;
	GVariant* _tmp26_;
	gboolean _tmp27_ = FALSE;
	gchar* quicklist_path = NULL;
	GVariant* _tmp30_;
	gboolean _tmp31_ = FALSE;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = data;
	_tmp1_ = g_variant_get_child_value (_tmp0_, (gsize) 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_get_string (_tmp2_, NULL);
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_variant_unref0 (_tmp2_);
	app_uri = _tmp5_;
	_tmp6_ = data;
	_tmp7_ = g_variant_get_child_value (_tmp6_, (gsize) 1);
	props = _tmp7_;
	_tmp8_ = app_uri;
	_tmp9_ = unity_launcher_entry_get_for_app_uri (_tmp8_);
	_self_ = _tmp9_;
	_tmp10_ = props;
	_tmp11_ = g_variant_lookup (_tmp10_, "count", "x", &count, NULL);
	if (_tmp11_) {
		UnityLauncherEntry* _tmp12_;
		gint64 _tmp13_;
		_tmp12_ = _self_;
		_tmp13_ = count;
		unity_launcher_entry_set_count (_tmp12_, _tmp13_);
	}
	_tmp14_ = props;
	_tmp15_ = g_variant_lookup (_tmp14_, "count-visible", "b", &visible, NULL);
	if (_tmp15_) {
		UnityLauncherEntry* _tmp16_;
		gboolean _tmp17_;
		_tmp16_ = _self_;
		_tmp17_ = visible;
		unity_launcher_entry_set_count_visible (_tmp16_, _tmp17_);
	}
	_tmp18_ = props;
	_tmp19_ = g_variant_lookup (_tmp18_, "count-visible", "d", &progress, NULL);
	if (_tmp19_) {
		UnityLauncherEntry* _tmp20_;
		gdouble _tmp21_;
		_tmp20_ = _self_;
		_tmp21_ = progress;
		unity_launcher_entry_set_progress (_tmp20_, _tmp21_);
	}
	_tmp22_ = props;
	_tmp23_ = g_variant_lookup (_tmp22_, "progress-visible", "b", &visible, NULL);
	if (_tmp23_) {
		UnityLauncherEntry* _tmp24_;
		gboolean _tmp25_;
		_tmp24_ = _self_;
		_tmp25_ = visible;
		unity_launcher_entry_set_progress_visible (_tmp24_, _tmp25_);
	}
	_tmp26_ = props;
	_tmp27_ = g_variant_lookup (_tmp26_, "urgent", "b", &urgent, NULL);
	if (_tmp27_) {
		UnityLauncherEntry* _tmp28_;
		gboolean _tmp29_;
		_tmp28_ = _self_;
		_tmp29_ = urgent;
		unity_launcher_entry_set_urgent (_tmp28_, _tmp29_);
	}
	_tmp30_ = props;
	_tmp31_ = g_variant_lookup (_tmp30_, "quicklist", "s", &quicklist_path, NULL);
	if (_tmp31_) {
		const gchar* _tmp32_;
		_tmp32_ = quicklist_path;
		if (g_strcmp0 (_tmp32_, "") != 0) {
			UnityLauncherEntry* _tmp33_;
			const gchar* _tmp34_;
			char* _tmp35_;
			_tmp33_ = _self_;
			_tmp34_ = quicklist_path;
			_tmp35_ = g_strdup (_tmp34_);
			_g_free0 (_tmp33_->_object_path);
			_tmp33_->_object_path = _tmp35_;
		}
	}
	result = (GObject*) _self_;
	_g_free0 (quicklist_path);
	_g_variant_unref0 (props);
	_g_free0 (app_uri);
	return result;
}


static GVariant* _variant_new2 (gint64 value) {
	return g_variant_ref_sink (g_variant_new_int64 (value));
}


static GVariant* _variant_new3 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static GVariant* _variant_new4 (gdouble value) {
	return g_variant_ref_sink (g_variant_new_double (value));
}


static GVariant* _variant_new5 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static GVariant* _variant_new6 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static GVariant* _variant_new7 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new8 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static gboolean _unity_launcher_entry_dispatch_property_notification_gsource_func (gpointer self) {
	gboolean result;
	result = unity_launcher_entry_dispatch_property_notification (self);
	return result;
}


static void unity_launcher_entry_queue_property_notification (UnityLauncherEntry* self, GObject* _self_, GParamSpec* pspec) {
	GVariant* v = NULL;
	gchar* object_path = NULL;
	GParamSpec* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	static GQuark _tmp3_label3 = 0;
	static GQuark _tmp3_label4 = 0;
	static GQuark _tmp3_label5 = 0;
	GVariant* _tmp20_;
	guint _tmp27_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_self_ != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = pspec;
	_tmp1_ = _tmp0_->name;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("count")))) {
		switch (0) {
			default:
			{
				gint64 _tmp5_;
				GVariant* _tmp6_;
				_tmp5_ = self->priv->_count;
				_tmp6_ = _variant_new2 (_tmp5_);
				_g_variant_unref0 (v);
				v = _tmp6_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("count-visible")))) {
		switch (0) {
			default:
			{
				gboolean _tmp7_;
				GVariant* _tmp8_;
				_tmp7_ = self->priv->_count_visible;
				_tmp8_ = _variant_new3 (_tmp7_);
				_g_variant_unref0 (v);
				v = _tmp8_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("progress")))) {
		switch (0) {
			default:
			{
				gdouble _tmp9_;
				GVariant* _tmp10_;
				_tmp9_ = self->priv->_progress;
				_tmp10_ = _variant_new4 (_tmp9_);
				_g_variant_unref0 (v);
				v = _tmp10_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label3) ? _tmp3_label3 : (_tmp3_label3 = g_quark_from_static_string ("progress-visible")))) {
		switch (0) {
			default:
			{
				gboolean _tmp11_;
				GVariant* _tmp12_;
				_tmp11_ = self->priv->_progress_visible;
				_tmp12_ = _variant_new5 (_tmp11_);
				_g_variant_unref0 (v);
				v = _tmp12_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label4) ? _tmp3_label4 : (_tmp3_label4 = g_quark_from_static_string ("urgent")))) {
		switch (0) {
			default:
			{
				gboolean _tmp13_;
				GVariant* _tmp14_;
				_tmp13_ = self->priv->_urgent;
				_tmp14_ = _variant_new6 (_tmp13_);
				_g_variant_unref0 (v);
				v = _tmp14_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label5) ? _tmp3_label5 : (_tmp3_label5 = g_quark_from_static_string ("quicklist")))) {
		switch (0) {
			default:
			{
				DbusmenuServer* _tmp15_;
				_tmp15_ = self->priv->_quicklist_server;
				if (_tmp15_ != NULL) {
					DbusmenuServer* _tmp16_;
					const gchar* _tmp17_;
					GVariant* _tmp18_;
					_tmp16_ = self->priv->_quicklist_server;
					g_object_get ((GObject*) _tmp16_, "dbus-object", &object_path, NULL);
					_tmp17_ = object_path;
					_tmp18_ = _variant_new7 (_tmp17_);
					_g_variant_unref0 (v);
					v = _tmp18_;
				} else {
					GVariant* _tmp19_;
					_tmp19_ = _variant_new8 ("");
					_g_variant_unref0 (v);
					v = _tmp19_;
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				_g_variant_unref0 (v);
				v = NULL;
				break;
			}
		}
	}
	_tmp20_ = v;
	if (_tmp20_ != NULL) {
		GHashTable* _tmp21_;
		GParamSpec* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		GVariant* _tmp25_;
		GVariant* _tmp26_;
		_tmp21_ = self->priv->_queued_properties;
		_tmp22_ = pspec;
		_tmp23_ = _tmp22_->name;
		_tmp24_ = g_strdup (_tmp23_);
		_tmp25_ = v;
		_tmp26_ = _g_variant_ref0 (_tmp25_);
		g_hash_table_insert (_tmp21_, _tmp24_, _tmp26_);
	}
	_tmp27_ = self->priv->_property_source_id;
	if (_tmp27_ == ((guint) 0)) {
		guint _tmp28_ = 0U;
		_tmp28_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _unity_launcher_entry_dispatch_property_notification_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->_property_source_id = _tmp28_;
	}
	_g_free0 (object_path);
	_g_variant_unref0 (v);
}


static gboolean unity_launcher_entry_dispatch_property_notification (UnityLauncherEntry* self) {
	gboolean result = FALSE;
	UnityInspector* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GHashTable* _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = unity_inspector_get_default ();
	_tmp1_ = unity_inspector_get_unity_running (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		UnityLauncherEntryDBusImpl* _tmp3_;
		const gchar* _tmp4_;
		GHashTable* _tmp5_;
		_tmp3_ = self->priv->_dbus_impl;
		_tmp4_ = self->priv->_app_uri;
		_tmp5_ = self->priv->_queued_properties;
		g_signal_emit_by_name (_tmp3_, "update", _tmp4_, _tmp5_);
	}
	self->priv->_property_source_id = (guint) 0;
	_tmp6_ = self->priv->_queued_properties;
	g_hash_table_remove_all (_tmp6_);
	result = FALSE;
	return result;
}


static void unity_launcher_entry_on_unity_running_changed (UnityLauncherEntry* self, GObject* _inspector, GParamSpec* pspec) {
	GObject* _tmp0_;
	UnityInspector* _tmp1_;
	UnityInspector* inspector;
	UnityInspector* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_inspector != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = _inspector;
	_tmp1_ = _g_object_ref0 (UNITY_IS_INSPECTOR (_tmp0_) ? ((UnityInspector*) _tmp0_) : NULL);
	inspector = _tmp1_;
	_tmp2_ = inspector;
	_tmp3_ = unity_inspector_get_unity_running (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		{
			GDBusConnection* _tmp5_;
			const char* _tmp6_;
			GVariant* _tmp7_ = NULL;
			GVariant* _tmp8_;
			_tmp5_ = self->priv->_bus;
			_tmp6_ = self->_object_path;
			_tmp7_ = dee_serializable_serialize ((DeeSerializable*) self);
			_tmp8_ = _tmp7_;
			g_dbus_connection_emit_signal (_tmp5_, NULL, (const gchar*) _tmp6_, "com.canonical.Unity.LauncherEntry", "Update", _tmp8_, &_inner_error_);
			_g_variant_unref0 (_tmp8_);
			if (_inner_error_ != NULL) {
				goto __catch15_g_error;
			}
		}
		goto __finally15;
		__catch15_g_error:
		{
			GError* e = NULL;
			GError* _tmp9_;
			const gchar* _tmp10_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			g_warning ("unity-launcher.vala:325: Failed to emit com.canonical.Unity.LauncherEn" \
"try.Update on the session bus: %s", _tmp10_);
			_g_error_free0 (e);
		}
		__finally15:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (inspector);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (inspector);
}


const gchar* unity_launcher_entry_get_app_uri (UnityLauncherEntry* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_uri;
	result = _tmp0_;
	return result;
}


void unity_launcher_entry_set_app_uri (UnityLauncherEntry* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_app_uri);
	self->priv->_app_uri = _tmp1_;
	g_object_notify ((GObject *) self, "app-uri");
}


gint64 unity_launcher_entry_get_count (UnityLauncherEntry* self) {
	gint64 result;
	gint64 _tmp0_;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_count;
	result = _tmp0_;
	return result;
}


void unity_launcher_entry_set_count (UnityLauncherEntry* self, gint64 value) {
	gint64 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_count = _tmp0_;
	g_object_notify ((GObject *) self, "count");
}


gboolean unity_launcher_entry_get_count_visible (UnityLauncherEntry* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_count_visible;
	result = _tmp0_;
	return result;
}


void unity_launcher_entry_set_count_visible (UnityLauncherEntry* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_count_visible = _tmp0_;
	g_object_notify ((GObject *) self, "count-visible");
}


gdouble unity_launcher_entry_get_progress (UnityLauncherEntry* self) {
	gdouble result;
	gdouble _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_progress;
	result = _tmp0_;
	return result;
}


void unity_launcher_entry_set_progress (UnityLauncherEntry* self, gdouble value) {
	gdouble _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_progress = _tmp0_;
	g_object_notify ((GObject *) self, "progress");
}


gboolean unity_launcher_entry_get_progress_visible (UnityLauncherEntry* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_progress_visible;
	result = _tmp0_;
	return result;
}


void unity_launcher_entry_set_progress_visible (UnityLauncherEntry* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_progress_visible = _tmp0_;
	g_object_notify ((GObject *) self, "progress-visible");
}


gboolean unity_launcher_entry_get_urgent (UnityLauncherEntry* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_urgent;
	result = _tmp0_;
	return result;
}


void unity_launcher_entry_set_urgent (UnityLauncherEntry* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_urgent = _tmp0_;
	g_object_notify ((GObject *) self, "urgent");
}


DbusmenuMenuitem* unity_launcher_entry_get_quicklist (UnityLauncherEntry* self) {
	DbusmenuMenuitem* result;
	DbusmenuMenuitem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_quicklist;
	result = _tmp0_;
	return result;
}


void unity_launcher_entry_set_quicklist (UnityLauncherEntry* self, DbusmenuMenuitem* value) {
	DbusmenuMenuitem* _tmp0_;
	DbusmenuMenuitem* _tmp1_;
	DbusmenuMenuitem* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_quicklist);
	self->priv->_quicklist = _tmp1_;
	_tmp2_ = self->priv->_quicklist;
	if (_tmp2_ != NULL) {
		const char* _tmp3_;
		DbusmenuServer* _tmp4_;
		DbusmenuServer* _tmp5_;
		DbusmenuMenuitem* _tmp6_;
		_tmp3_ = self->_object_path;
		_tmp4_ = dbusmenu_server_new ((const gchar*) _tmp3_);
		_g_object_unref0 (self->priv->_quicklist_server);
		self->priv->_quicklist_server = _tmp4_;
		_tmp5_ = self->priv->_quicklist_server;
		_tmp6_ = self->priv->_quicklist;
		g_object_set (_tmp5_, "root-node", _tmp6_, NULL);
	}
	g_object_notify ((GObject *) self, "quicklist");
}


static void _unity_launcher_entry_on_unity_running_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_launcher_entry_on_unity_running_changed (self, _sender, pspec);
}


static void _unity_launcher_entry_queue_property_notification_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_launcher_entry_queue_property_notification (self, _sender, pspec);
}


static GObject * unity_launcher_entry_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityLauncherEntry * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (unity_launcher_entry_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_LAUNCHER_ENTRY (obj);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_variant_unref0_);
	_g_hash_table_unref0 (self->priv->_queued_properties);
	self->priv->_queued_properties = _tmp2_;
	_g_object_unref0 (self->priv->_quicklist_server);
	self->priv->_quicklist_server = NULL;
	self->priv->_property_source_id = (guint) 0;
	{
		GDBusConnection* _tmp3_ = NULL;
		GDBusConnection* _tmp4_;
		const gchar* _tmp5_;
		guint _tmp6_ = 0U;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		char* _tmp11_;
		GDBusConnection* _tmp12_;
		const char* _tmp13_;
		UnityLauncherEntryDBusImpl* _tmp14_;
		UnityInspector* _tmp15_ = NULL;
		UnityInspector* _tmp16_;
		UnityInspector* inspector;
		UnityInspector* _tmp17_;
		_tmp3_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch16_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_object_unref0 (self->priv->_bus);
		self->priv->_bus = _tmp4_;
		_tmp5_ = self->priv->_app_uri;
		_tmp6_ = g_str_hash (_tmp5_);
		_tmp7_ = g_strdup_printf ("%u", _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat ("/com/canonical/unity/launcherentry/", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (self->_object_path);
		self->_object_path = _tmp11_;
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		_tmp12_ = self->priv->_bus;
		_tmp13_ = self->_object_path;
		_tmp14_ = unity_launcher_entry_dbus_impl_new (_tmp12_, _tmp13_, self);
		_g_object_unref0 (self->priv->_dbus_impl);
		self->priv->_dbus_impl = _tmp14_;
		_tmp15_ = unity_inspector_get_default ();
		_tmp16_ = _g_object_ref0 (_tmp15_);
		inspector = _tmp16_;
		_tmp17_ = inspector;
		g_signal_connect_object ((GObject*) _tmp17_, "notify::unity-running", (GCallback) _unity_launcher_entry_on_unity_running_changed_g_object_notify, self, 0);
		g_signal_connect_object ((GObject*) self, "notify", (GCallback) _unity_launcher_entry_queue_property_notification_g_object_notify, self, 0);
		_g_object_unref0 (inspector);
	}
	goto __finally16;
	__catch16_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_critical ("unity-launcher.vala:154: Unable to connect to session bus: %s", _tmp19_);
		_g_error_free0 (e);
	}
	__finally16:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static GObject* _unity_launcher_entry_parse_serializable_dee_serializable_parse_func (GVariant* data) {
	GObject* result;
	result = unity_launcher_entry_parse_serializable (data);
	return result;
}


static void unity_launcher_entry_class_init (UnityLauncherEntryClass * klass) {
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	unity_launcher_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityLauncherEntryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_launcher_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_launcher_entry_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_launcher_entry_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_launcher_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_ENTRY_APP_URI, g_param_spec_string ("app-uri", "app-uri", "app-uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_ENTRY_COUNT, g_param_spec_int64 ("count", "count", "count", G_MININT64, G_MAXINT64, (gint64) 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_ENTRY_COUNT_VISIBLE, g_param_spec_boolean ("count-visible", "count-visible", "count-visible", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_ENTRY_PROGRESS, g_param_spec_double ("progress", "progress", "progress", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_ENTRY_PROGRESS_VISIBLE, g_param_spec_boolean ("progress-visible", "progress-visible", "progress-visible", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_ENTRY_URGENT, g_param_spec_boolean ("urgent", "urgent", "urgent", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_ENTRY_QUICKLIST, g_param_spec_object ("quicklist", "quicklist", "quicklist", dbusmenu_menuitem_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_variant_type_new ("(sa{sv})");
	_tmp1_ = _tmp0_;
	dee_serializable_register_parser (UNITY_TYPE_LAUNCHER_ENTRY, _tmp1_, _unity_launcher_entry_parse_serializable_dee_serializable_parse_func);
	_g_variant_type_free0 (_tmp1_);
}


static void unity_launcher_entry_dee_serializable_interface_init (DeeSerializableIface * iface) {
	unity_launcher_entry_dee_serializable_parent_iface = g_type_interface_peek_parent (iface);
	iface->serialize = (GVariant* (*)(DeeSerializable*)) unity_launcher_entry_real_serialize;
}


static void unity_launcher_entry_instance_init (UnityLauncherEntry * self) {
	self->priv = UNITY_LAUNCHER_ENTRY_GET_PRIVATE (self);
	self->priv->_count = (gint64) 0;
	self->priv->_count_visible = FALSE;
	self->priv->_progress = 0.0;
	self->priv->_progress_visible = FALSE;
	self->priv->_urgent = FALSE;
}


static void unity_launcher_entry_finalize (GObject* obj) {
	UnityLauncherEntry * self;
	self = UNITY_LAUNCHER_ENTRY (obj);
	_g_free0 (self->priv->_app_uri);
	_g_object_unref0 (self->priv->_quicklist);
	_g_hash_table_unref0 (self->priv->_queued_properties);
	_g_object_unref0 (self->priv->_quicklist_server);
	_g_object_unref0 (self->priv->_bus);
	_g_object_unref0 (self->priv->_dbus_impl);
	_g_free0 (self->_object_path);
	G_OBJECT_CLASS (unity_launcher_entry_parent_class)->finalize (obj);
}


/**
   * This class represents your control point for your application's icon
   * in the Unity Launcher. You can control properties such as a counter,
   * progress, or emblem that will be overlaid on your application's launcher
   * icon. You can also set a quicklist on it by setting the "quicklist"
   * property to point at the Dbusmenu.Menuitem which is the root of your
   * quicklist.
   *
   * Create a LauncherEntry by giving your desktop file id to the constructor
   * (eg. "myapp.desktop").
   */
GType unity_launcher_entry_get_type (void) {
	static volatile gsize unity_launcher_entry_type_id__volatile = 0;
	if (g_once_init_enter (&unity_launcher_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityLauncherEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_launcher_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityLauncherEntry), 0, (GInstanceInitFunc) unity_launcher_entry_instance_init, NULL };
		static const GInterfaceInfo dee_serializable_info = { (GInterfaceInitFunc) unity_launcher_entry_dee_serializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType unity_launcher_entry_type_id;
		unity_launcher_entry_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityLauncherEntry", &g_define_type_info, 0);
		g_type_add_interface_static (unity_launcher_entry_type_id, dee_serializable_get_type (), &dee_serializable_info);
		g_once_init_leave (&unity_launcher_entry_type_id__volatile, unity_launcher_entry_type_id);
	}
	return unity_launcher_entry_type_id__volatile;
}


static void _vala_unity_launcher_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityLauncherEntry * self;
	self = UNITY_LAUNCHER_ENTRY (object);
	switch (property_id) {
		case UNITY_LAUNCHER_ENTRY_APP_URI:
		g_value_set_string (value, unity_launcher_entry_get_app_uri (self));
		break;
		case UNITY_LAUNCHER_ENTRY_COUNT:
		g_value_set_int64 (value, unity_launcher_entry_get_count (self));
		break;
		case UNITY_LAUNCHER_ENTRY_COUNT_VISIBLE:
		g_value_set_boolean (value, unity_launcher_entry_get_count_visible (self));
		break;
		case UNITY_LAUNCHER_ENTRY_PROGRESS:
		g_value_set_double (value, unity_launcher_entry_get_progress (self));
		break;
		case UNITY_LAUNCHER_ENTRY_PROGRESS_VISIBLE:
		g_value_set_boolean (value, unity_launcher_entry_get_progress_visible (self));
		break;
		case UNITY_LAUNCHER_ENTRY_URGENT:
		g_value_set_boolean (value, unity_launcher_entry_get_urgent (self));
		break;
		case UNITY_LAUNCHER_ENTRY_QUICKLIST:
		g_value_set_object (value, unity_launcher_entry_get_quicklist (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_launcher_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityLauncherEntry * self;
	self = UNITY_LAUNCHER_ENTRY (object);
	switch (property_id) {
		case UNITY_LAUNCHER_ENTRY_APP_URI:
		unity_launcher_entry_set_app_uri (self, g_value_get_string (value));
		break;
		case UNITY_LAUNCHER_ENTRY_COUNT:
		unity_launcher_entry_set_count (self, g_value_get_int64 (value));
		break;
		case UNITY_LAUNCHER_ENTRY_COUNT_VISIBLE:
		unity_launcher_entry_set_count_visible (self, g_value_get_boolean (value));
		break;
		case UNITY_LAUNCHER_ENTRY_PROGRESS:
		unity_launcher_entry_set_progress (self, g_value_get_double (value));
		break;
		case UNITY_LAUNCHER_ENTRY_PROGRESS_VISIBLE:
		unity_launcher_entry_set_progress_visible (self, g_value_get_boolean (value));
		break;
		case UNITY_LAUNCHER_ENTRY_URGENT:
		unity_launcher_entry_set_urgent (self, g_value_get_boolean (value));
		break;
		case UNITY_LAUNCHER_ENTRY_QUICKLIST:
		unity_launcher_entry_set_quicklist (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static GVariant* _variant_new9 (gint64 value) {
	return g_variant_ref_sink (g_variant_new_int64 (value));
}


static GVariant* _variant_new10 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static GVariant* _variant_new11 (gdouble value) {
	return g_variant_ref_sink (g_variant_new_double (value));
}


static GVariant* _variant_new12 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static GVariant* _variant_new13 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static GVariant* _variant_new14 (const char* value) {
	return g_variant_ref_sink (g_variant_new_object_path (value));
}


GHashTable* unity_collect_launcher_entry_properties (UnityLauncherEntry* l) {
	GHashTable* result = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* props;
	GHashTable* _tmp3_;
	gchar* _tmp4_;
	UnityLauncherEntry* _tmp5_;
	gint64 _tmp6_;
	gint64 _tmp7_;
	GVariant* _tmp8_;
	GHashTable* _tmp9_;
	gchar* _tmp10_;
	UnityLauncherEntry* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GVariant* _tmp14_;
	GHashTable* _tmp15_;
	gchar* _tmp16_;
	UnityLauncherEntry* _tmp17_;
	gdouble _tmp18_;
	gdouble _tmp19_;
	GVariant* _tmp20_;
	GHashTable* _tmp21_;
	gchar* _tmp22_;
	UnityLauncherEntry* _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	GVariant* _tmp26_;
	GHashTable* _tmp27_;
	gchar* _tmp28_;
	UnityLauncherEntry* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	GVariant* _tmp32_;
	UnityLauncherEntry* _tmp33_;
	DbusmenuMenuitem* _tmp34_;
	DbusmenuMenuitem* _tmp35_;
	g_return_val_if_fail (l != NULL, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_variant_unref0_);
	props = _tmp2_;
	_tmp3_ = props;
	_tmp4_ = g_strdup ("count");
	_tmp5_ = l;
	_tmp6_ = unity_launcher_entry_get_count (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _variant_new9 (_tmp7_);
	g_hash_table_insert (_tmp3_, _tmp4_, _tmp8_);
	_tmp9_ = props;
	_tmp10_ = g_strdup ("count-visible");
	_tmp11_ = l;
	_tmp12_ = unity_launcher_entry_get_count_visible (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _variant_new10 (_tmp13_);
	g_hash_table_insert (_tmp9_, _tmp10_, _tmp14_);
	_tmp15_ = props;
	_tmp16_ = g_strdup ("progress");
	_tmp17_ = l;
	_tmp18_ = unity_launcher_entry_get_progress (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = _variant_new11 (_tmp19_);
	g_hash_table_insert (_tmp15_, _tmp16_, _tmp20_);
	_tmp21_ = props;
	_tmp22_ = g_strdup ("progress-visible");
	_tmp23_ = l;
	_tmp24_ = unity_launcher_entry_get_progress_visible (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = _variant_new12 (_tmp25_);
	g_hash_table_insert (_tmp21_, _tmp22_, _tmp26_);
	_tmp27_ = props;
	_tmp28_ = g_strdup ("urgent");
	_tmp29_ = l;
	_tmp30_ = unity_launcher_entry_get_urgent (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = _variant_new13 (_tmp31_);
	g_hash_table_insert (_tmp27_, _tmp28_, _tmp32_);
	_tmp33_ = l;
	_tmp34_ = unity_launcher_entry_get_quicklist (_tmp33_);
	_tmp35_ = _tmp34_;
	if (_tmp35_ != NULL) {
		GHashTable* _tmp36_;
		gchar* _tmp37_;
		UnityLauncherEntry* _tmp38_;
		const char* _tmp39_;
		GVariant* _tmp40_;
		_tmp36_ = props;
		_tmp37_ = g_strdup ("quicklist");
		_tmp38_ = l;
		_tmp39_ = _tmp38_->_object_path;
		_tmp40_ = _variant_new14 (_tmp39_);
		g_hash_table_insert (_tmp36_, _tmp37_, _tmp40_);
	}
	result = props;
	return result;
}


static void _unity_launcher_favorites_reset_fav_cache_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	unity_launcher_favorites_reset_fav_cache (self);
}


static UnityLauncherFavorites* unity_launcher_favorites_construct (GType object_type) {
	UnityLauncherFavorites * self = NULL;
	GSettings* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	GSettings* _tmp4_;
	self = (UnityLauncherFavorites*) g_object_new (object_type, NULL);
	_tmp0_ = g_settings_new ("com.canonical.Unity.Launcher");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->fav_cache);
	self->priv->fav_cache = _tmp3_;
	unity_launcher_favorites_reset_fav_cache (self);
	_tmp4_ = self->priv->settings;
	g_signal_connect_object (_tmp4_, "changed::favorites", (GCallback) _unity_launcher_favorites_reset_fav_cache_g_settings_changed, self, 0);
	return self;
}


static UnityLauncherFavorites* unity_launcher_favorites_new (void) {
	return unity_launcher_favorites_construct (UNITY_TYPE_LAUNCHER_FAVORITES);
}


static void unity_launcher_favorites_reset_fav_cache (UnityLauncherFavorites* self) {
	GHashTable* _tmp0_;
	GSettings* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->fav_cache;
	g_hash_table_remove_all (_tmp0_);
	_tmp1_ = self->priv->settings;
	_tmp3_ = _tmp2_ = g_settings_get_strv (_tmp1_, "favorites");
	self->priv->fav_list = (_vala_array_free (self->priv->fav_list, self->priv->fav_list_length1, (GDestroyNotify) g_free), NULL);
	self->priv->fav_list = _tmp3_;
	self->priv->fav_list_length1 = _vala_array_length (_tmp2_);
	self->priv->_fav_list_size_ = self->priv->fav_list_length1;
	_tmp4_ = self->priv->fav_list;
	_tmp4__length1 = self->priv->fav_list_length1;
	{
		gchar** id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp4_;
		id_collection_length1 = _tmp4__length1;
		for (id_it = 0; id_it < _tmp4__length1; id_it = id_it + 1) {
			gchar* _tmp5_;
			gchar* id = NULL;
			_tmp5_ = g_strdup (id_collection[id_it]);
			id = _tmp5_;
			{
				GHashTable* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp6_ = self->priv->fav_cache;
				_tmp7_ = id;
				_tmp8_ = g_strdup (_tmp7_);
				g_hash_table_insert (_tmp6_, _tmp8_, NULL);
				_g_free0 (id);
			}
		}
	}
	g_signal_emit_by_name (self, "changed");
}


/**
     * Get the default singleton Unity.LauncherFavorites instance, creating it
     * dynamically if necessary.
     *
     * @return: (transfer none): The singleton Unity.LauncherFavorites.
     *                          If calling from C do not free this instance.
     *
     */
UnityLauncherFavorites* unity_launcher_favorites_get_default (void) {
	UnityLauncherFavorites* result = NULL;
	UnityLauncherFavorites* _tmp0_;
	UnityLauncherFavorites* _tmp2_;
	_tmp0_ = unity_launcher_favorites_singleton;
	if (_tmp0_ == NULL) {
		UnityLauncherFavorites* _tmp1_;
		_tmp1_ = unity_launcher_favorites_new ();
		_g_object_unref0 (unity_launcher_favorites_singleton);
		unity_launcher_favorites_singleton = _tmp1_;
	}
	_tmp2_ = unity_launcher_favorites_singleton;
	result = _tmp2_;
	return result;
}


gboolean unity_launcher_favorites_has_app_info (UnityLauncherFavorites* self, GAppInfo* appinfo) {
	gboolean result = FALSE;
	GAppInfo* _tmp0_;
	const gchar* _tmp1_ = NULL;
	GAppInfo* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (appinfo != NULL, FALSE);
	_tmp0_ = appinfo;
	_tmp1_ = g_app_info_get_id (_tmp0_);
	if (_tmp1_ == NULL) {
		g_critical ("unity-launcher.vala:399: Can not look up favorite for AppInfo with NUL" \
"L id");
		result = FALSE;
		return result;
	}
	_tmp2_ = appinfo;
	_tmp3_ = g_app_info_get_id (_tmp2_);
	_tmp4_ = unity_launcher_favorites_has_app_id (self, _tmp3_);
	result = _tmp4_;
	return result;
}


gboolean unity_launcher_favorites_has_app_id (UnityLauncherFavorites* self, const gchar* app_id) {
	gboolean result = FALSE;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (app_id != NULL, FALSE);
	_tmp0_ = self->priv->fav_cache;
	_tmp1_ = app_id;
	_tmp2_ = g_hash_table_lookup_extended (_tmp0_, _tmp1_, NULL, NULL);
	result = _tmp2_;
	return result;
}


GAppInfo* unity_launcher_favorites_lookup (UnityLauncherFavorites* self, const gchar* app_id) {
	GAppInfo* result = NULL;
	GAppInfo* appinfo = NULL;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GAppInfo* _tmp4_;
	gboolean has_id;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (app_id != NULL, NULL);
	_tmp0_ = self->priv->fav_cache;
	_tmp1_ = app_id;
	_tmp3_ = g_hash_table_lookup_extended (_tmp0_, _tmp1_, NULL, &_tmp2_);
	_g_object_unref0 (appinfo);
	_tmp4_ = _g_object_ref0 (_tmp2_);
	appinfo = _tmp4_;
	has_id = _tmp3_;
	_tmp5_ = has_id;
	if (_tmp5_) {
		GAppInfo* _tmp6_;
		UnityAppInfoManager* _tmp7_ = NULL;
		UnityAppInfoManager* appman;
		UnityAppInfoManager* _tmp8_;
		const gchar* _tmp9_;
		GAppInfo* _tmp10_ = NULL;
		GHashTable* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		GAppInfo* _tmp14_;
		GAppInfo* _tmp15_;
		GAppInfo* _tmp16_;
		_tmp6_ = appinfo;
		if (_tmp6_ != NULL) {
			result = appinfo;
			return result;
		}
		_tmp7_ = unity_app_info_manager_get_default ();
		appman = _tmp7_;
		_tmp8_ = appman;
		_tmp9_ = app_id;
		_tmp10_ = unity_app_info_manager_lookup (_tmp8_, _tmp9_);
		_g_object_unref0 (appinfo);
		appinfo = _tmp10_;
		_tmp11_ = self->priv->fav_cache;
		_tmp12_ = app_id;
		_tmp13_ = g_strdup (_tmp12_);
		_tmp14_ = appinfo;
		_tmp15_ = _g_object_ref0 (_tmp14_);
		g_hash_table_insert (_tmp11_, _tmp13_, _tmp15_);
		_tmp16_ = appinfo;
		if (_tmp16_ == NULL) {
			const gchar* _tmp17_;
			_tmp17_ = app_id;
			g_critical ("unity-launcher.vala:431: Can't find AppInfo for favorite '%s'", _tmp17_);
			result = NULL;
			_g_object_unref0 (appman);
			_g_object_unref0 (appinfo);
			return result;
		}
		result = appinfo;
		_g_object_unref0 (appman);
		return result;
	}
	result = NULL;
	_g_object_unref0 (appinfo);
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


gchar** unity_launcher_favorites_enumerate_ids (UnityLauncherFavorites* self, int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->fav_list;
	_tmp0__length1 = self->priv->fav_list_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}


GAppInfo** unity_launcher_favorites_enumerate_app_infos (UnityLauncherFavorites* self, int* result_length1) {
	GAppInfo** result = NULL;
	gint i;
	GHashTable* _tmp0_;
	guint _tmp1_ = 0U;
	GAppInfo** _tmp2_ = NULL;
	GAppInfo** infos;
	gint infos_length1;
	gint _infos_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GAppInfo** _tmp13_;
	gint _tmp13__length1;
	g_return_val_if_fail (self != NULL, NULL);
	i = 0;
	_tmp0_ = self->priv->fav_cache;
	_tmp1_ = g_hash_table_size (_tmp0_);
	_tmp2_ = g_new0 (GAppInfo*, _tmp1_ + 1);
	infos = _tmp2_;
	infos_length1 = _tmp1_;
	_infos_size_ = infos_length1;
	_tmp3_ = self->priv->fav_list;
	_tmp3__length1 = self->priv->fav_list_length1;
	{
		gchar** id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp3_;
		id_collection_length1 = _tmp3__length1;
		for (id_it = 0; id_it < _tmp3__length1; id_it = id_it + 1) {
			gchar* _tmp4_;
			gchar* id = NULL;
			_tmp4_ = g_strdup (id_collection[id_it]);
			id = _tmp4_;
			{
				const gchar* _tmp5_;
				GAppInfo* _tmp6_ = NULL;
				GAppInfo* appinfo;
				GAppInfo** _tmp7_;
				gint _tmp7__length1;
				gint _tmp8_;
				GAppInfo* _tmp9_;
				GAppInfo* _tmp10_;
				GAppInfo* _tmp11_;
				gint _tmp12_;
				_tmp5_ = id;
				_tmp6_ = unity_launcher_favorites_lookup (self, _tmp5_);
				appinfo = _tmp6_;
				_tmp7_ = infos;
				_tmp7__length1 = infos_length1;
				_tmp8_ = i;
				_tmp9_ = appinfo;
				_tmp10_ = _g_object_ref0 (_tmp9_);
				_g_object_unref0 (_tmp7_[_tmp8_]);
				_tmp7_[_tmp8_] = _tmp10_;
				_tmp11_ = _tmp7_[_tmp8_];
				_tmp12_ = i;
				i = _tmp12_ + 1;
				_g_object_unref0 (appinfo);
				_g_free0 (id);
			}
		}
	}
	_tmp13_ = infos;
	_tmp13__length1 = infos_length1;
	if (result_length1) {
		*result_length1 = _tmp13__length1;
	}
	result = _tmp13_;
	return result;
}


static void unity_launcher_favorites_class_init (UnityLauncherFavoritesClass * klass) {
	unity_launcher_favorites_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityLauncherFavoritesPrivate));
	G_OBJECT_CLASS (klass)->finalize = unity_launcher_favorites_finalize;
	g_signal_new ("changed", UNITY_TYPE_LAUNCHER_FAVORITES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void unity_launcher_favorites_instance_init (UnityLauncherFavorites * self) {
	self->priv = UNITY_LAUNCHER_FAVORITES_GET_PRIVATE (self);
}


static void unity_launcher_favorites_finalize (GObject* obj) {
	UnityLauncherFavorites * self;
	self = UNITY_LAUNCHER_FAVORITES (obj);
	_g_object_unref0 (self->priv->settings);
	_g_hash_table_unref0 (self->priv->fav_cache);
	self->priv->fav_list = (_vala_array_free (self->priv->fav_list, self->priv->fav_list_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (unity_launcher_favorites_parent_class)->finalize (obj);
}


GType unity_launcher_favorites_get_type (void) {
	static volatile gsize unity_launcher_favorites_type_id__volatile = 0;
	if (g_once_init_enter (&unity_launcher_favorites_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityLauncherFavoritesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_launcher_favorites_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityLauncherFavorites), 0, (GInstanceInitFunc) unity_launcher_favorites_instance_init, NULL };
		GType unity_launcher_favorites_type_id;
		unity_launcher_favorites_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityLauncherFavorites", &g_define_type_info, 0);
		g_once_init_leave (&unity_launcher_favorites_type_id__volatile, unity_launcher_favorites_type_id);
	}
	return unity_launcher_favorites_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



