package jacob.tool;

import ccl.awt.AWTUtil;
import ccl.util.*;

import jacob.Package;

import java.awt.Frame;
import java.io.*;

/**
 * 
 * @author  <a href="http://mats.gmd.de/clemens/">Chr. Clemens Lahme</a> (<a href="mailto:clemens.lahme@mailexcite.com"><i>Clemens.Lahme@mailexcite.com</i></a>)
 * @version $Id: JavaPWrapper.java,v 1.2 1998/09/20 12:47:38 clemens Exp clemens $
 */
public class JavaPWrapper implements JacobRunnable {
	private JacobInterface _pJacobInterface = null;
	private String _sToolName = "";

	public void set(JacobInterface pJacobInterface_) {
		Util.panicIf(pJacobInterface_ == null);
		_pJacobInterface = pJacobInterface_;
	}

	public JavaPWrapper() {
		super();
	}

	public void run() {
		String sClassFullName = _pJacobInterface.getSelectedClass();
		if (Util.isEmpty(sClassFullName)) {
			Frame frmMain = _pJacobInterface.getMainFrame();
			AWTUtil.showMessage(frmMain, "JavaPWrapper: Sorry, no class selected!");
			frmMain.requestFocus();
			_pJacobInterface.stopped(this);

			return;
		}

		// get path of class
		Package pckMain = _pJacobInterface.getMainPackage();
		// output file is the class name with .javap suffix
		String sOutputFile = pckMain.getClassFullFileName
				 (sClassFullName);
		sOutputFile += "p";

		String[] asArg = new String[5];
		asArg[0] = "-c";
		asArg[1] = "-l";
		asArg[2] = "-classpath";
		asArg[3] = Package.getClassPath();
		asArg[4] = sClassFullName;
		_sToolName = "JavaP " + sClassFullName;

		try {
			FileOutputStream pFileOutputStream = new FileOutputStream
					 (sOutputFile);
			PrintStream psOld = System.out;
			System.setOut(new PrintStream(pFileOutputStream));
			sun.tools.javap.JavaP.main(asArg);
			System.setOut(psOld);
			pFileOutputStream.close();
		} catch(Exception pException) {
		}

		// editFile
		_pJacobInterface.getEditor().editFile(sOutputFile);

		_pJacobInterface.stopped(this);
	}

	public String toString() {
		return _sToolName;
	}
}
