/*
 * JSError.cs - Error codes for the JScript engine.
 *
 * Copyright (C) 2003 Southern Storm Software, Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
namespace Microsoft.JScript
{

public enum JSError
{
	NoError										=    0,
	InvalidCall									=    5,
	OutOfMemory									=    7,
	TypeMismatch								=   13,
	OutOfStack									=   28,
	InternalError								=   51,
	FileNotFound								=   53, 
	NeedObject									=  424,
	CantCreateObject							=  429,
	OLENoPropOrMethod							=  438,
	ActionNotSupported							=  445,
	NotCollection								=  451,
	SyntaxError									= 1002,
	NoColon										= 1003,
	NoSemicolon									= 1004,
	NoLeftParen									= 1005,
	NoRightParen								= 1006,
	NoRightBracket								= 1007,
	NoLeftCurly									= 1008,
	NoRightCurly								= 1009,
	NoIdentifier								= 1010,
	NoEqual										= 1011,
	IllegalChar									= 1014,
	UnterminatedString							= 1015,
	NoCommentEnd								= 1016,
	BadReturn									= 1018,
	BadBreak									= 1019,
	BadContinue									= 1020,
	BadHexDigit									= 1023,
	NoWhile										= 1024,
	BadLabel									= 1025,
	NoLabel										= 1026,
	DupDefault									= 1027,
	NoMemberIdentifier							= 1028,
	NoCcEnd										= 1029,
	CcOff										= 1030,
	NotConst									= 1031,
	NoAt										= 1032,
	NoCatch										= 1033,
	InvalidElse								    = 1034,
	NoComma										= 1100,
	DupVisibility								= 1101,
	IllegalVisibility							= 1102,
	BadSwitch									= 1103,
	CcInvalidEnd								= 1104,
	CcInvalidElse								= 1105,
	CcInvalidElif								= 1106,
	ErrEOF										= 1107,
	IncompatibleVisibility						= 1108,
	ClassNotAllowed								= 1109,
	NeedCompileTimeConstant						= 1110,
	DuplicateName								= 1111,
	NeedType									= 1112,
	NotInsideClass								= 1113,
	InvalidPositionDirective					= 1114,
	MustBeEOL									= 1115,
	WrongDirective								= 1118,
	CannotNestPositionDirective					= 1119,
	CircularDefinition							= 1120,
	Deprecated									= 1121,
	IllegalUseOfThis							= 1122,
	NotAccessible								= 1123,
	CannotUseNameOfClass						= 1124,
	MustImplementMethod							= 1128,
	NeedInterface								= 1129,
	UnreachableCatch							= 1133,
	TypeCannotBeExtended						= 1134,
	UndeclaredVariable							= 1135,
	VariableLeftUninitialized					= 1136,
	KeywordUsedAsIdentifier						= 1137,
	NotAllowedInSuperConstructorCall			= 1140,
	NotMeantToBeCalledDirectly					= 1141,
	GetAndSetAreInconsistent					= 1142,
	InvalidCustomAttribute						= 1143,
	InvalidCustomAttributeArgument				= 1144,
	InvalidCustomAttributeClassOrCtor			= 1146,
	TooManyParameters							= 1148,
	AmbiguousBindingBecauseOfWith				= 1149,
	AmbiguousBindingBecauseOfEval				= 1150,
	NoSuchMember								= 1151,
	ItemNotAllowedOnExpandoClass				= 1152,
	MethodNotAllowedOnExpandoClass				= 1153,
	MethodClashOnExpandoSuperClass				= 1155,
	BaseClassIsExpandoAlready					= 1156,
	AbstractCannotBePrivate						= 1157,
	NotIndexable								= 1158,
	StaticMissingInStaticInit					= 1159,
	MissingConstructForAttributes				= 1160,
	OnlyClassesAllowed							= 1161,
	ExpandoClassShouldNotImpleEnumerable		= 1162,
	NonCLSCompliantMember						= 1163,
	NotDeletable								= 1164,
	PackageExpected								= 1165,
	UselessExpression							= 1169,
	HidesParentMember							= 1170,
	CannotChangeVisibility						= 1171,
	HidesAbstractInBase							= 1172,
	NewNotSpecifiedInMethodDeclaration			= 1173,
	MethodInBaseIsNotVirtual					= 1174,
	NoMethodInBaseToNew							= 1175,
	DifferentReturnTypeFromBase					= 1176,
	ClashWithProperty							= 1177,
	OverrideAndHideUsedTogether					= 1178,
	InvalidLanguageOption						= 1179,
	NoMethodInBaseToOverride					= 1180,
	NotValidForConstructor						= 1181,
	CannotReturnValueFromVoidFunction			= 1182,
	AmbiguousMatch								= 1183,
	AmbiguousConstructorCall					= 1184,
	SuperClassConstructorNotAccessible			= 1185,
	OctalLiteralsAreDeprecated					= 1186,
	VariableMightBeUnitialized					= 1187,
	NotOKToCallSuper							= 1188,
	IllegalUseOfSuper							= 1189,
	BadWayToLeaveFinally						= 1190,
	NoCommaOrTypeDefinitionError				= 1191,
	AbstractWithBody							= 1192,
	NoRightParenOrComma							= 1193,
	NoRightBracketOrComma						= 1194,
	ExpressionExpected							= 1195,
	UnexpectedSemicolon							= 1196,
	TooManyTokensSkipped						= 1197,
	BadVariableDeclaration						= 1198,
	BadFunctionDeclaration						= 1199,
	BadPropertyDeclaration						= 1200,
	DoesNotHaveAnAddress						= 1203,
	TooFewParameters							= 1204,
	UselessAssignment							= 1205,
	SuspectAssignment							= 1206,
	SuspectSemicolon							= 1207,
	ImpossibleConversion						= 1208,
	FinalPrecludesAbstract						= 1209,
	NeedInstance								= 1210,
	CannotBeAbstract							= 1212,
	InvalidBaseTypeForEnum						= 1213,
	CannotInstantiateAbstractClass				= 1214,
	ArrayMayBeCopied							= 1215,
	AbstractCannotBeStatic						= 1216,
	StaticIsAlreadyFinal						= 1217,
	StaticMethodsCannotOverride					= 1218,
	StaticMethodsCannotHide						= 1219,
	ExpandoPrecludesOverride					= 1220,
	IllegalParamArrayAttribute					= 1221,
	ExpandoPrecludesAbstract					= 1222,
	ShouldBeAbstract							= 1223,
	BadModifierInInterface						= 1224,
	VarIllegalInInterface						= 1226,
	InterfaceIllegalInInterface					= 1227,
	NoVarInEnum									= 1228,
	InvalidImport								= 1229,
	EnumNotAllowed								= 1230,
	InvalidCustomAttributeTarget				= 1231,
	PackageInWrongContext						= 1232,
	ConstructorMayNotHaveReturnType				= 1233,
	OnlyClassesAndPackagesAllowed				= 1234,
	InvalidDebugDirective						= 1235,
	CustomAttributeUsedMoreThanOnce				= 1236,
	NestedInstanceTypeCannotBeExtendedByStatic	= 1237,
	PropertyLevelAttributesMustBeOnGetter		= 1238,
	BadThrow									= 1239,
	ParamListNotLast							= 1240,
	NoSuchType									= 1241,
	BadOctalLiteral								= 1242,
	InstanceNotAccessibleFromStatic				= 1243,
	StaticRequiresTypeName						= 1244,
	NonStaticWithTypeName						= 1245,
	NoSuchStaticMember							= 1246,
	SuspectLoopCondition						= 1247,
	ExpectedAssembly							= 1248,
	AssemblyAttributesMustBeGlobal				= 1249,
	ExpandoPrecludesStatic						= 1250,
	DuplicateMethod								= 1251,
	NotAnExpandoFunction						= 1252,
	NotValidVersionString						= 1253,
	ExecutablesCannotBeLocalized				= 1254,
	StringConcatIsSlow							= 1255,
	CcInvalidInDebugger							= 1256,
	ExpandoMustBePublic							= 1257,
	DelegatesShouldNotBeExplicitlyConstructed	= 1258,
	ImplicitlyReferencedAssemblyNotFound		= 1259,
	PossibleBadConversion						= 1260,
	PossibleBadConversionFromString				= 1261,
	InvalidResource								= 1262,
	WrongUseOfAddressOf							= 1263,
	NonCLSCompliantType							= 1264,
	MemberTypeCLSCompliantMismatch				= 1265,
	TypeAssemblyCLSCompliantMismatch			= 1266,
	CantAssignThis								= 5000,
	NumberExpected								= 5001,
	FunctionExpected							= 5002,
	CannotAssignToFunctionResult				= 5003,
	StringExpected								= 5005,
	DateExpected								= 5006,
	ObjectExpected								= 5007,
	IllegalAssignment							= 5008,
	UndefinedIdentifier							= 5009,
	BooleanExpected								= 5010,
	VBArrayExpected								= 5013,
	EnumeratorExpected							= 5015,
	RegExpExpected								= 5016,
	RegExpSyntax								= 5017,
	UncaughtException							= 5022,
	InvalidPrototype							= 5023,
	URIEncodeError								= 5024,
	URIDecodeError								= 5025, 
	FractionOutOfRange							= 5026,
	PrecisionOutOfRange							= 5027,
	ArrayLengthConstructIncorrect				= 5029,
	ArrayLengthAssignIncorrect					= 5030,
	NeedArrayObject								= 5031,
	NoConstructor								= 5032,
	IllegalEval									= 5033,
	NotYetImplemented							= 5034,
	MustProvideNameForNamedParameter			= 5035,
	DuplicateNamedParameter						= 5036,
	MissingNameParameter						= 5037,
	MoreNamedParametersThanArguments			= 5038,
	NonSupportedInDebugger						= 5039,
	AssignmentToReadOnly						= 5040,
	WriteOnlyProperty							= 5041,
	IncorrectNumberOfIndices					= 5042,
	RefParamsNonSupportedInDebugger				= 5043,
	CannotCallSecurityMethodLateBound			= 5044,
	CannotUseStaticSecurityAttribute			= 5045,
	FuncEvalAborted								= 6000,
	FuncEvalTimedout							= 6001,
	FuncEvalThreadSuspended						= 6002,
	FuncEvalThreadSleepWaitJoin					= 6003,
	FuncEvalBadThreadState						= 6004,
	FuncEvalBadThreadNotStarted					= 6005,
	NoFuncEvalAllowed							= 6006, 
	FuncEvalBadLocation							= 6007,
	FuncEvalWebMethod							= 6008,
	StaticVarNotAvailable						= 6009,
	TypeObjectNotAvailable						= 6010,
	ExceptionFromHResult						= 6011

}; // enum JSError

}; // namespace Microsoft.JScript
