/*
 * RegisteredWaitHandle.cs - Implementation of the
 *		"System.Threading.RegisteredWaitHandle" class.
 *
 * Copyright (C) 2003  Southern Storm Software, Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

namespace System.Threading
{

#if ECMA_COMPAT
internal
#else
public
#endif
sealed class RegisteredWaitHandle : MarshalByRefObject
{
	// Internal state.
	private ThreadPool.WorkItem workItem;

	// Constructor.
	internal RegisteredWaitHandle(ThreadPool.WorkItem workItem)
			{
				this.workItem = workItem;
			}

	// Destructor.
	~RegisteredWaitHandle()
			{
				// Nothing to do here in this implementation.
			}

	// Unregister using a specific wait object.
	public bool Unregister(WaitHandle waitObject)
			{
				if(workItem.waitObject == waitObject)
				{
					workItem.registered = false;
					return true;
				}
				else
				{
					return false;
				}
			}

}; // class RegisteredWaitHandle

}; // namespace System.Threading
