/*
 * Shortcut.cs - Implementation of the
 *		"System.Windows.Forms.Shortcut" class.
 *
 * Copyright (C) 2003  Southern Storm Software, Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

namespace System.Windows.Forms
{

using System.Runtime.InteropServices;

#if !ECMA_COMPAT
[ComVisible(true)]
#endif
public enum Shortcut
{
	None			= 0x00000000,
	Ins				= 0x0000002D,
	Del				= 0x0000002E,
	F1				= 0x00000070,
	F2				= 0x00000071,
	F3				= 0x00000072,
	F4				= 0x00000073,
	F5				= 0x00000074,
	F6				= 0x00000075,
	F7				= 0x00000076,
	F8				= 0x00000077,
	F9				= 0x00000078,
	F10				= 0x00000079,
	F11				= 0x0000007A,
	F12				= 0x0000007B,
	ShiftIns		= 0x0001002D,
	ShiftDel		= 0x0001002E,
	ShiftF1			= 0x00020070,
	ShiftF2			= 0x00020071,
	ShiftF3			= 0x00020072,
	ShiftF4			= 0x00020073,
	ShiftF5			= 0x00020074,
	ShiftF6			= 0x00020075,
	ShiftF7			= 0x00020076,
	ShiftF8			= 0x00020077,
	ShiftF9			= 0x00020078,
	ShiftF10		= 0x00020079,
	ShiftF11		= 0x0002007A,
	ShiftF12		= 0x0002007B,
	CtrlIns			= 0x0002002D,
	CtrlDel			= 0x0002002E,
	Ctrl0			= 0x00020030,
	Ctrl1			= 0x00020031,
	Ctrl2			= 0x00020032,
	Ctrl3			= 0x00020033,
	Ctrl4			= 0x00020034,
	Ctrl5			= 0x00020035,
	Ctrl6			= 0x00020036,
	Ctrl7			= 0x00020037,
	Ctrl8			= 0x00020038,
	Ctrl9			= 0x00020039,
	CtrlA			= 0x00020041,
	CtrlB			= 0x00020042,
	CtrlC			= 0x00020043,
	CtrlD			= 0x00020044,
	CtrlE			= 0x00020045,
	CtrlF			= 0x00020046,
	CtrlG			= 0x00020047,
	CtrlH			= 0x00020048,
	CtrlI			= 0x00020049,
	CtrlJ			= 0x0002004A,
	CtrlK			= 0x0002004B,
	CtrlL			= 0x0002004C,
	CtrlM			= 0x0002004D,
	CtrlO			= 0x0002004E,
	CtrlP			= 0x0002004F,
	CtrlQ			= 0x00020050,
	CtrlR			= 0x00020051,
	CtrlS			= 0x00020052,
	CtrlT			= 0x00020053,
	CtrlU			= 0x00020054,
	CtrlV			= 0x00020055,
	CtrlW			= 0x00020056,
	CtrlX			= 0x00020057,
	CtrlY			= 0x00020058,
	CtrlZ			= 0x0002005A,
	CtrlF1			= 0x00020070,
	CtrlF2			= 0x00020071,
	CtrlF3			= 0x00020072,
	CtrlF4			= 0x00020073,
	CtrlF5			= 0x00020074,
	CtrlF6			= 0x00020075,
	CtrlF7			= 0x00020076,
	CtrlF8			= 0x00020077,
	CtrlF9			= 0x00020078,
	CtrlF10			= 0x00020079,
	CtrlF11			= 0x0002007A,
	CtrlF12			= 0x0002007B,
	CtrlShift0		= 0x00030030,
	CtrlShift1		= 0x00030031,
	CtrlShift2		= 0x00030032,
	CtrlShift3		= 0x00030033,
	CtrlShift4		= 0x00030034,
	CtrlShift5		= 0x00030035,
	CtrlShift6		= 0x00030036,
	CtrlShift7		= 0x00030037,
	CtrlShift8		= 0x00030038,
	CtrlShift9		= 0x00030039,
	CtrlShiftA		= 0x00030041,
	CtrlShiftB		= 0x00030042,
	CtrlShiftC		= 0x00030043,
	CtrlShiftD		= 0x00030044,
	CtrlShiftE		= 0x00030045,
	CtrlShiftF		= 0x00030046,
	CtrlShiftG		= 0x00030047,
	CtrlShiftH		= 0x00030048,
	CtrlShiftI		= 0x00030049,
	CtrlShiftJ		= 0x0003004A,
	CtrlShiftK		= 0x0003004B,
	CtrlShiftL		= 0x0003004C,
	CtrlShiftM		= 0x0003004D,
	CtrlShiftO		= 0x0003004E,
	CtrlShiftP		= 0x0003004F,
	CtrlShiftQ		= 0x00030050,
	CtrlShiftR		= 0x00030051,
	CtrlShiftS		= 0x00030052,
	CtrlShiftT		= 0x00030053,
	CtrlShiftU		= 0x00030054,
	CtrlShiftV		= 0x00030055,
	CtrlShiftW		= 0x00030056,
	CtrlShiftX		= 0x00030057,
	CtrlShiftY		= 0x00030058,
	CtrlShiftZ		= 0x0003005A,
	CtrlShiftF1		= 0x00030070,
	CtrlShiftF2		= 0x00030071,
	CtrlShiftF3		= 0x00030072,
	CtrlShiftF4		= 0x00030073,
	CtrlShiftF5		= 0x00030074,
	CtrlShiftF6		= 0x00030075,
	CtrlShiftF7		= 0x00030076,
	CtrlShiftF8		= 0x00030077,
	CtrlShiftF9		= 0x00030078,
	CtrlShiftF10	= 0x00030079,
	CtrlShiftF11	= 0x0003007A,
	CtrlShiftF12	= 0x0003007B,
	AltBksp			= 0x00040008,
	Alt0			= 0x00040030,
	Alt1			= 0x00040031,
	Alt2			= 0x00040032,
	Alt3			= 0x00040033,
	Alt4			= 0x00040034,
	Alt5			= 0x00040035,
	Alt6			= 0x00040036,
	Alt7			= 0x00040037,
	Alt8			= 0x00040038,
	Alt9			= 0x00040039,
	AltF1			= 0x00040070,
	AltF2			= 0x00040071,
	AltF3			= 0x00040072,
	AltF4			= 0x00040073,
	AltF5			= 0x00040074,
	AltF6			= 0x00040075,
	AltF7			= 0x00040076,
	AltF8			= 0x00040077,
	AltF9			= 0x00040078,
	AltF10			= 0x00040079,
	AltF11			= 0x0004007A,
	AltF12			= 0x0004007B,

}; // enum Shortcut

}; // namespace System.Windows.Forms
