/* log.h - part of ziproxy package
 *
 * Copyright (c)2003-2004 Juraj Variny<variny@naex.sk>
 * Copyright (c)2005-2006 Daniel Mealha Cabrita
 *
 * Released subject to GNU General Public License v2 or later version.
 *
 * Convenient logging functions.
 */

#include "http.h"

//To stop multiple inclusions.
#ifndef SRC_LOG_H
#define SRC_LOG_H

typedef struct {
	http_headers *hdr;	// client headers
	struct timeval *giventime;
	const char *client_addr;
	int inlen;
	int inlen_decompressed; // if incoming data wasn't gzipped, will be equal to inlen
	int outlen;
	int rep_strm_inlen_decompressed; // see AccessLogUserPOV
	int flag_as_broken_pipe;
} t_accesslog_data;

/* we need this data globally accessible in order to log accesses in the cases
 * the process was interrupted by a signal (due to broken pipe, timeout, etc) */
extern t_accesslog_data *accesslog_data;

extern int minus_one;

extern void init_logging();

extern int logprintf(char *fmt, ...);

extern void logputs(char *str);
extern void logputs_hdr(char *str);

extern void logdifftime(char *activity);

int init_access_log (void);

void set_logpid_current (void);

void access_log_flags (int *inlen_o, int *outlen_o, const char *extra_flags);
void access_log (int *inlen_o, int *outlen_o);

#endif //SRC_LOG_H
