/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AlreadyRegisteredException;
import Ice.Communicator;
import Ice.InitializationException;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectAdapterI;
import Ice.ObjectPrx;
import Ice.RouterPrx;
import Ice.Util;
import IceInternal.Instance;
import IceUtil.Assert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public final class ObjectAdapterFactory {
    private Instance _instance;
    private Communicator _communicator;
    private HashMap _adapters = new HashMap();
    private boolean _waitForShutdown;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        HashMap adapters;
        ObjectAdapterFactory objectAdapterFactory = this;
        synchronized (objectAdapterFactory) {
            if (this._instance == null) {
                return;
            }
            this._instance = null;
            this._communicator = null;
            adapters = this._adapters;
            this.notifyAll();
        }
        if (adapters != null) {
            Iterator i = adapters.values().iterator();
            while (i.hasNext()) {
                ObjectAdapter adapter = (ObjectAdapter)i.next();
                adapter.deactivate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForShutdown() {
        HashMap adapters;
        ObjectAdapterFactory objectAdapterFactory = this;
        synchronized (objectAdapterFactory) {
            while (this._instance != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            while (this._waitForShutdown) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            this._waitForShutdown = true;
            adapters = this._adapters;
        }
        if (adapters != null) {
            Iterator i = adapters.values().iterator();
            while (i.hasNext()) {
                ObjectAdapter adapter = (ObjectAdapter)i.next();
                adapter.waitForDeactivate();
            }
        }
        objectAdapterFactory = this;
        synchronized (objectAdapterFactory) {
            this._waitForShutdown = false;
            this.notifyAll();
        }
    }

    public synchronized boolean isShutdown() {
        return this._instance == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        HashMap adapters;
        this.waitForShutdown();
        ObjectAdapterFactory objectAdapterFactory = this;
        synchronized (objectAdapterFactory) {
            adapters = this._adapters;
            this._adapters = null;
        }
        if (adapters != null) {
            Iterator i = adapters.values().iterator();
            while (i.hasNext()) {
                ObjectAdapter adapter = (ObjectAdapter)i.next();
                adapter.destroy();
            }
        }
    }

    public synchronized ObjectAdapter createObjectAdapter(String name, String endpoints, RouterPrx router) {
        if (this._instance == null) {
            throw new ObjectAdapterDeactivatedException();
        }
        ObjectAdapter adapter = (ObjectAdapter)this._adapters.get(name);
        if (adapter != null) {
            throw new AlreadyRegisteredException("object adapter", name);
        }
        if (name.length() == 0 && (endpoints.length() != 0 || router != null)) {
            InitializationException ex = new InitializationException();
            ex.reason = "Cannot configure endpoints or router with nameless object adapter";
            throw ex;
        }
        if (name.length() == 0) {
            String uuid = Util.generateUUID();
            adapter = new ObjectAdapterI(this._instance, this._communicator, this, uuid, "", null, true);
            this._adapters.put(uuid, adapter);
        } else {
            adapter = new ObjectAdapterI(this._instance, this._communicator, this, name, endpoints, router, false);
            this._adapters.put(name, adapter);
        }
        return adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectAdapter findObjectAdapter(ObjectPrx proxy) {
        ArrayList adapters;
        ObjectAdapterFactory objectAdapterFactory = this;
        synchronized (objectAdapterFactory) {
            if (this._instance == null) {
                return null;
            }
            adapters = new ArrayList(this._adapters.values());
        }
        Iterator p = adapters.iterator();
        while (p.hasNext()) {
            try {
                ObjectAdapterI adapter = (ObjectAdapterI)p.next();
                if (!adapter.isLocal(proxy)) continue;
                return adapter;
            }
            catch (ObjectAdapterDeactivatedException ex) {
            }
        }
        return null;
    }

    public synchronized void removeObjectAdapter(String name) {
        if (this._instance == null) {
            return;
        }
        this._adapters.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBatchRequests() {
        ArrayList adapters;
        ObjectAdapterFactory objectAdapterFactory = this;
        synchronized (objectAdapterFactory) {
            if (this._adapters == null) {
                return;
            }
            adapters = new ArrayList(this._adapters.values());
        }
        Iterator p = adapters.iterator();
        while (p.hasNext()) {
            ((ObjectAdapterI)p.next()).flushBatchRequests();
        }
    }

    ObjectAdapterFactory(Instance instance, Communicator communicator) {
        this._instance = instance;
        this._communicator = communicator;
        this._waitForShutdown = false;
    }

    protected synchronized void finalize() throws Throwable {
        Assert.FinalizerAssert(this._instance == null);
        Assert.FinalizerAssert(this._communicator == null);
        Assert.FinalizerAssert(this._adapters == null);
        Assert.FinalizerAssert(!this._waitForShutdown);
        super.finalize();
    }
}

