/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI;

import IceGridGUI.Application.Root;
import IceGridGUI.ApplicationPane;
import IceGridGUI.Coordinator;
import IceGridGUI.Tab;
import IceGridGUI.Utils;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MainPane
extends JTabbedPane {
    private Coordinator _coordinator;
    private ImageIcon _registryIcon;
    private ImageIcon _fileIcon;

    public void addApplication(ApplicationPane application) {
        Root root = application.getRoot();
        super.addTab(this.computeTitle(root.getId()), this.getIcon(root), application);
    }

    public void setTitleAt(int index, String title) {
        super.setTitleAt(index, this.computeTitle(title));
    }

    public void resetTitle(Root root) {
        int i = this.findIndex(root);
        if (i > 0) {
            this.setTitleAt(i, root.getId());
        }
    }

    public void resetIcon(Root root) {
        int i = this.findIndex(root);
        if (i > 0) {
            this.setIconAt(i, this.getIcon(root));
        }
    }

    public int findIndex(Root root) {
        for (int i = 1; i < this.getTabCount(); ++i) {
            ApplicationPane pane = (ApplicationPane)this.getComponentAt(i);
            if (pane.getRoot() != root) continue;
            return i;
        }
        return -1;
    }

    public ApplicationPane findApplication(Root root) {
        for (int i = 1; i < this.getTabCount(); ++i) {
            ApplicationPane pane = (ApplicationPane)this.getComponentAt(i);
            if (pane.getRoot() != root) continue;
            return pane;
        }
        return null;
    }

    public void removeApplication(Root root) {
        for (int i = 1; i < this.getTabCount(); ++i) {
            ApplicationPane pane = (ApplicationPane)this.getComponentAt(i);
            if (pane.getRoot() != root) continue;
            this.removeTabAt(i);
            break;
        }
    }

    MainPane(Coordinator coordinator) {
        this._coordinator = coordinator;
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Tab tab = (Tab)((Object)MainPane.this.getSelectedComponent());
                tab.selected();
            }
        });
        this._registryIcon = Utils.getIcon("/icons/16x16/registry_bound_application.png");
        this._fileIcon = Utils.getIcon("/icons/16x16/file_bound_application.png");
        this.addTab("Live Deployment", Utils.getIcon("/icons/16x16/live_deployment.png"), this._coordinator.getLiveDeploymentPane());
    }

    private String computeTitle(String name) {
        String title = name;
        int i = 0;
        while (this.hasTitle(title)) {
            title = name + " (" + Integer.toString(++i) + ")";
        }
        return title;
    }

    private boolean hasTitle(String title) {
        int tabCount = this.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            if (!title.equals(this.getTitleAt(i))) continue;
            return true;
        }
        return false;
    }

    private ImageIcon getIcon(Root root) {
        if (root.isLive()) {
            return this._registryIcon;
        }
        if (root.hasFile()) {
            return this._fileIcon;
        }
        return null;
    }
}

