# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python tools
#
# Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

"""
Ticker is an object used to synchronize the update of Controllers. Ticker
maintains a list of controllers that are updated each time the tick() method
is called.
"""


class Ticker(object):
    """
    """

    def __init__(self):
        self._controllers = []

    # Public methods

    def tick(self):
        """
        Call the update method of all the controllers associated to the ticker.
        """
        for controller in self._controllers:
            controller.update()

    def get_controllers(self):
        """
        Retrieve the controller list associated to the ticker.
        """
        return self._controllers

    # Protected methods

    def add_controller(self, controller):
        """
        Add a new controller to the ticker.
        """
        self._controllers.append(controller)

    def remove_controller(self, controller):
        """
        Remove a controller from the ticker.
        """
        self._controllers.remove(controller)
