/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file XYList.h
    \brief Definition of the Template class XYList.
    
    Magics Team - ECMWF 2004
    
    Started: Thu 6-May-2004
    
    Changes:
    
*/

#ifndef XYList_H
#define XYList_H

#include "magics.h"
#include "MagException.h"

#include "Data.h"
#include "XYListAttributes.h"
#include "UserPoint.h"


namespace magics {

template <class P>
class XYList: public Data<P>, 
              public XYListAttributes, 
              public PointsList<P> 
{
public:
	XYList() {}
	virtual ~XYList() {}

	void prepare();
	void set(const map<string, string>& map ) { XYListAttributes::set(map); }
	void set(const XmlNode& node ) { XYListAttributes::set(node); }
	void visit(Transformation& transformation);


	PointsHandler<P>& points(const Transformation&)  {
	    	prepare();
	    	this->pointsHandlers_.push_back(new PointsHandler<P>(*this)); 
	    	return *(this->pointsHandlers_.back());
	    } 
	
	PointsHandler<P>& points(){
		prepare();
		this->pointsHandlers_.push_back(new PointsHandler<P>(*this)); 
		return *(this->pointsHandlers_.back());
	}

	virtual void customisedPoints(const std::set<string>&, CustomisedPointsList&);
	virtual void customisedPoints(const Transformation&, const std::set<string>&, CustomisedPointsList& );
	void getReady(const Transformation&);
	virtual void points(vector<P>&);

protected:
	//! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 

private:
    //! Copy constructor - No copy allowed
	XYList(const XYList&);
    //! Overloaded << operator to copy - No copy allowed
	XYList& operator=(const XYList&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const XYList& p)
		{ p.print(s); return s; }

};
#include "XYList.cc"
} // namespace magics
#endif
