dnl
dnl AM_PATH_MAGICS
dnl
AC_DEFUN([AM_PATH_MAGICS],
[

AC_ARG_WITH(magics,
	AS_HELP_STRING([--with-magics],
		[Prefix of Magics++ instalation (optional, default is $MAGPLUS_HOME)]),
	[
	magics_config_prefix=$with_magics
	],
	[
	if test x"${MAGPLUS_HOME}" != x; then
		magics_config_prefix=$MAGPLUS_HOME
	fi
	]
)

if test x$magics_config_prefix != x ; then
	MAGICS_CONFIG=$magics_config_prefix/bin/magics-config
fi

AC_PATH_PROG(MAGICS_CONFIG, magics-config, no)
if test "$MAGICS_CONFIG" = "no" ; then
	AC_MSG_ERROR([Cannot find 'magics-config'.])
fi

MAGICS_CFLAGS=`$MAGICS_CONFIG --cxxflags`
MAGICS_LIBS=`$MAGICS_CONFIG --libs`
MAGICS_PREFIX=`$MAGICS_CONFIG --prefix`
AC_SUBST(MAGICS_CFLAGS)
AC_SUBST(MAGICS_LIBS)
AC_SUBST(MAGICS_PREFIX)

magics_version=`$MAGICS_CONFIG --version`
AC_MSG_RESULT([Using Magics++ version ${magics_version} from ${MAGICS_PREFIX}])
])
