/*
 * Copyright (c) 2001, 2002 The XDoclet team
 * All rights reserved.
 */
package xdoclet.modules.ibm.websphere.ejb;

import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import xjavadoc.XTag;

import xdoclet.XDocletException;
import xdoclet.modules.ejb.env.EnvTagsHandler;

/**
 * @author               Matthias Germann (matthias@germann.com)
 * @created              December 24, 2004
 * @modified             Matthias Germann (matthias@germann.com)
 * @xdoclet.taghandler   namespace="WebSphere"
 * @version              $Revision: 1.3 $
 */
public class WebSphereTagsHandler extends EnvTagsHandler
{
    /**
     * Iterates over all \@websphere.resource-ref tags with the same res-ref-name as the current tag
     *
     * @param template           The body of the block tag
     * @param attributes         The attributes of the template tag
     * @throws XDocletException  if something goes wrong
     * @doc.tag                  type="block"
     * @doc.param                name="nameParam" optional="true" default="res-ref-name" description="The name of the
     *      current tag's parameter which contains the name of the resource reference. The value of this parameter is
     *      used for finding the corresponding \@websphere.resource-ref tag"
     */
    public void forAllResourceRefs(String template, Properties attributes) throws XDocletException
    {
        if (currentTag == null) {
            throw new XDocletException("XDtWebSphere.forAllResourceRefs can only be used inside XDtWebSphere.forAllTags");
        }

        String nameParam = attributes.getProperty("nameParam", "res-ref-name");
        String resRefName = currentTag.getAttributeValue(nameParam);

        XTag wsResRef = null;

        if (currentMember == null) {
            // class level
            Collection tags = getCurrentClass().getDoc().getTags("websphere:resource-ref", true);

            for (Iterator i = tags.iterator(); i.hasNext(); ) {
                XTag tag = (XTag) i.next();
                String attr = tag.getAttributeValue("res-ref-name");

                if (resRefName != null && !resRefName.equals(attr)) {
                    continue;
                }

                wsResRef = tag;
            }
        }
        else {
            // field- or method-level
            wsResRef = currentMember.getDoc().getTag("websphere:resource-ref", true);
        }

        if (wsResRef != null) {
            XTag oldCurrentTag = currentTag;

            currentTag = wsResRef;
            generate(template);
            currentTag = oldCurrentTag;
        }
    }
}
