$:.unshift "../lib"

require 'test/unit'
require 'needle'
require 'needle/extras/attr-inject'

class TC_AttrInject_Class < Test::Unit::TestCase

  def test_attr_inject
    assert_nothing_raised do
      Class.new do
        attr_inject :foo
        attr_inject :bar, :baz
        attr_inject "test"
      end
    end
  end

  def test_injectable_attributes
    klass = Class.new do
      attr_inject :foo
      attr_inject :bar, :baz
      attr_inject "test"
    end
    assert_equal [ :foo, :bar, :baz, :test ], klass.injectable_attributes
  end

end


class AttrInject_MockContainer
  def get( attribute )
    attribute
  end
end


class TC_AttrInject_Object < Test::Unit::TestCase

  def test_inject_attributes
    klass = Class.new { attr_inject :foo, :bar }
    obj = klass.new.inject_attributes( AttrInject_MockContainer.new )
    assert_equal :foo, obj.instance_variable_get( "@foo" )
    assert_equal :bar, obj.instance_variable_get( "@bar" )
  end

end


class TC_AttrInject_InjectorElement < Test::Unit::TestCase

  def setup
    point = Class.new do
      attr_reader :container
      def initialize( c ); @container = c; end
    end.new( AttrInject_MockContainer.new )

    klass = Class.new { attr_inject :foo, :bar }

    @element = Needle::Extras::AttrInject::InjectorElement.new( point )
    @element.succ = proc { klass.new }
  end

  def test_default_priority
    assert_equal 0, @element.priority
  end

  def test_call_multiargs
    assert_nothing_raised do
      @element.call( 1, 2, 3 )
    end
  end

  def test_call
    obj = @element.call( 1, 2, 3 )
    assert_equal :foo, obj.instance_variable_get( "@foo" )
    assert_equal :bar, obj.instance_variable_get( "@bar" )
  end

end


class TC_AttrInject_Services < Test::Unit::TestCase

  def setup
    @reg = Needle::Registry.new
    Needle::Extras::AttrInject.register_services( @reg )
    @reg.register( :foo ) { "foo is wizard!" }
    @reg.register( :bar ) { "bar is teh bomb!" }
  end

  def test_no_inject
    @reg.register( :hit_me, :model => :singleton_inject ) do
      Class.new { def hello; "hello"; end }.new
    end
    hit_me = nil
    assert_nothing_raised do
      hit_me = @reg.hit_me
    end
    assert_equal "hello", hit_me.hello
  end

  def test_inject
    @reg.register( :hit_me, :model => :singleton_inject ) do
      Class.new { attr_inject :foo, :bar; attr_reader :foo, :bar }.new
    end
    hit_me = nil
    assert_nothing_raised do
      hit_me = @reg.hit_me
    end
    assert_equal "foo is wizard!", hit_me.foo
    assert_equal "bar is teh bomb!", hit_me.bar
  end

end
