/**
 * GUI Commands
 * Copyright 2005 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: DelegateContainer.java,v 1.5 2006/05/27 18:25:01 pietschy Exp $
 */
package org.pietschy.command.delegate;

import org.pietschy.command.ActionCommandExecutor;

/**
 * The DelgateContainer interface marks a JComponent as being a provider of {@link CommandDelegate}s.
 * <p>
 * The {@link DelegateManager} tracks focus changes and searches up the components heirarchy to locate
 * the first container implementing this interface.  {@link DelegatingCommand}s use the {@link DelegateManager}
 * to automatically bind to their associated delegates when the focus changes. 
 *
 * @author andrewp
 * @version $Revision: 1.5 $
 */
public interface
DelegateContainer
{
   /**
    * Gets the specifed command from this container.  If the command isn't registered with this
    * container then the request is delegated to the containers parent.
    *
    * @param commandId the commands id.
    * @return the command with the specified id, or <tt>null</tt> if it hasn't been registered
    *         with this container of one of its parents.
    */
   public ActionCommandExecutor getCommandExecutor(String commandId);
}
