/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: DefaultButtonFactory.java,v 1.4 2005/01/09 03:24:02 pietschy Exp $
 */

package org.pietschy.command;

import javax.swing.*;

/**
 * Default implementation of {@link ButtonFactory}.  This factory creates standard swing
 * buttons.
 */
public class
DefaultButtonFactory
implements ButtonFactory
{
   /**
    * Creates a new {@link JButton}.
    * @return a new {@link JButton}.
    */
   public JButton createButton()
   {
      return new JButton();
   }

   /**
    * Creates a new {@link JCheckBox}.
    * @return a new {@link JCheckBox}.
    */
   public JCheckBox createCheckBox()
   {
      return new JCheckBox();
   }

   /**
    * Creates a new {@link JRadioButton}.
    * @return a new {@link JRadioButton}.
    */
   public JRadioButton createRadioButton()
   {
      return new JRadioButton();
   }

   /**
    * Creates a new {@link JToggleButton}.
    * @return a new {@link JToggleButton}.
    */
   public AbstractButton createToggleButton()
   {
      return new JToggleButton();
   }
}
