module Data.Default (
-- | This module defines a class for types with a default value. Instances are
-- provided for '()', 'S.Set', 'M.Map', 'Int', 'Integer', 'Float', 'Double',
-- 'Ratio', 'Maybe', '[]', '->' and 'IO'.
    Default(..)
) where

import Data.Ratio
import qualified Data.Set as S
import qualified Data.Map as M

-- | A class for types with a default value.
class Default a where
    -- | The default value for this type.
    def :: a

instance Default () where def = ()

instance Default (S.Set v) where def = S.empty
instance Default (M.Map k v) where def = M.empty

instance Default Int where def = 0
instance Default Integer where def = 0
instance Default Float where def = 0
instance Default Double where def = 0
instance (Integral a) => Default (Ratio a) where def = 0

instance Default (Maybe a) where def = Nothing
instance Default [a] where def = []

instance (Default r) => Default (e -> r) where def _ = def
instance (Default a) => Default (IO a) where def = return def
