/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/testing_namespaces.hpp
 * @brief [LEVEL: beta] the namespaces for test code
 *
 * $Id: testing_namespaces.hpp,v 1.4 2005/06/23 09:54:25 esdentem Exp $
 * 
 * @author Christian Schallhart
 */

#ifndef DIAGNOSTICS__UNITTEST__TESTING_NAMESPACES_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__UNITTEST__TESTING_NAMESPACES_HPP__INCLUDE_GUARD

#ifndef TEST_NAMESPACE
/**
 * @brief general namespace for test-code: to be nested in the
 * namespace which contains the tested code
 */
#  define TEST_NAMESPACE testing
#  define TEST_NAMESPACE_BEGIN namespace TEST_NAMESPACE { void dummy_for_semicolon_do_not_use()
#  define TEST_NAMESPACE_END } void dummy_for_semicolon_do_not_use()
#endif

#define TEST_INTERNAL_CONCAT_1(A,B) A ## B
#define TEST_INTERNAL_CONCAT(A,B) TEST_INTERNAL_CONCAT_1(A,B)

/**
 * @brief the namespace for the test-code of a single component: to be
 * nested in the namespace which contains all the test code for a
 * given tested namespace.
 */
#define TEST_COMPONENT_TEST_NAMESPACE TEST_INTERNAL_CONCAT(COMPONENT_,TEST_COMPONENT_NAME)

#define TEST_COMPONENT_TEST_NAMESPACE_BEGIN namespace TEST_COMPONENT_TEST_NAMESPACE { void dummy_for_semicolon_do_not_use()
#define TEST_COMPONENT_TEST_NAMESPACE_END } void dummy_for_semicolon_do_not_use()

#endif
// vim:ts=4:sw=4
