SET(LANGUAGES
	de_DE
	zh_TW
)

SET(LUPDATE_OPTIONS 
	-extensions C,ui,c,c++,cc,cpp,cxx,ch,h,h++,hh,hpp,hxx -source-language en_US
)

SET(TRANSLATION_DIR ${CMAKE_SOURCE_DIR}/data/BALLView/translations/)

SET(TRANSLATION_SEARCH_DIRS
	${CMAKE_SOURCE_DIR}/source
)

SET(LUPDATE_INLUDE_PATHS
	-I ${CMAKE_SOURCE_DIR}/include/
)

SET(TRANSLATIONS)
SET(COMPILED_TRANSLATIONS)

FOREACH(i ${LANGUAGES})
	SET(__TS_TMP_FILE "${TRANSLATION_DIR}/BALLView.${i}.ts")
	SET(__QM_TMP_FILE "${TRANSLATION_DIR}/BALLView.${i}.qm")
	SET(__TRANS_NAME "translation_${i}")

	LIST(APPEND TRANSLATIONS ${__TRANS_NAME})
	LIST(APPEND COMPILED_TRANSLATIONS ${__QM_TMP_FILE})

	ADD_CUSTOM_TARGET(
		${__TRANS_NAME}
		COMMAND ${QT_LUPDATE_EXECUTABLE} ${LUPDATE_INLUDE_PATHS} ${LUPDATE_OPTIONS} -target-language ${i} ${TRANSLATION_SEARCH_DIRS} -ts "${__TS_TMP_FILE}"
	)

	ADD_CUSTOM_COMMAND(
		OUTPUT ${__QM_TMP_FILE}
		COMMAND ${QT_LRELEASE_EXECUTABLE} ${__TS_TMP_FILE}
		WORKING_DIRECTORY ${TRANSLATION_DIR}
		DEPENDS "${__TS_TMP_FILE}"
	)
ENDFOREACH()

ADD_CUSTOM_TARGET(update_translations)
ADD_DEPENDENCIES(update_translations ${TRANSLATIONS})

ADD_CUSTOM_TARGET(compile_translations DEPENDS ${COMPILED_TRANSLATIONS})
ADD_DEPENDENCIES(BALLView compile_translations)
