# include <string.h>
# include <stdlib.h>
# include <strings.h>
# include <iostream>
# include "classes.h"
# include "charset.h"

using std::cout;

struct MapEntry 
 { ClassId         Id;
   CharSet         Chars;
   struct MapEntry *Next;
 };

class Map
 { public:
   struct MapEntry *First;
   struct MapEntry *ScanPtr;
   Map (void);
   ~Map (void);
   void StartScanning (void);
   int Next (ClassId& Id, CharSet& Chars);
   void Add (ClassId& Id, CharSet& Chars);
   void Set (ClassId& Id, CharSet& Chars);
 };

 Map::Map (void)
 { First = NULL;
 }

 Map::~Map (void)
 { MapEntry* CurrEntry;
   MapEntry* NextEntry;
   
   CurrEntry = First;
   while (CurrEntry != NULL)
    { NextEntry = CurrEntry->Next;
      delete CurrEntry;
      CurrEntry = NextEntry;
    }
 }

void Map::StartScanning (void)
 { ScanPtr = First;
 }
     
int Map::Next (ClassId& Id, CharSet& Chars)
 { if (!ScanPtr)
      return -1;
   Id      = ScanPtr->Id;
   Chars   = ScanPtr->Chars;
   ScanPtr = ScanPtr->Next;
   return 0;
 }
     
void Map::Add (ClassId& Id, CharSet& Chars)
 { struct MapEntry* CurrEntry;

   if (First)
    { CurrEntry = First;
      while (CurrEntry->Next)
	 CurrEntry = CurrEntry->Next;
      CurrEntry->Next = new struct MapEntry;
      CurrEntry = CurrEntry->Next;
    }
   else
    { First = new MapEntry;
      CurrEntry = First;
    }
   CurrEntry->Id    = Id;
   CurrEntry->Chars = Chars;
   CurrEntry->Next  = NULL;
 }
   

void Map::Set (ClassId& Id, CharSet& Chars)
 { struct MapEntry* CurrEntry;

   CurrEntry = First;
   while (CurrEntry->Id != Id)
      CurrEntry = CurrEntry->Next;
   CurrEntry->Chars = Chars;
 }


# define RELATION_STRING 0
# define RELATION_CHAR   1

struct RelationsEntry
 { unsigned char         Type;
   union
    { char *ClassName;
      char Char;
    }                    Object;
   struct ClassIdEntry   *First;
   struct RelationsEntry *Next;
 };

class RelationList
 { 
   public: 
      struct RelationsEntry* First;
      RelationList ();
      ~RelationList ();
      void Add (char* Name, ClassId Id);
      void AddSingleCharClass (char Char, ClassId Id);
      void AddId (ClassId ToFind, ClassId ToAdd);
 };

 RelationList::RelationList ()
 { First = NULL;
 }

 RelationList::~RelationList ()
 { 
   struct RelationsEntry *CurrRelationListEntry;
   struct RelationsEntry *NextRelationListEntry;
   struct ClassIdEntry   *CurrClassIdEntry;
   struct ClassIdEntry   *NextClassIdEntry;

   CurrRelationListEntry = First;
   while (CurrRelationListEntry != NULL)
    { NextRelationListEntry = CurrRelationListEntry->Next;
      CurrClassIdEntry = CurrRelationListEntry->First;
      while (CurrClassIdEntry != NULL)
       { NextClassIdEntry = CurrClassIdEntry->Next;
	 delete CurrClassIdEntry;
	 CurrClassIdEntry = NextClassIdEntry;
       }
      delete CurrRelationListEntry;
      CurrRelationListEntry = NextRelationListEntry;
    }
 }

void RelationList::Add (char* Name, ClassId Id)
 { struct RelationsEntry *CurrEntry;
   struct ClassIdEntry   *FirstEntry;

   if (First)
    { CurrEntry = First;
      while (1)
       { if (CurrEntry->Type == RELATION_STRING)
	    if (strcmp (CurrEntry->Object.ClassName, Name) ==
		0)
	     { FirstEntry             = CurrEntry->First;
	       break;
	     }
	 if (!CurrEntry->Next)
	  { CurrEntry->Next = new struct RelationsEntry;
	    CurrEntry = CurrEntry->Next;
	    CurrEntry->Next = NULL;
	    CurrEntry->Type = RELATION_STRING;
	    CurrEntry->Object.ClassName = Name;
	    FirstEntry = NULL;
	    break;
	  }
	 CurrEntry = CurrEntry->Next;
       }
      CurrEntry->First       = new struct ClassIdEntry;
      CurrEntry->First->Next = FirstEntry;
      CurrEntry->First->Id   = Id;
    } 
   else
    { First = new struct RelationsEntry;
      First->Type = RELATION_STRING;
      First->Object.ClassName = Name;
      First->Next = NULL;
      First->First = new struct ClassIdEntry;
      First->First->Id = Id;
      First->First->Next = NULL;
    }
 }

void RelationList::AddSingleCharClass (char Char, ClassId Id)
 { struct RelationsEntry *CurrEntry;
   struct ClassIdEntry   *FirstEntry;

   if (First)
    { CurrEntry = First;
      while (1)
       { if (CurrEntry->Type == RELATION_CHAR)
	    if (CurrEntry->Object.Char == Char)
	       return;
	 if (!CurrEntry->Next)
	    break;
	 CurrEntry = CurrEntry->Next;
       }
      CurrEntry->Next = new struct RelationsEntry;
      CurrEntry = CurrEntry->Next;
      CurrEntry->Next = NULL;
      CurrEntry->Type = RELATION_CHAR;
      CurrEntry->Object.Char = Char;
      CurrEntry->First       = new struct ClassIdEntry;
      CurrEntry->First->Next = NULL;
      CurrEntry->First->Id   = Id;
    } 
   else
    { First = new struct RelationsEntry;
      First->Type = RELATION_CHAR;
      First->Object.Char = Char;
      First->Next = NULL;
      First->First = new struct ClassIdEntry;
      First->First->Id = Id;
      First->First->Next = NULL;
    }
 }

void RelationList::AddId (ClassId ToFind, ClassId ToAdd)
 { 
   struct RelationsEntry *CurrRelationListEntry;
   struct RelationsEntry *NextRelationListEntry;
   struct ClassIdEntry   *CurrClassIdEntry;
   struct ClassIdEntry   *NextClassIdEntry;

   CurrRelationListEntry = First;
   while (CurrRelationListEntry != NULL)
    { NextRelationListEntry = CurrRelationListEntry->Next;
      CurrClassIdEntry = CurrRelationListEntry->First;
      while (CurrClassIdEntry != NULL)
       { NextClassIdEntry = CurrClassIdEntry->Next;
	 if (CurrClassIdEntry->Id == ToFind)
	  { CurrClassIdEntry->Next = new struct ClassIdEntry;
	    CurrClassIdEntry       = CurrClassIdEntry->Next;
	    CurrClassIdEntry->Next = NextClassIdEntry;
	    CurrClassIdEntry->Id   = ToAdd;
	  }
	 CurrClassIdEntry = NextClassIdEntry;
       }
      CurrRelationListEntry = NextRelationListEntry;
    }
 }

static ClassId      Base;
static Map          Map;
static RelationList Relations;

void NewClass (char* Name, CharSet Chars)
 { CharSet CurrChars;
   CharSet InBoth;
   ClassId Id;

   Map.StartScanning ();
   while (Map.Next (Id, CurrChars) != -1)
    { InBoth = CurrChars - (CurrChars - Chars);
      if(!InBoth.IsEmpty ())
       { if ((CurrChars - Chars).IsEmpty ())
	  { Relations.Add (Name, Id);
	  }
         else
	  { CharSet NewCharSet = CurrChars - InBoth;
            Map.Set (Id, NewCharSet);
	    Map.Add (Base, InBoth);
            Relations.Add (Name, Base);
            Relations.AddId (Id, Base);
            Base++;
	  }
	 Chars = Chars - InBoth;
       }
    }
   if (!Chars.IsEmpty ())
    { Map.Add (Base, Chars);
      Relations.Add (Name, Base);
      Base++;
    }
 }

void NewSingleChar (char NewChar)
 { CharSet Chars;
   CharSet CurrChars;
   ClassId Id;
   struct RelationsEntry *CurrRelationListEntry;

   Chars.Insert (NewChar, NewChar);
   Map.StartScanning ();
   while (Map.Next (Id, CurrChars) != -1)
    { if ((Chars - CurrChars).IsEmpty ())
         if ((CurrChars - Chars).IsEmpty ())
	  { CurrRelationListEntry = Relations.First;
            while (CurrRelationListEntry != NULL)
             { if (CurrRelationListEntry->Type == RELATION_CHAR)
	          if (CurrRelationListEntry->Object.Char == NewChar)
		     return;
	       CurrRelationListEntry = CurrRelationListEntry->Next;
	     }
	    Relations.AddSingleCharClass (NewChar, Id);
	    return;
	  }
	 else
	  { CharSet NewCharSet = CurrChars - Chars;
	    Map.Set (Id, NewCharSet);
	    Map.Add (Base, Chars);
	    Relations.AddSingleCharClass (NewChar, Base);
	    Relations.AddId (Id, Base);
	    Base++;
	    return;
	  }
    }
   Map.Add (Base, Chars);
   Relations.AddSingleCharClass (NewChar, Base);
   Base++;
 }

void PrintClasses (void)
 { CharSet CurrChars;
   ClassId Id;

   Map.StartScanning ();
   while (Map.Next (Id, CurrChars) != -1)
    { Id.Print ();
      cout << "\n";
      CurrChars.Print ();
      cout << "\n";
    }
 }

void ScanClassMap (void)
 { Map.StartScanning ();
 }

int NextEntry (int& Id, CharSet& Set)
 { ClassId ClassId;
   int     ReturnValue;

   ReturnValue = Map.Next (ClassId, Set);
   if (ReturnValue != -1)
      Id = ClassId.GetId ();
   return ReturnValue;
 }

void ScanClassIds (void)
 { Map.StartScanning ();
 }

int NextClassId (ClassId& Id)
 { CharSet Chars;

   return Map.Next (Id, Chars);
 }

void PrintRelationList (void)
 { 
   struct RelationsEntry *CurrRelationListEntry;
   struct RelationsEntry *NextRelationListEntry;
   struct ClassIdEntry   *CurrClassIdEntry;
   struct ClassIdEntry   *NextClassIdEntry;

   CurrRelationListEntry = Relations.First;
   while (CurrRelationListEntry != NULL)
    { switch (CurrRelationListEntry->Type)
       { case RELATION_STRING:
	    cout << "Class " << 
	    CurrRelationListEntry->Object.ClassName << ": ";
	    break;
	 case RELATION_CHAR:
	    cout << "Single Char \'" <<
	    CurrRelationListEntry->Object.Char << "\': ";
	    break;
       }
      NextRelationListEntry = CurrRelationListEntry->Next;
      CurrClassIdEntry = CurrRelationListEntry->First;
      while (CurrClassIdEntry != NULL)
       { NextClassIdEntry = CurrClassIdEntry->Next;
	 (CurrClassIdEntry->Id).Print ();
	 cout << " ";
	 CurrClassIdEntry = NextClassIdEntry;
       }
      cout << "\n";
      CurrRelationListEntry = NextRelationListEntry;
    }
 }

ClassId FindClassId (char Char)
 { struct RelationsEntry *CurrRelationListEntry;

   CurrRelationListEntry = Relations.First;
   while (CurrRelationListEntry != NULL)
    { if (CurrRelationListEntry->Type == RELATION_CHAR)
	 if (CurrRelationListEntry->Object.Char == Char)
	    return CurrRelationListEntry->First->Id;
      CurrRelationListEntry = CurrRelationListEntry->Next;
    }
   return ClassId (0);
 }

void ScanIds (struct ClassIdEntry*& Context, char* Name)
 { struct RelationsEntry *CurrRelationListEntry;

   CurrRelationListEntry = Relations.First;
   while (CurrRelationListEntry != NULL)
    { if (CurrRelationListEntry->Type == RELATION_STRING)
	 if (strcmp (CurrRelationListEntry->Object.ClassName, Name) == 0)
	  { Context = CurrRelationListEntry->First;
	    return;
	  }
      CurrRelationListEntry = CurrRelationListEntry->Next;
    }
 }

struct ClassIdEntry* FindClassIds (struct ClassIdEntry*& Context, ClassId& Id)
 { struct ClassIdEntry   *CurrClassIdEntry;

   CurrClassIdEntry = Context;
   if (Context != NULL)
    { Id = Context->Id;
      Context = Context->Next;
    }
   return CurrClassIdEntry;
 }
