#include "charconst.h"

unsigned char HexVal (unsigned char W1, unsigned char W2, int& Error);


int StringToChar (unsigned char *String, unsigned char& Char)
 { int Error;

   if ((Char = *(String++)) != '\\')
      return (*String == 0)?0:-1;
   switch (Char = *(String++))
    { case 'x'  : Char = HexVal (*(String), *(String + 1), Error);
                  if (Error == -1)
		     return -1;
                  break;
      case 'n'  : Char = '\n'; break;
      case 't'  : Char = '\t'; break;
      case 'v'  : Char = '\v'; break;
      case 'b'  : Char = '\b'; break;
      case 'r'  : Char = '\r'; break;
      case 'f'  : Char = '\f'; break;
      case 'a'  : Char = '\a'; break;
      case '\\' : Char = '\\'; break;
      case '\?' : Char = '\?'; break;
      case '\'' : Char = '\''; break;
      case '\"' : Char = '\"'; break;
      case '0' : Char = '\0'; break;
      default:    return -1;
     }
   return 0;
 }

unsigned char HexVal (unsigned char W1, unsigned char W2, int& Error)
 { unsigned char Val;
   
   Error = 0;
   if (W1 >= '0' && W1 <= '9')
      Val = (W1 - '0') * 16;
   else if (W1 >= 'a' && W1 <= 'f')
      Val = (W1 - 'a' + 10) * 16;
   else if (W1 >= 'A' && W1 <= 'F')
      Val = (W1 - 'A' + 10) * 16;
   else
    { Error = -1;
      return 0;
    }

   if (W2 >= '0' && W2 <= '9')
      Val += W2 - '0';
   else if (W2 >= 'a' && W2 <= 'f')
      Val += W2 - 'a' + 10;
   else if (W2 >= 'A' && W2 <= 'F')
      Val += W2 - 'A' + 10;
   else
    { Error = -1;
      return 0;
    }

   return Val;
 }


int CharToString (unsigned char& Char, unsigned char *String)
 {
   if (Char >= ' ')
    { *(String++) = Char;
      *String     = '\0';
      return 0;
    }
   *(String++) = '\\';
   switch (Char)
    { case '\n'  : *(String++) = 'n'; break;
      case '\t'  : *(String++) = 't'; break;
      case '\v'  : *(String++) = 'v'; break;
      case '\b'  : *(String++) = 'b'; break;
      case '\r'  : *(String++) = 'r'; break;
      case '\f'  : *(String++) = 'f'; break;
      case '\a'  : *(String++) = 's'; break;
      case '\\' : *(String++) = '\\'; break;
      case '\?' : *(String++) = '\?'; break;
      case '\'' : *(String++) = '\''; break;
      case '\"' : *(String++) = '\"'; break;
      case '\0' : *(String++) = '0'; break;
      default:    return -1;
     }
    *String = '\0';
    return 0;
 }

unsigned char ScanString (unsigned char*& String)
 { unsigned char Char;

   Char = *(String++);
   if (Char == '\\')
    { switch (Char = *(String++))
       { case 'n'  : return '\n';
         case 't'  : return '\t';
         case 'v'  : return '\v';
         case 'b'  : return '\b';
         case 'r'  : return '\r';
         case 'f'  : return '\f';
         case 'a'  : return '\a';
         case '\\' : return '\\';
         case '\?' : return '\?';
         case '\'' : return '\'';
         case '\"' : return '\"';
         case '0'  : return '\0';
         default   : return 0;
       }
    }
   else
      return Char;
 }






