// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#include "Puma/Filename.h"

namespace Puma {


void Filename::name (const char *n) {
  data (new FilenameInfo);
  info ()->name (n);
}


const char *Filename::name () const {
  return info ()->name (); 
}


const char *Filename::path () const {
  return info ()->path (); 
}

const char *Filename::root () const {
  return info ()->root (); 
}

bool Filename::is_absolute () const {
  return info ()->is_absolute ();
}

bool Filename::operator == (const Filename &f) const {
  if (info () == f.info ())
    return true;
  if (! info () || ! f.info ())
    return false;
   
  return *info () == *f.info ();
}


} // namespace Puma
