#!/usr/bin/perl -w
#
# Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
#
# enumerate.pl
#
# This script lists all of the registered virtual machines
# on the server specified by hostname.
#
# usage:
#   enumerate.pl <hostname> <user> <password>
#

BEGIN {
   if ($^O eq "MSWin32") {
      @INC = (
         # Set the path to your VmPerl Scripting directory if different
         'C:\Program Files\VMware\VMware VmPerl Scripting API\perl5\site_perl\5.005',
         'C:\Program Files\VMware\VMware VmPerl Scripting API\perl5\site_perl\5.005\MSWin32-x86');
   }
}

use VMware::VmPerl;
use VMware::VmPerl::Server;
use VMware::VmPerl::ConnectParams;
use strict;

my ($server_name, $user, $passwd) = @ARGV;

# Use the default port of 902.  Change this if your port is different.
my $port = 902;

# Create a new VMware::VmPerl::Server to connect to the server
# To connect to the remote server, use the following line:
my $connect_params = 
   VMware::VmPerl::ConnectParams::new($server_name,$port,$user,$passwd);

# To connect to a local server, you would use the following line:
# my $connect_params = 
#    VMware::VmPerl::ConnectParams::new(undef,$port,$user,$passwd);

# To connect to a local server as the current user, you would use the 
# following line:
# my $connect_params = VMware::VmPerl::ConnectParams::new();


# Establish a persistent connection with server
my $server = VMware::VmPerl::Server::new();
if (!$server->connect($connect_params)) {
   my ($error_number, $error_string) = $server->get_last_error();
   die "Could not connect to server: Error $error_number: $error_string\n";
}

print "\nThe following virtual machines are registered:\n";

# Obtain a list containing every config file path registered with the server.
my @list = $server->registered_vm_names();
if (!defined($list[0])) {
   my ($error_number, $error_string) = $server->get_last_error();
   die "Could not get list of VMs from server: Error $error_number: ".
       "$error_string\n";
}

print "$_\n" foreach (@list);

# Destroys the server object, thus disconnecting from the server.
undef $server;

