// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

//
// ISO C++ 14882: 27.6.2  Output streams
//

#include <bits/std_locale.h>

namespace std {

  template<typename _CharT, typename _Traits>
    basic_ostream<_CharT, _Traits>& 
    basic_ostream<_CharT, _Traits>::operator<<(bool __n)
    {
      sentry __cerb(*this);
      if (__cerb) 
	{
	  try {
	    if (_M_fnumput->put(*this, *this, this->fill(), __n).failed())
	      this->setstate(ios_base::failbit);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_ostream<_CharT, _Traits>& 
    basic_ostream<_CharT, _Traits>::operator<<(long __n)
    {
      sentry __cerb(*this);
      if (__cerb) 
	{
	  try {
	    if (_M_fnumput->put(*this, *this, this->fill(), __n).failed())
	      this->setstate(ios_base::failbit);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_ostream<_CharT, _Traits>& 
    basic_ostream<_CharT, _Traits>::operator<<(unsigned long __n)
    {
      sentry __cerb(*this);
      if (__cerb) 
	{
	  try {
	    if (_M_fnumput->put(*this, *this, this->fill(), __n).failed())
	      this->setstate(ios_base::failbit);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

#ifdef _GLIBCPP_USE_LONG_LONG
  template<typename _CharT, typename _Traits>
    basic_ostream<_CharT, _Traits>& 
    basic_ostream<_CharT, _Traits>::operator<<(long long __n)
    {
      sentry __cerb(*this);
      if (__cerb) 
	{
	  try {
	    if (_M_fnumput->put(*this, *this, this->fill(), __n).failed())
	      this->setstate(ios_base::failbit);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_ostream<_CharT, _Traits>& 
    basic_ostream<_CharT, _Traits>::operator<<(unsigned long long __n)
    {
      sentry __cerb(*this);
      if (__cerb) 
	{
	  try {
	    if (_M_fnumput->put(*this, *this, this->fill(), __n).failed())
	      this->setstate(ios_base::failbit);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }
#endif

  template<typename _CharT, typename _Traits>
    basic_ostream<_CharT, _Traits>& 
    basic_ostream<_CharT, _Traits>::operator<<(double __n)
    {
      sentry __cerb(*this);
      if (__cerb) 
	{
	  try {
	    if (_M_fnumput->put(*this, *this, this->fill(), __n).failed())
	      this->setstate(ios_base::failbit);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_ostream<_CharT, _Traits>& 
    basic_ostream<_CharT, _Traits>::operator<<(long double __n)
    {
      sentry __cerb(*this);
      if (__cerb) 
	{
	  try {
	    if (_M_fnumput->put(*this, *this, this->fill(), __n).failed())
	      this->setstate(ios_base::failbit);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_ostream<_CharT, _Traits>& 
    basic_ostream<_CharT, _Traits>::operator<<(const void* __n)
    {
      sentry __cerb(*this);
      if (__cerb) 
	{
	  try {
	    if (_M_fnumput->put(*this, *this, this->fill(), __n).failed())
	      this->setstate(ios_base::failbit);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_ostream<_CharT, _Traits>& 
    basic_ostream<_CharT, _Traits>::operator<<(__streambuf_type* __sb)
    {
      sentry __cerb(*this);
      if (__sb && __cerb) 
	{
	  streamsize __num = __sb->in_avail();
	  if (__num > 0)
	    {
	      char_type __buf[__num];
	      try {
		__sb->sgetn(__buf, __num);
	      }
	      catch(...) {
		this->setstate(ios_base::failbit);
		if ((this->exceptions() & ios_base::failbit) != 0)
		  throw;
	      }
	      streamsize __put = this->rdbuf()->sputn(__buf, __num);
	      if ( __put != __num)
		this->setstate(ios_base::failbit);
	    }
	  else
	    this->setstate(ios_base::failbit);
	}
      else
	this->setstate(ios_base::badbit);
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_ostream<_CharT, _Traits>&
    basic_ostream<_CharT, _Traits>::put(char_type __c)
    { 
      sentry __cerb(*this);
      if (__cerb) 
	{
	  int_type __put = rdbuf()->sputc(__c); 
	  if (__put != traits_type::to_int_type(__c))
	    this->setstate(ios_base::badbit);
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_ostream<_CharT, _Traits>&
    basic_ostream<_CharT, _Traits>::write(const _CharT* __s, streamsize __n)
    {
      sentry __cerb(*this);
      if (__cerb)
	{
	  streamsize __put = this->rdbuf()->sputn(__s, __n);
	  if ( __put != __n)
	    this->setstate(ios_base::badbit);
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_ostream<_CharT, _Traits>&
    basic_ostream<_CharT, _Traits>::flush()
    {
      sentry __cerb(*this);
      if (__cerb) 
	{
	  if (this->rdbuf() && this->rdbuf()->pubsync() == -1)
	    this->setstate(ios_base::badbit);
	}
      return *this;
    }
  
  template<typename _CharT, typename _Traits>
    typename basic_ostream<_CharT, _Traits>::pos_type
    basic_ostream<_CharT, _Traits>::tellp()
    {
      pos_type __retval = pos_type(-1);
      bool __testok = this->fail() != true;
      
      if (__testok)
	__retval = this->rdbuf()->pubseekoff(0, ios_base::cur, ios_base::out);
      return __retval;
    }


  template<typename _CharT, typename _Traits>
    basic_ostream<_CharT, _Traits>&
    basic_ostream<_CharT, _Traits>::seekp(pos_type __pos)
    {
      bool __testok = this->fail() != true;
      
      if (__testok)
	this->rdbuf()->pubseekpos(__pos);
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_ostream<_CharT, _Traits>&
    basic_ostream<_CharT, _Traits>::seekp(off_type __off, 
					  ios_base::seekdir __dir)
    {
      bool __testok = this->fail() != true;
      
      if (__testok)
	rdbuf()->pubseekoff(__off, __dir);
      return *this;
    }

  // 21.3.7.8 basic_string::operator<<
  template<typename _CharT, typename _Traits, typename _Alloc>
    basic_ostream<_CharT, _Traits>&
    operator<<(basic_ostream<_CharT, _Traits>& __o,
	       const basic_string<_CharT, _Traits, _Alloc>& __s)
    {
      return __o.write(__s.data(), __s.length());
    }

} // namespace std
 
// Local Variables:
// mode:C++
// End:








