// 981015 bkoz

// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.


#include <vector>
#include <string>
#include <sstream>

string read_str_to_osstream(void) {

  bool test = false;

  // empty string sanity check
  string str01;
  string::iterator __i_start = str01.begin();
  char* __p_start = __i_start.base();
  string::iterator __i_end = str01.end();
  char* __p_end = __i_end.base();
  string::size_type len = str01.size();
  test = __p_start == __p_end;
  test &= len == 0;

  // full string sanity check
  string str02("these golden days, i spend waiting for you: 
              Betty Carter on Verve with I'm Yours and You're Mine.");
  __i_start = str02.begin();
  __p_start = __i_start.base();
  __i_end = str02.end();
  __p_end = __i_end.base();
  len = str02.size();
  test &= __p_start != __p_end;
  test &= len != 0;
 
  // test an empty ostring stream for sanity.
  ostringstream ostrstream0;
  string str03 = ostrstream0.str();
  __i_start = str03.begin();
  __p_start = __i_start.base();
  __i_end = str03.end();
  __p_end = __i_end.base();
  len = str03.size();
  test &= __p_start == __p_end;
  test &= len == 0;
  test &= str01 == str03;

  char ch;
  
  for (string::size_type __i = 0; ostrstream0 && __i <len; ++__i)
    {
      ch = str02[__i];
      ostrstream0.put(ch);
    }
  
  return ostrstream0.str();
}

int main(void) {
  //
  //1: manipulate
  //
  string text = read_str_to_osstream();
  //marks the position of each newline within the text
  vector<string::size_type> lines;
  string::size_type pos = 0;
  
  while (pos != string::npos)
    {
      pos = text.find('\n', pos);
      lines.push_back(pos);
    }


  //
  // 2: automatic formatting of a compound string
  //
  int i = 1024;
  int *pi = &i;
  double d = 3.14159;
  double *pd = &d;
  ostringstream oformat_msg;
  
  //ok: converts values to a string representation
  oformat_msg << "i: " << i << " i's address:  " << pi << "\n"
	     << "d: " << d << " d's address: " << pd << endl;

  string msg = oformat_msg.str();
  

  //
  // 3: istringstream
  //
  // extracts the stored ascii values, placing them in turn in the four vars
  int i2 = 0;
  int *pi2 = &i2;
  double d2 = 0.0;
  double *pd2 = &d2;

  istringstream iformat_msg(oformat_msg.str());
  //990210 bkoz awaiting num_put
  //  iformat_msg >> i2 >> pi2 >> d2 >> pd2;


  return 0;
}


  











