
// Copyright (C) 1997,1998 Cygnus Solutions
//
// This file is part of the libstdc++ version 3 distribution.
//
// This software is a copyrighted work licensed under the terms of the
// Cygnus libstdc++ license. Please consult the file LICENSE.STD for
// details.

// XXX this is all quick'n'dirty.

#define _POSIX_SOURCE
#include <bits/std_ios.h>
#include <fcntl.h>
#include <unistd.h>

int 
_S_os_raw_open(const char* name, std::ios_base::openmode mode)
{
  using ::std::ios_base;
  // XXX this logic for computing unixflags is very probably wrong.
  int unixflags = 0;
  unixflags = (mode & ios_base::in) ?  
    ((mode & ios_base::out) ? 
      (O_RDWR|O_CREAT) : O_RDONLY) : (O_WRONLY|O_CREAT);
  if (mode & ios_base::app) 
    unixflags |= (O_APPEND|O_CREAT);
  else if (mode & ios_base::out)
    unixflags |= (O_TRUNC|O_CREAT);
  return ::open(name, unixflags);
}

int 
_S_os_raw_close(int fd)
{
  return ::close(fd);
}

streamoff
_S_os_raw_read(int fd, void* buf, size_t count)
{
  return (streamsize) ::read(fd, buf, count);
}

streamoff
_S_os_raw_write(int fd, const void* buf, size_t count)
{
  return (streamsize) ::write(fd, buf, count);
}

int 
_S_os_raw_seekoff(
  int fd, 
  streamoff off, 
  std::ios_base::seekdir way, 
  ios_base::openmode which)
{
  int myway = 0;
  switch (way) {
  case ios_base::beg: myway = SEEK_SET; break;
  case ios_base::cur: myway = SEEK_CUR; break;
  case ios_base::end: myway = SEEK_END; break;
  default: return 0;
  }
  return ::lseek(fd, off, myway);
}

int 
_S_os_raw_seekpos(
  int fd, 
  streampos pos,
  ios_base::openmode which)
{
  return ::lseek(fd, pos, std::ios_base::beg);
}

