/* Return cosine of complex double value.
   Copyright (C) 1997,1998 Cygnus Solutions

   This file is part of the libstdc++ version 3 distribution.

   This software is a copyrighted work licensed under the terms of the
   Cygnus libstdc++ license. Please consult the file LICENSE.STD for
   details.  */

#include <math.h>
#include "mathconf.h"

__complex__ double
ccos (__complex__ double x)
{
  __complex__ double res;

  if (!FINITE_P (__real__ x) || __imag__ x != __imag__ x)
    {
      if (__real__ x == 0.0 || __imag__ x == 0.0)
	{
	  __real__ res = NAN;
	  __imag__ res = 0.0;
	}
      else if (__isinf (__imag__ x))
	{
	  __real__ res = HUGE_VAL;
	  __imag__ res = NAN;
	}
      else
	{
	  __real__ res = NAN;
	  __imag__ res = NAN;
	}
    }
  else
    {
      __complex__ double y;

      __real__ y = -__imag__ x;
      __imag__ y = __real__ x;

      res = ccosh (y);
    }

  return res;
}
