// 981001 bkoz

// 21.3.7.1 basic_string non-member functions

// 21.3.7.1 operator+
/*
template<class charT, class traits, class Allocator>
  basic_string<charT,traits,Allocator>
    operator+(const basic_string<charT,traits,Allocator>& lhs,
              const basic_string<charT,traits,Allocator>& rhs);

template<class charT, class traits, class Allocator>
  basic_string<charT,traits,Allocator>
    operator+(const charT* lhs,
              const basic_string<charT,traits,Allocator>& rhs);

template<class charT, class traits, class Allocator>
  basic_string<charT,traits,Allocator>
    operator+(charT lhs, const basic_string<charT,traits,Allocator>& rhs);

template<class charT, class traits, class Allocator>
  basic_string<charT,traits,Allocator>
    operator+(const basic_string<charT,traits,Allocator>& lhs,
              const charT* rhs);

template<class charT, class traits, class Allocator>
  basic_string<charT,traits,Allocator>
    operator+(const basic_string<charT,traits,Allocator>& lhs, charT rhs);
*/

// 21.3.7.2 operator==
/*
template<class charT, class traits, class Allocator>
  bool operator==(const basic_string<charT,traits,Allocator>& lhs,
                  const basic_string<charT,traits,Allocator>& rhs);

template<class charT, class traits, class Allocator>
  bool operator==(const charT* lhs,
                  const basic_string<charT,traits,Allocator>& rhs);

template<class charT, class traits, class Allocator>
  bool operator==(const basic_string<charT,traits,Allocator>& lhs,
                  const charT* rhs);
*/

// 21.3.7.3 operator!=
/*
template<class charT, class traits, class Allocator>
  bool operator!=(const basic_string<charT,traits,Allocator>& lhs,
                  const basic_string<charT,traits,Allocator>& rhs);

template<class charT, class traits, class Allocator>
  bool operator!=(const charT* lhs,
                  const basic_string<charT,traits,Allocator>& rhs);

template<class charT, class traits, class Allocator>
  bool operator!=(const basic_string<charT,traits,Allocator>& lhs, 
                  const charT* rhs);
*/

// 21.3.7.4 operator<
/*
template<class charT, class traits, class Allocator>
  bool operator< (const basic_string<charT,traits,Allocator>& lhs,
                  const basic_string<charT,traits,Allocator>& rhs);

template<class charT, class traits, class Allocator>
  bool operator< (const basic_string<charT,traits,Allocator>& lhs,
                  const charT* rhs);

template<class charT, class traits, class Allocator>
  bool operator< (const charT* lhs, 
                  const basic_string<charT,traits,Allocator>& rhs);
*/

// 21.3.7.5 operator>
/*
template<class charT, class traits, class Allocator>
  bool operator> (const basic_string<charT,traits,Allocator>& lhs,
                  const basic_string<charT,traits,Allocator>& rhs);

template<class charT, class traits, class Allocator>
  bool operator> (const basic_string<charT,traits,Allocator>& lhs,
                  const charT* rhs);

template<class charT, class traits, class Allocator>
  bool operator> (const charT* lhs,
                  const basic_string<charT,traits,Allocator>& rhs);
*/

//21.3.7.6 operator<=
/*
template<class charT, class traits, class Allocator>
  bool operator<=(const basic_string<charT,traits,Allocator>& lhs,
                  const basic_string<charT,traits,Allocator>& rhs);

template<class charT, class traits, class Allocator>
  bool operator<=(const basic_string<charT,traits,Allocator>& lhs,
                  const charT* rhs);

template<class charT, class traits, class Allocator>
  bool operator<=(const charT* lhs,
                  const basic_string<charT,traits,Allocator>& rhs);
*/

// 21.3.7.7 operator>=
/*
template<class charT, class traits, class Allocator>
  bool operator>=(const basic_string<charT,traits,Allocator>& lhs,
                const basic_string<charT,traits,Allocator>& rhs);

template<class charT, class traits, class Allocator>
  bool operator>=(const basic_string<charT,traits,Allocator>& lhs,
                  const charT* rhs);

template<class charT, class traits, class Allocator>
  bool operator>=(const charT* lhs,
                  const basic_string<charT,traits,Allocator>& rhs);
*/

#include <string>
#ifdef DEBUG_ASSERT
#include <assert.h>
#endif

void test_value(bool result, bool expected);
void test_value(bool result, bool expected) {
  bool pass = result == expected;

#ifdef DEBUG_ASSERT
  assert (pass);
#endif
}
 

int test01(void)
{
  string 	str_0("costa rica");
  string 	str_1("costa marbella");
  string 	str_2("cost");
  string	str_3("costa ricans");
  string        str_4;
   
  str_4 = str_0;
  //comparisons between string objects
  test_value (str_0 == str_1, false);
  test_value (str_0 == str_2, false);
  test_value (str_0 == str_3, false);
  test_value (str_1 == str_0, false);
  test_value (str_2 == str_0, false);
  test_value (str_3 == str_0, false);
  test_value (str_4 == str_0, true);
  test_value (str_0 == str_4, true);

  test_value (str_0 != str_1, true);
  test_value (str_0 != str_2, true);
  test_value (str_0 != str_3, true);
  test_value (str_1 != str_0, true);
  test_value (str_2 != str_0, true);
  test_value (str_3 != str_0, true);
  test_value (str_0 != str_4, false);
  test_value (str_4 != str_0, false);
   
  test_value (str_0 > str_1, true); //true cuz r>m
  test_value (str_0 > str_2, true);
  test_value (str_0 > str_3, false);
  test_value (str_1 > str_0, false); //false cuz m<r
  test_value (str_2 > str_0, false);
  test_value (str_3 > str_0, true);
  test_value (str_0 > str_4, false);
  test_value (str_4 > str_0, false);

  test_value (str_0 < str_1, false); //false cuz r>m
  test_value (str_0 < str_2, false);
  test_value (str_0 < str_3, true);
  test_value (str_1 < str_0, true); //true cuz m<r
  test_value (str_2 < str_0, true);
  test_value (str_3 < str_0, false);
  test_value (str_0 < str_4, false);
  test_value (str_4 < str_0, false);

  test_value (str_0 >= str_1, true); //true cuz r>m
  test_value (str_0 >= str_2, true);
  test_value (str_0 >= str_3, false);
  test_value (str_1 >= str_0, false);//false cuz m<r
  test_value (str_2 >= str_0, false);
  test_value (str_3 >= str_0, true);
  test_value (str_0 >= str_4, true);
  test_value (str_4 >= str_0, true);

  test_value (str_0 <= str_1, false);//false cuz r>m
  test_value (str_0 <= str_2, false);
  test_value (str_0 <= str_3, true);
  test_value (str_1 <= str_0, true);//true cuz m<r
  test_value (str_2 <= str_0, true);
  test_value (str_3 <= str_0, false);
  test_value (str_0 <= str_4, true);
  test_value (str_4 <= str_0, true);

  //comparisons between string object and string literal
  test_value (str_0 == "costa marbella", false);
  test_value (str_0 == "cost", false);
  test_value (str_0 == "costa ricans", false);
  test_value ("costa marbella" == str_0, false);
  test_value ("cost" == str_0, false);
  test_value ("costa ricans" == str_0, false);
  test_value ("costa rica" == str_0, true);
  test_value (str_0 == "costa rica", true);

  test_value (str_0 != "costa marbella", true);
  test_value (str_0 != "cost", true);
  test_value (str_0 != "costa ricans", true);
  test_value ("costa marbella" != str_0, true);
  test_value ("cost" != str_0, true);
  test_value ("costa ricans" != str_0, true);
  test_value ("costa rica" != str_0, false);
  test_value (str_0 != "costa rica", false);

  test_value (str_0 > "costa marbella", true); //true cuz r>m
  test_value (str_0 > "cost", true);
  test_value (str_0 > "costa ricans", false);
  test_value ("costa marbella" > str_0, false);//false cuz m<r
  test_value ("cost" > str_0, false);
  test_value ("costa ricans" > str_0, true);
  test_value ("costa rica" > str_0, false);
  test_value (str_0 > "costa rica", false);

  test_value (str_0 < "costa marbella", false);//false cuz r>m
  test_value (str_0 < "cost", false);
  test_value (str_0 < "costa ricans", true);
  test_value ("costa marbella" < str_0, true);//true cuz m<r
  test_value ("cost" < str_0, true);
  test_value ("costa ricans" < str_0, false);
  test_value ("costa rica" < str_0, false);
  test_value (str_0 < "costa rica", false);

  test_value (str_0 >= "costa marbella", true);//true cuz r>m
  test_value (str_0 >= "cost", true);
  test_value (str_0 >= "costa ricans", false);
  test_value ("costa marbella" >= str_0, false);//false cuz m<r
  test_value ("cost" >= str_0, false);
  test_value ("costa ricans" >= str_0, true);
  test_value ("costa rica" >= str_0, true);
  test_value (str_0 >= "costa rica", true);

  test_value (str_0 <= "costa marbella", false);//false cuz r>m
  test_value (str_0 <= "cost", false);
  test_value (str_0 <= "costa ricans", true);
  test_value ("costa marbella" <= str_0, true);//true cuz m<r
  test_value ("cost" <= str_0, true);
  test_value ("costa ricans" <= str_0, false);
  test_value ("costa rica" <= str_0, true);
  test_value (str_0 <= "costa rica", true);

  return 0;
}

int main() {
  test01();
}


