/* Complex tangent function for float.
   Copyright (C) 1997,1998 Cygnus Solutions

   This file is part of the libstdc++ version 3 distribution.

   This software is a copyrighted work licensed under the terms of the
   Cygnus libstdc++ license. Please consult the file LICENSE.STD for
   details.  */

#include <math.h>
#include "mathconf.h"


__complex__ float
ctanf (__complex__ float x)
{
  __complex__ float res;

  if (!FINITEF_P (__real__ x) || !FINITEF_P (__imag__ x))
    {
      if (__isinff (__imag__ x))
	{
	  __real__ res = __copysignf (0.0, __real__ x);
	  __imag__ res = __copysignf (1.0, __imag__ x);
	}
      else if (__real__ x == 0.0)
	{
	  res = x;
	}
      else
	{
	  __real__ res = NAN;
	  __imag__ res = NAN;
	}
    }
  else
    {
      float sin2rx = sinf (2.0f * __real__ x);
      float cos2rx = cosf (2.0f * __real__ x);
      float den;

      den = cos2rx + coshf (2.0 * __imag__ x);

      __real__ res = sin2rx / den;
      __imag__ res = sinhf (2.0 * __imag__ x) / den;
    }

  return res;
}
