/* Compute complex natural logarithm.
   Copyright (C) 1997,1998 Cygnus Solutions

   This file is part of the libstdc++ version 3 distribution.

   This software is a copyrighted work licensed under the terms of the
   Cygnus libstdc++ license. Please consult the file LICENSE.STD for
   details.  */

#include <math.h>
#include "mathconf.h"

/* Thanks to SGI we have to trick here.  At least Irix 6.2 provides hypotl,
   but it has a wrong prototype.  Grrr.  */
extern long double local_hypotl (long double, long double) asm ("hypotl");


__complex__ long double
clog10l (__complex__ long double x)
{
  __complex__ long double result;

  if (x == 0.0)
    {
      /* Real and imaginary part are 0.0.  */
      __imag__ result = signbit (__real__ x) ? M_PI : 0.0;
      __imag__ result = __copysignl (__imag__ result, __imag__ x);
      /* Yes, the following line raises an exception.  */
      __real__ result = -1.0 / fabsl (__real__ x);
    }
  else if (__real__ x == __real__ x && __imag__ x == __imag__ x)
    {
      /* Neither real nor imaginary part is NaN.  */
      __real__ result = log10l (local_hypotl (__real__ x, __imag__ x));
      __imag__ result = atan2l (__imag__ x, __real__ x);
    }
  else
    {
      __imag__ result = NAN;
      if (INFINITEL_P (__real__ x) || INFINITEL_P (__imag__ x))
	/* Real or imaginary part is infinite.  */
	__real__ result = HUGE_VALL;
      else
	__real__ result = NAN;
    }

  return result;
}
