# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.


"""
Xapian is a highly adaptable toolkit which allows developers to easily
add advanced indexing and search facilities to their own applications.
It has built-in support for several families of weighting models
and also supports a rich set of boolean query operators.

In addition to the doc strings provided by this python library, you
may wish to look at the library's overall documentation, either
installed along with the bindings or online at
<https://xapian.org/docs/bindings/python/>, as well as the library's
documentation, possibly installed with the library or with its
development files, or again online at <https://xapian.org/docs/>.
"""



from sys import version_info as _swig_python_version_info
from . import _xapian


_swig_new_instance_method = _xapian.SWIG_PyInstanceMethod_New
_swig_new_static_method = _xapian.SWIG_PyStaticMethod_New

def _swig_repr(self):
    strthis = ""
    if hasattr(self.this, '__repr__'):
        strthis = "proxy of " + self.this.__repr__()

    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)



import weakref


__version__ = '1.4.23'

class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _xapian.delete_SwigPyIterator
    value = _swig_new_instance_method(_xapian.SwigPyIterator_value)
    incr = _swig_new_instance_method(_xapian.SwigPyIterator_incr)
    decr = _swig_new_instance_method(_xapian.SwigPyIterator_decr)
    distance = _swig_new_instance_method(_xapian.SwigPyIterator_distance)
    equal = _swig_new_instance_method(_xapian.SwigPyIterator_equal)
    copy = _swig_new_instance_method(_xapian.SwigPyIterator_copy)
    next = _swig_new_instance_method(_xapian.SwigPyIterator_next)
    __next__ = _swig_new_instance_method(_xapian.SwigPyIterator___next__)
    previous = _swig_new_instance_method(_xapian.SwigPyIterator_previous)
    advance = _swig_new_instance_method(_xapian.SwigPyIterator_advance)
    __eq__ = _swig_new_instance_method(_xapian.SwigPyIterator___eq__)
    __ne__ = _swig_new_instance_method(_xapian.SwigPyIterator___ne__)
    __iadd__ = _swig_new_instance_method(_xapian.SwigPyIterator___iadd__)
    __isub__ = _swig_new_instance_method(_xapian.SwigPyIterator___isub__)
    __add__ = _swig_new_instance_method(_xapian.SwigPyIterator___add__)
    __sub__ = _swig_new_instance_method(_xapian.SwigPyIterator___sub__)
    def __iter__(self):
        return self

# Register SwigPyIterator in _xapian:
_xapian.SwigPyIterator_swigregister(SwigPyIterator)
class Error(Exception):
    r"""


    All exceptions thrown by Xapian are subclasses of Xapian::Error.

    This class can not be instantiated directly - instead a subclass
    should be used. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    get_type = _swig_new_instance_method(_xapian.Error_get_type)
    get_msg = _swig_new_instance_method(_xapian.Error_get_msg)
    get_context = _swig_new_instance_method(_xapian.Error_get_context)
    get_error_string = _swig_new_instance_method(_xapian.Error_get_error_string)
    __str__ = _swig_new_instance_method(_xapian.Error___str__)
    __swig_destroy__ = _xapian.delete_Error

# Register Error in _xapian:
_xapian.Error_swigregister(Error)
class LogicError(Error):
    r"""


    The base class for exceptions indicating errors in the program logic.

    A subclass of LogicError will be thrown if Xapian detects a violation
    of a class invariant or a logical precondition or postcondition, etc.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _xapian.delete_LogicError

# Register LogicError in _xapian:
_xapian.LogicError_swigregister(LogicError)
class RuntimeError(Error):
    r"""


    The base class for exceptions indicating errors only detectable at
    runtime.

    A subclass of RuntimeError will be thrown if Xapian detects an error
    which is exception derived from RuntimeError is thrown when an error
    is caused by problems with the data or environment rather than a
    programming mistake. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _xapian.delete_RuntimeError

# Register RuntimeError in _xapian:
_xapian.RuntimeError_swigregister(RuntimeError)
class AssertionError(LogicError):
    r"""


    AssertionError is thrown if a logical assertion inside Xapian fails.

    In a debug build of Xapian, a failed assertion in the core library
    code will cause AssertionError to be thrown.

    This represents a bug in Xapian (either an invariant, precondition,
    etc has been violated, or the assertion is incorrect!) 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct from message and errno value.

        Xapian::AssertionError::AssertionError(const std::string &msg_, int
        errno_) Xapian::AssertionError::AssertionError

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.AssertionError_swiginit(self, _xapian.new_AssertionError(*args))
    __swig_destroy__ = _xapian.delete_AssertionError

# Register AssertionError in _xapian:
_xapian.AssertionError_swigregister(AssertionError)
class InvalidArgumentError(LogicError):
    r"""


    InvalidArgumentError indicates an invalid parameter value was passed
    to the API. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct from message and errno value.

        Xapian::InvalidArgumentError::InvalidArgumentError(const std::string
        &msg_, int errno_) Xapian::InvalidArgumentError::InvalidArgumentError

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.InvalidArgumentError_swiginit(self, _xapian.new_InvalidArgumentError(*args))
    __swig_destroy__ = _xapian.delete_InvalidArgumentError

# Register InvalidArgumentError in _xapian:
_xapian.InvalidArgumentError_swigregister(InvalidArgumentError)
class InvalidOperationError(LogicError):
    r"""


    InvalidOperationError indicates the API was used in an invalid way. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct from message and errno value.

        Xapian::InvalidOperationError::InvalidOperationError(const std::string
        &msg_, int errno_)
        Xapian::InvalidOperationError::InvalidOperationError

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.InvalidOperationError_swiginit(self, _xapian.new_InvalidOperationError(*args))
    __swig_destroy__ = _xapian.delete_InvalidOperationError

# Register InvalidOperationError in _xapian:
_xapian.InvalidOperationError_swigregister(InvalidOperationError)
class UnimplementedError(LogicError):
    r"""


    UnimplementedError indicates an attempt to use an unimplemented
    feature. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct from message and errno value.

        Xapian::UnimplementedError::UnimplementedError(const std::string
        &msg_, int errno_) Xapian::UnimplementedError::UnimplementedError

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.UnimplementedError_swiginit(self, _xapian.new_UnimplementedError(*args))
    __swig_destroy__ = _xapian.delete_UnimplementedError

# Register UnimplementedError in _xapian:
_xapian.UnimplementedError_swigregister(UnimplementedError)
class DatabaseError(RuntimeError):
    r"""


    DatabaseError indicates some sort of database related error. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct from message and errno value.

        Xapian::DatabaseError::DatabaseError(const std::string &msg_, int
        errno_) Xapian::DatabaseError::DatabaseError

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.DatabaseError_swiginit(self, _xapian.new_DatabaseError(*args))
    __swig_destroy__ = _xapian.delete_DatabaseError

# Register DatabaseError in _xapian:
_xapian.DatabaseError_swigregister(DatabaseError)
class DatabaseCorruptError(DatabaseError):
    r"""


    DatabaseCorruptError indicates database corruption was detected. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct from message and errno value.

        Xapian::DatabaseCorruptError::DatabaseCorruptError(const std::string
        &msg_, int errno_) Xapian::DatabaseCorruptError::DatabaseCorruptError

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.DatabaseCorruptError_swiginit(self, _xapian.new_DatabaseCorruptError(*args))
    __swig_destroy__ = _xapian.delete_DatabaseCorruptError

# Register DatabaseCorruptError in _xapian:
_xapian.DatabaseCorruptError_swigregister(DatabaseCorruptError)
class DatabaseCreateError(DatabaseError):
    r"""


    DatabaseCreateError indicates a failure to create a database. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct from message and errno value.

        Xapian::DatabaseCreateError::DatabaseCreateError(const std::string
        &msg_, int errno_) Xapian::DatabaseCreateError::DatabaseCreateError

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.DatabaseCreateError_swiginit(self, _xapian.new_DatabaseCreateError(*args))
    __swig_destroy__ = _xapian.delete_DatabaseCreateError

# Register DatabaseCreateError in _xapian:
_xapian.DatabaseCreateError_swigregister(DatabaseCreateError)
class DatabaseLockError(DatabaseError):
    r"""


    DatabaseLockError indicates failure to lock a database. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct from message and errno value.

        Xapian::DatabaseLockError::DatabaseLockError(const std::string &msg_,
        int errno_) Xapian::DatabaseLockError::DatabaseLockError

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.DatabaseLockError_swiginit(self, _xapian.new_DatabaseLockError(*args))
    __swig_destroy__ = _xapian.delete_DatabaseLockError

# Register DatabaseLockError in _xapian:
_xapian.DatabaseLockError_swigregister(DatabaseLockError)
class DatabaseModifiedError(DatabaseError):
    r"""


    DatabaseModifiedError indicates a database was modified.

    To recover after catching this error, you need to call
    Xapian::Database::reopen() on the Database and repeat the operation
    which failed. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct from message and errno value.

        Xapian::DatabaseModifiedError::DatabaseModifiedError(const std::string
        &msg_, int errno_)
        Xapian::DatabaseModifiedError::DatabaseModifiedError

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.DatabaseModifiedError_swiginit(self, _xapian.new_DatabaseModifiedError(*args))
    __swig_destroy__ = _xapian.delete_DatabaseModifiedError

# Register DatabaseModifiedError in _xapian:
_xapian.DatabaseModifiedError_swigregister(DatabaseModifiedError)
class DatabaseOpeningError(DatabaseError):
    r"""


    DatabaseOpeningError indicates failure to open a database. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct from message and errno value.

        Xapian::DatabaseOpeningError::DatabaseOpeningError(const std::string
        &msg_, int errno_) Xapian::DatabaseOpeningError::DatabaseOpeningError

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.DatabaseOpeningError_swiginit(self, _xapian.new_DatabaseOpeningError(*args))
    __swig_destroy__ = _xapian.delete_DatabaseOpeningError

# Register DatabaseOpeningError in _xapian:
_xapian.DatabaseOpeningError_swigregister(DatabaseOpeningError)
class DatabaseVersionError(DatabaseOpeningError):
    r"""


    DatabaseVersionError indicates that a database is in an unsupported
    format.

    From time to time, new versions of Xapian will require the database
    format to be changed, to allow new information to be stored or new
    optimisations to be performed. Backwards compatibility will sometimes
    be maintained, so that new versions of Xapian can open old databases,
    but in some cases Xapian will be unable to open a database because it
    is in too old (or new) a format. This can be resolved either be
    upgrading or downgrading the version of Xapian in use, or by
    rebuilding the database from scratch with the current version of
    Xapian. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct from message and errno value.

        Xapian::DatabaseVersionError::DatabaseVersionError(const std::string
        &msg_, int errno_) Xapian::DatabaseVersionError::DatabaseVersionError

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.DatabaseVersionError_swiginit(self, _xapian.new_DatabaseVersionError(*args))
    __swig_destroy__ = _xapian.delete_DatabaseVersionError

# Register DatabaseVersionError in _xapian:
_xapian.DatabaseVersionError_swigregister(DatabaseVersionError)
class DocNotFoundError(RuntimeError):
    r"""


    Indicates an attempt to access a document not present in the database.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct from message and errno value.

        Xapian::DocNotFoundError::DocNotFoundError(const std::string &msg_,
        int errno_) Xapian::DocNotFoundError::DocNotFoundError

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.DocNotFoundError_swiginit(self, _xapian.new_DocNotFoundError(*args))
    __swig_destroy__ = _xapian.delete_DocNotFoundError

# Register DocNotFoundError in _xapian:
_xapian.DocNotFoundError_swigregister(DocNotFoundError)
class FeatureUnavailableError(RuntimeError):
    r"""


    Indicates an attempt to use a feature which is unavailable.

    Typically a feature is unavailable because it wasn't compiled in, or
    because it requires other software or facilities which aren't
    available. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct from message and errno value.

        Xapian::FeatureUnavailableError::FeatureUnavailableError(const
        std::string &msg_, int errno_)
        Xapian::FeatureUnavailableError::FeatureUnavailableError

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.FeatureUnavailableError_swiginit(self, _xapian.new_FeatureUnavailableError(*args))
    __swig_destroy__ = _xapian.delete_FeatureUnavailableError

# Register FeatureUnavailableError in _xapian:
_xapian.FeatureUnavailableError_swigregister(FeatureUnavailableError)
class InternalError(RuntimeError):
    r"""


    InternalError indicates a runtime problem of some sort. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct from message and errno value.

        Xapian::InternalError::InternalError(const std::string &msg_, int
        errno_) Xapian::InternalError::InternalError

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.InternalError_swiginit(self, _xapian.new_InternalError(*args))
    __swig_destroy__ = _xapian.delete_InternalError

# Register InternalError in _xapian:
_xapian.InternalError_swigregister(InternalError)
class NetworkError(RuntimeError):
    r"""


    Indicates a problem communicating with a remote database. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct from message and errno value.

        Xapian::NetworkError::NetworkError(const std::string &msg_, int
        errno_) Xapian::NetworkError::NetworkError

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.NetworkError_swiginit(self, _xapian.new_NetworkError(*args))
    __swig_destroy__ = _xapian.delete_NetworkError

# Register NetworkError in _xapian:
_xapian.NetworkError_swigregister(NetworkError)
class NetworkTimeoutError(NetworkError):
    r"""


    Indicates a timeout expired while communicating with a remote
    database. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct from message and errno value.

        Xapian::NetworkTimeoutError::NetworkTimeoutError(const std::string
        &msg_, int errno_) Xapian::NetworkTimeoutError::NetworkTimeoutError

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.NetworkTimeoutError_swiginit(self, _xapian.new_NetworkTimeoutError(*args))
    __swig_destroy__ = _xapian.delete_NetworkTimeoutError

# Register NetworkTimeoutError in _xapian:
_xapian.NetworkTimeoutError_swigregister(NetworkTimeoutError)
class QueryParserError(RuntimeError):
    r"""


    Indicates a query string can't be parsed. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct from message and errno value.

        Xapian::QueryParserError::QueryParserError(const std::string &msg_,
        int errno_) Xapian::QueryParserError::QueryParserError

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.QueryParserError_swiginit(self, _xapian.new_QueryParserError(*args))
    __swig_destroy__ = _xapian.delete_QueryParserError

# Register QueryParserError in _xapian:
_xapian.QueryParserError_swigregister(QueryParserError)
class SerialisationError(RuntimeError):
    r"""


    Indicates an error in the std::string serialisation of an object. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct from message and errno value.

        Xapian::SerialisationError::SerialisationError(const std::string
        &msg_, int errno_) Xapian::SerialisationError::SerialisationError

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.SerialisationError_swiginit(self, _xapian.new_SerialisationError(*args))
    __swig_destroy__ = _xapian.delete_SerialisationError

# Register SerialisationError in _xapian:
_xapian.SerialisationError_swigregister(SerialisationError)
class RangeError(RuntimeError):
    r"""


    RangeError indicates an attempt to access outside the bounds of a
    container. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct from message and errno value.

        Xapian::RangeError::RangeError(const std::string &msg_, int errno_)
        Xapian::RangeError::RangeError

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.RangeError_swiginit(self, _xapian.new_RangeError(*args))
    __swig_destroy__ = _xapian.delete_RangeError

# Register RangeError in _xapian:
_xapian.RangeError_swigregister(RangeError)
class WildcardError(RuntimeError):
    r"""


    WildcardError indicates an error expanding a wildcarded query. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct from message and errno value.

        Xapian::WildcardError::WildcardError(const std::string &msg_, int
        errno_) Xapian::WildcardError::WildcardError

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.WildcardError_swiginit(self, _xapian.new_WildcardError(*args))
    __swig_destroy__ = _xapian.delete_WildcardError

# Register WildcardError in _xapian:
_xapian.WildcardError_swigregister(WildcardError)
class DatabaseNotFoundError(DatabaseOpeningError):
    r"""


    Indicates an attempt to access a database not present. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct from message and errno value.

        Xapian::DatabaseNotFoundError::DatabaseNotFoundError(const std::string
        &msg_, int errno_)
        Xapian::DatabaseNotFoundError::DatabaseNotFoundError

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.DatabaseNotFoundError_swiginit(self, _xapian.new_DatabaseNotFoundError(*args))
    __swig_destroy__ = _xapian.delete_DatabaseNotFoundError

# Register DatabaseNotFoundError in _xapian:
_xapian.DatabaseNotFoundError_swigregister(DatabaseNotFoundError)
class DatabaseClosedError(DatabaseError):
    r"""


    Indicates an attempt to access a closed database. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct from message and errno value.

        Xapian::DatabaseClosedError::DatabaseClosedError(const std::string
        &msg_, int errno_) Xapian::DatabaseClosedError::DatabaseClosedError

        Parameters:
        -----------

        msg_:  Message giving details of the error, intended for human
        consumption.

        errno_:  Optional errno value associated with this error. 
        """
        _xapian.DatabaseClosedError_swiginit(self, _xapian.new_DatabaseClosedError(*args))
    __swig_destroy__ = _xapian.delete_DatabaseClosedError

# Register DatabaseClosedError in _xapian:
_xapian.DatabaseClosedError_swigregister(DatabaseClosedError)
version_string = _xapian.version_string
major_version = _xapian.major_version
minor_version = _xapian.minor_version
revision = _xapian.revision
BAD_VALUENO = _xapian.BAD_VALUENO
DB_CREATE = _xapian.DB_CREATE
DB_CREATE_OR_OPEN = _xapian.DB_CREATE_OR_OPEN
DB_CREATE_OR_OVERWRITE = _xapian.DB_CREATE_OR_OVERWRITE
DB_OPEN = _xapian.DB_OPEN
DB_NO_SYNC = _xapian.DB_NO_SYNC
DB_FULL_SYNC = _xapian.DB_FULL_SYNC
DB_DANGEROUS = _xapian.DB_DANGEROUS
DB_NO_TERMLIST = _xapian.DB_NO_TERMLIST
DB_BACKEND_CHERT = _xapian.DB_BACKEND_CHERT
DB_BACKEND_GLASS = _xapian.DB_BACKEND_GLASS
DB_BACKEND_INMEMORY = _xapian.DB_BACKEND_INMEMORY
DB_BACKEND_STUB = _xapian.DB_BACKEND_STUB
DB_RETRY_LOCK = _xapian.DB_RETRY_LOCK
DBCHECK_SHORT_TREE = _xapian.DBCHECK_SHORT_TREE
DBCHECK_FULL_TREE = _xapian.DBCHECK_FULL_TREE
DBCHECK_SHOW_FREELIST = _xapian.DBCHECK_SHOW_FREELIST
DBCHECK_SHOW_STATS = _xapian.DBCHECK_SHOW_STATS
DBCHECK_FIX = _xapian.DBCHECK_FIX
DBCOMPACT_MULTIPASS = _xapian.DBCOMPACT_MULTIPASS
DBCOMPACT_NO_RENUMBER = _xapian.DBCOMPACT_NO_RENUMBER
DBCOMPACT_SINGLE_FILE = _xapian.DBCOMPACT_SINGLE_FILE
DOC_ASSUME_VALID = _xapian.DOC_ASSUME_VALID
class _PositionIterator(object):
    r"""


    Class for iterating over term positions. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""


        Default constructor.

        Xapian::PositionIterator::PositionIterator()
        Xapian::PositionIterator::PositionIterator Creates an uninitialised
        iterator, which can't be used before being assigned to, but is
        sometimes syntactically convenient. 
        """
        _xapian._PositionIterator_swiginit(self, _xapian.new__PositionIterator())
    __swig_destroy__ = _xapian.delete__PositionIterator
    skip_to = _swig_new_instance_method(_xapian._PositionIterator_skip_to)
    __str__ = _swig_new_instance_method(_xapian._PositionIterator___str__)
    __eq__ = _swig_new_instance_method(_xapian._PositionIterator___eq__)
    __ne__ = _swig_new_instance_method(_xapian._PositionIterator___ne__)
    equals = _swig_new_instance_method(_xapian._PositionIterator_equals)
    get_termpos = _swig_new_instance_method(_xapian._PositionIterator_get_termpos)
    __next__ = _swig_new_instance_method(_xapian._PositionIterator___next__)

# Register _PositionIterator in _xapian:
_xapian._PositionIterator_swigregister(_PositionIterator)
class _PostingIterator(object):
    r"""


    Class for iterating over a list of terms. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""


        Default constructor.

        Xapian::PostingIterator::PostingIterator()
        Xapian::PostingIterator::PostingIterator Creates an uninitialised
        iterator, which can't be used before being assigned to, but is
        sometimes syntactically convenient. 
        """
        _xapian._PostingIterator_swiginit(self, _xapian.new__PostingIterator())
    __swig_destroy__ = _xapian.delete__PostingIterator
    get_wdf = _swig_new_instance_method(_xapian._PostingIterator_get_wdf)
    get_doclength = _swig_new_instance_method(_xapian._PostingIterator_get_doclength)
    get_unique_terms = _swig_new_instance_method(_xapian._PostingIterator_get_unique_terms)
    _positionlist_begin = _swig_new_instance_method(_xapian._PostingIterator__positionlist_begin)
    _positionlist_end = _swig_new_instance_method(_xapian._PostingIterator__positionlist_end)
    skip_to = _swig_new_instance_method(_xapian._PostingIterator_skip_to)
    __str__ = _swig_new_instance_method(_xapian._PostingIterator___str__)
    __eq__ = _swig_new_instance_method(_xapian._PostingIterator___eq__)
    __ne__ = _swig_new_instance_method(_xapian._PostingIterator___ne__)
    equals = _swig_new_instance_method(_xapian._PostingIterator_equals)
    get_docid = _swig_new_instance_method(_xapian._PostingIterator_get_docid)
    __next__ = _swig_new_instance_method(_xapian._PostingIterator___next__)

# Register _PostingIterator in _xapian:
_xapian._PostingIterator_swigregister(_PostingIterator)
class _TermIterator(object):
    r"""


    Class for iterating over a list of terms. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""


        Default constructor.

        Xapian::TermIterator::TermIterator()
        Xapian::TermIterator::TermIterator Creates an uninitialised iterator,
        which can't be used before being assigned to, but is sometimes
        syntactically convenient. 
        """
        _xapian._TermIterator_swiginit(self, _xapian.new__TermIterator())
    __swig_destroy__ = _xapian.delete__TermIterator
    get_wdf = _swig_new_instance_method(_xapian._TermIterator_get_wdf)
    get_termfreq = _swig_new_instance_method(_xapian._TermIterator_get_termfreq)
    positionlist_count = _swig_new_instance_method(_xapian._TermIterator_positionlist_count)
    _positionlist_begin = _swig_new_instance_method(_xapian._TermIterator__positionlist_begin)
    _positionlist_end = _swig_new_instance_method(_xapian._TermIterator__positionlist_end)
    skip_to = _swig_new_instance_method(_xapian._TermIterator_skip_to)
    __str__ = _swig_new_instance_method(_xapian._TermIterator___str__)
    __eq__ = _swig_new_instance_method(_xapian._TermIterator___eq__)
    __ne__ = _swig_new_instance_method(_xapian._TermIterator___ne__)
    equals = _swig_new_instance_method(_xapian._TermIterator_equals)
    get_term = _swig_new_instance_method(_xapian._TermIterator_get_term)
    __next__ = _swig_new_instance_method(_xapian._TermIterator___next__)

# Register _TermIterator in _xapian:
_xapian._TermIterator_swigregister(_TermIterator)
class _ValueIterator(object):
    r"""


    Class for iterating over document values. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""


        Default constructor.

        Xapian::ValueIterator::ValueIterator()
        Xapian::ValueIterator::ValueIterator Creates an uninitialised
        iterator, which can't be used before being assigned to, but is
        sometimes syntactically convenient. 
        """
        _xapian._ValueIterator_swiginit(self, _xapian.new__ValueIterator())
    __swig_destroy__ = _xapian.delete__ValueIterator
    get_docid = _swig_new_instance_method(_xapian._ValueIterator_get_docid)
    get_valueno = _swig_new_instance_method(_xapian._ValueIterator_get_valueno)
    skip_to = _swig_new_instance_method(_xapian._ValueIterator_skip_to)
    check = _swig_new_instance_method(_xapian._ValueIterator_check)
    __str__ = _swig_new_instance_method(_xapian._ValueIterator___str__)
    __eq__ = _swig_new_instance_method(_xapian._ValueIterator___eq__)
    __ne__ = _swig_new_instance_method(_xapian._ValueIterator___ne__)
    equals = _swig_new_instance_method(_xapian._ValueIterator_equals)
    get_value = _swig_new_instance_method(_xapian._ValueIterator_get_value)
    __next__ = _swig_new_instance_method(_xapian._ValueIterator___next__)

# Register _ValueIterator in _xapian:
_xapian._ValueIterator_swigregister(_ValueIterator)
class Document(object):
    r"""


    A handle representing a document in a Xapian database.

    The Document class fetches information from the database lazily.
    Usually this behaviour isn't visible to users (except for the speed
    benefits), but if the document in the database is modified or deleted,
    then preexisting Document objects may return the old or new versions
    of data (or throw Xapian::DocNotFoundError in the case of deletion).

    Since Database objects work on a snapshot of the database's state, the
    situation above can only happen with a WritableDatabase object, or if
    you call Database::reopen() on a Database object.

    We recommend you avoid designs where this behaviour is an issue, but
    if you need a way to make a non-lazy version of a Document object, you
    can do this like so:doc =
    Xapian::Document::unserialise(doc.serialise()); 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""


        Make a new empty Document.

        Xapian::Document::Document() Xapian::Document::Document
        """
        _xapian.Document_swiginit(self, _xapian.new_Document())
    __swig_destroy__ = _xapian.delete_Document
    get_value = _swig_new_instance_method(_xapian.Document_get_value)
    add_value = _swig_new_instance_method(_xapian.Document_add_value)
    remove_value = _swig_new_instance_method(_xapian.Document_remove_value)
    clear_values = _swig_new_instance_method(_xapian.Document_clear_values)
    get_data = _swig_new_instance_method(_xapian.Document_get_data)
    set_data = _swig_new_instance_method(_xapian.Document_set_data)
    add_posting = _swig_new_instance_method(_xapian.Document_add_posting)
    add_term = _swig_new_instance_method(_xapian.Document_add_term)
    add_boolean_term = _swig_new_instance_method(_xapian.Document_add_boolean_term)
    remove_posting = _swig_new_instance_method(_xapian.Document_remove_posting)
    remove_postings = _swig_new_instance_method(_xapian.Document_remove_postings)
    remove_term = _swig_new_instance_method(_xapian.Document_remove_term)
    clear_terms = _swig_new_instance_method(_xapian.Document_clear_terms)
    termlist_count = _swig_new_instance_method(_xapian.Document_termlist_count)
    _termlist_begin = _swig_new_instance_method(_xapian.Document__termlist_begin)
    _termlist_end = _swig_new_instance_method(_xapian.Document__termlist_end)
    values_count = _swig_new_instance_method(_xapian.Document_values_count)
    _values_begin = _swig_new_instance_method(_xapian.Document__values_begin)
    _values_end = _swig_new_instance_method(_xapian.Document__values_end)
    get_docid = _swig_new_instance_method(_xapian.Document_get_docid)
    serialise = _swig_new_instance_method(_xapian.Document_serialise)
    unserialise = _swig_new_static_method(_xapian.Document_unserialise)
    __str__ = _swig_new_instance_method(_xapian.Document___str__)

# Register Document in _xapian:
_xapian.Document_swigregister(Document)
class Registry(object):
    r"""


    Registry for user subclasses.

    This class provides a way for the remote server to look up user
    subclasses when unserialising. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""


        Default constructor.

        Xapian::Registry::Registry() Xapian::Registry::Registry The registry
        will contain all standard subclasses of user-subclassable classes. 
        """
        _xapian.Registry_swiginit(self, _xapian.new_Registry())
    __swig_destroy__ = _xapian.delete_Registry
    register_weighting_scheme = _swig_new_instance_method(_xapian.Registry_register_weighting_scheme)
    get_weighting_scheme = _swig_new_instance_method(_xapian.Registry_get_weighting_scheme)
    register_posting_source = _swig_new_instance_method(_xapian.Registry_register_posting_source)
    get_posting_source = _swig_new_instance_method(_xapian.Registry_get_posting_source)
    register_match_spy = _swig_new_instance_method(_xapian.Registry_register_match_spy)
    get_match_spy = _swig_new_instance_method(_xapian.Registry_get_match_spy)
    register_lat_long_metric = _swig_new_instance_method(_xapian.Registry_register_lat_long_metric)
    get_lat_long_metric = _swig_new_instance_method(_xapian.Registry_get_lat_long_metric)

# Register Registry in _xapian:
_xapian.Registry_swigregister(Registry)
class Query(object):
    r"""


    Class representing a query. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    OP_AND = _xapian.Query_OP_AND
    OP_OR = _xapian.Query_OP_OR
    OP_AND_NOT = _xapian.Query_OP_AND_NOT
    OP_XOR = _xapian.Query_OP_XOR
    OP_AND_MAYBE = _xapian.Query_OP_AND_MAYBE
    OP_FILTER = _xapian.Query_OP_FILTER
    OP_NEAR = _xapian.Query_OP_NEAR
    OP_PHRASE = _xapian.Query_OP_PHRASE
    OP_VALUE_RANGE = _xapian.Query_OP_VALUE_RANGE
    OP_SCALE_WEIGHT = _xapian.Query_OP_SCALE_WEIGHT
    OP_ELITE_SET = _xapian.Query_OP_ELITE_SET
    OP_VALUE_GE = _xapian.Query_OP_VALUE_GE
    OP_VALUE_LE = _xapian.Query_OP_VALUE_LE
    OP_SYNONYM = _xapian.Query_OP_SYNONYM
    OP_MAX = _xapian.Query_OP_MAX
    OP_WILDCARD = _xapian.Query_OP_WILDCARD
    OP_INVALID = _xapian.Query_OP_INVALID
    WILDCARD_LIMIT_ERROR = _xapian.Query_WILDCARD_LIMIT_ERROR
    WILDCARD_LIMIT_FIRST = _xapian.Query_WILDCARD_LIMIT_FIRST
    WILDCARD_LIMIT_MOST_FREQUENT = _xapian.Query_WILDCARD_LIMIT_MOST_FREQUENT
    __swig_destroy__ = _xapian.delete_Query
    _get_terms_begin = _swig_new_instance_method(_xapian.Query__get_terms_begin)
    _get_terms_end = _swig_new_instance_method(_xapian.Query__get_terms_end)
    get_unique_terms_begin = _swig_new_instance_method(_xapian.Query_get_unique_terms_begin)
    get_unique_terms_end = _swig_new_instance_method(_xapian.Query_get_unique_terms_end)
    get_length = _swig_new_instance_method(_xapian.Query_get_length)
    empty = _swig_new_instance_method(_xapian.Query_empty)
    serialise = _swig_new_instance_method(_xapian.Query_serialise)
    unserialise = _swig_new_static_method(_xapian.Query_unserialise)
    get_type = _swig_new_instance_method(_xapian.Query_get_type)
    get_num_subqueries = _swig_new_instance_method(_xapian.Query_get_num_subqueries)
    get_subquery = _swig_new_instance_method(_xapian.Query_get_subquery)
    __str__ = _swig_new_instance_method(_xapian.Query___str__)

    def __init__(self, *args):
        r"""


        Construct with just an operator.

        Xapian::Query::Query(Query::op op_) Xapian::Query::Query

        Parameters:
        -----------

        op_:  The operator to use - currently only OP_INVALID is useful. 
        """
        _xapian.Query_swiginit(self, _xapian.new_Query(*args))

# Register Query in _xapian:
_xapian.Query_swigregister(Query)
class StemImplementation(object):
    r"""


    Class representing a stemming algorithm implementation. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""


        Default constructor.

        Xapian::StemImplementation::StemImplementation()
        Xapian::StemImplementation::StemImplementation
        """
        if self.__class__ == StemImplementation:
            _self = None
        else:
            _self = self
        _xapian.StemImplementation_swiginit(self, _xapian.new_StemImplementation(_self, ))
    __swig_destroy__ = _xapian.delete_StemImplementation
    __call__ = _swig_new_instance_method(_xapian.StemImplementation___call__)
    __str__ = _swig_new_instance_method(_xapian.StemImplementation___str__)
    def __disown__(self):
        self.this.disown()
        _xapian.disown_StemImplementation(self)
        return weakref.proxy(self)

# Register StemImplementation in _xapian:
_xapian.StemImplementation_swigregister(StemImplementation)
class Stem(object):
    r"""


    Class representing a stemming algorithm. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct a Xapian::Stem object with a user-provided stemming
        algorithm.

        Xapian::Stem::Stem(StemImplementation *p) Xapian::Stem::Stem You can
        subclass Xapian::StemImplementation to implement your own stemming
        algorithm (or to wrap a third-party algorithm) and then wrap your
        implementation in a Xapian::Stem object to pass to the Xapian API.

        Parameters:
        -----------

        p:  The user-subclassed StemImplementation object. This is reference
        counted, and so will be automatically deleted by the Xapian::Stem
        wrapper when no longer required. 
        """
        _xapian.Stem_swiginit(self, _xapian.new_Stem(*args))
    __swig_destroy__ = _xapian.delete_Stem
    __call__ = _swig_new_instance_method(_xapian.Stem___call__)
    is_none = _swig_new_instance_method(_xapian.Stem_is_none)
    __str__ = _swig_new_instance_method(_xapian.Stem___str__)
    get_available_languages = _swig_new_static_method(_xapian.Stem_get_available_languages)

# Register Stem in _xapian:
_xapian.Stem_swigregister(Stem)
class TermGenerator(object):
    r"""


    Parses a piece of text and generate terms.

    This module takes a piece of text and parses it to produce words which
    are then used to generate suitable terms for indexing. The terms
    generated are suitable for use with Query objects produced by the
    QueryParser class. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""


        Default constructor.

        Xapian::TermGenerator::TermGenerator()
        Xapian::TermGenerator::TermGenerator
        """
        _xapian.TermGenerator_swiginit(self, _xapian.new_TermGenerator())
    __swig_destroy__ = _xapian.delete_TermGenerator
    set_stemmer = _swig_new_instance_method(_xapian.TermGenerator_set_stemmer)
    set_stopper = _swig_new_instance_method(_xapian.TermGenerator_set_stopper)
    set_document = _swig_new_instance_method(_xapian.TermGenerator_set_document)
    get_document = _swig_new_instance_method(_xapian.TermGenerator_get_document)
    set_database = _swig_new_instance_method(_xapian.TermGenerator_set_database)
    FLAG_SPELLING = _xapian.TermGenerator_FLAG_SPELLING
    FLAG_NGRAMS = _xapian.TermGenerator_FLAG_NGRAMS
    FLAG_CJK_NGRAM = _xapian.TermGenerator_FLAG_CJK_NGRAM
    STEM_NONE = _xapian.TermGenerator_STEM_NONE
    STEM_SOME = _xapian.TermGenerator_STEM_SOME
    STEM_ALL = _xapian.TermGenerator_STEM_ALL
    STEM_ALL_Z = _xapian.TermGenerator_STEM_ALL_Z
    STEM_SOME_FULL_POS = _xapian.TermGenerator_STEM_SOME_FULL_POS
    STOP_NONE = _xapian.TermGenerator_STOP_NONE
    STOP_ALL = _xapian.TermGenerator_STOP_ALL
    STOP_STEMMED = _xapian.TermGenerator_STOP_STEMMED
    set_flags = _swig_new_instance_method(_xapian.TermGenerator_set_flags)
    set_stemming_strategy = _swig_new_instance_method(_xapian.TermGenerator_set_stemming_strategy)
    set_stopper_strategy = _swig_new_instance_method(_xapian.TermGenerator_set_stopper_strategy)
    set_max_word_length = _swig_new_instance_method(_xapian.TermGenerator_set_max_word_length)
    index_text = _swig_new_instance_method(_xapian.TermGenerator_index_text)
    index_text_without_positions = _swig_new_instance_method(_xapian.TermGenerator_index_text_without_positions)
    increase_termpos = _swig_new_instance_method(_xapian.TermGenerator_increase_termpos)
    get_termpos = _swig_new_instance_method(_xapian.TermGenerator_get_termpos)
    set_termpos = _swig_new_instance_method(_xapian.TermGenerator_set_termpos)
    __str__ = _swig_new_instance_method(_xapian.TermGenerator___str__)

# Register TermGenerator in _xapian:
_xapian.TermGenerator_swigregister(TermGenerator)
class MSet(object):
    r"""


    Class representing a list of search results. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""


        Default constructor.

        Xapian::MSet::MSet() Xapian::MSet::MSet Creates an empty MSet, mostly
        useful as a placeholder. 
        """
        _xapian.MSet_swiginit(self, _xapian.new_MSet())
    __swig_destroy__ = _xapian.delete_MSet
    convert_to_percent = _swig_new_instance_method(_xapian.MSet_convert_to_percent)
    get_termfreq = _swig_new_instance_method(_xapian.MSet_get_termfreq)
    get_termweight = _swig_new_instance_method(_xapian.MSet_get_termweight)
    get_firstitem = _swig_new_instance_method(_xapian.MSet_get_firstitem)
    get_matches_lower_bound = _swig_new_instance_method(_xapian.MSet_get_matches_lower_bound)
    get_matches_estimated = _swig_new_instance_method(_xapian.MSet_get_matches_estimated)
    get_matches_upper_bound = _swig_new_instance_method(_xapian.MSet_get_matches_upper_bound)
    get_uncollapsed_matches_lower_bound = _swig_new_instance_method(_xapian.MSet_get_uncollapsed_matches_lower_bound)
    get_uncollapsed_matches_estimated = _swig_new_instance_method(_xapian.MSet_get_uncollapsed_matches_estimated)
    get_uncollapsed_matches_upper_bound = _swig_new_instance_method(_xapian.MSet_get_uncollapsed_matches_upper_bound)
    get_max_attained = _swig_new_instance_method(_xapian.MSet_get_max_attained)
    get_max_possible = _swig_new_instance_method(_xapian.MSet_get_max_possible)
    SNIPPET_BACKGROUND_MODEL = _xapian.MSet_SNIPPET_BACKGROUND_MODEL
    SNIPPET_EXHAUSTIVE = _xapian.MSet_SNIPPET_EXHAUSTIVE
    SNIPPET_EMPTY_WITHOUT_MATCH = _xapian.MSet_SNIPPET_EMPTY_WITHOUT_MATCH
    SNIPPET_NGRAMS = _xapian.MSet_SNIPPET_NGRAMS
    SNIPPET_CJK_NGRAM = _xapian.MSet_SNIPPET_CJK_NGRAM
    snippet = _swig_new_instance_method(_xapian.MSet_snippet)
    fetch = _swig_new_instance_method(_xapian.MSet_fetch)
    size = _swig_new_instance_method(_xapian.MSet_size)
    empty = _swig_new_instance_method(_xapian.MSet_empty)
    _begin = _swig_new_instance_method(_xapian.MSet__begin)
    _end = _swig_new_instance_method(_xapian.MSet__end)
    back = _swig_new_instance_method(_xapian.MSet_back)
    __str__ = _swig_new_instance_method(_xapian.MSet___str__)
    get_docid = _swig_new_instance_method(_xapian.MSet_get_docid)
    get_document = _swig_new_instance_method(_xapian.MSet_get_document)
    _get_hit_internal = _swig_new_instance_method(_xapian.MSet__get_hit_internal)
    get_document_percentage = _swig_new_instance_method(_xapian.MSet_get_document_percentage)

# Register MSet in _xapian:
_xapian.MSet_swigregister(MSet)
class _MSetIterator(object):
    r"""


    Iterator over a Xapian::MSet. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    mset = property(_xapian._MSetIterator_mset_get, _xapian._MSetIterator_mset_set)
    off_from_end = property(_xapian._MSetIterator_off_from_end_get, _xapian._MSetIterator_off_from_end_set)

    def __init__(self):
        r"""


        Create an unpositioned MSetIterator.

        Xapian::MSetIterator::MSetIterator()
        Xapian::MSetIterator::MSetIterator
        """
        _xapian._MSetIterator_swiginit(self, _xapian.new__MSetIterator())
    get_rank = _swig_new_instance_method(_xapian._MSetIterator_get_rank)
    get_document = _swig_new_instance_method(_xapian._MSetIterator_get_document)
    get_weight = _swig_new_instance_method(_xapian._MSetIterator_get_weight)
    get_collapse_key = _swig_new_instance_method(_xapian._MSetIterator_get_collapse_key)
    get_collapse_count = _swig_new_instance_method(_xapian._MSetIterator_get_collapse_count)
    get_sort_key = _swig_new_instance_method(_xapian._MSetIterator_get_sort_key)
    get_percent = _swig_new_instance_method(_xapian._MSetIterator_get_percent)
    __str__ = _swig_new_instance_method(_xapian._MSetIterator___str__)
    __eq__ = _swig_new_instance_method(_xapian._MSetIterator___eq__)
    __ne__ = _swig_new_instance_method(_xapian._MSetIterator___ne__)
    equals = _swig_new_instance_method(_xapian._MSetIterator_equals)
    get_docid = _swig_new_instance_method(_xapian._MSetIterator_get_docid)
    __next__ = _swig_new_instance_method(_xapian._MSetIterator___next__)
    prev = _swig_new_instance_method(_xapian._MSetIterator_prev)
    __swig_destroy__ = _xapian.delete__MSetIterator

# Register _MSetIterator in _xapian:
_xapian._MSetIterator_swigregister(_MSetIterator)
class ESet(object):
    r"""


    Class representing a list of search results. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""


        Default constructor.

        Xapian::ESet::ESet() Xapian::ESet::ESet Creates an empty ESet, mostly
        useful as a placeholder. 
        """
        _xapian.ESet_swiginit(self, _xapian.new_ESet())
    __swig_destroy__ = _xapian.delete_ESet
    size = _swig_new_instance_method(_xapian.ESet_size)
    empty = _swig_new_instance_method(_xapian.ESet_empty)
    get_ebound = _swig_new_instance_method(_xapian.ESet_get_ebound)
    _begin = _swig_new_instance_method(_xapian.ESet__begin)
    _end = _swig_new_instance_method(_xapian.ESet__end)
    back = _swig_new_instance_method(_xapian.ESet_back)
    __str__ = _swig_new_instance_method(_xapian.ESet___str__)

# Register ESet in _xapian:
_xapian.ESet_swigregister(ESet)
class _ESetIterator(object):
    r"""


    Iterator over a Xapian::ESet. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    eset = property(_xapian._ESetIterator_eset_get, _xapian._ESetIterator_eset_set)
    off_from_end = property(_xapian._ESetIterator_off_from_end_get, _xapian._ESetIterator_off_from_end_set)

    def __init__(self):
        r"""


        Create an unpositioned ESetIterator.

        Xapian::ESetIterator::ESetIterator()
        Xapian::ESetIterator::ESetIterator
        """
        _xapian._ESetIterator_swiginit(self, _xapian.new__ESetIterator())
    get_weight = _swig_new_instance_method(_xapian._ESetIterator_get_weight)
    __str__ = _swig_new_instance_method(_xapian._ESetIterator___str__)
    __eq__ = _swig_new_instance_method(_xapian._ESetIterator___eq__)
    __ne__ = _swig_new_instance_method(_xapian._ESetIterator___ne__)
    equals = _swig_new_instance_method(_xapian._ESetIterator_equals)
    get_term = _swig_new_instance_method(_xapian._ESetIterator_get_term)
    __next__ = _swig_new_instance_method(_xapian._ESetIterator___next__)
    prev = _swig_new_instance_method(_xapian._ESetIterator_prev)
    __swig_destroy__ = _xapian.delete__ESetIterator

# Register _ESetIterator in _xapian:
_xapian._ESetIterator_swigregister(_ESetIterator)
__eq__ = _xapian.__eq__
__lt__ = _xapian.__lt__
__gt__ = _xapian.__gt__
__ge__ = _xapian.__ge__
__le__ = _xapian.__le__
__add__ = _xapian.__add__
class RSet(object):
    r"""


    A relevance set (R-Set).

    This is the set of documents which are marked as relevant, for use in
    modifying the term weights, and in performing query expansion. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""


        Default constructor.

        Xapian::RSet::RSet() Xapian::RSet::RSet
        """
        _xapian.RSet_swiginit(self, _xapian.new_RSet())
    __swig_destroy__ = _xapian.delete_RSet
    size = _swig_new_instance_method(_xapian.RSet_size)
    empty = _swig_new_instance_method(_xapian.RSet_empty)
    add_document = _swig_new_instance_method(_xapian.RSet_add_document)
    remove_document = _swig_new_instance_method(_xapian.RSet_remove_document)
    contains = _swig_new_instance_method(_xapian.RSet_contains)
    __str__ = _swig_new_instance_method(_xapian.RSet___str__)

# Register RSet in _xapian:
_xapian.RSet_swigregister(RSet)
class MatchDecider(object):
    r"""


    Base class for matcher decision functor. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""


        Default constructor.

        Xapian::MatchDecider::MatchDecider()
        Xapian::MatchDecider::MatchDecider
        """
        if self.__class__ == MatchDecider:
            _self = None
        else:
            _self = self
        _xapian.MatchDecider_swiginit(self, _xapian.new_MatchDecider(_self, ))
    __call__ = _swig_new_instance_method(_xapian.MatchDecider___call__)
    __swig_destroy__ = _xapian.delete_MatchDecider
    def __disown__(self):
        self.this.disown()
        _xapian.disown_MatchDecider(self)
        return weakref.proxy(self)

# Register MatchDecider in _xapian:
_xapian.MatchDecider_swigregister(MatchDecider)
class Enquire(object):
    r"""


    This class provides an interface to the information retrieval system
    for the purpose of searching.

    Databases are usually opened lazily, so exceptions may not be thrown
    where you would expect them to be. You should catch Xapian::Error
    exceptions when calling any method in Xapian::Enquire.

    Parameters:
    -----------

    Xapian::InvalidArgumentError:  will be thrown if an invalid argument
    is supplied, for example, an unknown database type. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, database):
        r"""


        Create a Xapian::Enquire object.

        Xapian::Enquire::Enquire(const Database &database, ErrorHandler
        *errorhandler_) Xapian::Enquire::Enquire This specification cannot be
        changed once the Xapian::Enquire is opened: you must create a new
        Xapian::Enquire object to access a different database, or set of
        databases.

        The database supplied must have been initialised (ie, must not be the
        result of calling the Database::Database() constructor). If you need
        to handle a situation where you have no databases gracefully, a
        database created with DB_BACKEND_INMEMORY can be passed here to
        provide a completely empty database.

        Parameters:
        -----------

        database:  Specification of the database or databases to use.

        errorhandler_:  This parameter is deprecated (since Xapian 1.3.1), and
        as of 1.3.5 it's ignored completely.

        Parameters:
        -----------

        Xapian::InvalidArgumentError:  will be thrown if an empty Database
        object is supplied. 
        """
        _xapian.Enquire_swiginit(self, _xapian.new_Enquire(database))
    __swig_destroy__ = _xapian.delete_Enquire
    set_query = _swig_new_instance_method(_xapian.Enquire_set_query)
    get_query = _swig_new_instance_method(_xapian.Enquire_get_query)
    add_matchspy = _swig_new_instance_method(_xapian.Enquire_add_matchspy)
    clear_matchspies = _swig_new_instance_method(_xapian.Enquire_clear_matchspies)
    set_weighting_scheme = _swig_new_instance_method(_xapian.Enquire_set_weighting_scheme)
    set_expansion_scheme = _swig_new_instance_method(_xapian.Enquire_set_expansion_scheme)
    set_collapse_key = _swig_new_instance_method(_xapian.Enquire_set_collapse_key)
    ASCENDING = _xapian.Enquire_ASCENDING
    DESCENDING = _xapian.Enquire_DESCENDING
    DONT_CARE = _xapian.Enquire_DONT_CARE
    set_docid_order = _swig_new_instance_method(_xapian.Enquire_set_docid_order)
    set_cutoff = _swig_new_instance_method(_xapian.Enquire_set_cutoff)
    set_sort_by_relevance = _swig_new_instance_method(_xapian.Enquire_set_sort_by_relevance)
    set_sort_by_value = _swig_new_instance_method(_xapian.Enquire_set_sort_by_value)
    set_sort_by_key = _swig_new_instance_method(_xapian.Enquire_set_sort_by_key)
    set_sort_by_value_then_relevance = _swig_new_instance_method(_xapian.Enquire_set_sort_by_value_then_relevance)
    set_sort_by_key_then_relevance = _swig_new_instance_method(_xapian.Enquire_set_sort_by_key_then_relevance)
    set_sort_by_relevance_then_value = _swig_new_instance_method(_xapian.Enquire_set_sort_by_relevance_then_value)
    set_sort_by_relevance_then_key = _swig_new_instance_method(_xapian.Enquire_set_sort_by_relevance_then_key)
    set_time_limit = _swig_new_instance_method(_xapian.Enquire_set_time_limit)
    get_mset = _swig_new_instance_method(_xapian.Enquire_get_mset)
    INCLUDE_QUERY_TERMS = _xapian.Enquire_INCLUDE_QUERY_TERMS
    USE_EXACT_TERMFREQ = _xapian.Enquire_USE_EXACT_TERMFREQ
    get_eset = _swig_new_instance_method(_xapian.Enquire_get_eset)
    _get_matching_terms_begin = _swig_new_instance_method(_xapian.Enquire__get_matching_terms_begin)
    _get_matching_terms_end = _swig_new_instance_method(_xapian.Enquire__get_matching_terms_end)
    __str__ = _swig_new_instance_method(_xapian.Enquire___str__)

# Register Enquire in _xapian:
_xapian.Enquire_swigregister(Enquire)
class ExpandDecider(object):
    r"""


    Virtual base class for expand decider functor. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""


        Default constructor.

        Xapian::ExpandDecider::ExpandDecider()
        Xapian::ExpandDecider::ExpandDecider
        """
        if self.__class__ == ExpandDecider:
            _self = None
        else:
            _self = self
        _xapian.ExpandDecider_swiginit(self, _xapian.new_ExpandDecider(_self, ))
    __call__ = _swig_new_instance_method(_xapian.ExpandDecider___call__)
    __swig_destroy__ = _xapian.delete_ExpandDecider
    release = _swig_new_instance_method(_xapian.ExpandDecider_release)
    def __disown__(self):
        self.this.disown()
        _xapian.disown_ExpandDecider(self)
        return weakref.proxy(self)

# Register ExpandDecider in _xapian:
_xapian.ExpandDecider_swigregister(ExpandDecider)
class ExpandDeciderAnd(ExpandDecider):
    r"""


    ExpandDecider subclass which rejects terms using two ExpandDeciders.

    Terms are only accepted if they are accepted by both of the specified
    ExpandDecider objects. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, first_, second_):
        r"""


        Compatibility method.

        Xapian::ExpandDeciderAnd::ExpandDeciderAnd(const ExpandDecider
        *first_, const ExpandDecider *second_)
        Xapian::ExpandDeciderAnd::ExpandDeciderAnd

        Parameters:
        -----------

        first_:  First ExpandDecider object to test with.

        second_:   ExpandDecider object to test with if first_ accepts. 
        """
        _xapian.ExpandDeciderAnd_swiginit(self, _xapian.new_ExpandDeciderAnd(first_, second_))
    __swig_destroy__ = _xapian.delete_ExpandDeciderAnd

# Register ExpandDeciderAnd in _xapian:
_xapian.ExpandDeciderAnd_swigregister(ExpandDeciderAnd)
class ExpandDeciderFilterPrefix(ExpandDecider):
    r"""


    ExpandDecider subclass which restrict terms to a particular prefix.

    ExpandDeciderFilterPrefix provides an easy way to choose terms with a
    particular prefix when generating an ESet. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, prefix_):
        r"""


        The parameter specify the prefix of terms to be retained.

        Xapian::ExpandDeciderFilterPrefix::ExpandDeciderFilterPrefix(const
        std::string &prefix_)
        Xapian::ExpandDeciderFilterPrefix::ExpandDeciderFilterPrefix

        Parameters:
        -----------

        prefix_:  restrict terms to the particular prefix_ 
        """
        _xapian.ExpandDeciderFilterPrefix_swiginit(self, _xapian.new_ExpandDeciderFilterPrefix(prefix_))
    __swig_destroy__ = _xapian.delete_ExpandDeciderFilterPrefix

# Register ExpandDeciderFilterPrefix in _xapian:
_xapian.ExpandDeciderFilterPrefix_swigregister(ExpandDeciderFilterPrefix)
class KeyMaker(object):
    r"""


    Virtual base class for key making functors. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""


        Default constructor.

        Xapian::KeyMaker::KeyMaker() Xapian::KeyMaker::KeyMaker
        """
        if self.__class__ == KeyMaker:
            _self = None
        else:
            _self = self
        _xapian.KeyMaker_swiginit(self, _xapian.new_KeyMaker(_self, ))
    __call__ = _swig_new_instance_method(_xapian.KeyMaker___call__)
    __swig_destroy__ = _xapian.delete_KeyMaker
    release = _swig_new_instance_method(_xapian.KeyMaker_release)
    def __disown__(self):
        self.this.disown()
        _xapian.disown_KeyMaker(self)
        return weakref.proxy(self)

# Register KeyMaker in _xapian:
_xapian.KeyMaker_swigregister(KeyMaker)
class MultiValueKeyMaker(KeyMaker):
    r"""


    KeyMaker subclass which combines several values.

    When the result is used for sorting, results are ordered by the first
    value. In the event of a tie, the second is used. If this is the same
    for both, the third is used, and so on. If reverse is true for a
    value, then the sort order for that value is reversed.

    When used for collapsing, the documents will only be considered equal
    if all the values specified match. If none of the specified values are
    set then the generated key will be empty, so such documents won't be
    collapsed (which is consistent with the behaviour in the "collapse on
    a value" case). If you'd prefer that documents with none of the keys
    set are collapsed together, then you can set reverse for at least one
    of the values. Other than this, it isn't useful to set reverse for
    collapsing. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""


        Construct a MultiValueKeyMaker from a pair of iterators.

        Xapian::MultiValueKeyMaker::MultiValueKeyMaker(Iterator begin,
        Iterator end) Xapian::MultiValueKeyMaker::MultiValueKeyMaker The
        iterators must be a begin/end pair returning Xapian::valueno (or a
        compatible type) when dereferenced. 
        """
        _xapian.MultiValueKeyMaker_swiginit(self, _xapian.new_MultiValueKeyMaker())
    add_value = _swig_new_instance_method(_xapian.MultiValueKeyMaker_add_value)
    __swig_destroy__ = _xapian.delete_MultiValueKeyMaker

# Register MultiValueKeyMaker in _xapian:
_xapian.MultiValueKeyMaker_swigregister(MultiValueKeyMaker)
RP_SUFFIX = _xapian.RP_SUFFIX
RP_REPEATED = _xapian.RP_REPEATED
RP_DATE_PREFER_MDY = _xapian.RP_DATE_PREFER_MDY
class Stopper(object):
    r"""


    Abstract base class for stop-word decision functor.

    If you just want to use an existing stopword list, see
    Xapian::SimpleStopper. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""


        Default constructor.

        Xapian::Stopper::Stopper() Xapian::Stopper::Stopper
        """
        if self.__class__ == Stopper:
            _self = None
        else:
            _self = self
        _xapian.Stopper_swiginit(self, _xapian.new_Stopper(_self, ))
    __call__ = _swig_new_instance_method(_xapian.Stopper___call__)
    __swig_destroy__ = _xapian.delete_Stopper
    __str__ = _swig_new_instance_method(_xapian.Stopper___str__)
    release = _swig_new_instance_method(_xapian.Stopper_release)
    def __disown__(self):
        self.this.disown()
        _xapian.disown_Stopper(self)
        return weakref.proxy(self)

# Register Stopper in _xapian:
_xapian.Stopper_swigregister(Stopper)
class SimpleStopper(Stopper):
    r"""


    Simple implementation of Stopper class - this will suit most users. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    add = _swig_new_instance_method(_xapian.SimpleStopper_add)

    def __init__(self, *args):
        r"""


        Initialise from a pair of iterators.

        Xapian::SimpleStopper::SimpleStopper(Iterator begin, Iterator end)
        Xapian::SimpleStopper::SimpleStopper  Xapian includes stopword list
        files for many languages. You can initialise from a file like so:

        In bindings for other languages it isn't possible to pass a C++
        iterator pair, so instead this constructor is wrapped to allow passing
        a filename. 
        """
        _xapian.SimpleStopper_swiginit(self, _xapian.new_SimpleStopper(*args))
    __swig_destroy__ = _xapian.delete_SimpleStopper

# Register SimpleStopper in _xapian:
_xapian.SimpleStopper_swigregister(SimpleStopper)
class RangeProcessor(object):
    r"""


    Base class for range processors. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Constructor.

        Xapian::RangeProcessor::RangeProcessor(Xapian::valueno slot_, const
        std::string &str_=std::string(), unsigned flags_=0)
        Xapian::RangeProcessor::RangeProcessor

        Parameters:
        -----------

        slot_:  Which value slot to generate ranges over.

        str_:  A string to look for to recognise values as belonging to this
        range (as a prefix by default, or as a suffix if flags
        Xapian::RP_SUFFIX is specified).

        flags_:  Zero or more of the following flags, combined with bitwise-or
        (| in C++): Xapian::RP_SUFFIX - require str_ as a suffix instead of a
        prefix.

        Xapian::RP_REPEATED - optionally allow str_ on both ends of the range
        - e.g. $1..$10 or 5m..50m. By default a prefix is only checked for on
        the start (e.g. date:1/1/1980..31/12/1989), and a suffix only on the
        end (e.g. 2..12kg). 
        """
        if self.__class__ == RangeProcessor:
            _self = None
        else:
            _self = self
        _xapian.RangeProcessor_swiginit(self, _xapian.new_RangeProcessor(_self, *args))
    __swig_destroy__ = _xapian.delete_RangeProcessor
    check_range = _swig_new_instance_method(_xapian.RangeProcessor_check_range)
    __call__ = _swig_new_instance_method(_xapian.RangeProcessor___call__)
    release = _swig_new_instance_method(_xapian.RangeProcessor_release)
    def __disown__(self):
        self.this.disown()
        _xapian.disown_RangeProcessor(self)
        return weakref.proxy(self)

# Register RangeProcessor in _xapian:
_xapian.RangeProcessor_swigregister(RangeProcessor)
class DateRangeProcessor(RangeProcessor):
    r"""


    Handle a date range.

    Begin and end must be dates in a recognised format. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Constructor.

        Xapian::DateRangeProcessor::DateRangeProcessor(Xapian::valueno slot_,
        const std::string &str_, unsigned flags_=0, int epoch_year_=1970)
        Xapian::DateRangeProcessor::DateRangeProcessor

        Parameters:
        -----------

        slot_:  The value slot number to query.

        str_:  A string to look for to recognise values as belonging to this
        date range.

        flags_:  Zero or more of the following flags, combined with bitwise-
        or: Xapian::RP_SUFFIX - require str_ as a suffix instead of a prefix.

        Xapian::RP_REPEATED - optionally allow str_ on both ends of the range
        - e.g. $1..$10 or 5m..50m. By default a prefix is only checked for on
        the start (e.g. date:1/1/1980..31/12/1989), and a suffix only on the
        end (e.g. 2..12kg).

        Xapian::RP_DATE_PREFER_MDY - interpret ambiguous dates as
        month/day/year rather than day/month/year.

        epoch_year_:  Year to use as the epoch for dates with 2 digit years
        (default: 1970, so 1/1/69 is 2069 while 1/1/70 is 1970).

        The string supplied in str_ is used by operator() to decide whether
        the pair of strings supplied to it constitute a valid range. If
        prefix_ is true, the first value in a range must begin with str_ (and
        the second value may optionally begin with str_); if prefix_ is false,
        the second value in a range must end with str_ (and the first value
        may optionally end with str_).

        If str_ is empty, the Xapian::RP_SUFFIX and Xapian::RP_REPEATED are
        irrelevant, and no special strings are required at the start or end of
        the strings defining the range.

        The remainder of both strings defining the endpoints must be valid
        dates.

        For example, if str_ is "created:", Xapian::RP_SUFFIX is not
        specified, and the range processor has been added to the queryparser,
        the queryparser will accept "created:1/1/2000..31/12/2001". 
        """
        _xapian.DateRangeProcessor_swiginit(self, _xapian.new_DateRangeProcessor(*args))
    __swig_destroy__ = _xapian.delete_DateRangeProcessor

# Register DateRangeProcessor in _xapian:
_xapian.DateRangeProcessor_swigregister(DateRangeProcessor)
class NumberRangeProcessor(RangeProcessor):
    r"""


    Handle a number range.

    This class must be used on values which have been encoded using
    Xapian::sortable_serialise() which turns numbers into strings which
    will sort in the same order as the numbers (the same values can be
    used to implement a numeric sort). 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Constructor.

        Xapian::NumberRangeProcessor::NumberRangeProcessor(Xapian::valueno
        slot_, const std::string &str_=std::string(), unsigned flags_=0)
        Xapian::NumberRangeProcessor::NumberRangeProcessor

        Parameters:
        -----------

        slot_:  The value slot number to query.

        str_:  A string to look for to recognise values as belonging to this
        numeric range.

        flags_:  Zero or more of the following flags, combined with bitwise-
        or: Xapian::RP_SUFFIX - require str_ as a suffix instead of a prefix.

        Xapian::RP_REPEATED - optionally allow str_ on both ends of the range
        - e.g. $1..$10 or 5m..50m. By default a prefix is only checked for on
        the start (e.g. date:1/1/1980..31/12/1989), and a suffix only on the
        end (e.g. 2..12kg).

        The string supplied in str_ is used by operator() to decide whether
        the pair of strings supplied to it constitute a valid range. If
        prefix_ is true, the first value in a range must begin with str_ (and
        the second value may optionally begin with str_); if prefix_ is false,
        the second value in a range must end with str_ (and the first value
        may optionally end with str_).

        If str_ is empty, the setting of prefix_ is irrelevant, and no special
        strings are required at the start or end of the strings defining the
        range.

        The remainder of both strings defining the endpoints must be valid
        floating point numbers. (FIXME: define format recognised).

        For example, if str_ is "$" and prefix_ is true, and the range
        processor has been added to the queryparser, the queryparser will
        accept "$10..50" or "$10..$50", but not "10..50" or "10..$50"
        as valid ranges. If str_ is "kg" and prefix_ is false, the
        queryparser will accept "10..50kg" or "10kg..50kg", but not
        "10..50" or "10kg..50" as valid ranges. 
        """
        _xapian.NumberRangeProcessor_swiginit(self, _xapian.new_NumberRangeProcessor(*args))
    __swig_destroy__ = _xapian.delete_NumberRangeProcessor

# Register NumberRangeProcessor in _xapian:
_xapian.NumberRangeProcessor_swigregister(NumberRangeProcessor)
class ValueRangeProcessor(object):
    r"""


    Base class for value range processors. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""


        Default constructor.

        Xapian::ValueRangeProcessor::ValueRangeProcessor()
        Xapian::ValueRangeProcessor::ValueRangeProcessor
        """
        if self.__class__ == ValueRangeProcessor:
            _self = None
        else:
            _self = self
        _xapian.ValueRangeProcessor_swiginit(self, _xapian.new_ValueRangeProcessor(_self, ))
    __swig_destroy__ = _xapian.delete_ValueRangeProcessor
    __call__ = _swig_new_instance_method(_xapian.ValueRangeProcessor___call__)
    release = _swig_new_instance_method(_xapian.ValueRangeProcessor_release)
    def __disown__(self):
        self.this.disown()
        _xapian.disown_ValueRangeProcessor(self)
        return weakref.proxy(self)

# Register ValueRangeProcessor in _xapian:
_xapian.ValueRangeProcessor_swigregister(ValueRangeProcessor)
class StringValueRangeProcessor(ValueRangeProcessor):
    r"""


    Handle a string range.

    The end points can be any strings.

    Deprecated Use Xapian::RangeProcessor instead (added in 1.3.6). 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Constructor.

        Xapian::StringValueRangeProcessor::StringValueRangeProcessor(Xapian::valueno
        slot_, const std::string &str_, bool prefix_=true)
        Xapian::StringValueRangeProcessor::StringValueRangeProcessor

        Parameters:
        -----------

        slot_:  The value number to return from operator().

        str_:  A string to look for to recognise values as belonging to this
        range.

        prefix_:  Flag specifying whether to check for str_ as a prefix or a
        suffix. 
        """
        _xapian.StringValueRangeProcessor_swiginit(self, _xapian.new_StringValueRangeProcessor(*args))
    __swig_destroy__ = _xapian.delete_StringValueRangeProcessor

# Register StringValueRangeProcessor in _xapian:
_xapian.StringValueRangeProcessor_swigregister(StringValueRangeProcessor)
class DateValueRangeProcessor(StringValueRangeProcessor):
    r"""


    Handle a date range.

    Begin and end must be dates in a recognised format.

    Deprecated Use Xapian::DateRangeProcessor instead (added in 1.3.6). 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Constructor.

        Xapian::DateValueRangeProcessor::DateValueRangeProcessor(Xapian::valueno
        slot_, const char *str_, bool prefix_=true, bool prefer_mdy_=false,
        int epoch_year_=1970)
        Xapian::DateValueRangeProcessor::DateValueRangeProcessor This is like
        the previous version, but with const char * instead of std::string -
        we need this overload as otherwise DateValueRangeProcessor(1,
        "date:") quietly interprets the second argument as a boolean in
        preference to std::string. If you want to be compatible with 1.2.12
        and earlier, then explicitly convert to std::string, i.e.:
        DateValueRangeProcessor(1, std::string("date:"))

        Parameters:
        -----------

        slot_:  The value number to return from operator().

        str_:  A string to look for to recognise values as belonging to this
        date range.

        prefix_:  Whether to look for the string at the start or end of the
        values. If true, the string is a prefix; if false, the string is a
        suffix (default: true).

        prefer_mdy_:  Should ambiguous dates be interpreted as month/day/year
        rather than day/month/year? (default: false)

        epoch_year_:  Year to use as the epoch for dates with 2 digit years
        (default: 1970, so 1/1/69 is 2069 while 1/1/70 is 1970).

        The string supplied in str_ is used by operator() to decide whether
        the pair of strings supplied to it constitute a valid range. If
        prefix_ is true, the first value in a range must begin with str_ (and
        the second value may optionally begin with str_); if prefix_ is false,
        the second value in a range must end with str_ (and the first value
        may optionally end with str_).

        If str_ is empty, the setting of prefix_ is irrelevant, and no special
        strings are required at the start or end of the strings defining the
        range.

        The remainder of both strings defining the endpoints must be valid
        dates.

        For example, if str_ is "created:" and prefix_ is true, and the
        range processor has been added to the queryparser, the queryparser
        will accept "created:1/1/2000..31/12/2001". 
        """
        _xapian.DateValueRangeProcessor_swiginit(self, _xapian.new_DateValueRangeProcessor(*args))
    __swig_destroy__ = _xapian.delete_DateValueRangeProcessor

# Register DateValueRangeProcessor in _xapian:
_xapian.DateValueRangeProcessor_swigregister(DateValueRangeProcessor)
class NumberValueRangeProcessor(StringValueRangeProcessor):
    r"""


    Handle a number range.

    This class must be used on values which have been encoded using
    Xapian::sortable_serialise() which turns numbers into strings which
    will sort in the same order as the numbers (the same values can be
    used to implement a numeric sort).

    Deprecated Use Xapian::NumberRangeProcessor instead (added in 1.3.6).

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Constructor.

        Xapian::NumberValueRangeProcessor::NumberValueRangeProcessor(Xapian::valueno
        slot_, const std::string &str_, bool prefix_=true)
        Xapian::NumberValueRangeProcessor::NumberValueRangeProcessor

        Parameters:
        -----------

        slot_:  The value number to return from operator().

        str_:  A string to look for to recognise values as belonging to this
        numeric range.

        prefix_:  Whether to look for the string at the start or end of the
        values. If true, the string is a prefix; if false, the string is a
        suffix (default: true).

        The string supplied in str_ is used by operator() to decide whether
        the pair of strings supplied to it constitute a valid range. If
        prefix_ is true, the first value in a range must begin with str_ (and
        the second value may optionally begin with str_); if prefix_ is false,
        the second value in a range must end with str_ (and the first value
        may optionally end with str_).

        If str_ is empty, the setting of prefix_ is irrelevant, and no special
        strings are required at the start or end of the strings defining the
        range.

        The remainder of both strings defining the endpoints must be valid
        floating point numbers. (FIXME: define format recognised).

        For example, if str_ is "$" and prefix_ is true, and the range
        processor has been added to the queryparser, the queryparser will
        accept "$10..50" or "$10..$50", but not "10..50" or "10..$50"
        as valid ranges. If str_ is "kg" and prefix_ is false, the
        queryparser will accept "10..50kg" or "10kg..50kg", but not
        "10..50" or "10kg..50" as valid ranges. 
        """
        _xapian.NumberValueRangeProcessor_swiginit(self, _xapian.new_NumberValueRangeProcessor(*args))
    __swig_destroy__ = _xapian.delete_NumberValueRangeProcessor

# Register NumberValueRangeProcessor in _xapian:
_xapian.NumberValueRangeProcessor_swigregister(NumberValueRangeProcessor)
class FieldProcessor(object):
    r"""


    Base class for field processors. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""


        Default constructor.

        Xapian::FieldProcessor::FieldProcessor()
        Xapian::FieldProcessor::FieldProcessor
        """
        if self.__class__ == FieldProcessor:
            _self = None
        else:
            _self = self
        _xapian.FieldProcessor_swiginit(self, _xapian.new_FieldProcessor(_self, ))
    __swig_destroy__ = _xapian.delete_FieldProcessor
    __call__ = _swig_new_instance_method(_xapian.FieldProcessor___call__)
    release = _swig_new_instance_method(_xapian.FieldProcessor_release)
    def __disown__(self):
        self.this.disown()
        _xapian.disown_FieldProcessor(self)
        return weakref.proxy(self)

# Register FieldProcessor in _xapian:
_xapian.FieldProcessor_swigregister(FieldProcessor)
class QueryParser(object):
    r"""


    Build a Xapian::Query object from a user query string. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    FLAG_BOOLEAN = _xapian.QueryParser_FLAG_BOOLEAN
    FLAG_PHRASE = _xapian.QueryParser_FLAG_PHRASE
    FLAG_LOVEHATE = _xapian.QueryParser_FLAG_LOVEHATE
    FLAG_BOOLEAN_ANY_CASE = _xapian.QueryParser_FLAG_BOOLEAN_ANY_CASE
    FLAG_WILDCARD = _xapian.QueryParser_FLAG_WILDCARD
    FLAG_PURE_NOT = _xapian.QueryParser_FLAG_PURE_NOT
    FLAG_PARTIAL = _xapian.QueryParser_FLAG_PARTIAL
    FLAG_SPELLING_CORRECTION = _xapian.QueryParser_FLAG_SPELLING_CORRECTION
    FLAG_SYNONYM = _xapian.QueryParser_FLAG_SYNONYM
    FLAG_AUTO_SYNONYMS = _xapian.QueryParser_FLAG_AUTO_SYNONYMS
    FLAG_AUTO_MULTIWORD_SYNONYMS = _xapian.QueryParser_FLAG_AUTO_MULTIWORD_SYNONYMS
    FLAG_NGRAMS = _xapian.QueryParser_FLAG_NGRAMS
    FLAG_CJK_NGRAM = _xapian.QueryParser_FLAG_CJK_NGRAM
    FLAG_ACCUMULATE = _xapian.QueryParser_FLAG_ACCUMULATE
    FLAG_NO_POSITIONS = _xapian.QueryParser_FLAG_NO_POSITIONS
    FLAG_DEFAULT = _xapian.QueryParser_FLAG_DEFAULT
    STEM_NONE = _xapian.QueryParser_STEM_NONE
    STEM_SOME = _xapian.QueryParser_STEM_SOME
    STEM_ALL = _xapian.QueryParser_STEM_ALL
    STEM_ALL_Z = _xapian.QueryParser_STEM_ALL_Z
    STEM_SOME_FULL_POS = _xapian.QueryParser_STEM_SOME_FULL_POS

    def __init__(self):
        r"""


        Default constructor.

        Xapian::QueryParser::QueryParser() Xapian::QueryParser::QueryParser
        """
        _xapian.QueryParser_swiginit(self, _xapian.new_QueryParser())
    __swig_destroy__ = _xapian.delete_QueryParser
    set_stemmer = _swig_new_instance_method(_xapian.QueryParser_set_stemmer)
    set_stemming_strategy = _swig_new_instance_method(_xapian.QueryParser_set_stemming_strategy)
    set_stopper = _swig_new_instance_method(_xapian.QueryParser_set_stopper)
    set_default_op = _swig_new_instance_method(_xapian.QueryParser_set_default_op)
    get_default_op = _swig_new_instance_method(_xapian.QueryParser_get_default_op)
    set_database = _swig_new_instance_method(_xapian.QueryParser_set_database)
    set_max_expansion = _swig_new_instance_method(_xapian.QueryParser_set_max_expansion)
    set_max_wildcard_expansion = _swig_new_instance_method(_xapian.QueryParser_set_max_wildcard_expansion)
    parse_query = _swig_new_instance_method(_xapian.QueryParser_parse_query)
    add_prefix = _swig_new_instance_method(_xapian.QueryParser_add_prefix)
    add_boolean_prefix = _swig_new_instance_method(_xapian.QueryParser_add_boolean_prefix)
    _stoplist_begin = _swig_new_instance_method(_xapian.QueryParser__stoplist_begin)
    _stoplist_end = _swig_new_instance_method(_xapian.QueryParser__stoplist_end)
    _unstem_begin = _swig_new_instance_method(_xapian.QueryParser__unstem_begin)
    _unstem_end = _swig_new_instance_method(_xapian.QueryParser__unstem_end)
    add_rangeprocessor = _swig_new_instance_method(_xapian.QueryParser_add_rangeprocessor)
    add_valuerangeprocessor = _swig_new_instance_method(_xapian.QueryParser_add_valuerangeprocessor)
    get_corrected_query_string = _swig_new_instance_method(_xapian.QueryParser_get_corrected_query_string)
    __str__ = _swig_new_instance_method(_xapian.QueryParser___str__)

# Register QueryParser in _xapian:
_xapian.QueryParser_swigregister(QueryParser)
sortable_serialise = _xapian.sortable_serialise
sortable_unserialise = _xapian.sortable_unserialise
class ValueSetMatchDecider(MatchDecider):
    r"""


    MatchDecider filtering results based on whether document values are in
    a user- defined set. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, slot, inclusive_):
        r"""


        Construct a ValueSetMatchDecider.

        Xapian::ValueSetMatchDecider::ValueSetMatchDecider(Xapian::valueno
        slot, bool inclusive_)
        Xapian::ValueSetMatchDecider::ValueSetMatchDecider

        Parameters:
        -----------

        slot:  The value slot number to look in.

        inclusive_:  If true, match decider accepts documents which have a
        value in the specified slot which is a member of the test set; if
        false, match decider accepts documents which do not have a value in
        the specified slot. 
        """
        _xapian.ValueSetMatchDecider_swiginit(self, _xapian.new_ValueSetMatchDecider(slot, inclusive_))
    add_value = _swig_new_instance_method(_xapian.ValueSetMatchDecider_add_value)
    remove_value = _swig_new_instance_method(_xapian.ValueSetMatchDecider_remove_value)
    __swig_destroy__ = _xapian.delete_ValueSetMatchDecider

# Register ValueSetMatchDecider in _xapian:
_xapian.ValueSetMatchDecider_swigregister(ValueSetMatchDecider)
class Weight(object):
    r"""


    Abstract base class for weighting schemes. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    TWO_STAGE_SMOOTHING = _xapian.Weight_TWO_STAGE_SMOOTHING
    DIRICHLET_SMOOTHING = _xapian.Weight_DIRICHLET_SMOOTHING
    ABSOLUTE_DISCOUNT_SMOOTHING = _xapian.Weight_ABSOLUTE_DISCOUNT_SMOOTHING
    JELINEK_MERCER_SMOOTHING = _xapian.Weight_JELINEK_MERCER_SMOOTHING
    DIRICHLET_PLUS_SMOOTHING = _xapian.Weight_DIRICHLET_PLUS_SMOOTHING
    __swig_destroy__ = _xapian.delete_Weight
    name = _swig_new_instance_method(_xapian.Weight_name)
    get_sumpart = _swig_new_instance_method(_xapian.Weight_get_sumpart)
    get_maxpart = _swig_new_instance_method(_xapian.Weight_get_maxpart)
    get_sumextra = _swig_new_instance_method(_xapian.Weight_get_sumextra)
    get_maxextra = _swig_new_instance_method(_xapian.Weight_get_maxextra)

# Register Weight in _xapian:
_xapian.Weight_swigregister(Weight)
class BoolWeight(Weight):
    r"""


    Class implementing a "boolean" weighting scheme.

    This weighting scheme gives all documents zero weight. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""


        Construct a BoolWeight.

        Xapian::BoolWeight::BoolWeight() Xapian::BoolWeight::BoolWeight
        """
        _xapian.BoolWeight_swiginit(self, _xapian.new_BoolWeight())
    __swig_destroy__ = _xapian.delete_BoolWeight

# Register BoolWeight in _xapian:
_xapian.BoolWeight_swigregister(BoolWeight)
class TfIdfWeight(Weight):
    r"""


    Xapian::Weight subclass implementing the tf-idf weighting scheme. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct a TfIdfWeight using the default normalizations ("ntn").

        Xapian::TfIdfWeight::TfIdfWeight() Xapian::TfIdfWeight::TfIdfWeight
        """
        _xapian.TfIdfWeight_swiginit(self, _xapian.new_TfIdfWeight(*args))
    __swig_destroy__ = _xapian.delete_TfIdfWeight

# Register TfIdfWeight in _xapian:
_xapian.TfIdfWeight_swigregister(TfIdfWeight)
class BM25Weight(Weight):
    r"""


    Xapian::Weight subclass implementing the BM25 probabilistic formula.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""Xapian::BM25Weight::BM25Weight() Xapian::BM25Weight::BM25Weight"""
        _xapian.BM25Weight_swiginit(self, _xapian.new_BM25Weight(*args))
    __swig_destroy__ = _xapian.delete_BM25Weight

# Register BM25Weight in _xapian:
_xapian.BM25Weight_swigregister(BM25Weight)
class BM25PlusWeight(Weight):
    r"""


    Xapian::Weight subclass implementing the BM25+ probabilistic formula.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Xapian::BM25PlusWeight::BM25PlusWeight()
        Xapian::BM25PlusWeight::BM25PlusWeight
        """
        _xapian.BM25PlusWeight_swiginit(self, _xapian.new_BM25PlusWeight(*args))
    __swig_destroy__ = _xapian.delete_BM25PlusWeight

# Register BM25PlusWeight in _xapian:
_xapian.BM25PlusWeight_swigregister(BM25PlusWeight)
class TradWeight(Weight):
    r"""


    Xapian::Weight subclass implementing the traditional probabilistic
    formula.

    This class implements the "traditional" Probabilistic Weighting
    scheme, as described by the early papers on Probabilistic Retrieval.
    BM25 generally gives better results.

    TradWeight(k) is equivalent to BM25Weight(k, 0, 0, 1, 0), except that
    the latter returns weights (k+1) times larger. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, k=1.0):
        r"""


        Construct a TradWeight.

        Xapian::TradWeight::TradWeight(double k=1.0)
        Xapian::TradWeight::TradWeight

        Parameters:
        -----------

        k:  A non-negative parameter controlling how influential within-
        document- frequency (wdf) and document length are. k=0 means that wdf
        and document length don't affect the weights. The larger k is, the
        more they do. (default 1) 
        """
        _xapian.TradWeight_swiginit(self, _xapian.new_TradWeight(k))
    __swig_destroy__ = _xapian.delete_TradWeight

# Register TradWeight in _xapian:
_xapian.TradWeight_swigregister(TradWeight)
class InL2Weight(Weight):
    r"""


    This class implements the InL2 weighting scheme.

    InL2 is a representative scheme of the Divergence from Randomness
    Framework by Gianni Amati.

    This weighting scheme is useful for tasks that require early
    precision.

    It uses the Inverse document frequency model (In), the Laplace method
    to find the aftereffect of sampling (L) and the second wdf
    normalization proposed by Amati to normalize the wdf in the document
    to the length of the document (H2).

    For more information about the DFR Framework and the InL2 scheme,
    please refer to: Gianni Amati and Cornelis Joost Van Rijsbergen
    Probabilistic models of information retrieval based on measuring the
    divergence from randomness ACM Transactions on Information Systems
    (TOIS) 20, (4), 2002, pp. 357-389. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""Xapian::InL2Weight::InL2Weight() Xapian::InL2Weight::InL2Weight"""
        _xapian.InL2Weight_swiginit(self, _xapian.new_InL2Weight(*args))
    __swig_destroy__ = _xapian.delete_InL2Weight

# Register InL2Weight in _xapian:
_xapian.InL2Weight_swigregister(InL2Weight)
class IfB2Weight(Weight):
    r"""


    This class implements the IfB2 weighting scheme.

    IfB2 is a representative scheme of the Divergence from Randomness
    Framework by Gianni Amati.

    It uses the Inverse term frequency model (If), the Bernoulli method to
    find the aftereffect of sampling (B) and the second wdf normalization
    proposed by Amati to normalize the wdf in the document to the length
    of the document (H2).

    For more information about the DFR Framework and the IfB2 scheme,
    please refer to: Gianni Amati and Cornelis Joost Van Rijsbergen
    Probabilistic models of information retrieval based on measuring the
    divergence from randomness ACM Transactions on Information Systems
    (TOIS) 20, (4), 2002, pp. 357-389. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""Xapian::IfB2Weight::IfB2Weight() Xapian::IfB2Weight::IfB2Weight"""
        _xapian.IfB2Weight_swiginit(self, _xapian.new_IfB2Weight(*args))
    __swig_destroy__ = _xapian.delete_IfB2Weight

# Register IfB2Weight in _xapian:
_xapian.IfB2Weight_swigregister(IfB2Weight)
class IneB2Weight(Weight):
    r"""


    This class implements the IneB2 weighting scheme.

    IneB2 is a representative scheme of the Divergence from Randomness
    Framework by Gianni Amati.

    It uses the Inverse expected document frequency model (Ine), the
    Bernoulli method to find the aftereffect of sampling (B) and the
    second wdf normalization proposed by Amati to normalize the wdf in the
    document to the length of the document (H2).

    For more information about the DFR Framework and the IneB2 scheme,
    please refer to: Gianni Amati and Cornelis Joost Van Rijsbergen
    Probabilistic models of information retrieval based on measuring the
    divergence from randomness ACM Transactions on Information Systems
    (TOIS) 20, (4), 2002, pp. 357-389. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""Xapian::IneB2Weight::IneB2Weight() Xapian::IneB2Weight::IneB2Weight"""
        _xapian.IneB2Weight_swiginit(self, _xapian.new_IneB2Weight(*args))
    __swig_destroy__ = _xapian.delete_IneB2Weight

# Register IneB2Weight in _xapian:
_xapian.IneB2Weight_swigregister(IneB2Weight)
class BB2Weight(Weight):
    r"""


    This class implements the BB2 weighting scheme.

    BB2 is a representative scheme of the Divergence from Randomness
    Framework by Gianni Amati.

    It uses the Bose-Einstein probabilistic distribution (B) along with
    Stirling's power approximation, the Bernoulli method to find the
    aftereffect of sampling (B) and the second wdf normalization proposed
    by Amati to normalize the wdf in the document to the length of the
    document (H2).

    For more information about the DFR Framework and the BB2 scheme,
    please refer to : Gianni Amati and Cornelis Joost Van Rijsbergen
    Probabilistic models of information retrieval based on measuring the
    divergence from randomness ACM Transactions on Information Systems
    (TOIS) 20, (4), 2002, pp. 357-389. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""Xapian::BB2Weight::BB2Weight() Xapian::BB2Weight::BB2Weight"""
        _xapian.BB2Weight_swiginit(self, _xapian.new_BB2Weight(*args))
    __swig_destroy__ = _xapian.delete_BB2Weight

# Register BB2Weight in _xapian:
_xapian.BB2Weight_swigregister(BB2Weight)
class DLHWeight(Weight):
    r"""


    This class implements the DLH weighting scheme, which is a
    representative scheme of the Divergence from Randomness Framework by
    Gianni Amati.

    This is a parameter free weighting scheme and it should be used with
    query expansion to obtain better results. It uses the HyperGeometric
    Probabilistic model and Laplace's normalization to calculate the risk
    gain.

    For more information about the DFR Framework and the DLH scheme,
    please refer to : a.) Gianni Amati and Cornelis Joost Van Rijsbergen
    Probabilistic models of information retrieval based on measuring the
    divergence from randomness ACM Transactions on Information Systems
    (TOIS) 20, (4), 2002, pp. 357-389. b.) FUB, IASI-CNR and University of
    Tor Vergata at TREC 2007 Blog Track. G. Amati and E. Ambrosi and M.
    Bianchi and C. Gaibisso and G. Gambosi. Proceedings of the 16th Text
    REtrieval Conference (TREC-2007), 2008. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""Xapian::DLHWeight::DLHWeight() Xapian::DLHWeight::DLHWeight"""
        _xapian.DLHWeight_swiginit(self, _xapian.new_DLHWeight())
    __swig_destroy__ = _xapian.delete_DLHWeight

# Register DLHWeight in _xapian:
_xapian.DLHWeight_swigregister(DLHWeight)
class PL2Weight(Weight):
    r"""


    This class implements the PL2 weighting scheme.

    PL2 is a representative scheme of the Divergence from Randomness
    Framework by Gianni Amati.

    This weighting scheme is useful for tasks that require early
    precision.

    It uses the Poisson approximation of the Binomial Probabilistic
    distribution (P) along with Stirling's approximation for the factorial
    value, the Laplace method to find the aftereffect of sampling (L) and
    the second wdf normalization proposed by Amati to normalize the wdf in
    the document to the length of the document (H2).

    For more information about the DFR Framework and the PL2 scheme,
    please refer to : Gianni Amati and Cornelis Joost Van Rijsbergen
    Probabilistic models of information retrieval based on measuring the
    divergence from randomness ACM Transactions on Information Systems
    (TOIS) 20, (4), 2002, pp. 357-389. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""Xapian::PL2Weight::PL2Weight() Xapian::PL2Weight::PL2Weight"""
        _xapian.PL2Weight_swiginit(self, _xapian.new_PL2Weight(*args))
    __swig_destroy__ = _xapian.delete_PL2Weight

# Register PL2Weight in _xapian:
_xapian.PL2Weight_swigregister(PL2Weight)
class PL2PlusWeight(Weight):
    r"""


    Xapian::Weight subclass implementing the PL2+ probabilistic formula.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Xapian::PL2PlusWeight::PL2PlusWeight()
        Xapian::PL2PlusWeight::PL2PlusWeight
        """
        _xapian.PL2PlusWeight_swiginit(self, _xapian.new_PL2PlusWeight(*args))
    __swig_destroy__ = _xapian.delete_PL2PlusWeight

# Register PL2PlusWeight in _xapian:
_xapian.PL2PlusWeight_swigregister(PL2PlusWeight)
class DPHWeight(Weight):
    r"""


    This class implements the DPH weighting scheme.

    DPH is a representative scheme of the Divergence from Randomness
    Framework by Gianni Amati.

    This is a parameter free weighting scheme and it should be used with
    query expansion to obtain better results. It uses the HyperGeometric
    Probabilistic model and Popper's normalization to calculate the risk
    gain.

    For more information about the DFR Framework and the DPH scheme,
    please refer to : a.) Gianni Amati and Cornelis Joost Van Rijsbergen
    Probabilistic models of information retrieval based on measuring the
    divergence from randomness ACM Transactions on Information Systems
    (TOIS) 20, (4), 2002, pp. 357-389. b.) FUB, IASI-CNR and University of
    Tor Vergata at TREC 2007 Blog Track. G. Amati and E. Ambrosi and M.
    Bianchi and C. Gaibisso and G. Gambosi. Proceedings of the 16th Text
    Retrieval Conference (TREC-2007), 2008. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""


        Construct a DPHWeight.

        Xapian::DPHWeight::DPHWeight() Xapian::DPHWeight::DPHWeight
        """
        _xapian.DPHWeight_swiginit(self, _xapian.new_DPHWeight())
    __swig_destroy__ = _xapian.delete_DPHWeight

# Register DPHWeight in _xapian:
_xapian.DPHWeight_swigregister(DPHWeight)
class LMWeight(Weight):
    r"""


    Xapian::Weight subclass implementing the Language Model formula.

    This class implements the "Language Model" Weighting scheme, as
    described by the early papers on LM by Bruce Croft.

    LM works by comparing the query to a Language Model of the document.
    The language model itself is parameter-free, though LMWeight takes
    parameters which specify the smoothing used. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct a LMWeight.

        Xapian::LMWeight::LMWeight(double param_log_=0.0, type_smoothing
        select_smoothing_=TWO_STAGE_SMOOTHING, double param_smoothing1_=-1.0,
        double param_smoothing2_=-1.0) Xapian::LMWeight::LMWeight

        Parameters:
        -----------

        param_log_:  A non-negative parameter controlling how much to clamp
        negative values returned by the log. The log is calculated by
        multiplying the actual weight by param_log. If param_log is 0.0, then
        the document length upper bound will be used (default: document length
        upper bound)

        select_smoothing_:  A parameter of type enum type_smoothing. This
        parameter controls which smoothing type to use. (default:
        TWO_STAGE_SMOOTHING)

        param_smoothing1_:  A non-negative parameter for smoothing whose
        meaning depends on select_smoothing_. In JELINEK_MERCER_SMOOTHING, it
        plays the role of estimation and in DIRICHLET_SMOOTHING the role of
        query modelling. (default JELINEK_MERCER, ABSOLUTE, TWOSTAGE(0.7),
        DIRCHLET(2000))

        param_smoothing2_:  A non-negative parameter which is used with
        TWO_STAGE_SMOOTHING as parameter for Dirichlet's smoothing (default:
        2000) and as parameter delta to control the scale of the tf lower
        bound in the DIRICHLET_PLUS_SMOOTHING (default 0.05). 
        """
        _xapian.LMWeight_swiginit(self, _xapian.new_LMWeight(*args))
    __swig_destroy__ = _xapian.delete_LMWeight

# Register LMWeight in _xapian:
_xapian.LMWeight_swigregister(LMWeight)
class CoordWeight(Weight):
    r"""


    Xapian::Weight subclass implementing Coordinate Matching.

    Each matching term score one point. See Managing Gigabytes, Second
    Edition p181. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    init = _swig_new_instance_method(_xapian.CoordWeight_init)

    def __init__(self):
        r"""


        Construct a CoordWeight.

        Xapian::CoordWeight::CoordWeight() Xapian::CoordWeight::CoordWeight
        """
        _xapian.CoordWeight_swiginit(self, _xapian.new_CoordWeight())
    __swig_destroy__ = _xapian.delete_CoordWeight

# Register CoordWeight in _xapian:
_xapian.CoordWeight_swigregister(CoordWeight)
class Compactor(object):
    r"""


    Compact a database, or merge and compact several. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    STANDARD = _xapian.Compactor_STANDARD
    FULL = _xapian.Compactor_FULL
    FULLER = _xapian.Compactor_FULLER

    def __init__(self):
        r"""Xapian::Compactor::Compactor() Xapian::Compactor::Compactor"""
        if self.__class__ == Compactor:
            _self = None
        else:
            _self = self
        _xapian.Compactor_swiginit(self, _xapian.new_Compactor(_self, ))
    __swig_destroy__ = _xapian.delete_Compactor
    set_block_size = _swig_new_instance_method(_xapian.Compactor_set_block_size)
    set_renumber = _swig_new_instance_method(_xapian.Compactor_set_renumber)
    set_multipass = _swig_new_instance_method(_xapian.Compactor_set_multipass)
    set_compaction_level = _swig_new_instance_method(_xapian.Compactor_set_compaction_level)
    set_destdir = _swig_new_instance_method(_xapian.Compactor_set_destdir)
    add_source = _swig_new_instance_method(_xapian.Compactor_add_source)
    compact = _swig_new_instance_method(_xapian.Compactor_compact)
    set_status = _swig_new_instance_method(_xapian.Compactor_set_status)
    resolve_duplicate_metadata = _swig_new_instance_method(_xapian.Compactor_resolve_duplicate_metadata)
    def __disown__(self):
        self.this.disown()
        _xapian.disown_Compactor(self)
        return weakref.proxy(self)

# Register Compactor in _xapian:
_xapian.Compactor_swigregister(Compactor)
class PostingSource(object):
    r"""


    Base class which provides an "external" source of postings. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""


        Allow subclasses to be instantiated.

        Xapian::PostingSource::PostingSource()
        Xapian::PostingSource::PostingSource
        """
        if self.__class__ == PostingSource:
            _self = None
        else:
            _self = self
        _xapian.PostingSource_swiginit(self, _xapian.new_PostingSource(_self, ))
    __swig_destroy__ = _xapian.delete_PostingSource
    get_termfreq_min = _swig_new_instance_method(_xapian.PostingSource_get_termfreq_min)
    get_termfreq_est = _swig_new_instance_method(_xapian.PostingSource_get_termfreq_est)
    get_termfreq_max = _swig_new_instance_method(_xapian.PostingSource_get_termfreq_max)
    set_maxweight = _swig_new_instance_method(_xapian.PostingSource_set_maxweight)
    get_maxweight = _swig_new_instance_method(_xapian.PostingSource_get_maxweight)
    get_weight = _swig_new_instance_method(_xapian.PostingSource_get_weight)
    get_docid = _swig_new_instance_method(_xapian.PostingSource_get_docid)
    __next__ = _swig_new_instance_method(_xapian.PostingSource___next__)
    skip_to = _swig_new_instance_method(_xapian.PostingSource_skip_to)
    check = _swig_new_instance_method(_xapian.PostingSource_check)
    at_end = _swig_new_instance_method(_xapian.PostingSource_at_end)
    name = _swig_new_instance_method(_xapian.PostingSource_name)
    init = _swig_new_instance_method(_xapian.PostingSource_init)
    __str__ = _swig_new_instance_method(_xapian.PostingSource___str__)
    release = _swig_new_instance_method(_xapian.PostingSource_release)
    def __disown__(self):
        self.this.disown()
        _xapian.disown_PostingSource(self)
        return weakref.proxy(self)

# Register PostingSource in _xapian:
_xapian.PostingSource_swigregister(PostingSource)
class ValuePostingSource(PostingSource):
    r"""


    A posting source which generates weights from a value slot.

    This is a base class for classes which generate weights using values
    stored in the specified slot. For example, ValueWeightPostingSource
    uses sortable_unserialise to convert values directly to weights.

    The upper bound on the weight returned is set to DBL_MAX. Subclasses
    should call set_maxweight() in their init() methods after calling
    ValuePostingSource::init() if they know a tighter bound on the weight.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, slot_):
        r"""


        Construct a ValuePostingSource.

        Xapian::ValuePostingSource::ValuePostingSource(Xapian::valueno slot_)
        Xapian::ValuePostingSource::ValuePostingSource

        Parameters:
        -----------

        slot_:  The value slot to read values from. 
        """
        if self.__class__ == ValuePostingSource:
            _self = None
        else:
            _self = self
        _xapian.ValuePostingSource_swiginit(self, _xapian.new_ValuePostingSource(_self, slot_))
    get_termfreq_min = _swig_new_instance_method(_xapian.ValuePostingSource_get_termfreq_min)
    get_termfreq_est = _swig_new_instance_method(_xapian.ValuePostingSource_get_termfreq_est)
    get_termfreq_max = _swig_new_instance_method(_xapian.ValuePostingSource_get_termfreq_max)
    __next__ = _swig_new_instance_method(_xapian.ValuePostingSource___next__)
    skip_to = _swig_new_instance_method(_xapian.ValuePostingSource_skip_to)
    check = _swig_new_instance_method(_xapian.ValuePostingSource_check)
    at_end = _swig_new_instance_method(_xapian.ValuePostingSource_at_end)
    get_docid = _swig_new_instance_method(_xapian.ValuePostingSource_get_docid)
    init = _swig_new_instance_method(_xapian.ValuePostingSource_init)
    get_database = _swig_new_instance_method(_xapian.ValuePostingSource_get_database)
    get_slot = _swig_new_instance_method(_xapian.ValuePostingSource_get_slot)
    get_value = _swig_new_instance_method(_xapian.ValuePostingSource_get_value)
    done = _swig_new_instance_method(_xapian.ValuePostingSource_done)
    get_started = _swig_new_instance_method(_xapian.ValuePostingSource_get_started)
    set_termfreq_min = _swig_new_instance_method(_xapian.ValuePostingSource_set_termfreq_min)
    set_termfreq_est = _swig_new_instance_method(_xapian.ValuePostingSource_set_termfreq_est)
    set_termfreq_max = _swig_new_instance_method(_xapian.ValuePostingSource_set_termfreq_max)
    __swig_destroy__ = _xapian.delete_ValuePostingSource
    def __disown__(self):
        self.this.disown()
        _xapian.disown_ValuePostingSource(self)
        return weakref.proxy(self)

# Register ValuePostingSource in _xapian:
_xapian.ValuePostingSource_swigregister(ValuePostingSource)
class ValueWeightPostingSource(ValuePostingSource):
    r"""


    A posting source which reads weights from a value slot.

    This returns entries for all documents in the given database which
    have a non empty values in the specified slot. It returns a weight
    calculated by applying sortable_unserialise to the value stored in the
    slot (so the values stored should probably have been calculated by
    applying sortable_serialise to a floating point number at index time).

    The upper bound on the weight returned is set using the upper bound on
    the values in the specified slot, or DBL_MAX if value bounds aren't
    supported by the current backend.

    For efficiency, this posting source doesn't check that the stored
    values are valid in any way, so it will never raise an exception due
    to invalid stored values. In particular, it doesn't ensure that the
    unserialised values are positive, which is a requirement for weights.
    The behaviour if the slot contains values which unserialise to
    negative values is undefined. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, slot_):
        r"""


        Construct a ValueWeightPostingSource.

        Xapian::ValueWeightPostingSource::ValueWeightPostingSource(Xapian::valueno
        slot_) Xapian::ValueWeightPostingSource::ValueWeightPostingSource

        Parameters:
        -----------

        slot_:  The value slot to read values from. 
        """
        if self.__class__ == ValueWeightPostingSource:
            _self = None
        else:
            _self = self
        _xapian.ValueWeightPostingSource_swiginit(self, _xapian.new_ValueWeightPostingSource(_self, slot_))
    get_weight = _swig_new_instance_method(_xapian.ValueWeightPostingSource_get_weight)
    name = _swig_new_instance_method(_xapian.ValueWeightPostingSource_name)
    init = _swig_new_instance_method(_xapian.ValueWeightPostingSource_init)
    __str__ = _swig_new_instance_method(_xapian.ValueWeightPostingSource___str__)
    __swig_destroy__ = _xapian.delete_ValueWeightPostingSource
    def __disown__(self):
        self.this.disown()
        _xapian.disown_ValueWeightPostingSource(self)
        return weakref.proxy(self)

# Register ValueWeightPostingSource in _xapian:
_xapian.ValueWeightPostingSource_swigregister(ValueWeightPostingSource)
class DecreasingValueWeightPostingSource(ValueWeightPostingSource):
    r"""


    Read weights from a value which is known to decrease as docid
    increases.

    This posting source can be used, like ValueWeightPostingSource, to add
    a weight contribution to a query based on the values stored in a slot.
    The values in the slot must be serialised as by  sortable_serialise().

    However, this posting source is additionally given a range of document
    IDs, within which the weight is known to be decreasing. ie, for all
    documents with ids A and B within this range (including the
    endpoints), where A is less than B, the weight of A is less than or
    equal to the weight of B. This can allow the posting source to skip to
    the end of the range quickly if insufficient weight is left in the
    posting source for a particular source.

    By default, the range is assumed to cover all document IDs.

    The ordering property can be arranged at index time, or by sorting an
    indexed database to produce a new, sorted, database. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, slot_, range_start_=0, range_end_=0):
        r"""


        Construct a DecreasingValueWeightPostingSource.

        Xapian::DecreasingValueWeightPostingSource::DecreasingValueWeightPostingSource(Xapian::valueno
        slot_, Xapian::docid range_start_=0, Xapian::docid range_end_=0)
        Xapian::DecreasingValueWeightPostingSource::DecreasingValueWeightPosti
        ngSource

        Parameters:
        -----------

        slot_:  The value slot to read values from.

        range_start_:  Start of range of docids for which weights are known to
        be decreasing (default: first docid)

        range_end_:  End of range of docids for which weights are known to be
        decreasing (default: last docid) 
        """
        _xapian.DecreasingValueWeightPostingSource_swiginit(self, _xapian.new_DecreasingValueWeightPostingSource(slot_, range_start_, range_end_))
    __swig_destroy__ = _xapian.delete_DecreasingValueWeightPostingSource

# Register DecreasingValueWeightPostingSource in _xapian:
_xapian.DecreasingValueWeightPostingSource_swigregister(DecreasingValueWeightPostingSource)
class ValueMapPostingSource(ValuePostingSource):
    r"""


    A posting source which looks up weights in a map using values as the
    key.

    This allows will return entries for all documents in the given
    database which have a value in the slot specified. The values will be
    mapped to the corresponding weight in the weight map. If there is no
    mapping for a particular value, the default weight will be returned
    (which itself defaults to 0.0). 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, slot_):
        r"""


        Construct a ValueMapPostingSource.

        Xapian::ValueMapPostingSource::ValueMapPostingSource(Xapian::valueno
        slot_) Xapian::ValueMapPostingSource::ValueMapPostingSource

        Parameters:
        -----------

        slot_:  The value slot to read values from. 
        """
        _xapian.ValueMapPostingSource_swiginit(self, _xapian.new_ValueMapPostingSource(slot_))
    add_mapping = _swig_new_instance_method(_xapian.ValueMapPostingSource_add_mapping)
    clear_mappings = _swig_new_instance_method(_xapian.ValueMapPostingSource_clear_mappings)
    set_default_weight = _swig_new_instance_method(_xapian.ValueMapPostingSource_set_default_weight)
    __swig_destroy__ = _xapian.delete_ValueMapPostingSource

# Register ValueMapPostingSource in _xapian:
_xapian.ValueMapPostingSource_swigregister(ValueMapPostingSource)
class FixedWeightPostingSource(PostingSource):
    r"""


    A posting source which returns a fixed weight for all documents.

    This returns entries for all documents in the given database, with a
    fixed weight (specified by a parameter to the constructor). 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, wt):
        r"""


        Construct a FixedWeightPostingSource.

        Xapian::FixedWeightPostingSource::FixedWeightPostingSource(double wt)
        Xapian::FixedWeightPostingSource::FixedWeightPostingSource

        Parameters:
        -----------

        wt:  The fixed weight to return. 
        """
        _xapian.FixedWeightPostingSource_swiginit(self, _xapian.new_FixedWeightPostingSource(wt))
    __swig_destroy__ = _xapian.delete_FixedWeightPostingSource

# Register FixedWeightPostingSource in _xapian:
_xapian.FixedWeightPostingSource_swigregister(FixedWeightPostingSource)
class MatchSpy(object):
    r"""


    Abstract base class for match spies.

    The subclasses will generally accumulate information seen during the
    match, to calculate aggregate functions, or other profiles of the
    matching documents. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""


        Default constructor, needed by subclass constructors.

        Xapian::MatchSpy::MatchSpy() Xapian::MatchSpy::MatchSpy
        """
        if self.__class__ == MatchSpy:
            _self = None
        else:
            _self = self
        _xapian.MatchSpy_swiginit(self, _xapian.new_MatchSpy(_self, ))
    __swig_destroy__ = _xapian.delete_MatchSpy
    __call__ = _swig_new_instance_method(_xapian.MatchSpy___call__)
    name = _swig_new_instance_method(_xapian.MatchSpy_name)
    merge_results = _swig_new_instance_method(_xapian.MatchSpy_merge_results)
    __str__ = _swig_new_instance_method(_xapian.MatchSpy___str__)
    release = _swig_new_instance_method(_xapian.MatchSpy_release)
    def __disown__(self):
        self.this.disown()
        _xapian.disown_MatchSpy(self)
        return weakref.proxy(self)

# Register MatchSpy in _xapian:
_xapian.MatchSpy_swigregister(MatchSpy)
class ValueCountMatchSpy(MatchSpy):
    r"""


    Class for counting the frequencies of values in the matching
    documents. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct a MatchSpy which counts the values in a particular slot.

        Xapian::ValueCountMatchSpy::ValueCountMatchSpy(Xapian::valueno slot_)
        Xapian::ValueCountMatchSpy::ValueCountMatchSpy
        """
        _xapian.ValueCountMatchSpy_swiginit(self, _xapian.new_ValueCountMatchSpy(*args))
    get_total = _swig_new_instance_method(_xapian.ValueCountMatchSpy_get_total)
    values_begin = _swig_new_instance_method(_xapian.ValueCountMatchSpy_values_begin)
    values_end = _swig_new_instance_method(_xapian.ValueCountMatchSpy_values_end)
    top_values_begin = _swig_new_instance_method(_xapian.ValueCountMatchSpy_top_values_begin)
    top_values_end = _swig_new_instance_method(_xapian.ValueCountMatchSpy_top_values_end)
    __swig_destroy__ = _xapian.delete_ValueCountMatchSpy

# Register ValueCountMatchSpy in _xapian:
_xapian.ValueCountMatchSpy_swigregister(ValueCountMatchSpy)
miles_to_metres = _xapian.miles_to_metres
metres_to_miles = _xapian.metres_to_miles
class LatLongCoord(object):
    r"""


    A latitude-longitude coordinate.

    Experimental - seehttps://xapian.org/docs/deprecation#experimental-
    features

    Note that latitude-longitude coordinates are only precisely meaningful
    if the datum used to define them is specified. This class ignores this
    issue - it is up to the caller to ensure that the datum used for each
    coordinate in a system is consistent. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    latitude = property(_xapian.LatLongCoord_latitude_get, _xapian.LatLongCoord_latitude_set)
    longitude = property(_xapian.LatLongCoord_longitude_get, _xapian.LatLongCoord_longitude_set)

    def __init__(self, *args):
        r"""


        Construct a coordinate.

        Xapian::LatLongCoord::LatLongCoord(double latitude_, double
        longitude_) Xapian::LatLongCoord::LatLongCoord If the supplied
        longitude is out of the standard range, it will be normalised to the
        range 0 <= longitude < 360.

        If you want to avoid the checks (for example, you know that your
        values are already in range), you can use the alternate constructor to
        construct an uninitialised coordinate, and then set the latitude and
        longitude directly.

        Parameters:
        -----------

        InvalidArgumentError:  the supplied latitude is out of range. 
        """
        _xapian.LatLongCoord_swiginit(self, _xapian.new_LatLongCoord(*args))
    unserialise = _swig_new_instance_method(_xapian.LatLongCoord_unserialise)
    serialise = _swig_new_instance_method(_xapian.LatLongCoord_serialise)
    __str__ = _swig_new_instance_method(_xapian.LatLongCoord___str__)
    __swig_destroy__ = _xapian.delete_LatLongCoord

# Register LatLongCoord in _xapian:
_xapian.LatLongCoord_swigregister(LatLongCoord)
class LatLongCoordsIterator(object):
    r"""


    An iterator across the values in a LatLongCoords object.

    Experimental - seehttps://xapian.org/docs/deprecation#experimental-
    features 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""


        Default constructor. Produces an uninitialised iterator.

        Xapian::LatLongCoordsIterator::LatLongCoordsIterator()
        Xapian::LatLongCoordsIterator::LatLongCoordsIterator
        """
        _xapian.LatLongCoordsIterator_swiginit(self, _xapian.new_LatLongCoordsIterator())
    __eq__ = _swig_new_instance_method(_xapian.LatLongCoordsIterator___eq__)
    equals = _swig_new_instance_method(_xapian.LatLongCoordsIterator_equals)
    get_coord = _swig_new_instance_method(_xapian.LatLongCoordsIterator_get_coord)
    __next__ = _swig_new_instance_method(_xapian.LatLongCoordsIterator___next__)
    __swig_destroy__ = _xapian.delete_LatLongCoordsIterator

# Register LatLongCoordsIterator in _xapian:
_xapian.LatLongCoordsIterator_swigregister(LatLongCoordsIterator)
class LatLongCoords(object):
    r"""


    A sequence of latitude-longitude coordinates.

    Experimental - seehttps://xapian.org/docs/deprecation#experimental-
    features 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    begin = _swig_new_instance_method(_xapian.LatLongCoords_begin)
    end = _swig_new_instance_method(_xapian.LatLongCoords_end)
    size = _swig_new_instance_method(_xapian.LatLongCoords_size)
    empty = _swig_new_instance_method(_xapian.LatLongCoords_empty)
    append = _swig_new_instance_method(_xapian.LatLongCoords_append)

    def __init__(self, *args):
        r"""


        Construct a container holding one coordinate.

        Xapian::LatLongCoords::LatLongCoords(const LatLongCoord &coord)
        Xapian::LatLongCoords::LatLongCoords
        """
        _xapian.LatLongCoords_swiginit(self, _xapian.new_LatLongCoords(*args))
    unserialise = _swig_new_instance_method(_xapian.LatLongCoords_unserialise)
    serialise = _swig_new_instance_method(_xapian.LatLongCoords_serialise)
    __str__ = _swig_new_instance_method(_xapian.LatLongCoords___str__)
    __swig_destroy__ = _xapian.delete_LatLongCoords

# Register LatLongCoords in _xapian:
_xapian.LatLongCoords_swigregister(LatLongCoords)
__ne__ = _xapian.__ne__
class LatLongMetric(object):
    r"""


    Base class for calculating distances between two lat/long coordinates.

    Experimental - seehttps://xapian.org/docs/deprecation#experimental-
    features 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _xapian.delete_LatLongMetric
    pointwise_distance = _swig_new_instance_method(_xapian.LatLongMetric_pointwise_distance)
    __call__ = _swig_new_instance_method(_xapian.LatLongMetric___call__)
    name = _swig_new_instance_method(_xapian.LatLongMetric_name)

    def __init__(self):
        if self.__class__ == LatLongMetric:
            _self = None
        else:
            _self = self
        _xapian.LatLongMetric_swiginit(self, _xapian.new_LatLongMetric(_self, ))
    def __disown__(self):
        self.this.disown()
        _xapian.disown_LatLongMetric(self)
        return weakref.proxy(self)

# Register LatLongMetric in _xapian:
_xapian.LatLongMetric_swigregister(LatLongMetric)
class GreatCircleMetric(LatLongMetric):
    r"""


    Calculate the great-circle distance between two coordinates on a
    sphere.

    Experimental - seehttps://xapian.org/docs/deprecation#experimental-
    features

    This uses the haversine formula to calculate the distance. Note that
    this formula is subject to inaccuracy due to numerical errors for
    coordinates on the opposite side of the sphere.

    Seehttps://en.wikipedia.org/wiki/Haversine_formula 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct a GreatCircleMetric using a specified radius.

        Xapian::GreatCircleMetric::GreatCircleMetric(double radius_)
        Xapian::GreatCircleMetric::GreatCircleMetric This is useful for data
        sets in which the points are not on Earth (eg, a database of features
        on Mars).

        Parameters:
        -----------

        radius_:  The radius of the sphere to use, in metres. 
        """
        _xapian.GreatCircleMetric_swiginit(self, _xapian.new_GreatCircleMetric(*args))
    __swig_destroy__ = _xapian.delete_GreatCircleMetric

# Register GreatCircleMetric in _xapian:
_xapian.GreatCircleMetric_swigregister(GreatCircleMetric)
class LatLongDistancePostingSource(ValuePostingSource):
    r"""


    Posting source which returns a weight based on geospatial distance.

    Experimental - seehttps://xapian.org/docs/deprecation#experimental-
    features

    Results are weighted by the distance from a fixed point, or list of
    points, calculated according to the metric supplied. If multiple
    points are supplied (either in the constructor, or in the coordinates
    stored in a document), the closest pointwise distance is used.

    Documents further away than a specified maximum range (or with no
    location stored in the specified slot) will not be returned.

    The weight returned is computed from the distance using the formula:

    k1 * pow(distance + k1, -k2)

    (Where k1 and k2 are (strictly) positive, floating point constants,
    which default to 1000 and 1, respectively. Distance is measured in
    metres, so this means that something at the centre gets a weight of
    1.0, something 1km away gets a weight of 0.5, and something 3km away
    gets a weight of 0.25, etc) 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct a new posting source which returns only documents within
        range of one of the central coordinates.

        Xapian::LatLongDistancePostingSource::LatLongDistancePostingSource(Xapian::valueno
        slot_, const LatLongCoords &centre_, double max_range_=0.0, double
        k1_=1000.0, double k2_=1.0)
        Xapian::LatLongDistancePostingSource::LatLongDistancePostingSource

        Parameters:
        -----------

        slot_:  The value slot to read values from.

        centre_:  The centre point to use for distance calculations.

        max_range_:  The maximum distance for documents which are returned.

        k1_:  The k1 constant to use in the weighting function.

        k2_:  The k2 constant to use in the weighting function.

        Xapian::GreatCircleMetric is used as the metric. 
        """
        _xapian.LatLongDistancePostingSource_swiginit(self, _xapian.new_LatLongDistancePostingSource(*args))
    __swig_destroy__ = _xapian.delete_LatLongDistancePostingSource

# Register LatLongDistancePostingSource in _xapian:
_xapian.LatLongDistancePostingSource_swigregister(LatLongDistancePostingSource)
class LatLongDistanceKeyMaker(KeyMaker):
    r"""


    KeyMaker subclass which sorts by distance from a latitude/longitude.

    Experimental - seehttps://xapian.org/docs/deprecation#experimental-
    features

    Results are ordered by the distance from a fixed point, or list of
    points, calculated according to the metric supplied. If multiple
    points are supplied (either in the constructor, or in the coordinates
    stored in a document), the closest pointwise distance is used.

    If a document contains no coordinate stored in the specified slot, a
    special value for the distance will be used. This defaults to a large
    number, so that such results get a low rank, but may be specified by a
    constructor parameter. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""


        Construct a LatLongDistanceKeyMaker.

        Xapian::LatLongDistanceKeyMaker::LatLongDistanceKeyMaker(Xapian::valueno
        slot_, const LatLongCoord &centre_)
        Xapian::LatLongDistanceKeyMaker::LatLongDistanceKeyMaker

        Parameters:
        -----------

        slot_:  Value slot to use.

        centre_:  Point to calculate distance from.

        Xapian::GreatCircleMetric is used as the metric.

        Documents where no value is set are assumed to be a large distance
        away. 
        """
        _xapian.LatLongDistanceKeyMaker_swiginit(self, _xapian.new_LatLongDistanceKeyMaker(*args))
    __swig_destroy__ = _xapian.delete_LatLongDistanceKeyMaker

# Register LatLongDistanceKeyMaker in _xapian:
_xapian.LatLongDistanceKeyMaker_swigregister(LatLongDistanceKeyMaker)
class Database(object):
    r"""


    This class is used to access a database, or a group of databases.

    For searching, this class is used in conjunction with an Enquire
    object.

    Parameters:
    -----------

    InvalidArgumentError:  will be thrown if an invalid argument is
    supplied, for example, an unknown database type.

    DatabaseOpeningError:  may be thrown if the database cannot be opened
    (for example, a required file cannot be found).

    DatabaseVersionError:  may be thrown if the database is in an
    unsupported format (for example, created by a newer version of Xapian
    which uses an incompatible format). 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    add_database = _swig_new_instance_method(_xapian.Database_add_database)
    size = _swig_new_instance_method(_xapian.Database_size)

    def __init__(self, *args):
        r"""


        Copying is allowed.

        Xapian::Database::Database(const Database &other)
        Xapian::Database::Database The internals are reference counted, so
        copying is cheap.

        Parameters:
        -----------

        other:  The object to copy. 
        """
        _xapian.Database_swiginit(self, _xapian.new_Database(*args))
    __swig_destroy__ = _xapian.delete_Database
    reopen = _swig_new_instance_method(_xapian.Database_reopen)
    close = _swig_new_instance_method(_xapian.Database_close)
    __str__ = _swig_new_instance_method(_xapian.Database___str__)
    _postlist_begin = _swig_new_instance_method(_xapian.Database__postlist_begin)
    _postlist_end = _swig_new_instance_method(_xapian.Database__postlist_end)
    _termlist_begin = _swig_new_instance_method(_xapian.Database__termlist_begin)
    _termlist_end = _swig_new_instance_method(_xapian.Database__termlist_end)
    has_positions = _swig_new_instance_method(_xapian.Database_has_positions)
    _positionlist_begin = _swig_new_instance_method(_xapian.Database__positionlist_begin)
    _positionlist_end = _swig_new_instance_method(_xapian.Database__positionlist_end)
    _allterms_begin = _swig_new_instance_method(_xapian.Database__allterms_begin)
    _allterms_end = _swig_new_instance_method(_xapian.Database__allterms_end)
    get_doccount = _swig_new_instance_method(_xapian.Database_get_doccount)
    get_lastdocid = _swig_new_instance_method(_xapian.Database_get_lastdocid)
    get_avlength = _swig_new_instance_method(_xapian.Database_get_avlength)
    get_average_length = _swig_new_instance_method(_xapian.Database_get_average_length)
    get_total_length = _swig_new_instance_method(_xapian.Database_get_total_length)
    get_termfreq = _swig_new_instance_method(_xapian.Database_get_termfreq)
    term_exists = _swig_new_instance_method(_xapian.Database_term_exists)
    get_collection_freq = _swig_new_instance_method(_xapian.Database_get_collection_freq)
    get_value_freq = _swig_new_instance_method(_xapian.Database_get_value_freq)
    get_value_lower_bound = _swig_new_instance_method(_xapian.Database_get_value_lower_bound)
    get_value_upper_bound = _swig_new_instance_method(_xapian.Database_get_value_upper_bound)
    get_doclength_lower_bound = _swig_new_instance_method(_xapian.Database_get_doclength_lower_bound)
    get_doclength_upper_bound = _swig_new_instance_method(_xapian.Database_get_doclength_upper_bound)
    get_wdf_upper_bound = _swig_new_instance_method(_xapian.Database_get_wdf_upper_bound)
    valuestream_begin = _swig_new_instance_method(_xapian.Database_valuestream_begin)
    valuestream_end = _swig_new_instance_method(_xapian.Database_valuestream_end)
    get_doclength = _swig_new_instance_method(_xapian.Database_get_doclength)
    get_unique_terms = _swig_new_instance_method(_xapian.Database_get_unique_terms)
    keep_alive = _swig_new_instance_method(_xapian.Database_keep_alive)
    get_document = _swig_new_instance_method(_xapian.Database_get_document)
    get_spelling_suggestion = _swig_new_instance_method(_xapian.Database_get_spelling_suggestion)
    _spellings_begin = _swig_new_instance_method(_xapian.Database__spellings_begin)
    _spellings_end = _swig_new_instance_method(_xapian.Database__spellings_end)
    _synonyms_begin = _swig_new_instance_method(_xapian.Database__synonyms_begin)
    _synonyms_end = _swig_new_instance_method(_xapian.Database__synonyms_end)
    _synonym_keys_begin = _swig_new_instance_method(_xapian.Database__synonym_keys_begin)
    _synonym_keys_end = _swig_new_instance_method(_xapian.Database__synonym_keys_end)
    get_metadata = _swig_new_instance_method(_xapian.Database_get_metadata)
    _metadata_keys_begin = _swig_new_instance_method(_xapian.Database__metadata_keys_begin)
    _metadata_keys_end = _swig_new_instance_method(_xapian.Database__metadata_keys_end)
    get_uuid = _swig_new_instance_method(_xapian.Database_get_uuid)
    locked = _swig_new_instance_method(_xapian.Database_locked)
    get_revision = _swig_new_instance_method(_xapian.Database_get_revision)
    check = _swig_new_static_method(_xapian.Database_check)
    compact = _swig_new_instance_method(_xapian.Database_compact)

# Register Database in _xapian:
_xapian.Database_swigregister(Database)
class WritableDatabase(Database):
    r"""


    This class provides read/write access to a database. 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _xapian.delete_WritableDatabase

    def __init__(self, *args):
        r"""


        Copying is allowed.

        Xapian::WritableDatabase::WritableDatabase(const WritableDatabase
        &other) Xapian::WritableDatabase::WritableDatabase The internals are
        reference counted, so copying is cheap.

        Parameters:
        -----------

        other:  The object to copy. 
        """
        _xapian.WritableDatabase_swiginit(self, _xapian.new_WritableDatabase(*args))
    add_database = _swig_new_instance_method(_xapian.WritableDatabase_add_database)
    commit = _swig_new_instance_method(_xapian.WritableDatabase_commit)
    flush = _swig_new_instance_method(_xapian.WritableDatabase_flush)
    begin_transaction = _swig_new_instance_method(_xapian.WritableDatabase_begin_transaction)
    commit_transaction = _swig_new_instance_method(_xapian.WritableDatabase_commit_transaction)
    cancel_transaction = _swig_new_instance_method(_xapian.WritableDatabase_cancel_transaction)
    add_document = _swig_new_instance_method(_xapian.WritableDatabase_add_document)
    delete_document = _swig_new_instance_method(_xapian.WritableDatabase_delete_document)
    replace_document = _swig_new_instance_method(_xapian.WritableDatabase_replace_document)
    add_spelling = _swig_new_instance_method(_xapian.WritableDatabase_add_spelling)
    remove_spelling = _swig_new_instance_method(_xapian.WritableDatabase_remove_spelling)
    add_synonym = _swig_new_instance_method(_xapian.WritableDatabase_add_synonym)
    remove_synonym = _swig_new_instance_method(_xapian.WritableDatabase_remove_synonym)
    clear_synonyms = _swig_new_instance_method(_xapian.WritableDatabase_clear_synonyms)
    set_metadata = _swig_new_instance_method(_xapian.WritableDatabase_set_metadata)

# Register WritableDatabase in _xapian:
_xapian.WritableDatabase_swigregister(WritableDatabase)
remote_open = _xapian.remote_open
remote_open_writable = _xapian.remote_open_writable


# Set the documentation format - this is used by tools like "epydoc" to decide
# how to format the documentation strings.
__docformat__ = "restructuredtext en"

##################################
# Support for iteration of MSets #
##################################

class MSetItem(object):
    """An item returned from iteration of the MSet.

    The item supports access to the following attributes and properties:

     - `docid`: The Xapian document ID corresponding to this MSet item.
     - `weight`: The weight corresponding to this MSet item.
     - `rank`: The rank of this MSet item.  The rank is the position in the
       total set of matching documents of this item.  The highest document is
       given a rank of 0.  If the MSet did not start at the highest matching
       document, because a non-zero 'start' parameter was supplied to
       get_mset(), the first document in the MSet will have a rank greater than
       0 (in fact, it will be equal to the value of 'start' supplied to
       get_mset()).
     - `percent`: The percentage score assigned to this MSet item.
     - `document`: The document for this MSet item.  This can be used to access
       the document data, or any other information stored in the document (such
       as term lists).  It is lazily evaluated.
     - `collapse_key`: The value of the key which was used for collapsing.
     - `collapse_count`: An estimate of the number of documents that have been
       collapsed into this one.

    The collapse count estimate will always be less than or equal to the actual
    number of other documents satisfying the match criteria with the same
    collapse key as this document.  If may be 0 even though there are other
    documents with the same collapse key which satisfying the match criteria.
    However if this method returns non-zero, there definitely are other such
    documents.  So this method may be used to inform the user that there are
    "at least N other matches in this group", or to control whether to offer a
    "show other documents in this group" feature (but note that it may not
    offer it in every case where it would show other documents).

    """

    __slots__ = ('_mset', '_firstitem', 'docid', 'weight', 'rank',
                 'percent', 'collapse_key', 'collapse_count', '_document', )

    def __init__(self, iter, mset):
        self._mset = mset
        self._firstitem = self._mset.get_firstitem()
        self.docid = iter.get_docid()
        self.weight = iter.get_weight()
        self.rank = iter.get_rank()
        self.percent = iter.get_percent()
        self.collapse_key = iter.get_collapse_key()
        self.collapse_count = iter.get_collapse_count()
        self._document = None

    def _get_document(self):
        if self._document is None:
            self._document = self._mset._get_hit_internal(self.rank - self._firstitem).get_document()
        return self._document

    document = property(_get_document, doc="The document object corresponding to this MSet item.")

class MSetIter(object):
    """An iterator over the items in an MSet.

    The iterator will return MSetItem objects, which will be evaluated lazily
    where appropriate.

    """
    __slots__ = ('_iter', '_end', '_mset')
    def __init__(self, mset):
        self._iter = mset._begin()
        self._end = mset._end()
        self._mset = mset

    def __iter__(self):
        return self

    def __next__(self):
        if self._iter == self._end:
            raise StopIteration
        else:
            r = MSetItem(self._iter, self._mset)
            next(self._iter)
            return r

# Modify the MSet to allow access to the python iterators, and have other
# convenience methods.

def _mset_gen_iter(self):
    """Return an iterator over the MSet.

    The iterator will return MSetItem objects, which will be evaluated lazily
    where appropriate.

    """
    return MSetIter(self)
MSet.__iter__ = _mset_gen_iter

MSet.__len__ = lambda self: MSet.size(self)

def _mset_getitem(self, index):
    """Get an item from the MSet.

    The supplied index is relative to the start of the MSet, not the absolute
    rank of the item.

    Returns an MSetItem.

    """
    if index < 0:
        index += len(self)
    if index < 0 or index >= len(self):
        raise IndexError("Mset index out of range")
    return MSetItem(self._get_hit_internal(index), self)
MSet.__getitem__ = _mset_getitem
MSet.get_hit = _mset_getitem


##################################
# Support for iteration of ESets #
##################################

class ESetItem(object):
    """An item returned from iteration of the ESet.

    The item supports access to the following attributes:

     - `term`: The term corresponding to this ESet item.
     - `weight`: The weight corresponding to this ESet item.

    """
    __slots__ = ('term', 'weight')

    def __init__(self, iter):
        self.term = iter.get_term()
        self.weight = iter.get_weight()

class ESetIter(object):
    """An iterator over the items in an ESet.

    The iterator will return ESetItem objects.

    """
    __slots__ = ('_iter', '_end')
    def __init__(self, eset):
        self._iter = eset._begin()
        self._end = eset._end()

    def __iter__(self):
        return self

    def __next__(self):
        if self._iter == self._end:
            raise StopIteration
        else:
            r = ESetItem(self._iter)
            next(self._iter)
            return r

# Modify the ESet to allow access to the python iterators, and have other
# convenience methods.

def _eset_gen_iter(self):
    """Return an iterator over the ESet.

    The iterator will return ESetItem objects.

    """
    return ESetIter(self)
ESet.__iter__ = _eset_gen_iter

ESet.__len__ = lambda self: ESet.size(self)


#######################################
# Support for iteration of term lists #
#######################################

class TermListItem(object):
    """An item returned from iteration of a term list.

    The item supports access to the following attributes and properties:

     - `term`: The term corresponding to this TermListItem.
     - `wdf`: The within document frequency of this term.
     - `termfreq`: The number of documents in the collection which are indexed
       by the term
     - `positer`: An iterator over the positions which the term appears at in
       the document.  This is only available until the iterator which returned
       this item next moves.

    """
    __slots__ = ('_iter', 'term', '_wdf', '_termfreq')

    def __init__(self, iter, term):
        self._iter = iter
        self.term = term
        self._wdf = None
        self._termfreq = None

        if iter._has_wdf == TermIter.EAGER:
            self._wdf = iter._iter.get_wdf()
        if iter._has_termfreq == TermIter.EAGER:
            self._termfreq = iter._iter.get_termfreq()

# Support for sequence API
        sequence = ['term', 'wdf', 'termfreq', 'positer']
        if iter._has_wdf == TermIter.INVALID:
            sequence[1] = 0
        if iter._has_termfreq == TermIter.INVALID:
            sequence[2] = 0
        if iter._has_positions == TermIter.INVALID:
            sequence[3] = PositionIter()

    def _get_wdf(self):
        """Get the within-document-frequency of the current term.

        This will raise a InvalidOperationError exception if the iterator this
        item came from doesn't support within-document-frequencies.

        """
        if self._wdf is None:
            if self._iter._has_wdf == TermIter.INVALID:
                raise InvalidOperationError("Iterator does not support wdfs")
            if self.term is not self._iter._lastterm:
                raise InvalidOperationError("Iterator has moved, and does not support random access")
            self._wdf = self._iter._iter.get_wdf()
        return self._wdf
    wdf = property(_get_wdf, doc=
    """The within-document-frequency of the current term (if meaningful).

    This will raise a InvalidOperationError exception if the iterator
    this item came from doesn't support within-document-frequencies.

    """)

    def _get_termfreq(self):
        """Get the term frequency.

        This is the number of documents in the collection which are indexed by
        the term.

        This will raise a InvalidOperationError exception if the iterator this
        item came from doesn't support term frequencies.

        """
        if self._termfreq is None:
            if self._iter._has_termfreq == TermIter.INVALID:
                raise InvalidOperationError("Iterator does not support term frequencies")
            if self.term is not self._iter._lastterm:
                raise InvalidOperationError("Iterator has moved, and does not support random access")
            self._termfreq = self._iter._iter.get_termfreq()
        return self._termfreq
    termfreq = property(_get_termfreq, doc=
    """The term frequency of the current term (if meaningful).

    This is the number of documents in the collection which are indexed by the
    term.

    This will raise a InvalidOperationError exception if the iterator
    this item came from doesn't support term frequencies.

    """)

    def _get_positer(self):
        """Get a position list iterator.

        The iterator will return integers representing the positions that the
        term occurs at.

        This will raise a InvalidOperationError exception if the iterator this
        item came from doesn't support position lists, or if the iterator has
        moved on since the item was returned from it.

        """
        if self._iter._has_positions == TermIter.INVALID:
            raise InvalidOperationError("Iterator does not support position lists")
# Access to position lists is always lazy, so we don't need to check
# _has_positions.
        if self.term is not self._iter._lastterm:
            raise InvalidOperationError("Iterator has moved, and does not support random access")
        return PositionIter(self._iter._iter._positionlist_begin(),
                            self._iter._iter._positionlist_end())
    positer = property(_get_positer, doc=
    """A position iterator for the current term (if meaningful).

    The iterator will return integers representing the positions that the term
    occurs at.

    This will raise a InvalidOperationError exception if the iterator this item
    came from doesn't support position lists, or if the iterator has moved on
    since the item was returned from it.

    """)


class TermIter(object):
    """An iterator over a term list.

    The iterator will return TermListItem objects, which will be evaluated
    lazily where appropriate.

    """
    __slots__ = ('_iter', '_end', '_has_termfreq', '_has_wdf',
                 '_has_positions', '_return_strings', '_lastterm', '_moved')

    INVALID = 0
    LAZY = 1
    EAGER = 2

    def __init__(self, start, end, has_termfreq=INVALID,
                 has_wdf=INVALID, has_positions=INVALID,
                 return_strings=False):
        self._iter = start
        self._end = end
        self._has_termfreq = has_termfreq
        self._has_wdf = has_wdf
        self._has_positions = has_positions
        assert(has_positions != TermIter.EAGER) # Can't do eager access to position lists
        self._return_strings = return_strings
        self._lastterm = None # Used to test if the iterator has moved

# _moved is True if we've moved onto the next item.  This is needed so
# that the iterator doesn't have to move on until just before next() is
# called: since the iterator starts by pointing at a valid item, we
# can't just call next(self._iter) unconditionally at the start of our
# __next__() method.
        self._moved = True

    def __iter__(self):
        return self

    def __next__(self):
        if not self._moved:
            next(self._iter)
            self._moved = True

        if self._iter == self._end:
            self._lastterm = None
            raise StopIteration
        else:
            self._lastterm = self._iter.get_term()
            self._moved = False
            if self._return_strings:
                return self._lastterm
            return TermListItem(self, self._lastterm)

    def skip_to(self, term):
        """Skip the iterator forward.

        The iterator is advanced to the first term at or after the current
        position which is greater than or equal to the supplied term.

        If there are no such items, this will raise StopIteration.

        This returns the item which the iterator is moved to.  The subsequent
        item will be returned the next time that next() is called (unless
        skip_to() is called again first).

        """
        if self._iter != self._end:
            self._iter.skip_to(term)

        if self._iter == self._end:
            self._lastterm = None
            self._moved = True
            raise StopIteration

# Update self._lastterm if the iterator has moved.
# TermListItems compare a saved value of lastterm with self._lastterm
# with the object identity comparator, so it is important to ensure
# that it does not get modified if the new term compares equal.
        newterm = self._iter.get_term()
        if newterm != self._lastterm:
            self._lastterm = newterm

        self._moved = False
        if self._return_strings:
            return self._lastterm
        return TermListItem(self, self._lastterm)

# Modify Enquire to add a "matching_terms()" method.
def _enquire_gen_iter(self, which):
    """Get an iterator over the terms which match a given match set item.

    The match set item to consider is specified by the `which` parameter, which
    may be a document ID, or an MSetItem object.

    The iterator will return string objects.

    """
    if isinstance(which, MSetItem):
        which = which.docid
    return TermIter(self._get_matching_terms_begin(which),
                    self._get_matching_terms_end(which),
                    return_strings=True)
Enquire.matching_terms = _enquire_gen_iter

# Modify Query to add an "__iter__()" method.
def _query_gen_iter(self):
    """Get an iterator over the terms in a query.

    The iterator will return string objects.

    """
    return TermIter(self._get_terms_begin(),
                    self._get_terms_end(),
                    return_strings=True)
Query.__iter__ = _query_gen_iter

# Modify Database to add an "__iter__()" method and an "allterms()" method.
def _database_gen_allterms_iter(self, prefix=None):
    """Get an iterator over all the terms in the database.

    The iterator will return TermListItem objects, but these will not support
    access to wdf, or position information.

    Access to term frequency information is only available until the iterator
    has moved on.

    If prefix is supplied, only terms which start with that prefix will be
    returned.

    """
    if prefix is None:
        return TermIter(self._allterms_begin(), self._allterms_end(),
                        has_termfreq=TermIter.LAZY)
    else:
        return TermIter(self._allterms_begin(prefix), self._allterms_end(prefix),
                        has_termfreq=TermIter.LAZY)
Database.__iter__ = _database_gen_allterms_iter
Database.allterms = _database_gen_allterms_iter

# Modify Database to add a "termlist()" method.
def _database_gen_termlist_iter(self, docid):
    """Get an iterator over all the terms which index a given document ID.

    The iterator will return TermListItem objects.

    Access to term frequency and position information is only available until
    the iterator has moved on.

    """
# Note: has_termfreq is set to LAZY because most databases don't store term
# frequencies in the termlist (because this would require updating many termlist
# entries for every document update), so access to the term frequency requires a
# separate lookup.
    return TermIter(self._termlist_begin(docid), self._termlist_end(docid),
                    has_termfreq=TermIter.LAZY,
                    has_wdf=TermIter.EAGER,
                    has_positions=TermIter.LAZY)
Database.termlist = _database_gen_termlist_iter

# Modify Database to add a "spellings()" method.
def _database_gen_spellings_iter(self):
    """Get an iterator which returns all the spelling correction targets

    The iterator will return TermListItem objects.  Only the term frequency is
    available; wdf and positions are not meaningful.

    """
    return TermIter(self._spellings_begin(), self._spellings_end(),
                    has_termfreq=TermIter.EAGER,
                    has_wdf=TermIter.INVALID,
                    has_positions=TermIter.INVALID)
Database.spellings = _database_gen_spellings_iter

# Modify Database to add a "synonyms()" method.
def _database_gen_synonyms_iter(self, term):
    """Get an iterator which returns all the synonyms for a given term.

    The term to return synonyms for is specified by the `term` parameter.

    The iterator will return string objects.

    """
    return TermIter(self._synonyms_begin(term),
                    self._synonyms_end(term),
                    return_strings=True)
Database.synonyms = _database_gen_synonyms_iter

# Modify Database to add a "synonym_keys()" method.
def _database_gen_synonym_keys_iter(self, prefix=""):
    """Get an iterator which returns all the terms which have synonyms.

    The iterator will return string objects.

    If `prefix` is non-empty, only terms with this prefix are returned.

    """
    return TermIter(self._synonym_keys_begin(prefix),
                    self._synonym_keys_end(prefix),
                    return_strings=True)
Database.synonym_keys = _database_gen_synonym_keys_iter

# Modify Database to add a "metadata_keys()" method, instead of direct access
# to metadata_keys_begin and metadata_keys_end.
def _database_gen_metadata_keys_iter(self, prefix=""):
    """Get an iterator which returns all the metadata keys.

    The iterator will return string objects.

    If `prefix` is non-empty, only metadata keys with this prefix are returned.

    """
    return TermIter(self._metadata_keys_begin(prefix),
                    self._metadata_keys_end(prefix),
                    return_strings=True)
Database.metadata_keys = _database_gen_metadata_keys_iter

# Modify Document to add an "__iter__()" method and a "termlist()" method.
def _document_gen_termlist_iter(self):
    """Get an iterator over all the terms in a document.

    The iterator will return TermListItem objects.

    Access to term frequency and position information is only available until
    the iterator has moved on.

    Note that term frequency information is only meaningful for a document
    retrieved from a database.  If term frequency information is requested for
    a document which was freshly created, an InvalidOperationError will be
    raised.

    """
# Note: document termlist iterators may be implemented entirely in-memory
# (in which case access to all items could be allowed eagerly), but may
# also be implemented by returning a database termlist (for documents which
# are stored in a database, rather than freshly created).  We choose the
# most conservative settings, to avoid doing eager access when lazy access
# would be more appropriate.
    return TermIter(self._termlist_begin(), self._termlist_end(),
                    has_termfreq=TermIter.LAZY,
                    has_wdf=TermIter.EAGER,
                    has_positions=TermIter.LAZY)
Document.__iter__ = _document_gen_termlist_iter
Document.termlist = _document_gen_termlist_iter

# Modify QueryParser to add a "stoplist()" method.
def _queryparser_gen_stoplist_iter(self):
    """Get an iterator over all the stopped terms from the previous query.

    This returns an iterator over all the terms which were omitted from the
    previously parsed query due to being considered to be stopwords.  Each
    instance of a word omitted from the query is represented in the returned
    list, in the order in which the

    The iterator will return string objects.

    """
    return TermIter(self._stoplist_begin(), self._stoplist_end(),
                    return_strings=True)
QueryParser.stoplist = _queryparser_gen_stoplist_iter

# Modify QueryParser to add an "unstemlist()" method.
def _queryparser_gen_unstemlist_iter(self, tname):
    """Get an iterator over all the unstemmed forms of a stemmed term.

    This returns an iterator which returns all the unstemmed words which were
    stemmed to the stemmed form specified by `tname` when parsing the previous
    query.  Each instance of a word which stems to `tname` is returned by the
    iterator in the order in which the words appeared in the query - an
    individual unstemmed word may thus occur multiple times.

    The iterator will return string objects.

    """
    return TermIter(self._unstem_begin(tname), self._unstem_end(tname),
                    return_strings=True)
QueryParser.unstemlist = _queryparser_gen_unstemlist_iter

# Modify ValueCountMatchSpy to add a "values()" method.
def wrapper():
    begin = ValueCountMatchSpy.values_begin
    del ValueCountMatchSpy.values_begin
    end = ValueCountMatchSpy.values_end
    del ValueCountMatchSpy.values_end
    def values(self):
        """Get an iterator over all the values in the slot.

        Values will be returned in ascending alphabetical order.

        The iterator will return TermListItem objects: the value can be
        accessed as the `term` property, and the frequency can be accessed as
        the `termfreq` property.

        """
        return TermIter(begin(self), end(self), has_termfreq=TermIter.EAGER)
    return values
ValueCountMatchSpy.values = wrapper()
del wrapper

# Modify ValueCountMatchSpy to add a "top_values()" method.
def wrapper():
    begin = ValueCountMatchSpy.top_values_begin
    del ValueCountMatchSpy.top_values_begin
    end = ValueCountMatchSpy.top_values_end
    del ValueCountMatchSpy.top_values_end
    def top_values(self, maxvalues):
        """Get an iterator over the most frequent values for the slot.

        Values will be returned in descending order of frequency.  Values with
        the same frequency will be returned in ascending alphabetical order.

        The iterator will return TermListItem objects: the value can be
        accessed as the `term` property, and the frequency can be accessed as
        the `termfreq` property.

        """
        return TermIter(begin(self, maxvalues), end(self, maxvalues),
                        has_termfreq=TermIter.EAGER)
    return top_values
ValueCountMatchSpy.top_values = wrapper()
del wrapper

# When we make a query, keep a note of postingsources involved, so they won't
# be deleted. This hack can probably be removed once xapian bug #186 is fixed.
__query_init_orig = Query.__init__
def _query_init(self, *args):
    """Make a new query object.

    Many possible arguments are possible - see the documentation for details.

    """
    ps = []
    if len(args) == 1 and isinstance(args[0], PostingSource):
        ps.append(args[0])
    else:
        for arg in args:
            if isinstance(arg, Query):
                ps.extend(getattr(arg, '_ps', []))
            elif hasattr(arg, '__iter__'):
                for listarg in arg:
                    if isinstance(listarg, Query):
                        ps.extend(getattr(listarg, '_ps', []))
    __query_init_orig(self, *args)
    self._ps = ps
Query.__init__ = _query_init
del _query_init

# When setting a query on enquire, keep a note of postingsources involved, so
# they won't be deleted. This hack can probably be removed once xapian bug #186
# is fixed.
__enquire_set_query_orig = Enquire.set_query
def _enquire_set_query(self, query, qlen=0):
    self._ps = getattr(query, '_ps', [])
    return __enquire_set_query_orig(self, query, qlen)
_enquire_set_query.__doc__ = __enquire_set_query_orig.__doc__
Enquire.set_query = _enquire_set_query
del _enquire_set_query

# When getting  a query from enquire, keep a note of postingsources involved,
# so they won't be deleted. This hack can probably be removed once xapian bug
# #186 is fixed.
__enquire_get_query_orig = Enquire.get_query
def _enquire_get_query(self):
    query = __enquire_get_query_orig(self)
    query._ps = getattr(self, '_ps', [])
    return query
_enquire_get_query.__doc__ = __enquire_get_query_orig.__doc__
Enquire.get_query = _enquire_get_query
del _enquire_get_query

# When we set a ValueRangeProcessor into the QueryParser, keep a python
# reference so it won't be deleted. This hack can probably be removed once
# xapian bug #186 is fixed.
__queryparser_add_valuerangeprocessor_orig = QueryParser.add_valuerangeprocessor
def _queryparser_add_valuerangeprocessor(self, vrproc):
    if not hasattr(self, '_vrps'):
        self._vrps = []
    self._vrps.append(vrproc)
    return __queryparser_add_valuerangeprocessor_orig(self, vrproc)
_queryparser_add_valuerangeprocessor.__doc__ = __queryparser_add_valuerangeprocessor_orig.__doc__
QueryParser.add_valuerangeprocessor = _queryparser_add_valuerangeprocessor
del _queryparser_add_valuerangeprocessor

# When we set a RangeProcessor into the QueryParser, keep a python
# reference so it won't be deleted. This hack can probably be removed once
# xapian bug #186 is fixed.
__queryparser_add_rangeprocessor_orig = QueryParser.add_rangeprocessor
def _queryparser_add_rangeprocessor(self, rproc):
    if not hasattr(self, '_rps'):
        self._rps = []
    self._rps.append(rproc)
    return __queryparser_add_rangeprocessor_orig(self, rproc)
_queryparser_add_rangeprocessor.__doc__ = __queryparser_add_rangeprocessor_orig.__doc__
QueryParser.add_rangeprocessor = _queryparser_add_rangeprocessor
del _queryparser_add_rangeprocessor

# When we set a FieldProcessor into the QueryParser, keep a python
# reference so it won't be deleted. This hack can probably be removed once
# xapian bug #186 is fixed.
__queryparser_add_prefix_orig = QueryParser.add_prefix
def _queryparser_add_prefix(self, s, proc):
    if not isinstance(proc, (str, bytes)):
        if not hasattr(self, '_fps'):
            self._fps = []
        self._fps.append(proc)
    return __queryparser_add_prefix_orig(self, s, proc)
_queryparser_add_prefix.__doc__ = __queryparser_add_prefix_orig.__doc__
QueryParser.add_prefix = _queryparser_add_prefix
del _queryparser_add_prefix
__queryparser_add_boolean_prefix_orig = QueryParser.add_boolean_prefix
def _queryparser_add_boolean_prefix(self, s, proc, exclusive = True):
    if not isinstance(proc, (str, bytes)):
        if not hasattr(self, '_fps'):
            self._fps = []
        self._fps.append(proc)
    return __queryparser_add_boolean_prefix_orig(self, s, proc, exclusive)
_queryparser_add_boolean_prefix.__doc__ = __queryparser_add_boolean_prefix_orig.__doc__
QueryParser.add_boolean_prefix = _queryparser_add_boolean_prefix
del _queryparser_add_boolean_prefix

# When we set a Stopper into the QueryParser, keep a python reference so it
# won't be deleted. This hack can probably be removed once xapian bug #186 is
# fixed.
__queryparser_set_stopper_orig = QueryParser.set_stopper
def _queryparser_set_stopper(self, stopper):
    self._stopper = stopper
    return __queryparser_set_stopper_orig(self, stopper)
_queryparser_set_stopper.__doc__ = __queryparser_set_stopper_orig.__doc__
QueryParser.set_stopper = _queryparser_set_stopper
del _queryparser_set_stopper

# When we set a Stopper into the TermGenerator, keep a python reference so it
# won't be deleted. This hack can probably be removed once xapian bug #186 is
# fixed.
__termgenerator_set_stopper_orig = TermGenerator.set_stopper
def _termgenerator_set_stopper(self, stopper):
    self._stopper = stopper
    return __termgenerator_set_stopper_orig(self, stopper)
_termgenerator_set_stopper.__doc__ = __termgenerator_set_stopper_orig.__doc__
TermGenerator.set_stopper = _termgenerator_set_stopper
del _termgenerator_set_stopper

# When we set a Sorter on enquire, keep a python reference so it won't be
# deleted.  This hack can probably be removed once xapian bug #186 is fixed.
__enquire_set_sort_by_key_orig = Enquire.set_sort_by_key
def _enquire_set_sort_by_key(self, sorter, reverse):
    self._sorter = sorter
    return __enquire_set_sort_by_key_orig(self, sorter, reverse)
_enquire_set_sort_by_key.__doc__ = __enquire_set_sort_by_key_orig.__doc__
Enquire.set_sort_by_key = _enquire_set_sort_by_key
del _enquire_set_sort_by_key

__enquire_set_sort_by_key_then_relevance_orig = Enquire.set_sort_by_key_then_relevance
def _enquire_set_sort_by_key_then_relevance(self, sorter, reverse):
    self._sorter = sorter
    return __enquire_set_sort_by_key_then_relevance_orig(self, sorter, reverse)
_enquire_set_sort_by_key_then_relevance.__doc__ = __enquire_set_sort_by_key_then_relevance_orig.__doc__
Enquire.set_sort_by_key_then_relevance = _enquire_set_sort_by_key_then_relevance
del _enquire_set_sort_by_key_then_relevance

__enquire_set_sort_by_relevance_then_key_orig = Enquire.set_sort_by_relevance_then_key
def _enquire_set_sort_by_relevance_then_key(self, sorter, reverse):
    self._sorter = sorter
    return __enquire_set_sort_by_relevance_then_key_orig(self, sorter, reverse)
_enquire_set_sort_by_relevance_then_key.__doc__ = __enquire_set_sort_by_relevance_then_key_orig.__doc__
Enquire.set_sort_by_relevance_then_key = _enquire_set_sort_by_relevance_then_key
del _enquire_set_sort_by_relevance_then_key


##########################################
# Support for iteration of posting lists #
##########################################

class PostingItem(object):
    """An item returned from iteration of a posting list.

    The item supports access to the following attributes and properties:

     - `docid`: The document ID corresponding to this PostingItem.
     - `doclength`: The length of the document corresponding to this
       PostingItem.
     - `wdf`: The within document frequency of the term which the posting list
       is for in the document corresponding to this PostingItem.
     - `positer`: An iterator over the positions which the term corresponing to
       this posting list occurs at in the document corresponding to this
       PostingItem.  This is only available until the iterator which returned
       this item next moves.

    """
    __slots__ = ('_iter', 'docid', 'doclength', 'wdf',)

    def __init__(self, iter):
        self._iter = iter
        self.docid = iter._iter.get_docid()
        self.doclength = iter._iter.get_doclength()
        self.wdf = iter._iter.get_wdf()

# Support for sequence API
        sequence = ['docid', 'doclength', 'wdf', 'positer']
        if not iter._has_positions:
            sequence[3] = PositionIter()

    def _get_positer(self):
        """Get a position list iterator.

        The iterator will return integers representing the positions that the
        term occurs at in the document corresponding to this PostingItem.

        This will raise a InvalidOperationError exception if the iterator this
        item came from doesn't support position lists, or if the iterator has
        moved on since the item was returned from it.

        """
        if not self._iter._has_positions:
            raise InvalidOperationError("Iterator does not support position lists")
        if self._iter._iter == self._iter._end or \
           self.docid != self._iter._iter.get_docid():
            raise InvalidOperationError("Iterator has moved, and does not support random access")
        return PositionIter(self._iter._iter._positionlist_begin(),
                            self._iter._iter._positionlist_end())
    positer = property(_get_positer, doc=
    """A position iterator for the current posting (if meaningful).

    The iterator will return integers representing the positions that the term
    occurs at.

    This will raise a InvalidOperationError exception if the iterator this item
    came from doesn't support position lists, or if the iterator has moved on
    since the item was returned from it.

    """)


class PostingIter(object):
    """An iterator over a posting list.

    The iterator will return PostingItem objects, which will be evaluated
    lazily where appropriate.

    """
    __slots__ = ('_iter', '_end', '_has_positions', '_moved')

    def __init__(self, start, end, has_positions=False):
        self._iter = start
        self._end = end
        self._has_positions = has_positions

# _moved is True if we've moved onto the next item.  This is needed so
# that the iterator doesn't have to move on until just before next() is
# called: since the iterator starts by pointing at a valid item, we
# can't just call next(self._iter) unconditionally at the start of our
# __next__() method.
        self._moved = True

    def __iter__(self):
        return self

    def __next__(self):
        if not self._moved:
            next(self._iter)
            self._moved = True

        if self._iter == self._end:
            raise StopIteration
        else:
            self._moved = False
            return PostingItem(self)

    def skip_to(self, docid):
        """Skip the iterator forward.

        The iterator is advanced to the first document with a document ID
        which is greater than or equal to the supplied document ID.

        If there are no such items, this will raise StopIteration.

        This returns the item which the iterator is moved to.  The subsequent
        item will be returned the next time that next() is called (unless
        skip_to() is called again first).

        """
        if self._iter != self._end:
            self._iter.skip_to(docid)
        if self._iter == self._end:
            self._moved = True
            raise StopIteration
        self._moved = False
        return PostingItem(self)

def _database_gen_postlist_iter(self, tname):
    """Get an iterator over the postings which are indexed by a given term.

    If `tname` is empty, an iterator over all the documents will be returned
    (this will contain one entry for each document, will always return a wdf of
    1, and will not allow access to a position iterator).

    """
    if len(tname) != 0:
        return PostingIter(self._postlist_begin(tname), self._postlist_end(tname),
                           has_positions=True)
    else:
        return PostingIter(self._postlist_begin(tname), self._postlist_end(tname))
Database.postlist = _database_gen_postlist_iter


###########################################
# Support for iteration of position lists #
###########################################

class PositionIter(object):
    """An iterator over a position list.

    The iterator will return integers, in ascending order.

    """
    def __init__(self, start = 0, end = 0):
        self.iter = start
        self.end = end

    def __iter__(self):
        return self

    def __next__(self):
        if self.iter==self.end:
            raise StopIteration
        else:
            r = self.iter.get_termpos()
            next(self.iter)
            return r

# Modify Database to add a "positionlist()" method.
def _database_gen_positionlist_iter(self, docid, tname):
    """Get an iterator over all the positions in a given document of a term.

    The iterator will return integers, in ascending order.

    """
    return PositionIter(self._positionlist_begin(docid, tname), self._positionlist_end(docid, tname))
Database.positionlist = _database_gen_positionlist_iter

########################################
# Support for iteration of value lists #
########################################

class ValueItem(object):
    """An item returned from iteration of the values in a document.

    The item supports access to the following attributes:

     - `num`: The number of the value.
     - `value`: The contents of the value.

    """

    __slots__ = ('num', 'value', )

    def __init__(self, num, value):
        self.num = num
        self.value = value

class ValueIter(object):
    """An iterator over all the values stored in a document.

    The iterator will return ValueItem objects, in ascending order of value number.

    """
    def __init__(self, start, end):
        self.iter = start
        self.end = end

    def __iter__(self):
        return self

    def __next__(self):
        if self.iter==self.end:
            raise StopIteration
        else:
            r = ValueItem(self.iter.get_valueno(), self.iter.get_value())
            next(self.iter)
            return r

# Modify Document to add a "values()" method.
def _document_gen_values_iter(self):
    """Get an iterator over all the values stored in a document.

    The iterator will return ValueItem objects, in ascending order of value number.

    """
    return ValueIter(self._values_begin(), self._values_end())
Document.values = _document_gen_values_iter


##########################################
# Support for iteration of value streams #
##########################################

class ValueStreamItem(object):
    """An item returned from iteration of the values in a document.

    The item supports access to the following attributes:

     - `docid`: The docid for the item.
     - `value`: The contents of the value.

    """

    __slots__ = ('docid', 'value', )

    def __init__(self, docid, value):
        self.docid = docid
        self.value = value

class ValueStreamIter(object):
    """An iterator over all the values stored in a document.

    The iterator will return ValueStreamItem objects, in ascending order of value number.

    """
    def __init__(self, start, end):
        self.iter = start
        self.end = end
        self.moved = True

    def __iter__(self):
        return self

    def __next__(self):
        if not self.moved:
            self.iter.__next__()
            self.moved = True

        if self.iter==self.end:
            raise StopIteration
        else:
            self.moved = False
            return ValueStreamItem(self.iter.get_docid(), self.iter.get_value())

    def skip_to(self, docid):
        """Skip the iterator forward.

        The iterator is advanced to the first document with a document ID
        which is greater than or equal to the supplied document ID.

        If there are no such items, this will raise StopIteration.

        This returns the item which the iterator is moved to.  The subsequent
        item will be returned the next time that next() is called (unless
        skip_to() is called again first).

        """
        if self.iter != self.end:
            self.iter.skip_to(docid)
        if self.iter == self.end:
            self.moved = True
            raise StopIteration
        self.moved = False
        return ValueStreamItem(self.iter.get_docid(), self.iter.get_value())

# Modify Database to add a "valuestream()" method, and remove the
# valuestream_begin() and valuestream_end() methods.
def wrapper():
    vs_begin = Database.valuestream_begin
    del Database.valuestream_begin
    vs_end = Database.valuestream_end
    del Database.valuestream_end
    def valuestream(self, slot):
        """Get an iterator over all the values stored in a slot in the database.

        The iterator will return ValueStreamItem objects, in ascending order of
        document id.

        """
        return ValueStreamIter(vs_begin(self, slot), vs_end(self, slot))
    return valuestream
Database.valuestream = wrapper()
del wrapper

##########################################
# Support for iteration of LatLongCoords #
##########################################

class LatLongCoordsIter(object):
    """An iterator over all the coordinates in a LatLongCoords object.

    The iterator returns LatLongCoord objects.

    """
    def __init__(self, start, end):
        self.iter = start
        self.end = end

    def __iter__(self):
        return self

    def __eq__(self, other):
        return self.equals(other)

    def __ne__(self, other):
        return not self.equals(other)

    def __next__(self):
        if self.iter.equals(self.end):
            raise StopIteration
        else:
            r = self.iter.get_coord()
            self.iter.__next__()
            return r

# Modify LatLongCoords to make it iterable.
def _latlongcoords_iter(self):
    """Get an iterator over all the coordinates in a LatLongCoords.

    The iterator will return xapian.LatLongCoord objects.

    """
    return LatLongCoordsIter(self.begin(), self.end())
LatLongCoords.__iter__ = _latlongcoords_iter
del _latlongcoords_iter
del LatLongCoordsIterator

# Fix up Enquire so that it keeps a python reference to the deciders supplied
# to it so that they won't be deleted before the Enquire object.  This hack can
# probably be removed once xapian bug #186 is fixed.
_enquire_add_matchspy_orig = Enquire.add_matchspy
def _enquire_match_spy_add(self, decider):
    if not hasattr(self, '_deciders'):
        self._deciders = []
    self._deciders.append(decider)
    _enquire_add_matchspy_orig(self, decider)
_enquire_match_spy_add.__doc__ = Enquire.add_matchspy.__doc__
Enquire.add_matchspy = _enquire_match_spy_add

_enquire_clear_matchspies_orig = Enquire.clear_matchspies
def _enquire_match_spies_clear(self):
    _enquire_clear_matchspies_orig(self)
    if hasattr(self, '_deciders'):
        del self._deciders
_enquire_match_spies_clear.__doc__ = Enquire.clear_matchspies.__doc__
Enquire.clear_matchspies = _enquire_match_spies_clear


# Fix up Stem.__init__() so that it calls __disown__() on the passed
# StemImplementation object so that Python won't delete it from under us.
_stem_init_orig = Stem.__init__
def _stem_init(self, *args):
    _stem_init_orig(self, *args)
    if len(args) > 0 and isinstance(args[0], StemImplementation):
        args[0].__disown__()
_stem_init.__doc__ = Stem.__init__.__doc__
Stem.__init__ = _stem_init


# Add wrappers for Query::MatchAll and Query::MatchNothing
Query.MatchAll = Query("")
Query.MatchNothing = Query()


# Set the list of names which should be public.
# Note that this needs to happen at the end of xapian.py.
__all__ = []
for item in dir():
    if item.startswith('_') or item.endswith('_swigregister') or item.endswith('Iterator'):
        continue
    __all__.append(item)
__all__ = tuple(__all__)


