/*
 * Copyright (c) 2009 Charles S. Wilson
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a 
 * copy of this software and associated documentation files (the "Software"), 
 * to deal in the Software without restriction, including without limitation 
 * the rights to use, copy, modify, merge, publish, distribute, sublicense, 
 * and/or sell copies of the Software, and to permit persons to whom the 
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included 
 * in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR 
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
 * OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef RUN2_CONFPARSER_H
#define RUN2_CONFPARSER_H

#include "confdata.h"
#include "util.h"

typedef struct run2_xml_parser {
  void            *handler;   /* xmlSAXHandler*        */
  void            *schema;    /* xmlSchemaPtr          */
  void            *validator; /* xmlSchemaValidCtxtPtr */
  const char      *xmlfilename;
  run2_confdata_t *confdata;
} run2_xml_parser_t;

run2_xml_parser_t *run2_xml_parser_create (void);
int  run2_xml_parser_parse (run2_xml_parser_t *parser);
void run2_xml_parser_destroy (run2_xml_parser_t *parser);

/* do it all in one step */
run2_confdata_t *run2_xml_parse (const char *xmlfilename);

#endif

