// This file is generated by kconfig_compiler_kf5 from freespacenotifier.kcfg.
// All changes you do to this file will be lost.
#ifndef FREESPACENOTIFIERSETTINGS_H
#define FREESPACENOTIFIERSETTINGS_H

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

class FreeSpaceNotifierSettings : public KConfigSkeleton
{
  public:

    static FreeSpaceNotifierSettings *self();
    ~FreeSpaceNotifierSettings();

    /**
      Set Minimum free space before user starts being notified.
    */
    static
    void setMinimumSpace( int v )
    {
      if (v < 1)
      {
        qDebug() << "setMinimumSpace: value " << v << " is less than the minimum value of 1";
        v = 1;
      }

      if (v > 100000)
      {
        qDebug() << "setMinimumSpace: value " << v << " is greater than the maximum value of 100000";
        v = 100000;
      }

      if (!self()->isImmutable( QStringLiteral( "minimumSpace" ) ))
        self()->mMinimumSpace = v;
    }

    /**
      Get Minimum free space before user starts being notified.
    */
    static
    int minimumSpace()
    {
      return self()->mMinimumSpace;
    }

    /**
      Set Is the free space notification enabled.
    */
    static
    void setEnableNotification( bool v )
    {
      if (!self()->isImmutable( QStringLiteral( "enableNotification" ) ))
        self()->mEnableNotification = v;
    }

    /**
      Get Is the free space notification enabled.
    */
    static
    bool enableNotification()
    {
      return self()->mEnableNotification;
    }

  protected:
    FreeSpaceNotifierSettings();
    friend class FreeSpaceNotifierSettingsHelper;


    // General
    int mMinimumSpace;
    bool mEnableNotification;

  private:
};

#endif

