
#include <octave/oct.h>
#include "Cost_auto_fcn.h"

double Cost_auto_fcn::cost_update (octave_idx_type nn1, octave_idx_type nn2,
                                   double cmax, bool &accept)
{
  octave_idx_type n1 = std::min (nn1, nn2);
  octave_idx_type n2 = std::max (nn1, nn2);

  accept = false;

  double comp = 0;

  Matrix ccop (c);

  for (octave_idx_type n = 1; n <= no_lags; n++)
    {
      double cc = c(n-1);
      double dx = (*series)(n2) - (*series)(n1);
      if (n1 - n >= 0)
        cc += dx * (*series)(n1-n);
      if (n2 + n < series->rows ())
        cc -= dx * (*series)(n2+n);
      if (n2 - n1 != n)
        {
          if (n1 + n < series->rows ())
            cc += dx * (*series)(n1+n);
          if (n2 - n >= 0)
            cc -= dx * (*series)(n2-n);
        }
      comp = average (comp, c0(n-1) - cc, n);

      // FIXME: should not have multiple return statements !!!
      if (comp >= cmax)
        return this->cost;

      ccop(n-1) = cc;
    }
  this->cost   = comp;
  accept = true;

  c = ccop;

  return this->cost;  /// EXCHANGE FROM PERMUTATION SCHEME in MAIN PROGRAM!!!!!!!!!
}

void Cost_auto_fcn::autocorrelation (Matrix &cor_mat)
{
  for (octave_idx_type n = 1; n <= no_lags; n++)
    {
      double c_sum = 0;
      for (octave_idx_type j = n+1; j <= series->rows (); j++)
        c_sum += (*series)(j - n - 1) * (*series)(j - 1);
      cor_mat(n-1) = c_sum;
    }
}

double Cost_auto_fcn::average (double comp, double dc, octave_idx_type n)
{
  double ret_val;
  if (average_type == 0)
    ret_val = std::max (comp, fabs (dc) / (double)(series->rows () - n));
  // TODO: Add rest
  else
    ret_val = std::max (comp, fabs (dc) / (double) ((series->rows () - n) * n));

  return ret_val;
}
