; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=skylake-avx512  | FileCheck %s --check-prefixes=CHECK,CHECK-SKX
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=icelake-server  | FileCheck %s --check-prefixes=CHECK,CHECK-ICX,CHECK-ICX-NO-BYPASS-DELAY
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=icelake-server -mattr=-no-bypass-delay-shuffle | FileCheck %s --check-prefixes=CHECK,CHECK-ICX,CHECK-ICX-BYPASS-DELAY
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=x86-64-v4  | FileCheck %s --check-prefixes=CHECK,CHECK-V4
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vl,+avx512bw,+avx512dq  | FileCheck %s --check-prefixes=CHECK,CHECK-AVX512
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=znver4  | FileCheck %s --check-prefixes=CHECK,CHECK-ZNVER4
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=znver5  | FileCheck %s --check-prefixes=CHECK,CHECK-ZNVER4


define <16 x float> @transform_VUNPCKLPDZrr(<16 x float> %a, <16 x float> %b) nounwind {
; CHECK-LABEL: transform_VUNPCKLPDZrr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vunpcklpd {{.*#+}} zmm0 = zmm0[0],zmm1[0],zmm0[2],zmm1[2],zmm0[4],zmm1[4],zmm0[6],zmm1[6]
; CHECK-NEXT:    retq
  %shufp = shufflevector <16 x float> %a, <16 x float> %b, <16 x i32> <i32 0, i32 1, i32 16, i32 17, i32 4, i32 5, i32 20, i32 21, i32 8, i32 9, i32 24, i32 25, i32 12, i32 13, i32 28, i32 29>
  ret <16 x float> %shufp
}

define <16 x float> @transform_VUNPCKHPDZrr(<16 x float> %a, <16 x float> %b) nounwind {
; CHECK-LABEL: transform_VUNPCKHPDZrr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vunpckhpd {{.*#+}} zmm0 = zmm0[1],zmm1[1],zmm0[3],zmm1[3],zmm0[5],zmm1[5],zmm0[7],zmm1[7]
; CHECK-NEXT:    retq
  %shufp = shufflevector <16 x float> %a, <16 x float> %b, <16 x i32> <i32 2, i32 3, i32 18, i32 19, i32 6, i32 7, i32 22, i32 23, i32 10, i32 11, i32 26, i32 27, i32 14, i32 15, i32 30, i32 31>
  ret <16 x float> %shufp
}

define <8 x float> @transform_VUNPCKLPDYrr(<8 x float> %a, <8 x float> %b) nounwind {
; CHECK-SKX-LABEL: transform_VUNPCKLPDYrr:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-NO-BYPASS-DELAY-LABEL: transform_VUNPCKLPDYrr:
; CHECK-ICX-NO-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    retq
;
; CHECK-ICX-BYPASS-DELAY-LABEL: transform_VUNPCKLPDYrr:
; CHECK-ICX-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-BYPASS-DELAY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; CHECK-ICX-BYPASS-DELAY-NEXT:    retq
;
; CHECK-V4-LABEL: transform_VUNPCKLPDYrr:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; CHECK-V4-NEXT:    retq
;
; CHECK-AVX512-LABEL: transform_VUNPCKLPDYrr:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; CHECK-AVX512-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: transform_VUNPCKLPDYrr:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; CHECK-ZNVER4-NEXT:    retq
  %shufp = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 1, i32 8, i32 9, i32 4, i32 5, i32 12, i32 13>
  ret <8 x float> %shufp
}

define <8 x float> @transform_VUNPCKHPDYrr(<8 x float> %a, <8 x float> %b) nounwind {
; CHECK-SKX-LABEL: transform_VUNPCKHPDYrr:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-NO-BYPASS-DELAY-LABEL: transform_VUNPCKHPDYrr:
; CHECK-ICX-NO-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    retq
;
; CHECK-ICX-BYPASS-DELAY-LABEL: transform_VUNPCKHPDYrr:
; CHECK-ICX-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-BYPASS-DELAY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; CHECK-ICX-BYPASS-DELAY-NEXT:    retq
;
; CHECK-V4-LABEL: transform_VUNPCKHPDYrr:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; CHECK-V4-NEXT:    retq
;
; CHECK-AVX512-LABEL: transform_VUNPCKHPDYrr:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; CHECK-AVX512-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: transform_VUNPCKHPDYrr:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; CHECK-ZNVER4-NEXT:    retq
  %shufp = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 2, i32 3, i32 10, i32 11, i32 6, i32 7, i32 14, i32 15>
  ret <8 x float> %shufp
}

define <4 x float> @transform_VUNPCKLPDrr(<4 x float> %a, <4 x float> %b) nounwind {
; CHECK-SKX-LABEL: transform_VUNPCKLPDrr:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-NO-BYPASS-DELAY-LABEL: transform_VUNPCKLPDrr:
; CHECK-ICX-NO-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    retq
;
; CHECK-ICX-BYPASS-DELAY-LABEL: transform_VUNPCKLPDrr:
; CHECK-ICX-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-BYPASS-DELAY-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; CHECK-ICX-BYPASS-DELAY-NEXT:    retq
;
; CHECK-V4-LABEL: transform_VUNPCKLPDrr:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; CHECK-V4-NEXT:    retq
;
; CHECK-AVX512-LABEL: transform_VUNPCKLPDrr:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; CHECK-AVX512-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: transform_VUNPCKLPDrr:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; CHECK-ZNVER4-NEXT:    retq
  %shufp = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 0, i32 1, i32 4, i32 5>
  ret <4 x float> %shufp
}

define <4 x float> @transform_VUNPCKHPDrr(<4 x float> %a, <4 x float> %b) nounwind {
; CHECK-SKX-LABEL: transform_VUNPCKHPDrr:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-NO-BYPASS-DELAY-LABEL: transform_VUNPCKHPDrr:
; CHECK-ICX-NO-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vpunpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    retq
;
; CHECK-ICX-BYPASS-DELAY-LABEL: transform_VUNPCKHPDrr:
; CHECK-ICX-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-BYPASS-DELAY-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; CHECK-ICX-BYPASS-DELAY-NEXT:    retq
;
; CHECK-V4-LABEL: transform_VUNPCKHPDrr:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; CHECK-V4-NEXT:    retq
;
; CHECK-AVX512-LABEL: transform_VUNPCKHPDrr:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; CHECK-AVX512-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: transform_VUNPCKHPDrr:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; CHECK-ZNVER4-NEXT:    retq
  %shufp = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 2, i32 3, i32 6, i32 7>
  ret <4 x float> %shufp
}

define <8 x double> @transform_VUNPCKLPDZrrkz(<8 x double> %a, <8 x double> %b, i8 %mask_int) nounwind {
; CHECK-LABEL: transform_VUNPCKLPDZrrkz:
; CHECK:       # %bb.0:
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vunpcklpd {{.*#+}} zmm0 {%k1} {z} = zmm0[0],zmm1[0],zmm0[2],zmm1[2],zmm0[4],zmm1[4],zmm0[6],zmm1[6]
; CHECK-NEXT:    retq
  %mask = bitcast i8 %mask_int to <8 x i1>
  %shufp = shufflevector <8 x double> %a, <8 x double> %b, <8 x i32> <i32 0, i32 8, i32 2, i32 10, i32 4, i32 12, i32 6, i32 14>
  %res = select <8 x i1> %mask, <8 x double> %shufp, <8 x double> zeroinitializer
  ret <8 x double> %res
}

define <8 x double> @transform_VUNPCKHPDZrrkz(<8 x double> %a, <8 x double> %b, i8 %mask_int) nounwind {
; CHECK-LABEL: transform_VUNPCKHPDZrrkz:
; CHECK:       # %bb.0:
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vunpckhpd {{.*#+}} zmm0 {%k1} {z} = zmm0[1],zmm1[1],zmm0[3],zmm1[3],zmm0[5],zmm1[5],zmm0[7],zmm1[7]
; CHECK-NEXT:    retq
  %mask = bitcast i8 %mask_int to <8 x i1>
  %shufp = shufflevector <8 x double> %a, <8 x double> %b, <8 x i32> <i32 1, i32 9, i32 3, i32 11, i32 5, i32 13, i32 7, i32 15>
  %res = select <8 x i1> %mask, <8 x double> %shufp, <8 x double> zeroinitializer
  ret <8 x double> %res
}

define <4 x double> @transform_VUNPCKLPDYrrkz(<4 x double> %a, <4 x double> %b, i4 %mask_int) nounwind {
; CHECK-SKX-LABEL: transform_VUNPCKLPDYrrkz:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    kmovd %edi, %k1
; CHECK-SKX-NEXT:    vunpcklpd {{.*#+}} ymm0 {%k1} {z} = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-NO-BYPASS-DELAY-LABEL: transform_VUNPCKLPDYrrkz:
; CHECK-ICX-NO-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    kmovd %edi, %k1
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vpunpcklqdq {{.*#+}} ymm0 {%k1} {z} = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    retq
;
; CHECK-ICX-BYPASS-DELAY-LABEL: transform_VUNPCKLPDYrrkz:
; CHECK-ICX-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-BYPASS-DELAY-NEXT:    kmovd %edi, %k1
; CHECK-ICX-BYPASS-DELAY-NEXT:    vshufpd {{.*#+}} ymm0 {%k1} {z} = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; CHECK-ICX-BYPASS-DELAY-NEXT:    retq
;
; CHECK-V4-LABEL: transform_VUNPCKLPDYrrkz:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    kmovd %edi, %k1
; CHECK-V4-NEXT:    vunpcklpd {{.*#+}} ymm0 {%k1} {z} = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; CHECK-V4-NEXT:    retq
;
; CHECK-AVX512-LABEL: transform_VUNPCKLPDYrrkz:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    kmovd %edi, %k1
; CHECK-AVX512-NEXT:    vunpcklpd {{.*#+}} ymm0 {%k1} {z} = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; CHECK-AVX512-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: transform_VUNPCKLPDYrrkz:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    kmovd %edi, %k1
; CHECK-ZNVER4-NEXT:    vunpcklpd {{.*#+}} ymm0 {%k1} {z} = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; CHECK-ZNVER4-NEXT:    retq
  %mask = bitcast i4 %mask_int to <4 x i1>
  %shufp = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 0, i32 4, i32 2, i32 6>
  %res = select <4 x i1> %mask, <4 x double> %shufp, <4 x double> zeroinitializer
  ret <4 x double> %res
}

define <4 x double> @transform_VUNPCKHPDYrrkz(<4 x double> %a, <4 x double> %b, i4 %mask_int) nounwind {
; CHECK-SKX-LABEL: transform_VUNPCKHPDYrrkz:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    kmovd %edi, %k1
; CHECK-SKX-NEXT:    vunpckhpd {{.*#+}} ymm0 {%k1} {z} = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-NO-BYPASS-DELAY-LABEL: transform_VUNPCKHPDYrrkz:
; CHECK-ICX-NO-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    kmovd %edi, %k1
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 {%k1} {z} = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    retq
;
; CHECK-ICX-BYPASS-DELAY-LABEL: transform_VUNPCKHPDYrrkz:
; CHECK-ICX-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-BYPASS-DELAY-NEXT:    kmovd %edi, %k1
; CHECK-ICX-BYPASS-DELAY-NEXT:    vshufpd {{.*#+}} ymm0 {%k1} {z} = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; CHECK-ICX-BYPASS-DELAY-NEXT:    retq
;
; CHECK-V4-LABEL: transform_VUNPCKHPDYrrkz:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    kmovd %edi, %k1
; CHECK-V4-NEXT:    vunpckhpd {{.*#+}} ymm0 {%k1} {z} = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; CHECK-V4-NEXT:    retq
;
; CHECK-AVX512-LABEL: transform_VUNPCKHPDYrrkz:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    kmovd %edi, %k1
; CHECK-AVX512-NEXT:    vunpckhpd {{.*#+}} ymm0 {%k1} {z} = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; CHECK-AVX512-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: transform_VUNPCKHPDYrrkz:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    kmovd %edi, %k1
; CHECK-ZNVER4-NEXT:    vunpckhpd {{.*#+}} ymm0 {%k1} {z} = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; CHECK-ZNVER4-NEXT:    retq
  %mask = bitcast i4 %mask_int to <4 x i1>
  %shufp = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 1, i32 5, i32 3, i32 7>
  %res = select <4 x i1> %mask, <4 x double> %shufp, <4 x double> zeroinitializer
  ret <4 x double> %res
}

define <2 x double> @transform_VUNPCKLPDrrkz(<2 x double> %a, <2 x double> %b, i2 %mask_int) nounwind {
; CHECK-SKX-LABEL: transform_VUNPCKLPDrrkz:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    kmovd %edi, %k1
; CHECK-SKX-NEXT:    vunpcklpd {{.*#+}} xmm0 {%k1} {z} = xmm0[0],xmm1[0]
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-NO-BYPASS-DELAY-LABEL: transform_VUNPCKLPDrrkz:
; CHECK-ICX-NO-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    kmovd %edi, %k1
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vpunpcklqdq {{.*#+}} xmm0 {%k1} {z} = xmm0[0],xmm1[0]
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    retq
;
; CHECK-ICX-BYPASS-DELAY-LABEL: transform_VUNPCKLPDrrkz:
; CHECK-ICX-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-BYPASS-DELAY-NEXT:    kmovd %edi, %k1
; CHECK-ICX-BYPASS-DELAY-NEXT:    vshufpd {{.*#+}} xmm0 {%k1} {z} = xmm0[0],xmm1[0]
; CHECK-ICX-BYPASS-DELAY-NEXT:    retq
;
; CHECK-V4-LABEL: transform_VUNPCKLPDrrkz:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    kmovd %edi, %k1
; CHECK-V4-NEXT:    vunpcklpd {{.*#+}} xmm0 {%k1} {z} = xmm0[0],xmm1[0]
; CHECK-V4-NEXT:    retq
;
; CHECK-AVX512-LABEL: transform_VUNPCKLPDrrkz:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    kmovd %edi, %k1
; CHECK-AVX512-NEXT:    vunpcklpd {{.*#+}} xmm0 {%k1} {z} = xmm0[0],xmm1[0]
; CHECK-AVX512-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: transform_VUNPCKLPDrrkz:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    kmovd %edi, %k1
; CHECK-ZNVER4-NEXT:    vunpcklpd {{.*#+}} xmm0 {%k1} {z} = xmm0[0],xmm1[0]
; CHECK-ZNVER4-NEXT:    retq
  %mask = bitcast i2 %mask_int to <2 x i1>
  %shufp = shufflevector <2 x double> %a, <2 x double> %b, <2 x i32> <i32 0, i32 2>
  %res = select <2 x i1> %mask, <2 x double> %shufp, <2 x double> zeroinitializer
  ret <2 x double> %res
}

define <2 x double> @transform_VUNPCKHPDrrkz(<2 x double> %a, <2 x double> %b, i2 %mask_int) nounwind {
; CHECK-SKX-LABEL: transform_VUNPCKHPDrrkz:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    kmovd %edi, %k1
; CHECK-SKX-NEXT:    vunpckhpd {{.*#+}} xmm0 {%k1} {z} = xmm0[1],xmm1[1]
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-NO-BYPASS-DELAY-LABEL: transform_VUNPCKHPDrrkz:
; CHECK-ICX-NO-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    kmovd %edi, %k1
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vpunpckhqdq {{.*#+}} xmm0 {%k1} {z} = xmm0[1],xmm1[1]
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    retq
;
; CHECK-ICX-BYPASS-DELAY-LABEL: transform_VUNPCKHPDrrkz:
; CHECK-ICX-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-BYPASS-DELAY-NEXT:    kmovd %edi, %k1
; CHECK-ICX-BYPASS-DELAY-NEXT:    vshufpd {{.*#+}} xmm0 {%k1} {z} = xmm0[1],xmm1[1]
; CHECK-ICX-BYPASS-DELAY-NEXT:    retq
;
; CHECK-V4-LABEL: transform_VUNPCKHPDrrkz:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    kmovd %edi, %k1
; CHECK-V4-NEXT:    vunpckhpd {{.*#+}} xmm0 {%k1} {z} = xmm0[1],xmm1[1]
; CHECK-V4-NEXT:    retq
;
; CHECK-AVX512-LABEL: transform_VUNPCKHPDrrkz:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    kmovd %edi, %k1
; CHECK-AVX512-NEXT:    vunpckhpd {{.*#+}} xmm0 {%k1} {z} = xmm0[1],xmm1[1]
; CHECK-AVX512-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: transform_VUNPCKHPDrrkz:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    kmovd %edi, %k1
; CHECK-ZNVER4-NEXT:    vunpckhpd {{.*#+}} xmm0 {%k1} {z} = xmm0[1],xmm1[1]
; CHECK-ZNVER4-NEXT:    retq
  %mask = bitcast i2 %mask_int to <2 x i1>
  %shufp = shufflevector <2 x double> %a, <2 x double> %b, <2 x i32> <i32 1, i32 3>
  %res = select <2 x i1> %mask, <2 x double> %shufp, <2 x double> zeroinitializer
  ret <2 x double> %res
}

define <8 x double> @transform_VUNPCKLPDZrrk(<8 x double> %a, <8 x double> %b, <8 x double> %c, i8 %mask_int) nounwind {
; CHECK-LABEL: transform_VUNPCKLPDZrrk:
; CHECK:       # %bb.0:
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vunpcklpd {{.*#+}} zmm2 {%k1} = zmm0[0],zmm1[0],zmm0[2],zmm1[2],zmm0[4],zmm1[4],zmm0[6],zmm1[6]
; CHECK-NEXT:    vmovapd %zmm2, %zmm0
; CHECK-NEXT:    retq
  %mask = bitcast i8 %mask_int to <8 x i1>
  %shufp = shufflevector <8 x double> %a, <8 x double> %b, <8 x i32> <i32 0, i32 8, i32 2, i32 10, i32 4, i32 12, i32 6, i32 14>
  %res = select <8 x i1> %mask, <8 x double> %shufp, <8 x double> %c
  ret <8 x double> %res
}

define <8 x double> @transform_VUNPCKHPDZrrk(<8 x double> %a, <8 x double> %b, <8 x double> %c, i8 %mask_int) nounwind {
; CHECK-LABEL: transform_VUNPCKHPDZrrk:
; CHECK:       # %bb.0:
; CHECK-NEXT:    kmovd %edi, %k1
; CHECK-NEXT:    vunpckhpd {{.*#+}} zmm2 {%k1} = zmm0[1],zmm1[1],zmm0[3],zmm1[3],zmm0[5],zmm1[5],zmm0[7],zmm1[7]
; CHECK-NEXT:    vmovapd %zmm2, %zmm0
; CHECK-NEXT:    retq
  %mask = bitcast i8 %mask_int to <8 x i1>
  %shufp = shufflevector <8 x double> %a, <8 x double> %b, <8 x i32> <i32 1, i32 9, i32 3, i32 11, i32 5, i32 13, i32 7, i32 15>
  %res = select <8 x i1> %mask, <8 x double> %shufp, <8 x double> %c
  ret <8 x double> %res
}

define <4 x double> @transform_VUNPCKLPDYrrk(<4 x double> %a, <4 x double> %b, <4 x double> %c, i4 %mask_int) nounwind {
; CHECK-SKX-LABEL: transform_VUNPCKLPDYrrk:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    kmovd %edi, %k1
; CHECK-SKX-NEXT:    vunpcklpd {{.*#+}} ymm2 {%k1} = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; CHECK-SKX-NEXT:    vmovapd %ymm2, %ymm0
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-NO-BYPASS-DELAY-LABEL: transform_VUNPCKLPDYrrk:
; CHECK-ICX-NO-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    kmovd %edi, %k1
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vpunpcklqdq {{.*#+}} ymm2 {%k1} = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vmovapd %ymm2, %ymm0
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    retq
;
; CHECK-ICX-BYPASS-DELAY-LABEL: transform_VUNPCKLPDYrrk:
; CHECK-ICX-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-BYPASS-DELAY-NEXT:    kmovd %edi, %k1
; CHECK-ICX-BYPASS-DELAY-NEXT:    vshufpd {{.*#+}} ymm2 {%k1} = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; CHECK-ICX-BYPASS-DELAY-NEXT:    vmovapd %ymm2, %ymm0
; CHECK-ICX-BYPASS-DELAY-NEXT:    retq
;
; CHECK-V4-LABEL: transform_VUNPCKLPDYrrk:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    kmovd %edi, %k1
; CHECK-V4-NEXT:    vunpcklpd {{.*#+}} ymm2 {%k1} = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; CHECK-V4-NEXT:    vmovapd %ymm2, %ymm0
; CHECK-V4-NEXT:    retq
;
; CHECK-AVX512-LABEL: transform_VUNPCKLPDYrrk:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    kmovd %edi, %k1
; CHECK-AVX512-NEXT:    vunpcklpd {{.*#+}} ymm2 {%k1} = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; CHECK-AVX512-NEXT:    vmovapd %ymm2, %ymm0
; CHECK-AVX512-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: transform_VUNPCKLPDYrrk:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    kmovd %edi, %k1
; CHECK-ZNVER4-NEXT:    vunpcklpd {{.*#+}} ymm2 {%k1} = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; CHECK-ZNVER4-NEXT:    vmovapd %ymm2, %ymm0
; CHECK-ZNVER4-NEXT:    retq
  %mask = bitcast i4 %mask_int to <4 x i1>
  %shufp = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 0, i32 4, i32 2, i32 6>
  %res = select <4 x i1> %mask, <4 x double> %shufp, <4 x double> %c
  ret <4 x double> %res
}

define <4 x double> @transform_VUNPCKHPDYrrk(<4 x double> %a, <4 x double> %b, <4 x double> %c, i4 %mask_int) nounwind {
; CHECK-SKX-LABEL: transform_VUNPCKHPDYrrk:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    kmovd %edi, %k1
; CHECK-SKX-NEXT:    vunpckhpd {{.*#+}} ymm2 {%k1} = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; CHECK-SKX-NEXT:    vmovapd %ymm2, %ymm0
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-NO-BYPASS-DELAY-LABEL: transform_VUNPCKHPDYrrk:
; CHECK-ICX-NO-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    kmovd %edi, %k1
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vpunpckhqdq {{.*#+}} ymm2 {%k1} = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vmovapd %ymm2, %ymm0
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    retq
;
; CHECK-ICX-BYPASS-DELAY-LABEL: transform_VUNPCKHPDYrrk:
; CHECK-ICX-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-BYPASS-DELAY-NEXT:    kmovd %edi, %k1
; CHECK-ICX-BYPASS-DELAY-NEXT:    vshufpd {{.*#+}} ymm2 {%k1} = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; CHECK-ICX-BYPASS-DELAY-NEXT:    vmovapd %ymm2, %ymm0
; CHECK-ICX-BYPASS-DELAY-NEXT:    retq
;
; CHECK-V4-LABEL: transform_VUNPCKHPDYrrk:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    kmovd %edi, %k1
; CHECK-V4-NEXT:    vunpckhpd {{.*#+}} ymm2 {%k1} = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; CHECK-V4-NEXT:    vmovapd %ymm2, %ymm0
; CHECK-V4-NEXT:    retq
;
; CHECK-AVX512-LABEL: transform_VUNPCKHPDYrrk:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    kmovd %edi, %k1
; CHECK-AVX512-NEXT:    vunpckhpd {{.*#+}} ymm2 {%k1} = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; CHECK-AVX512-NEXT:    vmovapd %ymm2, %ymm0
; CHECK-AVX512-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: transform_VUNPCKHPDYrrk:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    kmovd %edi, %k1
; CHECK-ZNVER4-NEXT:    vunpckhpd {{.*#+}} ymm2 {%k1} = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; CHECK-ZNVER4-NEXT:    vmovapd %ymm2, %ymm0
; CHECK-ZNVER4-NEXT:    retq
  %mask = bitcast i4 %mask_int to <4 x i1>
  %shufp = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 1, i32 5, i32 3, i32 7>
  %res = select <4 x i1> %mask, <4 x double> %shufp, <4 x double> %c
  ret <4 x double> %res
}

define <2 x double> @transform_VUNPCKLPDrrk(<2 x double> %a, <2 x double> %b, <2 x double> %c, i2 %mask_int) nounwind {
; CHECK-SKX-LABEL: transform_VUNPCKLPDrrk:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    kmovd %edi, %k1
; CHECK-SKX-NEXT:    vunpcklpd {{.*#+}} xmm2 {%k1} = xmm0[0],xmm1[0]
; CHECK-SKX-NEXT:    vmovapd %xmm2, %xmm0
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-NO-BYPASS-DELAY-LABEL: transform_VUNPCKLPDrrk:
; CHECK-ICX-NO-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    kmovd %edi, %k1
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vpunpcklqdq {{.*#+}} xmm2 {%k1} = xmm0[0],xmm1[0]
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vmovapd %xmm2, %xmm0
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    retq
;
; CHECK-ICX-BYPASS-DELAY-LABEL: transform_VUNPCKLPDrrk:
; CHECK-ICX-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-BYPASS-DELAY-NEXT:    kmovd %edi, %k1
; CHECK-ICX-BYPASS-DELAY-NEXT:    vshufpd {{.*#+}} xmm2 {%k1} = xmm0[0],xmm1[0]
; CHECK-ICX-BYPASS-DELAY-NEXT:    vmovapd %xmm2, %xmm0
; CHECK-ICX-BYPASS-DELAY-NEXT:    retq
;
; CHECK-V4-LABEL: transform_VUNPCKLPDrrk:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    kmovd %edi, %k1
; CHECK-V4-NEXT:    vunpcklpd {{.*#+}} xmm2 {%k1} = xmm0[0],xmm1[0]
; CHECK-V4-NEXT:    vmovapd %xmm2, %xmm0
; CHECK-V4-NEXT:    retq
;
; CHECK-AVX512-LABEL: transform_VUNPCKLPDrrk:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    kmovd %edi, %k1
; CHECK-AVX512-NEXT:    vunpcklpd {{.*#+}} xmm2 {%k1} = xmm0[0],xmm1[0]
; CHECK-AVX512-NEXT:    vmovapd %xmm2, %xmm0
; CHECK-AVX512-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: transform_VUNPCKLPDrrk:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    kmovd %edi, %k1
; CHECK-ZNVER4-NEXT:    vunpcklpd {{.*#+}} xmm2 {%k1} = xmm0[0],xmm1[0]
; CHECK-ZNVER4-NEXT:    vmovapd %xmm2, %xmm0
; CHECK-ZNVER4-NEXT:    retq
  %mask = bitcast i2 %mask_int to <2 x i1>
  %shufp = shufflevector <2 x double> %a, <2 x double> %b, <2 x i32> <i32 0, i32 2>
  %res = select <2 x i1> %mask, <2 x double> %shufp, <2 x double> %c
  ret <2 x double> %res
}

define <2 x double> @transform_VUNPCKHPDrrk(<2 x double> %a, <2 x double> %b, <2 x double> %c, i2 %mask_int) nounwind {
; CHECK-SKX-LABEL: transform_VUNPCKHPDrrk:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    kmovd %edi, %k1
; CHECK-SKX-NEXT:    vunpckhpd {{.*#+}} xmm2 {%k1} = xmm0[1],xmm1[1]
; CHECK-SKX-NEXT:    vmovapd %xmm2, %xmm0
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-NO-BYPASS-DELAY-LABEL: transform_VUNPCKHPDrrk:
; CHECK-ICX-NO-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    kmovd %edi, %k1
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vpunpckhqdq {{.*#+}} xmm2 {%k1} = xmm0[1],xmm1[1]
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vmovapd %xmm2, %xmm0
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    retq
;
; CHECK-ICX-BYPASS-DELAY-LABEL: transform_VUNPCKHPDrrk:
; CHECK-ICX-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-BYPASS-DELAY-NEXT:    kmovd %edi, %k1
; CHECK-ICX-BYPASS-DELAY-NEXT:    vshufpd {{.*#+}} xmm2 {%k1} = xmm0[1],xmm1[1]
; CHECK-ICX-BYPASS-DELAY-NEXT:    vmovapd %xmm2, %xmm0
; CHECK-ICX-BYPASS-DELAY-NEXT:    retq
;
; CHECK-V4-LABEL: transform_VUNPCKHPDrrk:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    kmovd %edi, %k1
; CHECK-V4-NEXT:    vunpckhpd {{.*#+}} xmm2 {%k1} = xmm0[1],xmm1[1]
; CHECK-V4-NEXT:    vmovapd %xmm2, %xmm0
; CHECK-V4-NEXT:    retq
;
; CHECK-AVX512-LABEL: transform_VUNPCKHPDrrk:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    kmovd %edi, %k1
; CHECK-AVX512-NEXT:    vunpckhpd {{.*#+}} xmm2 {%k1} = xmm0[1],xmm1[1]
; CHECK-AVX512-NEXT:    vmovapd %xmm2, %xmm0
; CHECK-AVX512-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: transform_VUNPCKHPDrrk:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    kmovd %edi, %k1
; CHECK-ZNVER4-NEXT:    vunpckhpd {{.*#+}} xmm2 {%k1} = xmm0[1],xmm1[1]
; CHECK-ZNVER4-NEXT:    vmovapd %xmm2, %xmm0
; CHECK-ZNVER4-NEXT:    retq
  %mask = bitcast i2 %mask_int to <2 x i1>
  %shufp = shufflevector <2 x double> %a, <2 x double> %b, <2 x i32> <i32 1, i32 3>
  %res = select <2 x i1> %mask, <2 x double> %shufp, <2 x double> %c
  ret <2 x double> %res
}

define <16 x float> @transform_VUNPCKLPDZrm(<16 x float> %a, ptr %pb) nounwind {
; CHECK-LABEL: transform_VUNPCKLPDZrm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vunpcklpd {{.*#+}} zmm0 = zmm0[0],mem[0],zmm0[2],mem[2],zmm0[4],mem[4],zmm0[6],mem[6]
; CHECK-NEXT:    retq
  %b = load <16 x float>, ptr %pb
  %shufp = shufflevector <16 x float> %a, <16 x float> %b, <16 x i32> <i32 0, i32 1, i32 16, i32 17, i32 4, i32 5, i32 20, i32 21, i32 8, i32 9, i32 24, i32 25, i32 12, i32 13, i32 28, i32 29>
  ret <16 x float> %shufp
}

define <16 x float> @transform_VUNPCKHPDZrm(<16 x float> %a, ptr %pb) nounwind {
; CHECK-LABEL: transform_VUNPCKHPDZrm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vunpckhpd {{.*#+}} zmm0 = zmm0[1],mem[1],zmm0[3],mem[3],zmm0[5],mem[5],zmm0[7],mem[7]
; CHECK-NEXT:    retq
  %b = load <16 x float>, ptr %pb
  %shufp = shufflevector <16 x float> %a, <16 x float> %b, <16 x i32> <i32 2, i32 3, i32 18, i32 19, i32 6, i32 7, i32 22, i32 23, i32 10, i32 11, i32 26, i32 27, i32 14, i32 15, i32 30, i32 31>
  ret <16 x float> %shufp
}

define <8 x float> @transform_VUNPCKLPDYrm(<8 x float> %a, ptr %pb) nounwind {
; CHECK-SKX-LABEL: transform_VUNPCKLPDYrm:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-NO-BYPASS-DELAY-LABEL: transform_VUNPCKLPDYrm:
; CHECK-ICX-NO-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    retq
;
; CHECK-ICX-BYPASS-DELAY-LABEL: transform_VUNPCKLPDYrm:
; CHECK-ICX-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-BYPASS-DELAY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; CHECK-ICX-BYPASS-DELAY-NEXT:    retq
;
; CHECK-V4-LABEL: transform_VUNPCKLPDYrm:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; CHECK-V4-NEXT:    retq
;
; CHECK-AVX512-LABEL: transform_VUNPCKLPDYrm:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; CHECK-AVX512-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: transform_VUNPCKLPDYrm:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; CHECK-ZNVER4-NEXT:    retq
  %b = load <8 x float>, ptr %pb
  %shufp = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 0, i32 1, i32 8, i32 9, i32 4, i32 5, i32 12, i32 13>
  ret <8 x float> %shufp
}

define <8 x float> @transform_VUNPCKHPDYrm(<8 x float> %a, ptr %pb) nounwind {
; CHECK-SKX-LABEL: transform_VUNPCKHPDYrm:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-NO-BYPASS-DELAY-LABEL: transform_VUNPCKHPDYrm:
; CHECK-ICX-NO-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    retq
;
; CHECK-ICX-BYPASS-DELAY-LABEL: transform_VUNPCKHPDYrm:
; CHECK-ICX-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-BYPASS-DELAY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; CHECK-ICX-BYPASS-DELAY-NEXT:    retq
;
; CHECK-V4-LABEL: transform_VUNPCKHPDYrm:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; CHECK-V4-NEXT:    retq
;
; CHECK-AVX512-LABEL: transform_VUNPCKHPDYrm:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; CHECK-AVX512-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: transform_VUNPCKHPDYrm:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; CHECK-ZNVER4-NEXT:    retq
  %b = load <8 x float>, ptr %pb
  %shufp = shufflevector <8 x float> %a, <8 x float> %b, <8 x i32> <i32 2, i32 3, i32 10, i32 11, i32 6, i32 7, i32 14, i32 15>
  ret <8 x float> %shufp
}

define <4 x float> @transform_VUNPCKLPDrm(<4 x float> %a, ptr %pb) nounwind {
; CHECK-SKX-LABEL: transform_VUNPCKLPDrm:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-NO-BYPASS-DELAY-LABEL: transform_VUNPCKLPDrm:
; CHECK-ICX-NO-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],mem[0]
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    retq
;
; CHECK-ICX-BYPASS-DELAY-LABEL: transform_VUNPCKLPDrm:
; CHECK-ICX-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-BYPASS-DELAY-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; CHECK-ICX-BYPASS-DELAY-NEXT:    retq
;
; CHECK-V4-LABEL: transform_VUNPCKLPDrm:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; CHECK-V4-NEXT:    retq
;
; CHECK-AVX512-LABEL: transform_VUNPCKLPDrm:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; CHECK-AVX512-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: transform_VUNPCKLPDrm:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; CHECK-ZNVER4-NEXT:    retq
  %b = load <4 x float>, ptr %pb
  %shufp = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 0, i32 1, i32 4, i32 5>
  ret <4 x float> %shufp
}

define <4 x float> @transform_VUNPCKHPDrm(<4 x float> %a, ptr %pb) nounwind {
; CHECK-SKX-LABEL: transform_VUNPCKHPDrm:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-NO-BYPASS-DELAY-LABEL: transform_VUNPCKHPDrm:
; CHECK-ICX-NO-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vpunpckhqdq {{.*#+}} xmm0 = xmm0[1],mem[1]
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    retq
;
; CHECK-ICX-BYPASS-DELAY-LABEL: transform_VUNPCKHPDrm:
; CHECK-ICX-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-BYPASS-DELAY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; CHECK-ICX-BYPASS-DELAY-NEXT:    retq
;
; CHECK-V4-LABEL: transform_VUNPCKHPDrm:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; CHECK-V4-NEXT:    retq
;
; CHECK-AVX512-LABEL: transform_VUNPCKHPDrm:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; CHECK-AVX512-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: transform_VUNPCKHPDrm:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; CHECK-ZNVER4-NEXT:    retq
  %b = load <4 x float>, ptr %pb
  %shufp = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 2, i32 3, i32 6, i32 7>
  ret <4 x float> %shufp
}

define <8 x double> @transform_VUNPCKLPDZrmkz(<8 x double> %a, ptr %pb, i8 %mask_int) nounwind {
; CHECK-LABEL: transform_VUNPCKLPDZrmkz:
; CHECK:       # %bb.0:
; CHECK-NEXT:    kmovd %esi, %k1
; CHECK-NEXT:    vunpcklpd {{.*#+}} zmm0 {%k1} {z} = zmm0[0],mem[0],zmm0[2],mem[2],zmm0[4],mem[4],zmm0[6],mem[6]
; CHECK-NEXT:    retq
  %mask = bitcast i8 %mask_int to <8 x i1>
  %b = load <8 x double>, ptr %pb
  %shufp = shufflevector <8 x double> %a, <8 x double> %b, <8 x i32> <i32 0, i32 8, i32 2, i32 10, i32 4, i32 12, i32 6, i32 14>
  %res = select <8 x i1> %mask, <8 x double> %shufp, <8 x double> zeroinitializer
  ret <8 x double> %res
}

define <8 x double> @transform_VUNPCKHPDZrmkz(<8 x double> %a, ptr %pb, i8 %mask_int) nounwind {
; CHECK-LABEL: transform_VUNPCKHPDZrmkz:
; CHECK:       # %bb.0:
; CHECK-NEXT:    kmovd %esi, %k1
; CHECK-NEXT:    vunpckhpd {{.*#+}} zmm0 {%k1} {z} = zmm0[1],mem[1],zmm0[3],mem[3],zmm0[5],mem[5],zmm0[7],mem[7]
; CHECK-NEXT:    retq
  %mask = bitcast i8 %mask_int to <8 x i1>
  %b = load <8 x double>, ptr %pb
  %shufp = shufflevector <8 x double> %a, <8 x double> %b, <8 x i32> <i32 1, i32 9, i32 3, i32 11, i32 5, i32 13, i32 7, i32 15>
  %res = select <8 x i1> %mask, <8 x double> %shufp, <8 x double> zeroinitializer
  ret <8 x double> %res
}

define <4 x double> @transform_VUNPCKLPDYrmkz(<4 x double> %a, ptr %pb, i4 %mask_int) nounwind {
; CHECK-SKX-LABEL: transform_VUNPCKLPDYrmkz:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    kmovd %esi, %k1
; CHECK-SKX-NEXT:    vunpcklpd {{.*#+}} ymm0 {%k1} {z} = ymm0[0],mem[0],ymm0[2],mem[2]
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-NO-BYPASS-DELAY-LABEL: transform_VUNPCKLPDYrmkz:
; CHECK-ICX-NO-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    kmovd %esi, %k1
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vpunpcklqdq {{.*#+}} ymm0 {%k1} {z} = ymm0[0],mem[0],ymm0[2],mem[2]
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    retq
;
; CHECK-ICX-BYPASS-DELAY-LABEL: transform_VUNPCKLPDYrmkz:
; CHECK-ICX-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-BYPASS-DELAY-NEXT:    kmovd %esi, %k1
; CHECK-ICX-BYPASS-DELAY-NEXT:    vunpcklpd {{.*#+}} ymm0 {%k1} {z} = ymm0[0],mem[0],ymm0[2],mem[2]
; CHECK-ICX-BYPASS-DELAY-NEXT:    retq
;
; CHECK-V4-LABEL: transform_VUNPCKLPDYrmkz:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    kmovd %esi, %k1
; CHECK-V4-NEXT:    vunpcklpd {{.*#+}} ymm0 {%k1} {z} = ymm0[0],mem[0],ymm0[2],mem[2]
; CHECK-V4-NEXT:    retq
;
; CHECK-AVX512-LABEL: transform_VUNPCKLPDYrmkz:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    kmovd %esi, %k1
; CHECK-AVX512-NEXT:    vunpcklpd {{.*#+}} ymm0 {%k1} {z} = ymm0[0],mem[0],ymm0[2],mem[2]
; CHECK-AVX512-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: transform_VUNPCKLPDYrmkz:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    kmovd %esi, %k1
; CHECK-ZNVER4-NEXT:    vunpcklpd {{.*#+}} ymm0 {%k1} {z} = ymm0[0],mem[0],ymm0[2],mem[2]
; CHECK-ZNVER4-NEXT:    retq
  %mask = bitcast i4 %mask_int to <4 x i1>
  %b = load <4 x double>, ptr %pb
  %shufp = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 0, i32 4, i32 2, i32 6>
  %res = select <4 x i1> %mask, <4 x double> %shufp, <4 x double> zeroinitializer
  ret <4 x double> %res
}

define <4 x double> @transform_VUNPCKHPDYrmkz(<4 x double> %a, ptr %pb, i4 %mask_int) nounwind {
; CHECK-SKX-LABEL: transform_VUNPCKHPDYrmkz:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    kmovd %esi, %k1
; CHECK-SKX-NEXT:    vunpckhpd {{.*#+}} ymm0 {%k1} {z} = ymm0[1],mem[1],ymm0[3],mem[3]
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-NO-BYPASS-DELAY-LABEL: transform_VUNPCKHPDYrmkz:
; CHECK-ICX-NO-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    kmovd %esi, %k1
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 {%k1} {z} = ymm0[1],mem[1],ymm0[3],mem[3]
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    retq
;
; CHECK-ICX-BYPASS-DELAY-LABEL: transform_VUNPCKHPDYrmkz:
; CHECK-ICX-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-BYPASS-DELAY-NEXT:    kmovd %esi, %k1
; CHECK-ICX-BYPASS-DELAY-NEXT:    vunpckhpd {{.*#+}} ymm0 {%k1} {z} = ymm0[1],mem[1],ymm0[3],mem[3]
; CHECK-ICX-BYPASS-DELAY-NEXT:    retq
;
; CHECK-V4-LABEL: transform_VUNPCKHPDYrmkz:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    kmovd %esi, %k1
; CHECK-V4-NEXT:    vunpckhpd {{.*#+}} ymm0 {%k1} {z} = ymm0[1],mem[1],ymm0[3],mem[3]
; CHECK-V4-NEXT:    retq
;
; CHECK-AVX512-LABEL: transform_VUNPCKHPDYrmkz:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    kmovd %esi, %k1
; CHECK-AVX512-NEXT:    vunpckhpd {{.*#+}} ymm0 {%k1} {z} = ymm0[1],mem[1],ymm0[3],mem[3]
; CHECK-AVX512-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: transform_VUNPCKHPDYrmkz:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    kmovd %esi, %k1
; CHECK-ZNVER4-NEXT:    vunpckhpd {{.*#+}} ymm0 {%k1} {z} = ymm0[1],mem[1],ymm0[3],mem[3]
; CHECK-ZNVER4-NEXT:    retq
  %mask = bitcast i4 %mask_int to <4 x i1>
  %b = load <4 x double>, ptr %pb
  %shufp = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 1, i32 5, i32 3, i32 7>
  %res = select <4 x i1> %mask, <4 x double> %shufp, <4 x double> zeroinitializer
  ret <4 x double> %res
}

define <2 x double> @transform_VUNPCKLPDrmkz(<2 x double> %a, ptr %pb, i2 %mask_int) nounwind {
; CHECK-SKX-LABEL: transform_VUNPCKLPDrmkz:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    kmovd %esi, %k1
; CHECK-SKX-NEXT:    vunpcklpd {{.*#+}} xmm0 {%k1} {z} = xmm0[0],mem[0]
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-NO-BYPASS-DELAY-LABEL: transform_VUNPCKLPDrmkz:
; CHECK-ICX-NO-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    kmovd %esi, %k1
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vpunpcklqdq {{.*#+}} xmm0 {%k1} {z} = xmm0[0],mem[0]
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    retq
;
; CHECK-ICX-BYPASS-DELAY-LABEL: transform_VUNPCKLPDrmkz:
; CHECK-ICX-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-BYPASS-DELAY-NEXT:    kmovd %esi, %k1
; CHECK-ICX-BYPASS-DELAY-NEXT:    vunpcklpd {{.*#+}} xmm0 {%k1} {z} = xmm0[0],mem[0]
; CHECK-ICX-BYPASS-DELAY-NEXT:    retq
;
; CHECK-V4-LABEL: transform_VUNPCKLPDrmkz:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    kmovd %esi, %k1
; CHECK-V4-NEXT:    vunpcklpd {{.*#+}} xmm0 {%k1} {z} = xmm0[0],mem[0]
; CHECK-V4-NEXT:    retq
;
; CHECK-AVX512-LABEL: transform_VUNPCKLPDrmkz:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    kmovd %esi, %k1
; CHECK-AVX512-NEXT:    vunpcklpd {{.*#+}} xmm0 {%k1} {z} = xmm0[0],mem[0]
; CHECK-AVX512-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: transform_VUNPCKLPDrmkz:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    kmovd %esi, %k1
; CHECK-ZNVER4-NEXT:    vunpcklpd {{.*#+}} xmm0 {%k1} {z} = xmm0[0],mem[0]
; CHECK-ZNVER4-NEXT:    retq
  %mask = bitcast i2 %mask_int to <2 x i1>
  %b = load <2 x double>, ptr %pb
  %shufp = shufflevector <2 x double> %a, <2 x double> %b, <2 x i32> <i32 0, i32 2>
  %res = select <2 x i1> %mask, <2 x double> %shufp, <2 x double> zeroinitializer
  ret <2 x double> %res
}

define <2 x double> @transform_VUNPCKHPDrmkz(<2 x double> %a, ptr %pb, i2 %mask_int) nounwind {
; CHECK-SKX-LABEL: transform_VUNPCKHPDrmkz:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    kmovd %esi, %k1
; CHECK-SKX-NEXT:    vunpckhpd {{.*#+}} xmm0 {%k1} {z} = xmm0[1],mem[1]
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-NO-BYPASS-DELAY-LABEL: transform_VUNPCKHPDrmkz:
; CHECK-ICX-NO-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    kmovd %esi, %k1
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vpunpckhqdq {{.*#+}} xmm0 {%k1} {z} = xmm0[1],mem[1]
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    retq
;
; CHECK-ICX-BYPASS-DELAY-LABEL: transform_VUNPCKHPDrmkz:
; CHECK-ICX-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-BYPASS-DELAY-NEXT:    kmovd %esi, %k1
; CHECK-ICX-BYPASS-DELAY-NEXT:    vunpckhpd {{.*#+}} xmm0 {%k1} {z} = xmm0[1],mem[1]
; CHECK-ICX-BYPASS-DELAY-NEXT:    retq
;
; CHECK-V4-LABEL: transform_VUNPCKHPDrmkz:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    kmovd %esi, %k1
; CHECK-V4-NEXT:    vunpckhpd {{.*#+}} xmm0 {%k1} {z} = xmm0[1],mem[1]
; CHECK-V4-NEXT:    retq
;
; CHECK-AVX512-LABEL: transform_VUNPCKHPDrmkz:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    kmovd %esi, %k1
; CHECK-AVX512-NEXT:    vunpckhpd {{.*#+}} xmm0 {%k1} {z} = xmm0[1],mem[1]
; CHECK-AVX512-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: transform_VUNPCKHPDrmkz:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    kmovd %esi, %k1
; CHECK-ZNVER4-NEXT:    vunpckhpd {{.*#+}} xmm0 {%k1} {z} = xmm0[1],mem[1]
; CHECK-ZNVER4-NEXT:    retq
  %mask = bitcast i2 %mask_int to <2 x i1>
  %b = load <2 x double>, ptr %pb
  %shufp = shufflevector <2 x double> %a, <2 x double> %b, <2 x i32> <i32 1, i32 3>
  %res = select <2 x i1> %mask, <2 x double> %shufp, <2 x double> zeroinitializer
  ret <2 x double> %res
}

define <8 x double> @transform_VUNPCKLPDZrmk(<8 x double> %a, ptr %pb, <8 x double> %c, i8 %mask_int) nounwind {
; CHECK-LABEL: transform_VUNPCKLPDZrmk:
; CHECK:       # %bb.0:
; CHECK-NEXT:    kmovd %esi, %k1
; CHECK-NEXT:    vunpcklpd {{.*#+}} zmm1 {%k1} = zmm0[0],mem[0],zmm0[2],mem[2],zmm0[4],mem[4],zmm0[6],mem[6]
; CHECK-NEXT:    vmovapd %zmm1, %zmm0
; CHECK-NEXT:    retq
  %mask = bitcast i8 %mask_int to <8 x i1>
  %b = load <8 x double>, ptr %pb
  %shufp = shufflevector <8 x double> %a, <8 x double> %b, <8 x i32> <i32 0, i32 8, i32 2, i32 10, i32 4, i32 12, i32 6, i32 14>
  %res = select <8 x i1> %mask, <8 x double> %shufp, <8 x double> %c
  ret <8 x double> %res
}

define <8 x double> @transform_VUNPCKHPDZrmk(<8 x double> %a, ptr %pb, <8 x double> %c, i8 %mask_int) nounwind {
; CHECK-LABEL: transform_VUNPCKHPDZrmk:
; CHECK:       # %bb.0:
; CHECK-NEXT:    kmovd %esi, %k1
; CHECK-NEXT:    vunpckhpd {{.*#+}} zmm1 {%k1} = zmm0[1],mem[1],zmm0[3],mem[3],zmm0[5],mem[5],zmm0[7],mem[7]
; CHECK-NEXT:    vmovapd %zmm1, %zmm0
; CHECK-NEXT:    retq
  %mask = bitcast i8 %mask_int to <8 x i1>
  %b = load <8 x double>, ptr %pb
  %shufp = shufflevector <8 x double> %a, <8 x double> %b, <8 x i32> <i32 1, i32 9, i32 3, i32 11, i32 5, i32 13, i32 7, i32 15>
  %res = select <8 x i1> %mask, <8 x double> %shufp, <8 x double> %c
  ret <8 x double> %res
}

define <4 x double> @transform_VUNPCKLPDYrmk(<4 x double> %a, ptr %pb, <4 x double> %c, i4 %mask_int) nounwind {
; CHECK-SKX-LABEL: transform_VUNPCKLPDYrmk:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    kmovd %esi, %k1
; CHECK-SKX-NEXT:    vunpcklpd {{.*#+}} ymm1 {%k1} = ymm0[0],mem[0],ymm0[2],mem[2]
; CHECK-SKX-NEXT:    vmovapd %ymm1, %ymm0
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-NO-BYPASS-DELAY-LABEL: transform_VUNPCKLPDYrmk:
; CHECK-ICX-NO-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    kmovd %esi, %k1
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vpunpcklqdq {{.*#+}} ymm1 {%k1} = ymm0[0],mem[0],ymm0[2],mem[2]
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vmovapd %ymm1, %ymm0
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    retq
;
; CHECK-ICX-BYPASS-DELAY-LABEL: transform_VUNPCKLPDYrmk:
; CHECK-ICX-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-BYPASS-DELAY-NEXT:    kmovd %esi, %k1
; CHECK-ICX-BYPASS-DELAY-NEXT:    vunpcklpd {{.*#+}} ymm1 {%k1} = ymm0[0],mem[0],ymm0[2],mem[2]
; CHECK-ICX-BYPASS-DELAY-NEXT:    vmovapd %ymm1, %ymm0
; CHECK-ICX-BYPASS-DELAY-NEXT:    retq
;
; CHECK-V4-LABEL: transform_VUNPCKLPDYrmk:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    kmovd %esi, %k1
; CHECK-V4-NEXT:    vunpcklpd {{.*#+}} ymm1 {%k1} = ymm0[0],mem[0],ymm0[2],mem[2]
; CHECK-V4-NEXT:    vmovapd %ymm1, %ymm0
; CHECK-V4-NEXT:    retq
;
; CHECK-AVX512-LABEL: transform_VUNPCKLPDYrmk:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    kmovd %esi, %k1
; CHECK-AVX512-NEXT:    vunpcklpd {{.*#+}} ymm1 {%k1} = ymm0[0],mem[0],ymm0[2],mem[2]
; CHECK-AVX512-NEXT:    vmovapd %ymm1, %ymm0
; CHECK-AVX512-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: transform_VUNPCKLPDYrmk:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    kmovd %esi, %k1
; CHECK-ZNVER4-NEXT:    vunpcklpd {{.*#+}} ymm1 {%k1} = ymm0[0],mem[0],ymm0[2],mem[2]
; CHECK-ZNVER4-NEXT:    vmovapd %ymm1, %ymm0
; CHECK-ZNVER4-NEXT:    retq
  %mask = bitcast i4 %mask_int to <4 x i1>
  %b = load <4 x double>, ptr %pb
  %shufp = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 0, i32 4, i32 2, i32 6>
  %res = select <4 x i1> %mask, <4 x double> %shufp, <4 x double> %c
  ret <4 x double> %res
}

define <4 x double> @transform_VUNPCKHPDYrmk(<4 x double> %a, ptr %pb, <4 x double> %c, i4 %mask_int) nounwind {
; CHECK-SKX-LABEL: transform_VUNPCKHPDYrmk:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    kmovd %esi, %k1
; CHECK-SKX-NEXT:    vunpckhpd {{.*#+}} ymm1 {%k1} = ymm0[1],mem[1],ymm0[3],mem[3]
; CHECK-SKX-NEXT:    vmovapd %ymm1, %ymm0
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-NO-BYPASS-DELAY-LABEL: transform_VUNPCKHPDYrmk:
; CHECK-ICX-NO-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    kmovd %esi, %k1
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vpunpckhqdq {{.*#+}} ymm1 {%k1} = ymm0[1],mem[1],ymm0[3],mem[3]
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vmovapd %ymm1, %ymm0
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    retq
;
; CHECK-ICX-BYPASS-DELAY-LABEL: transform_VUNPCKHPDYrmk:
; CHECK-ICX-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-BYPASS-DELAY-NEXT:    kmovd %esi, %k1
; CHECK-ICX-BYPASS-DELAY-NEXT:    vunpckhpd {{.*#+}} ymm1 {%k1} = ymm0[1],mem[1],ymm0[3],mem[3]
; CHECK-ICX-BYPASS-DELAY-NEXT:    vmovapd %ymm1, %ymm0
; CHECK-ICX-BYPASS-DELAY-NEXT:    retq
;
; CHECK-V4-LABEL: transform_VUNPCKHPDYrmk:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    kmovd %esi, %k1
; CHECK-V4-NEXT:    vunpckhpd {{.*#+}} ymm1 {%k1} = ymm0[1],mem[1],ymm0[3],mem[3]
; CHECK-V4-NEXT:    vmovapd %ymm1, %ymm0
; CHECK-V4-NEXT:    retq
;
; CHECK-AVX512-LABEL: transform_VUNPCKHPDYrmk:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    kmovd %esi, %k1
; CHECK-AVX512-NEXT:    vunpckhpd {{.*#+}} ymm1 {%k1} = ymm0[1],mem[1],ymm0[3],mem[3]
; CHECK-AVX512-NEXT:    vmovapd %ymm1, %ymm0
; CHECK-AVX512-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: transform_VUNPCKHPDYrmk:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    kmovd %esi, %k1
; CHECK-ZNVER4-NEXT:    vunpckhpd {{.*#+}} ymm1 {%k1} = ymm0[1],mem[1],ymm0[3],mem[3]
; CHECK-ZNVER4-NEXT:    vmovapd %ymm1, %ymm0
; CHECK-ZNVER4-NEXT:    retq
  %mask = bitcast i4 %mask_int to <4 x i1>
  %b = load <4 x double>, ptr %pb
  %shufp = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 1, i32 5, i32 3, i32 7>
  %res = select <4 x i1> %mask, <4 x double> %shufp, <4 x double> %c
  ret <4 x double> %res
}

define <2 x double> @transform_VUNPCKLPDrmk(<2 x double> %a, ptr %pb, <2 x double> %c, i2 %mask_int) nounwind {
; CHECK-SKX-LABEL: transform_VUNPCKLPDrmk:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    kmovd %esi, %k1
; CHECK-SKX-NEXT:    vunpcklpd {{.*#+}} xmm1 {%k1} = xmm0[0],mem[0]
; CHECK-SKX-NEXT:    vmovapd %xmm1, %xmm0
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-NO-BYPASS-DELAY-LABEL: transform_VUNPCKLPDrmk:
; CHECK-ICX-NO-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    kmovd %esi, %k1
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vpunpcklqdq {{.*#+}} xmm1 {%k1} = xmm0[0],mem[0]
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vmovapd %xmm1, %xmm0
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    retq
;
; CHECK-ICX-BYPASS-DELAY-LABEL: transform_VUNPCKLPDrmk:
; CHECK-ICX-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-BYPASS-DELAY-NEXT:    kmovd %esi, %k1
; CHECK-ICX-BYPASS-DELAY-NEXT:    vunpcklpd {{.*#+}} xmm1 {%k1} = xmm0[0],mem[0]
; CHECK-ICX-BYPASS-DELAY-NEXT:    vmovapd %xmm1, %xmm0
; CHECK-ICX-BYPASS-DELAY-NEXT:    retq
;
; CHECK-V4-LABEL: transform_VUNPCKLPDrmk:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    kmovd %esi, %k1
; CHECK-V4-NEXT:    vunpcklpd {{.*#+}} xmm1 {%k1} = xmm0[0],mem[0]
; CHECK-V4-NEXT:    vmovapd %xmm1, %xmm0
; CHECK-V4-NEXT:    retq
;
; CHECK-AVX512-LABEL: transform_VUNPCKLPDrmk:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    kmovd %esi, %k1
; CHECK-AVX512-NEXT:    vunpcklpd {{.*#+}} xmm1 {%k1} = xmm0[0],mem[0]
; CHECK-AVX512-NEXT:    vmovapd %xmm1, %xmm0
; CHECK-AVX512-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: transform_VUNPCKLPDrmk:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    kmovd %esi, %k1
; CHECK-ZNVER4-NEXT:    vunpcklpd {{.*#+}} xmm1 {%k1} = xmm0[0],mem[0]
; CHECK-ZNVER4-NEXT:    vmovapd %xmm1, %xmm0
; CHECK-ZNVER4-NEXT:    retq
  %mask = bitcast i2 %mask_int to <2 x i1>
  %b = load <2 x double>, ptr %pb
  %shufp = shufflevector <2 x double> %a, <2 x double> %b, <2 x i32> <i32 0, i32 2>
  %res = select <2 x i1> %mask, <2 x double> %shufp, <2 x double> %c
  ret <2 x double> %res
}

define <2 x double> @transform_VUNPCKHPDrmk(<2 x double> %a, ptr %pb, <2 x double> %c, i2 %mask_int) nounwind {
; CHECK-SKX-LABEL: transform_VUNPCKHPDrmk:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    kmovd %esi, %k1
; CHECK-SKX-NEXT:    vunpckhpd {{.*#+}} xmm1 {%k1} = xmm0[1],mem[1]
; CHECK-SKX-NEXT:    vmovapd %xmm1, %xmm0
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-NO-BYPASS-DELAY-LABEL: transform_VUNPCKHPDrmk:
; CHECK-ICX-NO-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    kmovd %esi, %k1
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vpunpckhqdq {{.*#+}} xmm1 {%k1} = xmm0[1],mem[1]
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    vmovapd %xmm1, %xmm0
; CHECK-ICX-NO-BYPASS-DELAY-NEXT:    retq
;
; CHECK-ICX-BYPASS-DELAY-LABEL: transform_VUNPCKHPDrmk:
; CHECK-ICX-BYPASS-DELAY:       # %bb.0:
; CHECK-ICX-BYPASS-DELAY-NEXT:    kmovd %esi, %k1
; CHECK-ICX-BYPASS-DELAY-NEXT:    vunpckhpd {{.*#+}} xmm1 {%k1} = xmm0[1],mem[1]
; CHECK-ICX-BYPASS-DELAY-NEXT:    vmovapd %xmm1, %xmm0
; CHECK-ICX-BYPASS-DELAY-NEXT:    retq
;
; CHECK-V4-LABEL: transform_VUNPCKHPDrmk:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    kmovd %esi, %k1
; CHECK-V4-NEXT:    vunpckhpd {{.*#+}} xmm1 {%k1} = xmm0[1],mem[1]
; CHECK-V4-NEXT:    vmovapd %xmm1, %xmm0
; CHECK-V4-NEXT:    retq
;
; CHECK-AVX512-LABEL: transform_VUNPCKHPDrmk:
; CHECK-AVX512:       # %bb.0:
; CHECK-AVX512-NEXT:    kmovd %esi, %k1
; CHECK-AVX512-NEXT:    vunpckhpd {{.*#+}} xmm1 {%k1} = xmm0[1],mem[1]
; CHECK-AVX512-NEXT:    vmovapd %xmm1, %xmm0
; CHECK-AVX512-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: transform_VUNPCKHPDrmk:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    kmovd %esi, %k1
; CHECK-ZNVER4-NEXT:    vunpckhpd {{.*#+}} xmm1 {%k1} = xmm0[1],mem[1]
; CHECK-ZNVER4-NEXT:    vmovapd %xmm1, %xmm0
; CHECK-ZNVER4-NEXT:    retq
  %mask = bitcast i2 %mask_int to <2 x i1>
  %b = load <2 x double>, ptr %pb
  %shufp = shufflevector <2 x double> %a, <2 x double> %b, <2 x i32> <i32 1, i32 3>
  %res = select <2 x i1> %mask, <2 x double> %shufp, <2 x double> %c
  ret <2 x double> %res
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK-ICX: {{.*}}
