; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=licm < %s | FileCheck %s
; RUN: opt -aa-pipeline=basic-aa -passes='require<aa>,require<target-ir>,require<scalar-evolution>,require<opt-remark-emit>,loop-mssa(licm)' -S %s| FileCheck %s
;
; Manually validate LCSSA form is preserved even after SSAUpdater is used to
; promote things in the loop bodies.

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

@x = common global i32 0, align 4
@y = common global i32 0, align 4

define void @PR18688(i1 %arg) {
; CHECK-LABEL: @PR18688(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[ARG:%.*]], label [[RETURN:%.*]], label [[OUTER_PREHEADER:%.*]]
; CHECK:       outer.preheader:
; CHECK-NEXT:    [[Y_VAL:%.*]] = load i32, ptr @y, align 4
; CHECK-NEXT:    [[ICMP:%.*]] = icmp eq i32 [[Y_VAL]], 0
; CHECK-NEXT:    br label [[OUTER_HEADER:%.*]]
; CHECK:       outer.header:
; CHECK-NEXT:    br i1 [[ARG]], label [[OUTER_LATCH:%.*]], label [[INNER_PREHEADER:%.*]]
; CHECK:       inner.preheader:
; CHECK-NEXT:    br label [[INNER_HEADER:%.*]]
; CHECK:       inner.header:
; CHECK-NEXT:    [[TMP0:%.*]] = phi i32 [ [[TMP1:%.*]], [[INNER_LATCH:%.*]] ], [ 0, [[INNER_PREHEADER]] ]
; CHECK-NEXT:    br i1 [[ARG]], label [[INNER_BODY_RHS:%.*]], label [[INNER_LATCH]]
; CHECK:       inner.body.rhs:
; CHECK-NEXT:    br label [[INNER_LATCH]]
; CHECK:       inner.latch:
; CHECK-NEXT:    [[TMP1]] = phi i32 [ 0, [[INNER_BODY_RHS]] ], [ [[TMP0]], [[INNER_HEADER]] ]
; CHECK-NEXT:    br i1 [[ICMP]], label [[INNER_EXIT:%.*]], label [[INNER_HEADER]]
; CHECK:       inner.exit:
; CHECK-NEXT:    [[DOTLCSSA1:%.*]] = phi i32 [ [[TMP1]], [[INNER_LATCH]] ]
; CHECK-NEXT:    br label [[OUTER_LATCH]]
; CHECK:       outer.latch:
; CHECK-NEXT:    [[TMP2:%.*]] = phi i32 [ [[DOTLCSSA1]], [[INNER_EXIT]] ], [ 0, [[OUTER_HEADER]] ]
; CHECK-NEXT:    br i1 [[ARG]], label [[OUTER_EXIT:%.*]], label [[OUTER_HEADER]]
; CHECK:       outer.exit:
; CHECK-NEXT:    [[DOTLCSSA:%.*]] = phi i32 [ [[TMP2]], [[OUTER_LATCH]] ]
; CHECK-NEXT:    store i32 [[DOTLCSSA]], ptr @x, align 4
; CHECK-NEXT:    br label [[RETURN]]
; CHECK:       return:
; CHECK-NEXT:    ret void
;

entry:
  br i1 %arg, label %return, label %outer.preheader

outer.preheader:
  br label %outer.header

outer.header:
  store i32 0, ptr @x, align 4
  br i1 %arg, label %outer.latch, label %inner.preheader

inner.preheader:
  br label %inner.header

inner.header:
  br i1 %arg, label %inner.body.rhs, label %inner.latch

inner.body.rhs:
  store i32 0, ptr @x, align 4
  br label %inner.latch

inner.latch:
  %y_val = load i32, ptr @y, align 4
  %icmp = icmp eq i32 %y_val, 0
  br i1 %icmp, label %inner.exit, label %inner.header

inner.exit:
  br label %outer.latch

outer.latch:
  br i1 %arg, label %outer.exit, label %outer.header

outer.exit:
  br label %return

return:
  ret void
}

