; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; Test lib call simplification of __strncpy_chk calls with various values
; for len and dstlen.
;
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

target datalayout = "e-p:32:32:32-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-f32:32:32-f64:32:64-v64:64:64-v128:128:128-a0:0:64-f80:128:128"

@a = common global [60 x i8] zeroinitializer, align 1
@b = common global [60 x i8] zeroinitializer, align 1
@.str = private constant [12 x i8] c"abcdefghijk\00"

; Check cases where dstlen >= len

define ptr @test_simplify1() {
; CHECK-LABEL: @test_simplify1(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr noundef nonnull align 1 dereferenceable(12) @a, ptr noundef nonnull align 1 dereferenceable(12) @.str, i32 12, i1 false)
; CHECK-NEXT:    ret ptr @a
;

  %ret = call ptr @__strncpy_chk(ptr @a, ptr @.str, i32 12, i32 60)
  ret ptr %ret
}

define ptr @test_simplify2() {
; CHECK-LABEL: @test_simplify2(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr noundef nonnull align 1 dereferenceable(12) @a, ptr noundef nonnull align 1 dereferenceable(12) @.str, i32 12, i1 false)
; CHECK-NEXT:    ret ptr @a
;

  %ret = call ptr @__strncpy_chk(ptr @a, ptr @.str, i32 12, i32 12)
  ret ptr %ret
}

define ptr @test_simplify3() {
; CHECK-LABEL: @test_simplify3(
; CHECK-NEXT:    [[STRNCPY:%.*]] = call ptr @strncpy(ptr noundef nonnull dereferenceable(1) @a, ptr noundef nonnull dereferenceable(1) @b, i32 12)
; CHECK-NEXT:    ret ptr @a
;

  %ret = call ptr @__strncpy_chk(ptr @a, ptr @b, i32 12, i32 60)
  ret ptr %ret
}

; Check cases where dstlen < len

define ptr @test_no_simplify1() {
; CHECK-LABEL: @test_no_simplify1(
; CHECK-NEXT:    [[RET:%.*]] = call ptr @__strncpy_chk(ptr nonnull @a, ptr nonnull @.str, i32 8, i32 4)
; CHECK-NEXT:    ret ptr [[RET]]
;

  %ret = call ptr @__strncpy_chk(ptr @a, ptr @.str, i32 8, i32 4)
  ret ptr %ret
}

define ptr @test_no_simplify2() {
; CHECK-LABEL: @test_no_simplify2(
; CHECK-NEXT:    [[RET:%.*]] = call ptr @__strncpy_chk(ptr nonnull @a, ptr nonnull @b, i32 8, i32 0)
; CHECK-NEXT:    ret ptr [[RET]]
;

  %ret = call ptr @__strncpy_chk(ptr @a, ptr @b, i32 8, i32 0)
  ret ptr %ret
}

declare ptr @__strncpy_chk(ptr, ptr, i32, i32)
