; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --scrub-attributes
; RUN: opt -S -passes=inline < %s | FileCheck %s

;; Check that we correctly use the index size when accumulating offsets during CallPromotion

target datalayout = "p200:128:128:128:64-A200-P200-G200"

define void @test(ptr addrspace(200) %arg1, ptr addrspace(200) %arg2) local_unnamed_addr addrspace(200) {
; CHECK-LABEL: define {{[^@]+}}@test
; CHECK-SAME: (ptr addrspace(200) [[ARG1:%.*]], ptr addrspace(200) [[ARG2:%.*]]) local_unnamed_addr addrspace(200) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load ptr addrspace(200), ptr addrspace(200) [[ARG2]], align 16
; CHECK-NEXT:    call addrspace(200) void [[TMP0]](ptr addrspace(200) [[ARG1]])
; CHECK-NEXT:    ret void
;
entry:
  call void @call_fnptr(ptr addrspace(200) %arg1, ptr addrspace(200) %arg2)
  ret void
}

define internal void @call_fnptr(ptr addrspace(200) %this, ptr addrspace(200) %arg) unnamed_addr addrspace(200) align 2 {
entry:
  %0 = load ptr addrspace(200), ptr addrspace(200) %arg, align 16
  call void %0(ptr addrspace(200) %this)
  ret void
}

define void @test2(ptr addrspace(200) %this) local_unnamed_addr addrspace(200) {
; CHECK-LABEL: define {{[^@]+}}@test2
; CHECK-SAME: (ptr addrspace(200) [[THIS:%.*]]) local_unnamed_addr addrspace(200) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[VTABLE_I:%.*]] = load ptr addrspace(200), ptr addrspace(200) [[THIS]], align 16
; CHECK-NEXT:    [[FN_I:%.*]] = load ptr addrspace(200), ptr addrspace(200) [[VTABLE_I]], align 16
; CHECK-NEXT:    call addrspace(200) void [[FN_I]](ptr addrspace(200) [[THIS]])
; CHECK-NEXT:    ret void
;
entry:
  call void @call_via_vtable(ptr addrspace(200) %this)
  ret void
}

define internal void @call_via_vtable(ptr addrspace(200) %this) unnamed_addr addrspace(200) {
entry:
  %vtable = load ptr addrspace(200), ptr addrspace(200) %this, align 16
  %fn = load ptr addrspace(200), ptr addrspace(200) %vtable, align 16
  call void %fn(ptr addrspace(200) %this)
  ret void
}
