; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt -disable-output "-passes=print<scalar-evolution>" < %s 2>&1 | FileCheck %s

; In this case the %iv2 addrec is calculated and added to the value map in a
; recursive call trying to calculate that same addrec. Due to lazy nowrap flag
; inference, the exact SCEV calculated both times ends up being different,
; though both expressions are correct. Make sure we don't assert in this case.

define void @test(ptr %p) {
; CHECK-LABEL: 'test'
; CHECK-NEXT:  Classifying expressions for: @test
; CHECK-NEXT:    %iv = phi i32 [ 0, %entry ], [ %iv.next, %loop.latch ]
; CHECK-NEXT:    --> %iv U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop.header: Variant, %loop2: Invariant, %loop3: Invariant }
; CHECK-NEXT:    %iv2 = phi i32 [ %iv, %loop.header ], [ %iv2.next, %loop2 ]
; CHECK-NEXT:    --> {%iv,+,1}<%loop2> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop2: Computable, %loop.header: Variant }
; CHECK-NEXT:    %iv2.next = add i32 %iv2, 1
; CHECK-NEXT:    --> {(1 + %iv),+,1}<%loop2> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop2: Computable, %loop.header: Variant }
; CHECK-NEXT:    %v = load i32, ptr %p, align 4
; CHECK-NEXT:    --> %v U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop2: Variant, %loop.header: Variant }
; CHECK-NEXT:    %iv2.ext = sext i32 %iv2 to i64
; CHECK-NEXT:    --> (sext i32 {%iv,+,1}<%loop2> to i64) U: [-2147483648,2147483648) S: [-2147483648,2147483648) Exits: <<Unknown>> LoopDispositions: { %loop.header: Variant, %loop2: Computable, %loop3: Invariant }
; CHECK-NEXT:    %iv3 = phi i64 [ %iv2.ext, %loop2.end ], [ %iv3.next, %loop3 ]
; CHECK-NEXT:    --> {(sext i32 {%iv,+,1}<%loop2> to i64),+,1}<nsw><%loop3> U: [-2147483648,2147483648) S: [-2147483648,2147483648) Exits: (sext i32 {%iv,+,1}<%loop2> to i64) LoopDispositions: { %loop3: Computable, %loop.header: Variant }
; CHECK-NEXT:    %iv3.next = add nsw i64 %iv3, 1
; CHECK-NEXT:    --> {(1 + (sext i32 {%iv,+,1}<%loop2> to i64))<nsw>,+,1}<nsw><%loop3> U: [-2147483647,2147483649) S: [-2147483647,2147483649) Exits: (1 + (sext i32 {%iv,+,1}<%loop2> to i64))<nsw> LoopDispositions: { %loop3: Computable, %loop.header: Variant }
; CHECK-NEXT:    %iv.next = trunc i64 %iv3 to i32
; CHECK-NEXT:    --> {{\{\{}}%iv,+,1}<%loop2>,+,1}<%loop3> U: full-set S: full-set --> {%iv,+,1}<%loop2> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop.header: Variant, %loop2: Variant, %loop3: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test
; CHECK-NEXT:  Loop %loop2: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop2: constant max backedge-taken count is i32 -1
; CHECK-NEXT:  Loop %loop2: symbolic max backedge-taken count is i32 -1
; CHECK-NEXT:  Loop %loop3: backedge-taken count is i1 false
; CHECK-NEXT:  Loop %loop3: constant max backedge-taken count is i1 false
; CHECK-NEXT:  Loop %loop3: symbolic max backedge-taken count is i1 false
; CHECK-NEXT:  Loop %loop3: Trip multiple is 1
; CHECK-NEXT:  Loop %loop.header: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop.header: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop.header: Unpredictable symbolic max backedge-taken count.
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i32 [ 0, %entry ], [ %iv.next, %loop.latch ]
  br label %loop2

loop2:
  %iv2 = phi i32 [ %iv, %loop.header ], [ %iv2.next, %loop2 ]
  %iv2.next = add i32 %iv2, 1
  %v = load i32, ptr %p
  %cmp = icmp slt i32 %iv2, %v
  br i1 %cmp, label %loop2, label %loop2.end

loop2.end:
  %iv2.ext = sext i32 %iv2 to i64
  br label %loop3

loop3:
  %iv3 = phi i64 [ %iv2.ext, %loop2.end ], [ %iv3.next, %loop3 ]
  %iv3.next = add nsw i64 %iv3, 1
  br i1 false, label %loop3, label %loop.latch

loop.latch:
  %iv.next = trunc i64 %iv3 to i32
  br label %loop.header
}
