/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                         GNAT COMPILER COMPONENTS                         */
/*                                                                          */
/*                                E I N F O                                 */
/*                                                                          */
/*                              C Header File                               */
/*                                                                          */
/*          Copyright (C) 1992-2016, Free Software Foundation, Inc.         */
/*                                                                          */
/* GNAT is free software;  you can  redistribute it  and/or modify it under */
/* terms of the  GNU General Public License as published  by the Free Soft- */
/* ware  Foundation;  either version 3,  or (at your option) any later ver- */
/* sion.  GNAT is distributed in the hope that it will be useful, but WITH- */
/* OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE.                                     */
/*                                                                          */
/* As a special exception under Section 7 of GPL version 3, you are granted */
/* additional permissions described in the GCC Runtime Library Exception,   */
/* version 3.1, as published by the Free Software Foundation.               */
/*                                                                          */
/* You should have received a copy of the GNU General Public License and    */
/* a copy of the GCC Runtime Library Exception along with this program;     */
/* see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    */
/* <http://www.gnu.org/licenses/>.                                          */
/*                                                                          */
/* GNAT was originally developed  by the GNAT team at  New York University. */
/* Extensive contributions were provided by Ada Core Technologies Inc.      */
/*                                                                          */
/*--------------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif
   #define E_Void                           0
   #define E_Component                      1
   #define E_Constant                       2
   #define E_Discriminant                   3
   #define E_Loop_Parameter                 4
   #define E_Variable                       5
   #define E_Out_Parameter                  6
   #define E_In_Out_Parameter               7
   #define E_In_Parameter                   8
   #define E_Generic_In_Out_Parameter       9
   #define E_Generic_In_Parameter           10
   #define E_Named_Integer                  11
   #define E_Named_Real                     12
   #define E_Enumeration_Type               13
   #define E_Enumeration_Subtype            14
   #define E_Signed_Integer_Type            15
   #define E_Signed_Integer_Subtype         16
   #define E_Modular_Integer_Type           17
   #define E_Modular_Integer_Subtype        18
   #define E_Ordinary_Fixed_Point_Type      19
   #define E_Ordinary_Fixed_Point_Subtype   20
   #define E_Decimal_Fixed_Point_Type       21
   #define E_Decimal_Fixed_Point_Subtype    22
   #define E_Floating_Point_Type            23
   #define E_Floating_Point_Subtype         24
   #define E_Access_Type                    25
   #define E_Access_Subtype                 26
   #define E_Access_Attribute_Type          27
   #define E_Allocator_Type                 28
   #define E_General_Access_Type            29
   #define E_Access_Subprogram_Type         30
   #define E_Anonymous_Access_Subprogram_Type 31
   #define E_Access_Protected_Subprogram_Type 32
   #define E_Anonymous_Access_Protected_Subprogram_Type 33
   #define E_Anonymous_Access_Type          34
   #define E_Array_Type                     35
   #define E_Array_Subtype                  36
   #define E_String_Literal_Subtype         37
   #define E_Class_Wide_Type                38
   #define E_Class_Wide_Subtype             39
   #define E_Record_Type                    40
   #define E_Record_Subtype                 41
   #define E_Record_Type_With_Private       42
   #define E_Record_Subtype_With_Private    43
   #define E_Private_Type                   44
   #define E_Private_Subtype                45
   #define E_Limited_Private_Type           46
   #define E_Limited_Private_Subtype        47
   #define E_Incomplete_Type                48
   #define E_Incomplete_Subtype             49
   #define E_Task_Type                      50
   #define E_Task_Subtype                   51
   #define E_Protected_Type                 52
   #define E_Protected_Subtype              53
   #define E_Exception_Type                 54
   #define E_Subprogram_Type                55
   #define E_Enumeration_Literal            56
   #define E_Function                       57
   #define E_Operator                       58
   #define E_Procedure                      59
   #define E_Abstract_State                 60
   #define E_Entry                          61
   #define E_Entry_Family                   62
   #define E_Block                          63
   #define E_Entry_Index_Parameter          64
   #define E_Exception                      65
   #define E_Generic_Function               66
   #define E_Generic_Procedure              67
   #define E_Generic_Package                68
   #define E_Label                          69
   #define E_Loop                           70
   #define E_Return_Statement               71
   #define E_Package                        72
   #define E_Package_Body                   73
   #define E_Protected_Object               74
   #define E_Protected_Body                 75
   #define E_Task_Body                      76
   #define E_Subprogram_Body                77

   SUBTYPE (Access_Kind, Entity_Kind, 
      E_Access_Type, E_Anonymous_Access_Type)

   SUBTYPE (Access_Subprogram_Kind, Entity_Kind, 
      E_Access_Subprogram_Type, E_Anonymous_Access_Protected_Subprogram_Type)

   SUBTYPE (Access_Protected_Kind, Entity_Kind, 
      E_Access_Protected_Subprogram_Type, E_Anonymous_Access_Protected_Subprogram_Type)

   SUBTYPE (Aggregate_Kind, Entity_Kind, 
      E_Array_Type, E_Record_Subtype)

   SUBTYPE (Array_Kind, Entity_Kind, 
      E_Array_Type, E_String_Literal_Subtype)

   SUBTYPE (Assignable_Kind, Entity_Kind, 
      E_Variable, E_In_Out_Parameter)

   SUBTYPE (Class_Wide_Kind, Entity_Kind, 
      E_Class_Wide_Type, E_Class_Wide_Subtype)

   SUBTYPE (Composite_Kind, Entity_Kind, 
      E_Array_Type, E_Protected_Subtype)

   SUBTYPE (Concurrent_Kind, Entity_Kind, 
      E_Task_Type, E_Protected_Subtype)

   SUBTYPE (Concurrent_Body_Kind, Entity_Kind, 
      E_Protected_Body, E_Task_Body)

   SUBTYPE (Decimal_Fixed_Point_Kind, Entity_Kind, 
      E_Decimal_Fixed_Point_Type, E_Decimal_Fixed_Point_Subtype)

   SUBTYPE (Digits_Kind, Entity_Kind, 
      E_Decimal_Fixed_Point_Type, E_Floating_Point_Subtype)

   SUBTYPE (Discrete_Kind, Entity_Kind, 
      E_Enumeration_Type, E_Modular_Integer_Subtype)

   SUBTYPE (Discrete_Or_Fixed_Point_Kind, Entity_Kind, 
      E_Enumeration_Type, E_Decimal_Fixed_Point_Subtype)

   SUBTYPE (Elementary_Kind, Entity_Kind, 
      E_Enumeration_Type, E_Anonymous_Access_Type)

   SUBTYPE (Enumeration_Kind, Entity_Kind, 
      E_Enumeration_Type, E_Enumeration_Subtype)

   SUBTYPE (Entry_Kind, Entity_Kind, 
      E_Entry, E_Entry_Family)

   SUBTYPE (Fixed_Point_Kind, Entity_Kind, 
      E_Ordinary_Fixed_Point_Type, E_Decimal_Fixed_Point_Subtype)

   SUBTYPE (Float_Kind, Entity_Kind, 
      E_Floating_Point_Type, E_Floating_Point_Subtype)

   SUBTYPE (Formal_Kind, Entity_Kind, 
      E_Out_Parameter, E_In_Parameter)

   SUBTYPE (Formal_Object_Kind, Entity_Kind, 
      E_Generic_In_Out_Parameter, E_Generic_In_Parameter)

   SUBTYPE (Generic_Subprogram_Kind, Entity_Kind, 
      E_Generic_Function, E_Generic_Procedure)

   SUBTYPE (Generic_Unit_Kind, Entity_Kind, 
      E_Generic_Function, E_Generic_Package)

   SUBTYPE (Incomplete_Kind, Entity_Kind, 
      E_Incomplete_Type, E_Incomplete_Subtype)

   SUBTYPE (Incomplete_Or_Private_Kind, Entity_Kind, 
      E_Record_Type_With_Private, E_Incomplete_Subtype)

   SUBTYPE (Integer_Kind, Entity_Kind, 
      E_Signed_Integer_Type, E_Modular_Integer_Subtype)

   SUBTYPE (Modular_Integer_Kind, Entity_Kind, 
      E_Modular_Integer_Type, E_Modular_Integer_Subtype)

   SUBTYPE (Named_Kind, Entity_Kind, 
      E_Named_Integer, E_Named_Real)

   SUBTYPE (Numeric_Kind, Entity_Kind, 
      E_Signed_Integer_Type, E_Floating_Point_Subtype)

   SUBTYPE (Object_Kind, Entity_Kind, 
      E_Component, E_Generic_In_Parameter)

   SUBTYPE (Ordinary_Fixed_Point_Kind, Entity_Kind, 
      E_Ordinary_Fixed_Point_Type, E_Ordinary_Fixed_Point_Subtype)

   SUBTYPE (Overloadable_Kind, Entity_Kind, 
      E_Enumeration_Literal, E_Entry)

   SUBTYPE (Private_Kind, Entity_Kind, 
      E_Record_Type_With_Private, E_Limited_Private_Subtype)

   SUBTYPE (Protected_Kind, Entity_Kind, 
      E_Protected_Type, E_Protected_Subtype)

   SUBTYPE (Real_Kind, Entity_Kind, 
      E_Ordinary_Fixed_Point_Type, E_Floating_Point_Subtype)

   SUBTYPE (Record_Kind, Entity_Kind, 
      E_Class_Wide_Type, E_Record_Subtype_With_Private)

   SUBTYPE (Scalar_Kind, Entity_Kind, 
      E_Enumeration_Type, E_Floating_Point_Subtype)

   SUBTYPE (Subprogram_Kind, Entity_Kind, 
      E_Function, E_Procedure)

   SUBTYPE (Signed_Integer_Kind, Entity_Kind, 
      E_Signed_Integer_Type, E_Signed_Integer_Subtype)

   SUBTYPE (Task_Kind, Entity_Kind, 
      E_Task_Type, E_Task_Subtype)

   SUBTYPE (Type_Kind, Entity_Kind, 
      E_Enumeration_Type, E_Subprogram_Type)

   typedef char Component_Alignment_Kind;
      #define Calign_Default           0
      #define Calign_Component_Size    1
      #define Calign_Component_Size_4  2
      #define Calign_Storage_Unit      3

   typedef char Float_Rep_Kind;
      #define IEEE_Binary              0
      #define AAMP                     1

   typedef Boolean B;
   typedef Component_Alignment_Kind C;
   typedef Entity_Id E;
   typedef Float_Rep_Kind F;
   typedef Mechanism_Type M;
   typedef Node_Id N;
   typedef Uint U;
   typedef Ureal R;
   typedef Elist_Id L;
   typedef List_Id S;

   INLINE L Abstract_States                     (E Id);
   INLINE L Accept_Address                      (E Id);
   INLINE L Access_Disp_Table                   (E Id);
   INLINE E Activation_Record_Component         (E Id);
   INLINE E Actual_Subtype                      (E Id);
   INLINE B Address_Taken                       (E Id);
   INLINE E Alias                               (E Id);
   INLINE U Alignment                           (E Id);
   INLINE E Anonymous_Designated_Type           (E Id);
   INLINE L Anonymous_Masters                   (E Id);
   INLINE E Anonymous_Object                    (E Id);
   INLINE E Associated_Entity                   (E Id);
   INLINE E Associated_Formal_Package           (E Id);
   INLINE N Associated_Node_For_Itype           (E Id);
   INLINE E Associated_Storage_Pool             (E Id);
   INLINE N Barrier_Function                    (E Id);
   INLINE N BIP_Initialization_Call             (E Id);
   INLINE N Block_Node                          (E Id);
   INLINE E Body_Entity                         (E Id);
   INLINE B Body_Needed_For_SAL                 (E Id);
   INLINE L Body_References                     (E Id);
   INLINE B C_Pass_By_Copy                      (E Id);
   INLINE B Can_Never_Be_Null                   (E Id);
   INLINE B Can_Use_Internal_Rep                (E Id);
   INLINE B Checks_May_Be_Suppressed            (E Id);
   INLINE S Class_Wide_Postconds                (E Id);
   INLINE S Class_Wide_Preconds                 (E Id);
   INLINE E Class_Wide_Type                     (E Id);
   INLINE E Cloned_Subtype                      (E Id);

   #define Component_Alignment einfo__component_alignment
   C Component_Alignment                 (E Id);

   INLINE U Component_Bit_Offset                (E Id);
   INLINE N Component_Clause                    (E Id);
   INLINE U Component_Size                      (E Id);
   INLINE E Component_Type                      (E Id);
   INLINE B Contains_Ignored_Ghost_Code         (E Id);
   INLINE N Contract                            (E Id);
   INLINE E Contract_Wrapper                    (E Id);
   INLINE E Corresponding_Concurrent_Type       (E Id);
   INLINE E Corresponding_Discriminant          (E Id);
   INLINE E Corresponding_Equality              (E Id);

   #define Corresponding_Function einfo__corresponding_function
   E Corresponding_Function              (E Id);

   #define Corresponding_Procedure einfo__corresponding_procedure
   E Corresponding_Procedure             (E Id);

   INLINE E Corresponding_Protected_Entry       (E Id);
   INLINE E Corresponding_Record_Type           (E Id);
   INLINE E Corresponding_Remote_Type           (E Id);
   INLINE E CR_Discriminant                     (E Id);
   INLINE E Current_Use_Clause                  (E Id);
   INLINE N Current_Value                       (E Id);
   INLINE B Debug_Info_Off                      (E Id);
   INLINE E Debug_Renaming_Link                 (E Id);
   INLINE N Default_Aspect_Component_Value      (E Id);
   INLINE N Default_Aspect_Value                (E Id);
   INLINE E Default_Expr_Function               (E Id);
   INLINE B Default_Expressions_Processed       (E Id);
   INLINE N Default_Value                       (E Id);
   INLINE B Delay_Cleanups                      (E Id);
   INLINE B Delay_Subprogram_Descriptors        (E Id);
   INLINE R Delta_Value                         (E Id);
   INLINE L Dependent_Instances                 (E Id);
   INLINE B Depends_On_Private                  (E Id);
   INLINE E Derived_Type_Link                   (E Id);
   INLINE U Digits_Value                        (E Id);
   INLINE L Direct_Primitive_Operations         (E Id);
   INLINE E Directly_Designated_Type            (E Id);
   INLINE B Disable_Controlled                  (E Id);
   INLINE B Discard_Names                       (E Id);
   INLINE E Discriminal                         (E Id);
   INLINE E Discriminal_Link                    (E Id);
   INLINE E Discriminant_Checking_Func          (E Id);
   INLINE L Discriminant_Constraint             (E Id);
   INLINE N Discriminant_Default_Value          (E Id);
   INLINE U Discriminant_Number                 (E Id);
   INLINE L Dispatch_Table_Wrappers             (E Id);
   INLINE U DT_Entry_Count                      (E Id);
   INLINE E DT_Offset_To_Top_Func               (E Id);
   INLINE U DT_Position                         (E Id);
   INLINE E DTC_Entity                          (E Id);
   INLINE B Elaborate_Body_Desirable            (E Id);
   INLINE E Elaboration_Entity                  (E Id);
   INLINE B Elaboration_Entity_Required         (E Id);
   INLINE E Encapsulating_State                 (E Id);
   INLINE E Enclosing_Scope                     (E Id);
   INLINE B Entry_Accepted                      (E Id);
   INLINE E Entry_Bodies_Array                  (E Id);
   INLINE E Entry_Cancel_Parameter              (E Id);
   INLINE E Entry_Component                     (E Id);
   INLINE E Entry_Formal                        (E Id);
   INLINE E Entry_Index_Constant                (E Id);
   INLINE E Entry_Index_Type                    (E Id);

   #define Entry_Max_Queue_Lengths_Array einfo__entry_max_queue_lengths_array
   E Entry_Max_Queue_Lengths_Array       (E Id);

   INLINE E Entry_Parameters_Type               (E Id);
   INLINE E Enum_Pos_To_Rep                     (E Id);
   INLINE U Enumeration_Pos                     (E Id);
   INLINE U Enumeration_Rep                     (E Id);
   INLINE N Enumeration_Rep_Expr                (E Id);
   INLINE E Equivalent_Type                     (E Id);
   INLINE U Esize                               (E Id);
   INLINE E Extra_Accessibility                 (E Id);
   INLINE E Extra_Accessibility_Of_Result       (E Id);
   INLINE E Extra_Constrained                   (E Id);
   INLINE E Extra_Formal                        (E Id);
   INLINE E Extra_Formals                       (E Id);
   INLINE E Finalization_Master                 (E Id);

   #define Finalize_Storage_Only einfo__finalize_storage_only
   B Finalize_Storage_Only               (E Id);

   INLINE E Finalizer                           (E Id);
   INLINE E First_Entity                        (E Id);
   INLINE N First_Exit_Statement                (E Id);
   INLINE N First_Index                         (E Id);
   INLINE E First_Literal                       (E Id);
   INLINE E First_Private_Entity                (E Id);
   INLINE N First_Rep_Item                      (E Id);

   #define Float_Rep einfo__float_rep
   F Float_Rep                           (E Id);

   INLINE N Freeze_Node                         (E Id);
   INLINE B From_Limited_With                   (E Id);
   INLINE E Full_View                           (E Id);
   INLINE E Generic_Homonym                     (E Id);
   INLINE L Generic_Renamings                   (E Id);
   INLINE S Handler_Records                     (E Id);
   INLINE B Has_Aliased_Components              (E Id);
   INLINE B Has_Alignment_Clause                (E Id);
   INLINE B Has_All_Calls_Remote                (E Id);
   INLINE B Has_Atomic_Components               (E Id);
   INLINE B Has_Biased_Representation           (E Id);
   INLINE B Has_Completion                      (E Id);
   INLINE B Has_Completion_In_Body              (E Id);
   INLINE B Has_Complex_Representation          (E Id);
   INLINE B Has_Component_Size_Clause           (E Id);
   INLINE B Has_Constrained_Partial_View        (E Id);
   INLINE B Has_Contiguous_Rep                  (E Id);
   INLINE B Has_Controlled_Component            (E Id);
   INLINE B Has_Controlling_Result              (E Id);
   INLINE B Has_Convention_Pragma               (E Id);
   INLINE B Has_Default_Aspect                  (E Id);
   INLINE B Has_Delayed_Aspects                 (E Id);
   INLINE B Has_Delayed_Freeze                  (E Id);
   INLINE B Has_Delayed_Rep_Aspects             (E Id);

   #define Has_DIC einfo__has_dic
   B Has_DIC                             (E Id);

   INLINE B Has_Discriminants                   (E Id);
   INLINE B Has_Dispatch_Table                  (E Id);
   INLINE B Has_Dynamic_Predicate_Aspect        (E Id);
   INLINE B Has_Enumeration_Rep_Clause          (E Id);
   INLINE B Has_Exit                            (E Id);
   INLINE B Has_Expanded_Contract               (E Id);
   INLINE B Has_Forward_Instantiation           (E Id);
   INLINE B Has_Fully_Qualified_Name            (E Id);
   INLINE B Has_Gigi_Rep_Item                   (E Id);
   INLINE B Has_Homonym                         (E Id);
   INLINE B Has_Implicit_Dereference            (E Id);
   INLINE B Has_Independent_Components          (E Id);
   INLINE B Has_Inheritable_Invariants          (E Id);
   INLINE B Has_Inherited_DIC                   (E Id);
   INLINE B Has_Inherited_Invariants            (E Id);
   INLINE B Has_Initial_Value                   (E Id);

   #define Has_Interrupt_Handler einfo__has_interrupt_handler
   B Has_Interrupt_Handler               (E Id);

   #define Has_Invariants einfo__has_invariants
   B Has_Invariants                      (E Id);

   INLINE B Has_Loop_Entry_Attributes           (E Id);
   INLINE B Has_Machine_Radix_Clause            (E Id);
   INLINE B Has_Master_Entity                   (E Id);
   INLINE B Has_Missing_Return                  (E Id);
   INLINE B Has_Nested_Block_With_Handler       (E Id);
   INLINE B Has_Nested_Subprogram               (E Id);
   INLINE B Has_Non_Standard_Rep                (E Id);
   INLINE B Has_Object_Size_Clause              (E Id);
   INLINE B Has_Out_Or_In_Out_Parameter         (E Id);
   INLINE B Has_Own_DIC                         (E Id);
   INLINE B Has_Own_Invariants                  (E Id);
   INLINE B Has_Partial_Visible_Refinement      (E Id);
   INLINE B Has_Per_Object_Constraint           (E Id);
   INLINE B Has_Pragma_Controlled               (E Id);
   INLINE B Has_Pragma_Elaborate_Body           (E Id);
   INLINE B Has_Pragma_Inline                   (E Id);
   INLINE B Has_Pragma_Inline_Always            (E Id);
   INLINE B Has_Pragma_No_Inline                (E Id);
   INLINE B Has_Pragma_Ordered                  (E Id);
   INLINE B Has_Pragma_Pack                     (E Id);
   INLINE B Has_Pragma_Preelab_Init             (E Id);
   INLINE B Has_Pragma_Pure                     (E Id);
   INLINE B Has_Pragma_Pure_Function            (E Id);
   INLINE B Has_Pragma_Thread_Local_Storage     (E Id);
   INLINE B Has_Pragma_Unmodified               (E Id);
   INLINE B Has_Pragma_Unreferenced             (E Id);
   INLINE B Has_Pragma_Unreferenced_Objects     (E Id);
   INLINE B Has_Pragma_Unused                   (E Id);
   INLINE B Has_Predicates                      (E Id);
   INLINE B Has_Primitive_Operations            (E Id);
   INLINE B Has_Private_Ancestor                (E Id);
   INLINE B Has_Private_Declaration             (E Id);
   INLINE B Has_Protected                       (E Id);
   INLINE B Has_Qualified_Name                  (E Id);
   INLINE B Has_RACW                            (E Id);
   INLINE B Has_Record_Rep_Clause               (E Id);
   INLINE B Has_Recursive_Call                  (E Id);
   INLINE B Has_Shift_Operator                  (E Id);
   INLINE B Has_Size_Clause                     (E Id);
   INLINE B Has_Small_Clause                    (E Id);
   INLINE B Has_Specified_Layout                (E Id);
   INLINE B Has_Specified_Stream_Input          (E Id);
   INLINE B Has_Specified_Stream_Output         (E Id);
   INLINE B Has_Specified_Stream_Read           (E Id);
   INLINE B Has_Specified_Stream_Write          (E Id);
   INLINE B Has_Static_Discriminants            (E Id);
   INLINE B Has_Static_Predicate                (E Id);
   INLINE B Has_Static_Predicate_Aspect         (E Id);
   INLINE B Has_Storage_Size_Clause             (E Id);
   INLINE B Has_Stream_Size_Clause              (E Id);
   INLINE B Has_Task                            (E Id);
   INLINE B Has_Timing_Event                    (E Id);
   INLINE B Has_Thunks                          (E Id);
   INLINE B Has_Unchecked_Union                 (E Id);
   INLINE B Has_Unknown_Discriminants           (E Id);
   INLINE B Has_Visible_Refinement              (E Id);
   INLINE B Has_Volatile_Components             (E Id);
   INLINE B Has_Xref_Entry                      (E Id);
   INLINE E Hiding_Loop_Variable                (E Id);
   INLINE E Homonym                             (E Id);
   INLINE E Import_Pragma                       (E Id);
   INLINE L Incomplete_Actuals                  (E Id);
   INLINE B In_Package_Body                     (E Id);
   INLINE B In_Private_Part                     (E Id);
   INLINE B In_Use                              (E Id);

   #define Initialization_Statements einfo__initialization_statements
   N Initialization_Statements           (E Id);

   INLINE L Inner_Instances                     (E Id);
   INLINE E Interface_Alias                     (E Id);
   INLINE N Interface_Name                      (E Id);
   INLINE L Interfaces                          (E Id);
   INLINE B Is_Abstract_Subprogram              (E Id);
   INLINE B Is_Abstract_Type                    (E Id);
   INLINE B Is_Access_Constant                  (E Id);
   INLINE B Is_Actual_Subtype                   (E Id);
   INLINE B Is_Ada_2005_Only                    (E Id);
   INLINE B Is_Ada_2012_Only                    (E Id);
   INLINE B Is_Aliased                          (E Id);
   INLINE B Is_Asynchronous                     (E Id);
   INLINE B Is_Atomic                           (E Id);
   INLINE B Is_Atomic_Or_VFA                    (E Id);
   INLINE B Is_Bit_Packed_Array                 (E Id);
   INLINE B Is_Called                           (E Id);
   INLINE B Is_Character_Type                   (E Id);
   INLINE B Is_Checked_Ghost_Entity             (E Id);
   INLINE B Is_Child_Unit                       (E Id);
   INLINE B Is_Class_Wide_Equivalent_Type       (E Id);
   INLINE B Is_Compilation_Unit                 (E Id);
   INLINE B Is_Completely_Hidden                (E Id);
   INLINE B Is_Constr_Subt_For_U_Nominal        (E Id);
   INLINE B Is_Constr_Subt_For_UN_Aliased       (E Id);
   INLINE B Is_Constrained                      (E Id);
   INLINE B Is_Constructor                      (E Id);
   INLINE B Is_Controlled                       (E Id);
   INLINE B Is_Controlling_Formal               (E Id);
   INLINE B Is_CPP_Class                        (E Id);
   INLINE B Is_Descendant_Of_Address            (E Id);
   INLINE B Is_DIC_Procedure                    (E Id);
   INLINE B Is_Discrim_SO_Function              (E Id);
   INLINE B Is_Discriminant_Check_Function      (E Id);
   INLINE B Is_Dispatch_Table_Entity            (E Id);
   INLINE B Is_Dispatching_Operation            (E Id);
   INLINE B Is_Eliminated                       (E Id);
   INLINE B Is_Entry_Formal                     (E Id);
   INLINE B Is_Entry_Wrapper                    (E Id);
   INLINE B Is_Exception_Handler                (E Id);
   INLINE B Is_Exported                         (E Id);
   INLINE B Is_Finalized_Transient              (E Id);
   INLINE B Is_First_Subtype                    (E Id);
   INLINE B Is_For_Access_Subtype               (E Id);
   INLINE B Is_Frozen                           (E Id);
   INLINE B Is_Generic_Instance                 (E Id);
   INLINE B Is_Hidden                           (E Id);
   INLINE B Is_Hidden_Non_Overridden_Subpgm     (E Id);
   INLINE B Is_Hidden_Open_Scope                (E Id);
   INLINE B Is_Ignored_Ghost_Entity             (E Id);
   INLINE B Is_Ignored_Transient                (E Id);
   INLINE B Is_Immediately_Visible              (E Id);
   INLINE B Is_Implementation_Defined           (E Id);
   INLINE B Is_Imported                         (E Id);
   INLINE B Is_Independent                      (E Id);
   INLINE B Is_Inlined                          (E Id);
   INLINE B Is_Inlined_Always                   (E Id);
   INLINE B Is_Instantiated                     (E Id);
   INLINE B Is_Interface                        (E Id);
   INLINE B Is_Internal                         (E Id);
   INLINE B Is_Interrupt_Handler                (E Id);
   INLINE B Is_Intrinsic_Subprogram             (E Id);
   INLINE B Is_Invariant_Procedure              (E Id);
   INLINE B Is_Itype                            (E Id);
   INLINE B Is_Known_Non_Null                   (E Id);
   INLINE B Is_Known_Null                       (E Id);
   INLINE B Is_Known_Valid                      (E Id);
   INLINE B Is_Limited_Composite                (E Id);
   INLINE B Is_Limited_Interface                (E Id);
   INLINE B Is_Local_Anonymous_Access           (E Id);
   INLINE B Is_Machine_Code_Subprogram          (E Id);
   INLINE B Is_Non_Static_Subtype               (E Id);
   INLINE B Is_Null_Init_Proc                   (E Id);
   INLINE B Is_Obsolescent                      (E Id);
   INLINE B Is_Only_Out_Parameter               (E Id);
   INLINE B Is_Package_Body_Entity              (E Id);
   INLINE B Is_Packed                           (E Id);
   INLINE B Is_Packed_Array_Impl_Type           (E Id);
   INLINE B Is_Potentially_Use_Visible          (E Id);
   INLINE B Is_Param_Block_Component_Type       (E Id);
   INLINE B Is_Partial_Invariant_Procedure      (E Id);
   INLINE B Is_Predicate_Function               (E Id);
   INLINE B Is_Predicate_Function_M             (E Id);
   INLINE B Is_Preelaborated                    (E Id);
   INLINE B Is_Primitive                        (E Id);
   INLINE B Is_Primitive_Wrapper                (E Id);
   INLINE B Is_Private_Composite                (E Id);
   INLINE B Is_Private_Descendant               (E Id);
   INLINE B Is_Private_Primitive                (E Id);
   INLINE B Is_Public                           (E Id);
   INLINE B Is_Pure                             (E Id);
   INLINE B Is_Pure_Unit_Access_Type            (E Id);
   INLINE B Is_RACW_Stub_Type                   (E Id);
   INLINE B Is_Raised                           (E Id);
   INLINE B Is_Remote_Call_Interface            (E Id);
   INLINE B Is_Remote_Types                     (E Id);
   INLINE B Is_Renaming_Of_Object               (E Id);
   INLINE B Is_Return_Object                    (E Id);
   INLINE B Is_Safe_To_Reevaluate               (E Id);
   INLINE B Is_Shared_Passive                   (E Id);
   INLINE B Is_Static_Type                      (E Id);
   INLINE B Is_Statically_Allocated             (E Id);
   INLINE B Is_Tag                              (E Id);
   INLINE B Is_Tagged_Type                      (E Id);
   INLINE B Is_Thunk                            (E Id);
   INLINE B Is_Trivial_Subprogram               (E Id);
   INLINE B Is_True_Constant                    (E Id);
   INLINE B Is_Unchecked_Union                  (E Id);
   INLINE B Is_Underlying_Full_View             (E Id);
   INLINE B Is_Underlying_Record_View           (E Id);
   INLINE B Is_Unimplemented                    (E Id);
   INLINE B Is_Unsigned_Type                    (E Id);
   INLINE B Is_Uplevel_Referenced_Entity        (E Id);
   INLINE B Is_Valued_Procedure                 (E Id);
   INLINE B Is_Visible_Formal                   (E Id);
   INLINE B Is_Visible_Lib_Unit                 (E Id);

   #define Is_Volatile einfo__is_volatile
   B Is_Volatile                         (E Id);

   INLINE B Is_Volatile_Full_Access             (E Id);
   INLINE B Itype_Printed                       (E Id);
   INLINE B Kill_Elaboration_Checks             (E Id);
   INLINE B Kill_Range_Checks                   (E Id);
   INLINE B Known_To_Have_Preelab_Init          (E Id);
   INLINE N Last_Aggregate_Assignment           (E Id);
   INLINE N Last_Assignment                     (E Id);
   INLINE E Last_Entity                         (E Id);
   INLINE E Limited_View                        (E Id);
   INLINE N Linker_Section_Pragma               (E Id);
   INLINE E Lit_Indexes                         (E Id);
   INLINE E Lit_Strings                         (E Id);
   INLINE B Low_Bound_Tested                    (E Id);
   INLINE B Machine_Radix_10                    (E Id);
   INLINE E Master_Id                           (E Id);
   INLINE B Materialize_Entity                  (E Id);
   INLINE B May_Inherit_Delayed_Rep_Aspects     (E Id);
   INLINE M Mechanism                           (E Id);
   INLINE U Modulus                             (E Id);
   INLINE B Must_Be_On_Byte_Boundary            (E Id);
   INLINE B Must_Have_Preelab_Init              (E Id);
   INLINE B Needs_Debug_Info                    (E Id);
   INLINE B Needs_No_Actuals                    (E Id);
   INLINE B Never_Set_In_Source                 (E Id);
   INLINE E Next_Inlined_Subprogram             (E Id);
   INLINE B No_Dynamic_Predicate_On_Actual      (E Id);
   INLINE B No_Pool_Assigned                    (E Id);
   INLINE B No_Predicate_On_Actual              (E Id);
   INLINE B No_Return                           (E Id);
   INLINE B No_Strict_Aliasing                  (E Id);
   INLINE N No_Tagged_Streams_Pragma            (E Id);
   INLINE B Non_Binary_Modulus                  (E Id);
   INLINE E Non_Limited_View                    (E Id);
   INLINE B Nonzero_Is_True                     (E Id);
   INLINE U Normalized_First_Bit                (E Id);
   INLINE U Normalized_Position                 (E Id);
   INLINE U Normalized_Position_Max             (E Id);
   INLINE B OK_To_Rename                        (E Id);
   INLINE B OK_To_Reorder_Components            (E Id);
   INLINE B Optimize_Alignment_Space            (E Id);
   INLINE B Optimize_Alignment_Time             (E Id);
   INLINE E Original_Access_Type                (E Id);
   INLINE E Original_Array_Type                 (E Id);
   INLINE N Original_Protected_Subprogram       (E Id);
   INLINE E Original_Record_Component           (E Id);
   INLINE B Overlays_Constant                   (E Id);
   INLINE E Overridden_Operation                (E Id);
   INLINE N Package_Instantiation               (E Id);
   INLINE E Packed_Array_Impl_Type              (E Id);
   INLINE E Parent_Subtype                      (E Id);
   INLINE L Part_Of_Constituents                (E Id);
   INLINE L Part_Of_References                  (E Id);
   INLINE B Partial_View_Has_Unknown_Discr      (E Id);
   INLINE L Pending_Access_Types                (E Id);
   INLINE E Postconditions_Proc                 (E Id);
   INLINE B Predicates_Ignored                  (E Id);
   INLINE E Prival                              (E Id);
   INLINE E Prival_Link                         (E Id);
   INLINE L Private_Dependents                  (E Id);
   INLINE N Private_View                        (E Id);
   INLINE E Protected_Body_Subprogram           (E Id);
   INLINE E Protected_Formal                    (E Id);
   INLINE E Protection_Object                   (E Id);
   INLINE B Reachable                           (E Id);
   INLINE B Referenced                          (E Id);
   INLINE B Referenced_As_LHS                   (E Id);
   INLINE B Referenced_As_Out_Parameter         (E Id);
   INLINE L Refinement_Constituents             (E Id);
   INLINE N Register_Exception_Call             (E Id);
   INLINE E Related_Array_Object                (E Id);
   INLINE N Related_Expression                  (E Id);
   INLINE E Related_Instance                    (E Id);
   INLINE E Related_Type                        (E Id);
   INLINE E Relative_Deadline_Variable          (E Id);
   INLINE N Renamed_Entity                      (E Id);
   INLINE B Renamed_In_Spec                     (E Id);
   INLINE N Renamed_Object                      (E Id);
   INLINE U Renaming_Map                        (E Id);
   INLINE B Requires_Overriding                 (E Id);
   INLINE N Return_Applies_To                   (E Id);
   INLINE B Return_Present                      (E Id);
   INLINE B Returns_By_Ref                      (E Id);
   INLINE B Reverse_Bit_Order                   (E Id);
   INLINE B Reverse_Storage_Order               (E Id);
   INLINE B Rewritten_For_C                     (E Id);
   INLINE U RM_Size                             (E Id);
   INLINE N Scalar_Range                        (E Id);
   INLINE U Scale_Value                         (E Id);
   INLINE U Scope_Depth_Value                   (E Id);
   INLINE B Sec_Stack_Needed_For_Return         (E Id);
   INLINE S Shadow_Entities                     (E Id);
   INLINE E Shared_Var_Procs_Instance           (E Id);
   INLINE N Size_Check_Code                     (E Id);
   INLINE B Size_Depends_On_Discriminant        (E Id);
   INLINE B Size_Known_At_Compile_Time          (E Id);
   INLINE R Small_Value                         (E Id);
   INLINE N SPARK_Aux_Pragma                    (E Id);
   INLINE B SPARK_Aux_Pragma_Inherited          (E Id);
   INLINE N SPARK_Pragma                        (E Id);
   INLINE B SPARK_Pragma_Inherited              (E Id);
   INLINE E Spec_Entity                         (E Id);
   INLINE B SSO_Set_High_By_Default             (E Id);
   INLINE B SSO_Set_Low_By_Default              (E Id);
   INLINE S Static_Discrete_Predicate           (E Id);
   INLINE B Static_Elaboration_Desired          (E Id);
   INLINE N Static_Initialization               (E Id);
   INLINE N Static_Real_Or_String_Predicate     (E Id);
   INLINE E Status_Flag_Or_Transient_Decl       (E Id);
   INLINE E Storage_Size_Variable               (E Id);
   INLINE L Stored_Constraint                   (E Id);
   INLINE B Stores_Attribute_Old_Prefix         (E Id);
   INLINE B Strict_Alignment                    (E Id);
   INLINE U String_Literal_Length               (E Id);
   INLINE N String_Literal_Low_Bound            (E Id);
   INLINE L Subprograms_For_Type                (E Id);
   INLINE U Subps_Index                         (E Id);
   INLINE B Suppress_Elaboration_Warnings       (E Id);
   INLINE B Suppress_Initialization             (E Id);
   INLINE B Suppress_Style_Checks               (E Id);
   INLINE B Suppress_Value_Tracking_On_Call     (E Id);
   INLINE N Task_Body_Procedure                 (E Id);
   INLINE E Thunk_Entity                        (E Id);
   INLINE B Treat_As_Volatile                   (E Id);
   INLINE E Underlying_Full_View                (E Id);
   INLINE E Underlying_Record_View              (E Id);
   INLINE B Universal_Aliasing                  (E Id);
   INLINE N Unset_Reference                     (E Id);
   INLINE B Used_As_Generic_Actual              (E Id);
   INLINE B Uses_Lock_Free                      (E Id);
   INLINE B Uses_Sec_Stack                      (E Id);
   INLINE B Warnings_Off                        (E Id);
   INLINE B Warnings_Off_Used                   (E Id);
   INLINE B Warnings_Off_Used_Unmodified        (E Id);
   INLINE B Warnings_Off_Used_Unreferenced      (E Id);
   INLINE B Was_Hidden                          (E Id);
   INLINE E Wrapped_Entity                      (E Id);
   INLINE B Is_Access_Type                      (E Id);
   INLINE B Is_Access_Protected_Subprogram_Type (E Id);
   INLINE B Is_Access_Subprogram_Type           (E Id);
   INLINE B Is_Aggregate_Type                   (E Id);
   INLINE B Is_Array_Type                       (E Id);
   INLINE B Is_Assignable                       (E Id);
   INLINE B Is_Class_Wide_Type                  (E Id);
   INLINE B Is_Composite_Type                   (E Id);
   INLINE B Is_Concurrent_Body                  (E Id);
   INLINE B Is_Concurrent_Record_Type           (E Id);
   INLINE B Is_Concurrent_Type                  (E Id);
   INLINE B Is_Decimal_Fixed_Point_Type         (E Id);
   INLINE B Is_Digits_Type                      (E Id);
   INLINE B Is_Discrete_Or_Fixed_Point_Type     (E Id);
   INLINE B Is_Discrete_Type                    (E Id);
   INLINE B Is_Elementary_Type                  (E Id);
   INLINE B Is_Entry                            (E Id);
   INLINE B Is_Enumeration_Type                 (E Id);
   INLINE B Is_Fixed_Point_Type                 (E Id);
   INLINE B Is_Floating_Point_Type              (E Id);
   INLINE B Is_Formal                           (E Id);
   INLINE B Is_Formal_Object                    (E Id);
   INLINE B Is_Formal_Subprogram                (E Id);
   INLINE B Is_Generic_Actual_Subprogram        (E Id);
   INLINE B Is_Generic_Actual_Type              (E Id);
   INLINE B Is_Generic_Subprogram               (E Id);
   INLINE B Is_Generic_Type                     (E Id);
   INLINE B Is_Generic_Unit                     (E Id);
   INLINE B Is_Ghost_Entity                     (E Id);
   INLINE B Is_Incomplete_Or_Private_Type       (E Id);
   INLINE B Is_Incomplete_Type                  (E Id);
   INLINE B Is_Integer_Type                     (E Id);
   INLINE B Is_Limited_Record                   (E Id);
   INLINE B Is_Modular_Integer_Type             (E Id);
   INLINE B Is_Named_Number                     (E Id);
   INLINE B Is_Numeric_Type                     (E Id);
   INLINE B Is_Object                           (E Id);
   INLINE B Is_Ordinary_Fixed_Point_Type        (E Id);
   INLINE B Is_Overloadable                     (E Id);
   INLINE B Is_Private_Type                     (E Id);
   INLINE B Is_Protected_Type                   (E Id);
   INLINE B Is_Real_Type                        (E Id);
   INLINE B Is_Record_Type                      (E Id);
   INLINE B Is_Scalar_Type                      (E Id);
   INLINE B Is_Signed_Integer_Type              (E Id);
   INLINE B Is_Subprogram                       (E Id);

   #define Is_Subprogram_Or_Generic_Subprogram einfo__is_subprogram_or_generic_subprogram
   B Is_Subprogram_Or_Generic_Subprogram (E Id);

   INLINE B Is_Task_Type                        (E Id);
   INLINE B Is_Type                             (E Id);

   #define Address_Clause einfo__address_clause
   N Address_Clause                      (E Id);

   #define Aft_Value einfo__aft_value
   U Aft_Value                           (E Id);

   #define Alignment_Clause einfo__alignment_clause
   N Alignment_Clause                    (E Id);

   #define Base_Type einfo__base_type
   E Base_Type                           (E Id);

   #define Declaration_Node einfo__declaration_node
   N Declaration_Node                    (E Id);

   #define Designated_Type einfo__designated_type
   E Designated_Type                     (E Id);

   #define First_Component einfo__first_component
   E First_Component                     (E Id);

   #define First_Component_Or_Discriminant einfo__first_component_or_discriminant
   E First_Component_Or_Discriminant     (E Id);

   #define First_Formal einfo__first_formal
   E First_Formal                        (E Id);

   #define First_Formal_With_Extras einfo__first_formal_with_extras
   E First_Formal_With_Extras            (E Id);

   #define Has_Attach_Handler einfo__has_attach_handler
   B Has_Attach_Handler                  (E Id);

   #define Has_Entries einfo__has_entries
   B Has_Entries                         (E Id);

   #define Has_Foreign_Convention einfo__has_foreign_convention
   B Has_Foreign_Convention              (E Id);

   #define Has_Non_Limited_View einfo__has_non_limited_view
   B Has_Non_Limited_View                (E Id);

   #define Has_Non_Null_Abstract_State einfo__has_non_null_abstract_state
   B Has_Non_Null_Abstract_State         (E Id);

   #define Has_Non_Null_Visible_Refinement einfo__has_non_null_visible_refinement
   B Has_Non_Null_Visible_Refinement     (E Id);

   #define Has_Null_Abstract_State einfo__has_null_abstract_state
   B Has_Null_Abstract_State             (E Id);

   #define Has_Null_Visible_Refinement einfo__has_null_visible_refinement
   B Has_Null_Visible_Refinement         (E Id);

   #define Implementation_Base_Type einfo__implementation_base_type
   E Implementation_Base_Type            (E Id);

   #define Is_Base_Type einfo__is_base_type
   B Is_Base_Type                        (E Id);

   #define Is_Boolean_Type einfo__is_boolean_type
   B Is_Boolean_Type                     (E Id);

   #define Is_Constant_Object einfo__is_constant_object
   B Is_Constant_Object                  (E Id);

   #define Is_Controlled_Active einfo__is_controlled_active
   B Is_Controlled_Active                (E Id);

   #define Is_Discriminal einfo__is_discriminal
   B Is_Discriminal                      (E Id);

   #define Is_Dynamic_Scope einfo__is_dynamic_scope
   B Is_Dynamic_Scope                    (E Id);

   #define Is_External_State einfo__is_external_state
   B Is_External_State                   (E Id);

   #define Is_Finalizer einfo__is_finalizer
   B Is_Finalizer                        (E Id);

   #define Is_Null_State einfo__is_null_state
   B Is_Null_State                       (E Id);

   #define Is_Package_Or_Generic_Package einfo__is_package_or_generic_package
   B Is_Package_Or_Generic_Package       (E Id);

   #define Is_Packed_Array einfo__is_packed_array
   B Is_Packed_Array                     (E Id);

   #define Is_Prival einfo__is_prival
   B Is_Prival                           (E Id);

   #define Is_Protected_Component einfo__is_protected_component
   B Is_Protected_Component              (E Id);

   #define Is_Protected_Interface einfo__is_protected_interface
   B Is_Protected_Interface              (E Id);

   #define Is_Protected_Record_Type einfo__is_protected_record_type
   B Is_Protected_Record_Type            (E Id);

   #define Is_Standard_Character_Type einfo__is_standard_character_type
   B Is_Standard_Character_Type          (E Id);

   #define Is_Standard_String_Type einfo__is_standard_string_type
   B Is_Standard_String_Type             (E Id);

   #define Is_String_Type einfo__is_string_type
   B Is_String_Type                      (E Id);

   #define Is_Synchronized_Interface einfo__is_synchronized_interface
   B Is_Synchronized_Interface           (E Id);

   #define Is_Synchronized_State einfo__is_synchronized_state
   B Is_Synchronized_State               (E Id);

   #define Is_Task_Interface einfo__is_task_interface
   B Is_Task_Interface                   (E Id);

   #define Is_Task_Record_Type einfo__is_task_record_type
   B Is_Task_Record_Type                 (E Id);

   #define Is_Wrapper_Package einfo__is_wrapper_package
   B Is_Wrapper_Package                  (E Id);

   #define Last_Formal einfo__last_formal
   E Last_Formal                         (E Id);

   #define Machine_Emax_Value einfo__machine_emax_value
   U Machine_Emax_Value                  (E Id);

   #define Machine_Emin_Value einfo__machine_emin_value
   U Machine_Emin_Value                  (E Id);

   #define Machine_Mantissa_Value einfo__machine_mantissa_value
   U Machine_Mantissa_Value              (E Id);

   #define Machine_Radix_Value einfo__machine_radix_value
   U Machine_Radix_Value                 (E Id);

   #define Model_Emin_Value einfo__model_emin_value
   U Model_Emin_Value                    (E Id);

   #define Model_Epsilon_Value einfo__model_epsilon_value
   R Model_Epsilon_Value                 (E Id);

   #define Model_Mantissa_Value einfo__model_mantissa_value
   U Model_Mantissa_Value                (E Id);

   #define Model_Small_Value einfo__model_small_value
   R Model_Small_Value                   (E Id);

   #define Next_Component einfo__next_component
   E Next_Component                      (E Id);

   #define Next_Component_Or_Discriminant einfo__next_component_or_discriminant
   E Next_Component_Or_Discriminant      (E Id);

   #define Next_Discriminant einfo__next_discriminant
   E Next_Discriminant                   (E Id);

   #define Next_Formal einfo__next_formal
   E Next_Formal                         (E Id);

   #define Next_Formal_With_Extras einfo__next_formal_with_extras
   E Next_Formal_With_Extras             (E Id);

   INLINE E Next_Literal                        (E Id);

   #define Next_Stored_Discriminant einfo__next_stored_discriminant
   E Next_Stored_Discriminant            (E Id);

   #define Number_Dimensions einfo__number_dimensions
   Pos Number_Dimensions                   (E Id);

   #define Number_Entries einfo__number_entries
   Nat Number_Entries                      (E Id);

   #define Number_Formals einfo__number_formals
   Pos Number_Formals                      (E Id);

   INLINE Formal_Kind Parameter_Mode                      (E Id);

   #define Partial_Refinement_Constituents einfo__partial_refinement_constituents
   L Partial_Refinement_Constituents     (E Id);

   #define Primitive_Operations einfo__primitive_operations
   L Primitive_Operations                (E Id);

   #define Root_Type einfo__root_type
   E Root_Type                           (E Id);

   #define Safe_Emax_Value einfo__safe_emax_value
   U Safe_Emax_Value                     (E Id);

   #define Safe_First_Value einfo__safe_first_value
   R Safe_First_Value                    (E Id);

   #define Safe_Last_Value einfo__safe_last_value
   R Safe_Last_Value                     (E Id);

   #define Scope_Depth_Set einfo__scope_depth_set
   B Scope_Depth_Set                     (E Id);

   #define Size_Clause einfo__size_clause
   N Size_Clause                         (E Id);

   #define Stream_Size_Clause einfo__stream_size_clause
   N Stream_Size_Clause                  (E Id);

   #define Type_High_Bound einfo__type_high_bound
   N Type_High_Bound                     (E Id);

   #define Type_Low_Bound einfo__type_low_bound
   N Type_Low_Bound                      (E Id);

   #define Underlying_Type einfo__underlying_type
   E Underlying_Type                     (E Id);

   #define Known_Alignment einfo__known_alignment
   B Known_Alignment                       (Entity_Id E);

   #define Known_Component_Bit_Offset einfo__known_component_bit_offset
   B Known_Component_Bit_Offset            (Entity_Id E);

   #define Known_Component_Size einfo__known_component_size
   B Known_Component_Size                  (Entity_Id E);

   #define Known_Esize einfo__known_esize
   B Known_Esize                           (Entity_Id E);

   #define Known_Normalized_First_Bit einfo__known_normalized_first_bit
   B Known_Normalized_First_Bit            (Entity_Id E);

   #define Known_Normalized_Position einfo__known_normalized_position
   B Known_Normalized_Position             (Entity_Id E);

   #define Known_Normalized_Position_Max einfo__known_normalized_position_max
   B Known_Normalized_Position_Max         (Entity_Id E);

   #define Known_RM_Size einfo__known_rm_size
   B Known_RM_Size                         (Entity_Id E);

   #define Known_Static_Component_Bit_Offset einfo__known_static_component_bit_offset
   B Known_Static_Component_Bit_Offset     (Entity_Id E);

   #define Known_Static_Component_Size einfo__known_static_component_size
   B Known_Static_Component_Size           (Entity_Id E);

   #define Known_Static_Esize einfo__known_static_esize
   B Known_Static_Esize                    (Entity_Id E);

   #define Known_Static_Normalized_First_Bit einfo__known_static_normalized_first_bit
   B Known_Static_Normalized_First_Bit     (Entity_Id E);

   #define Known_Static_Normalized_Position einfo__known_static_normalized_position
   B Known_Static_Normalized_Position      (Entity_Id E);

   #define Known_Static_Normalized_Position_Max einfo__known_static_normalized_position_max
   B Known_Static_Normalized_Position_Max  (Entity_Id E);

   #define Known_Static_RM_Size einfo__known_static_rm_size
   B Known_Static_RM_Size                  (Entity_Id E);

   #define Unknown_Alignment einfo__unknown_alignment
   B Unknown_Alignment                     (Entity_Id E);

   #define Unknown_Component_Bit_Offset einfo__unknown_component_bit_offset
   B Unknown_Component_Bit_Offset          (Entity_Id E);

   #define Unknown_Component_Size einfo__unknown_component_size
   B Unknown_Component_Size                (Entity_Id E);

   #define Unknown_Esize einfo__unknown_esize
   B Unknown_Esize                         (Entity_Id E);

   #define Unknown_Normalized_First_Bit einfo__unknown_normalized_first_bit
   B Unknown_Normalized_First_Bit          (Entity_Id E);

   #define Unknown_Normalized_Position einfo__unknown_normalized_position
   B Unknown_Normalized_Position           (Entity_Id E);

   #define Unknown_Normalized_Position_Max einfo__unknown_normalized_position_max
   B Unknown_Normalized_Position_Max       (Entity_Id E);

   #define Unknown_RM_Size einfo__unknown_rm_size
   B Unknown_RM_Size                       (Entity_Id E);


   INLINE L Abstract_States (E Id)
      { return Elist25 (Id); }

   INLINE L Accept_Address (E Id)
      { return Elist21 (Id); }

   INLINE L Access_Disp_Table (E Id)
      { return Elist16 (Implementation_Base_Type (Id)); }

   INLINE E Activation_Record_Component (E Id)
      { return Node31 (Id); }

   INLINE E Actual_Subtype (E Id)
      { return Node17 (Id); }

   INLINE B Address_Taken (E Id)
      { return Flag104 (Id); }

   INLINE E Alias (E Id)
      { return Node18 (Id); }

   INLINE U Alignment (E Id)
      { return Uint14 (Id); }

   INLINE E Anonymous_Designated_Type (E Id)
      { return Node35 (Id); }

   INLINE L Anonymous_Masters (E Id)
      { return Elist29 (Id); }

   INLINE E Anonymous_Object (E Id)
      { return Node30 (Id); }

   INLINE E Associated_Entity (E Id)
      { return Node37 (Id); }

   INLINE E Associated_Formal_Package (E Id)
      { return Node12 (Id); }

   INLINE N Associated_Node_For_Itype (E Id)
      { return Node8 (Id); }

   INLINE E Associated_Storage_Pool (E Id)
      { return Node22 (Root_Type (Id)); }

   INLINE N Barrier_Function (E Id)
      { return Node12 (Id); }

   INLINE N Block_Node (E Id)
      { return Node11 (Id); }

   INLINE E Body_Entity (E Id)
      { return Node19 (Id); }

   INLINE B Body_Needed_For_SAL (E Id)
      { return Flag40 (Id); }

   INLINE L Body_References (E Id)
      { return Elist16 (Id); }

   INLINE N BIP_Initialization_Call (E Id)
      { return Node29 (Id); }

   INLINE B C_Pass_By_Copy (E Id)
      { return Flag125 (Implementation_Base_Type (Id)); }

   INLINE B Can_Never_Be_Null (E Id)
      { return Flag38 (Id); }

   INLINE B Checks_May_Be_Suppressed (E Id)
      { return Flag31 (Id); }

   INLINE S Class_Wide_Postconds (E Id)
      { return List39 (Id); }

   INLINE S Class_Wide_Preconds (E Id)
      { return List38 (Id); }

   INLINE E Class_Wide_Type (E Id)
      { return Node9 (Id); }

   INLINE E Cloned_Subtype (E Id)
      { return Node16 (Id); }

   INLINE U Component_Bit_Offset (E Id)
      { return Uint11 (Id); }

   INLINE N Component_Clause (E Id)
      { return Node13 (Id); }

   INLINE U Component_Size (E Id)
      { return Uint22 (Implementation_Base_Type (Id)); }

   INLINE E Component_Type (E Id)
      { return Node20 (Implementation_Base_Type (Id)); }

   INLINE E Corresponding_Concurrent_Type (E Id)
      { return Node18 (Id); }

   INLINE E Corresponding_Discriminant (E Id)
      { return Node19 (Id); }

   INLINE E Corresponding_Equality (E Id)
      { return Node30 (Id); }

   INLINE E Corresponding_Protected_Entry (E Id)
      { return Node18 (Id); }

   INLINE E Corresponding_Record_Type (E Id)
      { return Node18 (Id); }

   INLINE E Corresponding_Remote_Type (E Id)
      { return Node22 (Id); }

   INLINE E Current_Use_Clause (E Id)
      { return Node27 (Id); }

   INLINE N Current_Value (E Id)
      { return Node9 (Id); }

   INLINE E CR_Discriminant (E Id)
      { return Node23 (Id); }

   INLINE B Debug_Info_Off (E Id)
      { return Flag166 (Id); }

   INLINE E Debug_Renaming_Link (E Id)
      { return Node25 (Id); }

   INLINE N Default_Aspect_Component_Value (E Id)
      { return Node19 (Base_Type (Id)); }

   INLINE N Default_Aspect_Value (E Id)
      { return Node19 (Base_Type (Id)); }

   INLINE E Default_Expr_Function (E Id)
      { return Node21 (Id); }

   INLINE B Default_Expressions_Processed (E Id)
      { return Flag108 (Id); }

   INLINE N Default_Value (E Id)
      { return Node20 (Id); }

   INLINE B Delay_Cleanups (E Id)
      { return Flag114 (Id); }

   INLINE B Delay_Subprogram_Descriptors (E Id)
      { return Flag50 (Id); }

   INLINE R Delta_Value (E Id)
      { return Ureal18 (Id); }

   INLINE L Dependent_Instances (E Id)
      { return Elist8 (Id); }

   INLINE B Depends_On_Private (E Id)
      { return Flag14 (Id); }

   INLINE E Derived_Type_Link (E Id)
      { return Node31 (Base_Type (Id)); }

   INLINE U Digits_Value (E Id)
      { return Uint17 (Id); }

   INLINE L Direct_Primitive_Operations (E Id)
      { return Elist10 (Id); }

   INLINE E Directly_Designated_Type (E Id)
      { return Node20 (Id); }

   INLINE B Disable_Controlled (E Id)
      { return Flag253 (Base_Type (Id)); }

   INLINE B Discard_Names (E Id)
      { return Flag88 (Id); }

   INLINE E Discriminal (E Id)
      { return Node17 (Id); }

   INLINE N Discriminal_Link (E Id)
      { return Node10 (Id); }

   INLINE E Discriminant_Checking_Func (E Id)
      { return Node20 (Id); }

   INLINE L Discriminant_Constraint (E Id)
      { return Elist21 (Id); }

   INLINE N Discriminant_Default_Value (E Id)
      { return Node20 (Id); }

   INLINE U Discriminant_Number (E Id)
      { return Uint15 (Id); }

   INLINE L Dispatch_Table_Wrappers (E Id)
      { return Elist26 (Implementation_Base_Type (Id)); }

   INLINE U DT_Entry_Count (E Id)
      { return Uint15 (Id); }

   INLINE E DT_Offset_To_Top_Func (E Id)
      { return Node25 (Id); }

   INLINE U DT_Position (E Id)
      { return Uint15 (Id); }

   INLINE E DTC_Entity (E Id)
      { return Node16 (Id); }

   INLINE B Elaborate_Body_Desirable (E Id)
      { return Flag210 (Id); }

   INLINE E Elaboration_Entity (E Id)
      { return Node13 (Id); }

   INLINE B Elaboration_Entity_Required (E Id)
      { return Flag174 (Id); }

   INLINE N Encapsulating_State (E Id)
      { return Node32 (Id); }

   INLINE E Enclosing_Scope (E Id)
      { return Node18 (Id); }

   INLINE B Entry_Accepted (E Id)
      { return Flag152 (Id); }

   INLINE E Entry_Bodies_Array (E Id)
      { return Node19 (Id); }

   INLINE E Entry_Cancel_Parameter (E Id)
      { return Node23 (Id); }

   INLINE E Entry_Component (E Id)
      { return Node11 (Id); }

   INLINE E Entry_Formal (E Id)
      { return Node16 (Id); }

   INLINE N Entry_Index_Constant (E Id)
      { return Node18 (Id); }

   INLINE B Contains_Ignored_Ghost_Code (E Id)
      { return Flag279 (Id); }

   INLINE N Contract (E Id)
      { return Node34 (Id); }

   INLINE E Contract_Wrapper (E Id)
      { return Node25 (Id); }

   INLINE E Entry_Parameters_Type (E Id)
      { return Node15 (Id); }

   INLINE E Enum_Pos_To_Rep (E Id)
      { return Node23 (Id); }

   INLINE Uint Enumeration_Pos (E Id)
      { return Uint11 (Id); }

   INLINE U Enumeration_Rep (E Id)
      { return Uint12 (Id); }

   INLINE N Enumeration_Rep_Expr (E Id)
      { return Node22 (Id); }

   INLINE E Equivalent_Type (E Id)
      { return Node18 (Id); }

   INLINE Uint Esize (E Id)
      { return Uint12 (Id); }

   INLINE E Extra_Accessibility (E Id)
      { return Node13 (Id); }

   INLINE E Extra_Accessibility_Of_Result (E Id)
      { return Node19 (Id); }

   INLINE E Extra_Constrained (E Id)
      { return Node23 (Id); }

   INLINE E Extra_Formal (E Id)
      { return Node15 (Id); }

   INLINE E Extra_Formals (E Id)
      { return Node28 (Id); }

   INLINE B Can_Use_Internal_Rep (E Id)
      { return Flag229 (Base_Type (Id)); }

   INLINE E Finalization_Master (E Id)
      { return Node23 (Root_Type (Id)); }

   INLINE E Finalizer (E Id)
      { return Node28 (Id); }

   INLINE E First_Entity (E Id)
      { return Node17 (Id); }

   INLINE N First_Exit_Statement (E Id)
      { return Node8 (Id); }

   INLINE N First_Index (E Id)
      { return Node17 (Id); }

   INLINE E First_Literal (E Id)
      { return Node17 (Id); }

   INLINE E First_Private_Entity (E Id)
      { return Node16 (Id); }

   INLINE E First_Rep_Item (E Id)
      { return Node6 (Id); }

   INLINE N Freeze_Node (E Id)
      { return Node7 (Id); }

   INLINE B From_Limited_With (E Id)
      { return Flag159 (Id); }

   INLINE E Full_View (E Id)
      { return Node11 (Id); }

   INLINE E Generic_Homonym (E Id)
      { return Node11 (Id); }

   INLINE L Generic_Renamings (E Id)
      { return Elist23 (Id); }

   INLINE S Handler_Records (E Id)
      { return List10 (Id); }

   INLINE B Has_Aliased_Components (E Id)
      { return Flag135 (Implementation_Base_Type (Id)); }

   INLINE B Has_Alignment_Clause (E Id)
      { return Flag46 (Id); }

   INLINE B Has_All_Calls_Remote (E Id)
      { return Flag79 (Id); }

   INLINE B Has_Atomic_Components (E Id)
      { return Flag86 (Implementation_Base_Type (Id)); }

   INLINE B Has_Biased_Representation (E Id)
      { return Flag139 (Id); }

   INLINE B Has_Completion (E Id)
      { return Flag26 (Id); }

   INLINE B Has_Completion_In_Body (E Id)
      { return Flag71 (Id); }

   INLINE B Has_Complex_Representation (E Id)
      { return Flag140 (Implementation_Base_Type (Id)); }

   INLINE B Has_Component_Size_Clause (E Id)
      { return Flag68 (Implementation_Base_Type (Id)); }

   INLINE B Has_Constrained_Partial_View (E Id)
      { return Flag187 (Id); }

   INLINE B Has_Controlled_Component (E Id)
      { return Flag43 (Base_Type (Id)); }

   INLINE B Has_Contiguous_Rep (E Id)
      { return Flag181 (Id); }

   INLINE B Has_Controlling_Result (E Id)
      { return Flag98 (Id); }

   INLINE B Has_Convention_Pragma (E Id)
      { return Flag119 (Id); }

   INLINE B Has_Default_Aspect (E Id)
      { return Flag39 (Base_Type (Id)); }

   INLINE B Has_Delayed_Aspects (E Id)
      { return Flag200 (Id); }

   INLINE B Has_Delayed_Freeze (E Id)
      { return Flag18 (Id); }

   INLINE B Has_Delayed_Rep_Aspects (E Id)
      { return Flag261 (Id); }

   INLINE B Has_Discriminants (E Id)
      { return Flag5 (Id); }

   INLINE B Has_Dispatch_Table (E Id)
      { return Flag220 (Id); }

   INLINE B Has_Dynamic_Predicate_Aspect (E Id)
      { return Flag258 (Id); }

   INLINE B Has_Enumeration_Rep_Clause (E Id)
      { return Flag66 (Id); }

   INLINE B Has_Exit (E Id)
      { return Flag47 (Id); }

   INLINE B Has_Expanded_Contract (E Id)
      { return Flag240 (Id); }

   INLINE B Has_Forward_Instantiation (E Id)
      { return Flag175 (Id); }

   INLINE B Has_Fully_Qualified_Name (E Id)
      { return Flag173 (Id); }

   INLINE B Has_Gigi_Rep_Item (E Id)
      { return Flag82 (Id); }

   INLINE B Has_Homonym (E Id)
      { return Flag56 (Id); }

   INLINE B Has_Implicit_Dereference (E Id)
      { return Flag251 (Id); }

   INLINE B Has_Independent_Components (E Id)
      { return Flag34 (Implementation_Base_Type (Id)); }

   INLINE B Has_Inheritable_Invariants (E Id)
      { return Flag248 (Base_Type (Id)); }

   INLINE B Has_Inherited_DIC (E Id)
      { return Flag133 (Base_Type (Id)); }

   INLINE B Has_Inherited_Invariants (E Id)
      { return Flag291 (Base_Type (Id)); }

   INLINE B Has_Initial_Value (E Id)
      { return Flag219 (Id); }

   INLINE B Has_Loop_Entry_Attributes (E Id)
      { return Flag260 (Id); }

   INLINE B Has_Machine_Radix_Clause (E Id)
      { return Flag83 (Id); }

   INLINE B Has_Master_Entity (E Id)
      { return Flag21 (Id); }

   INLINE B Has_Missing_Return (E Id)
      { return Flag142 (Id); }

   INLINE B Has_Nested_Block_With_Handler (E Id)
      { return Flag101 (Id); }

   INLINE B Has_Nested_Subprogram (E Id)
      { return Flag282 (Id); }

   INLINE B Has_Non_Standard_Rep (E Id)
      { return Flag75 (Implementation_Base_Type (Id)); }

   INLINE B Has_Object_Size_Clause (E Id)
      { return Flag172 (Id); }

   INLINE B Has_Out_Or_In_Out_Parameter (E Id)
      { return Flag110 (Id); }

   INLINE B Has_Own_DIC (E Id)
      { return Flag3 (Base_Type (Id)); }

   INLINE B Has_Own_Invariants (E Id)
      { return Flag232 (Base_Type (Id)); }

   INLINE B Has_Partial_Visible_Refinement (E Id)
      { return Flag296 (Id); }

   INLINE B Has_Per_Object_Constraint (E Id)
      { return Flag154 (Id); }

   INLINE B Has_Pragma_Controlled (E Id)
      { return Flag27 (Implementation_Base_Type (Id)); }

   INLINE B Has_Pragma_Elaborate_Body (E Id)
      { return Flag150 (Id); }

   INLINE B Has_Pragma_Inline (E Id)
      { return Flag157 (Id); }

   INLINE B Has_Pragma_Inline_Always (E Id)
      { return Flag230 (Id); }

   INLINE B Has_Pragma_No_Inline (E Id)
      { return Flag201 (Id); }

   INLINE B Has_Pragma_Ordered (E Id)
      { return Flag198 (Implementation_Base_Type (Id)); }

   INLINE B Has_Pragma_Pack (E Id)
      { return Flag121 (Implementation_Base_Type (Id)); }

   INLINE B Has_Pragma_Preelab_Init (E Id)
      { return Flag221 (Id); }

   INLINE B Has_Pragma_Pure (E Id)
      { return Flag203 (Id); }

   INLINE B Has_Pragma_Pure_Function (E Id)
      { return Flag179 (Id); }

   INLINE B Has_Pragma_Thread_Local_Storage (E Id)
      { return Flag169 (Id); }

   INLINE B Has_Pragma_Unmodified (E Id)
      { return Flag233 (Id); }

   INLINE B Has_Pragma_Unreferenced (E Id)
      { return Flag180 (Id); }

   INLINE B Has_Pragma_Unreferenced_Objects (E Id)
      { return Flag212 (Id); }

   INLINE B Has_Pragma_Unused (E Id)
      { return Flag294 (Id); }

   INLINE B Has_Predicates (E Id)
      { return Flag250 (Id); }

   INLINE B Has_Primitive_Operations (E Id)
      { return Flag120 (Base_Type (Id)); }

   INLINE B Has_Private_Ancestor (E Id)
      { return Flag151 (Id); }

   INLINE B Has_Private_Declaration (E Id)
      { return Flag155 (Id); }

   INLINE B Has_Protected (E Id)
      { return Flag271 (Base_Type (Id)); }

   INLINE B Has_Qualified_Name (E Id)
      { return Flag161 (Id); }

   INLINE B Has_RACW (E Id)
      { return Flag214 (Id); }

   INLINE B Has_Record_Rep_Clause (E Id)
      { return Flag65 (Implementation_Base_Type (Id)); }

   INLINE B Has_Recursive_Call (E Id)
      { return Flag143 (Id); }

   INLINE B Has_Shift_Operator (E Id)
      { return Flag267 (Base_Type (Id)); }

   INLINE B Has_Size_Clause (E Id)
      { return Flag29 (Id); }

   INLINE B Has_Small_Clause (E Id)
      { return Flag67 (Id); }

   INLINE B Has_Specified_Layout (E Id)
      { return Flag100 (Implementation_Base_Type (Id)); }

   INLINE B Has_Specified_Stream_Input (E Id)
      { return Flag190 (Id); }

   INLINE B Has_Specified_Stream_Output (E Id)
      { return Flag191 (Id); }

   INLINE B Has_Specified_Stream_Read (E Id)
      { return Flag192 (Id); }

   INLINE B Has_Specified_Stream_Write (E Id)
      { return Flag193 (Id); }

   INLINE B Has_Static_Discriminants (E Id)
      { return Flag211 (Id); }

   INLINE B Has_Static_Predicate (E Id)
      { return Flag269 (Id); }

   INLINE B Has_Static_Predicate_Aspect (E Id)
      { return Flag259 (Id); }

   INLINE B Has_Storage_Size_Clause (E Id)
      { return Flag23 (Implementation_Base_Type (Id)); }

   INLINE B Has_Stream_Size_Clause (E Id)
      { return Flag184 (Id); }

   INLINE B Has_Task (E Id)
      { return Flag30 (Base_Type (Id)); }

   INLINE B Has_Thunks (E Id)
      { return Flag228 (Id); }

   INLINE B Has_Timing_Event (E Id)
      { return Flag289 (Base_Type (Id)); }

   INLINE B Has_Unchecked_Union (E Id)
      { return Flag123 (Base_Type (Id)); }

   INLINE B Has_Unknown_Discriminants (E Id)
      { return Flag72 (Id); }

   INLINE B Has_Visible_Refinement (E Id)
      { return Flag263 (Id); }

   INLINE B Has_Volatile_Components (E Id)
      { return Flag87 (Implementation_Base_Type (Id)); }

   INLINE B Has_Xref_Entry (E Id)
      { return Flag182 (Id); }

   INLINE E Hiding_Loop_Variable (E Id)
      { return Node8 (Id); }

   INLINE E Homonym (E Id)
      { return Node4 (Id); }

   INLINE E Import_Pragma (E Id)
      { return Node35 (Id); }

   INLINE L Incomplete_Actuals (E Id)
      { return Elist24 (Id); }

   INLINE E Interface_Alias (E Id)
      { return Node25 (Id); }

   INLINE L Interfaces (E Id)
      { return Elist25 (Id); }

   INLINE B In_Package_Body (E Id)
      { return Flag48 (Id); }

   INLINE B In_Private_Part (E Id)
      { return Flag45 (Id); }

   INLINE B In_Use (E Id)
      { return Flag8 (Id); }

   INLINE L Inner_Instances (E Id)
      { return Elist23 (Id); }

   INLINE N Interface_Name (E Id)
      { return Node21 (Id); }

   INLINE B Is_Abstract_Subprogram (E Id)
      { return Flag19 (Id); }

   INLINE B Is_Abstract_Type (E Id)
      { return Flag146 (Id); }

   INLINE B Is_Access_Constant (E Id)
      { return Flag69 (Id); }

   INLINE B Is_Actual_Subtype (E Id)
      { return Flag293 (Id); }

   INLINE B Is_Ada_2005_Only (E Id)
      { return Flag185 (Id); }

   INLINE B Is_Ada_2012_Only (E Id)
      { return Flag199 (Id); }

   INLINE B Is_Aliased (E Id)
      { return Flag15 (Id); }

   INLINE B Is_Asynchronous (E Id)
      { return Flag81 (Id); }

   INLINE B Is_Atomic (E Id)
      { return Flag85 (Id); }

   INLINE B Is_Bit_Packed_Array (E Id)
      { return Flag122 (Implementation_Base_Type (Id)); }

   INLINE B Is_Called (E Id)
      { return Flag102 (Id); }

   INLINE B Is_Character_Type (E Id)
      { return Flag63 (Id); }

   INLINE B Is_Checked_Ghost_Entity (E Id)
      { return Flag277 (Id); }

   INLINE B Is_Child_Unit (E Id)
      { return Flag73 (Id); }

   INLINE B Is_Class_Wide_Equivalent_Type (E Id)
      { return Flag35 (Id); }

   INLINE B Is_Compilation_Unit (E Id)
      { return Flag149 (Id); }

   INLINE B Is_Completely_Hidden (E Id)
      { return Flag103 (Id); }

   INLINE B Is_Constr_Subt_For_U_Nominal (E Id)
      { return Flag80 (Id); }

   INLINE B Is_Constr_Subt_For_UN_Aliased (E Id)
      { return Flag141 (Id); }

   INLINE B Is_Constrained (E Id)
      { return Flag12 (Id); }

   INLINE B Is_Constructor (E Id)
      { return Flag76 (Id); }

   INLINE B Is_Controlled (E Id)
      { return Flag42 (Base_Type (Id)); }

   INLINE B Is_Controlling_Formal (E Id)
      { return Flag97 (Id); }

   INLINE B Is_CPP_Class (E Id)
      { return Flag74 (Id); }

   INLINE B Is_DIC_Procedure (E Id)
      { return Flag132 (Id); }

   INLINE B Is_Descendant_Of_Address (E Id)
      { return Flag223 (Id); }

   INLINE B Is_Discrim_SO_Function (E Id)
      { return Flag176 (Id); }

   INLINE B Is_Discriminant_Check_Function (E Id)
      { return Flag264 (Id); }

   INLINE B Is_Dispatch_Table_Entity (E Id)
      { return Flag234 (Id); }

   INLINE B Is_Dispatching_Operation (E Id)
      { return Flag6 (Id); }

   INLINE B Is_Eliminated (E Id)
      { return Flag124 (Id); }

   INLINE B Is_Entry_Formal (E Id)
      { return Flag52 (Id); }

   INLINE B Is_Entry_Wrapper (E Id)
      { return Flag297 (Id); }

   INLINE B Is_Exception_Handler (E Id)
      { return Flag286 (Id); }

   INLINE B Is_Exported (E Id)
      { return Flag99 (Id); }

   INLINE B Is_Finalized_Transient (E Id)
      { return Flag252 (Id); }

   INLINE B Is_First_Subtype (E Id)
      { return Flag70 (Id); }

   INLINE B Is_For_Access_Subtype (E Id)
      { return Flag118 (Id); }

   INLINE B Is_Formal_Subprogram (E Id)
      { return Flag111 (Id); }

   INLINE B Is_Frozen (E Id)
      { return Flag4 (Id); }

   INLINE B Is_Generic_Actual_Subprogram (E Id)
      { return Flag274 (Id); }

   INLINE B Is_Generic_Actual_Type (E Id)
      { return Flag94 (Id); }

   INLINE B Is_Generic_Instance (E Id)
      { return Flag130 (Id); }

   INLINE B Is_Generic_Type (E Id)
      { return Flag13 (Id); }

   INLINE B Is_Hidden (E Id)
      { return Flag57 (Id); }

   INLINE B Is_Hidden_Non_Overridden_Subpgm (E Id)
      { return Flag2 (Id); }

   INLINE B Is_Hidden_Open_Scope (E Id)
      { return Flag171 (Id); }

   INLINE B Is_Ignored_Ghost_Entity (E Id)
      { return Flag278 (Id); }

   INLINE B Is_Ignored_Transient (E Id)
      { return Flag295 (Id); }

   INLINE B Is_Immediately_Visible (E Id)
      { return Flag7 (Id); }

   INLINE B Is_Implementation_Defined (E Id)
      { return Flag254 (Id); }

   INLINE B Is_Imported (E Id)
      { return Flag24 (Id); }

   INLINE B Is_Independent (E Id)
      { return Flag268 (Id); }

   INLINE B Is_Inlined (E Id)
      { return Flag11 (Id); }

   INLINE B Is_Inlined_Always (E Id)
      { return Flag1 (Id); }

   INLINE B Is_Interface (E Id)
      { return Flag186 (Id); }

   INLINE B Is_Instantiated (E Id)
      { return Flag126 (Id); }

   INLINE B Is_Internal (E Id)
      { return Flag17 (Id); }

   INLINE B Is_Interrupt_Handler (E Id)
      { return Flag89 (Id); }

   INLINE B Is_Intrinsic_Subprogram (E Id)
      { return Flag64 (Id); }

   INLINE B Is_Invariant_Procedure (E Id)
      { return Flag257 (Id); }

   INLINE B Is_Itype (E Id)
      { return Flag91 (Id); }

   INLINE B Is_Known_Non_Null (E Id)
      { return Flag37 (Id); }

   INLINE B Is_Known_Null (E Id)
      { return Flag204 (Id); }

   INLINE B Is_Known_Valid (E Id)
      { return Flag170 (Id); }

   INLINE B Is_Limited_Composite (E Id)
      { return Flag106 (Id); }

   INLINE B Is_Limited_Interface (E Id)
      { return Flag197 (Id); }

   INLINE B Is_Limited_Record (E Id)
      { return Flag25 (Id); }

   INLINE B Is_Local_Anonymous_Access (E Id)
      { return Flag194 (Id); }

   INLINE B Is_Machine_Code_Subprogram (E Id)
      { return Flag137 (Id); }

   INLINE B Is_Non_Static_Subtype (E Id)
      { return Flag109 (Id); }

   INLINE B Is_Null_Init_Proc (E Id)
      { return Flag178 (Id); }

   INLINE B Is_Obsolescent (E Id)
      { return Flag153 (Id); }

   INLINE B Is_Only_Out_Parameter (E Id)
      { return Flag226 (Id); }

   INLINE B Is_Package_Body_Entity (E Id)
      { return Flag160 (Id); }

   INLINE B Is_Packed (E Id)
      { return Flag51 (Implementation_Base_Type (Id)); }

   INLINE B Is_Packed_Array_Impl_Type (E Id)
      { return Flag138 (Id); }

   INLINE B Is_Param_Block_Component_Type (E Id)
      { return Flag215 (Base_Type (Id)); }

   INLINE B Is_Partial_Invariant_Procedure (E Id)
      { return Flag292 (Id); }

   INLINE B Is_Potentially_Use_Visible (E Id)
      { return Flag9 (Id); }

   INLINE B Is_Predicate_Function (E Id)
      { return Flag255 (Id); }

   INLINE B Is_Predicate_Function_M (E Id)
      { return Flag256 (Id); }

   INLINE B Is_Preelaborated (E Id)
      { return Flag59 (Id); }

   INLINE B Is_Primitive (E Id)
      { return Flag218 (Id); }

   INLINE B Is_Primitive_Wrapper (E Id)
      { return Flag195 (Id); }

   INLINE B Is_Private_Composite (E Id)
      { return Flag107 (Id); }

   INLINE B Is_Private_Descendant (E Id)
      { return Flag53 (Id); }

   INLINE B Is_Private_Primitive (E Id)
      { return Flag245 (Id); }

   INLINE B Is_Public (E Id)
      { return Flag10 (Id); }

   INLINE B Is_Pure (E Id)
      { return Flag44 (Id); }

   INLINE B Is_Pure_Unit_Access_Type (E Id)
      { return Flag189 (Id); }

   INLINE B Is_RACW_Stub_Type (E Id)
      { return Flag244 (Id); }

   INLINE B Is_Raised (E Id)
      { return Flag224 (Id); }

   INLINE B Is_Remote_Call_Interface (E Id)
      { return Flag62 (Id); }

   INLINE B Is_Remote_Types (E Id)
      { return Flag61 (Id); }

   INLINE B Is_Renaming_Of_Object (E Id)
      { return Flag112 (Id); }

   INLINE B Is_Return_Object (E Id)
      { return Flag209 (Id); }

   INLINE B Is_Safe_To_Reevaluate (E Id)
      { return Flag249 (Id); }

   INLINE B Is_Shared_Passive (E Id)
      { return Flag60 (Id); }

   INLINE B Is_Static_Type (E Id)
      { return Flag281 (Id); }

   INLINE B Is_Statically_Allocated (E Id)
      { return Flag28 (Id); }

   INLINE B Is_Tag (E Id)
      { return Flag78 (Id); }

   INLINE B Is_Tagged_Type (E Id)
      { return Flag55 (Id); }

   INLINE B Is_Thunk (E Id)
      { return Flag225 (Id); }

   INLINE B Is_Trivial_Subprogram (E Id)
      { return Flag235 (Id); }

   INLINE B Is_True_Constant (E Id)
      { return Flag163 (Id); }

   INLINE B Is_Unchecked_Union (E Id)
      { return Flag117 (Implementation_Base_Type (Id)); }

   INLINE B Is_Underlying_Full_View (E Id)
      { return Flag298 (Id); }

   INLINE B Is_Underlying_Record_View (E Id)
      { return Flag246 (Id); }

   INLINE B Is_Unimplemented (E Id)
      { return Flag284 (Id); }

   INLINE B Is_Unsigned_Type (E Id)
      { return Flag144 (Id); }

   INLINE B Is_Uplevel_Referenced_Entity (E Id)
      { return Flag283 (Id); }

   INLINE B Is_Valued_Procedure (E Id)
      { return Flag127 (Id); }

   INLINE B Is_Visible_Formal (E Id)
      { return Flag206 (Id); }

   INLINE B Is_Visible_Lib_Unit (E Id)
      { return Flag116 (Id); }

   INLINE B Is_Volatile_Full_Access (E Id)
      { return Flag285 (Id); }

   INLINE B Itype_Printed (E Id)
      { return Flag202 (Id); }

   INLINE B Kill_Elaboration_Checks (E Id)
      { return Flag32 (Id); }

   INLINE B Kill_Range_Checks (E Id)
      { return Flag33 (Id); }

   INLINE B Known_To_Have_Preelab_Init (E Id)
      { return Flag207 (Id); }

   INLINE N Last_Aggregate_Assignment (E Id)
      { return Node30 (Id); }

   INLINE N Last_Assignment (E Id)
      { return Node26 (Id); }

   INLINE E Last_Entity (E Id)
      { return Node20 (Id); }

   INLINE E Limited_View (E Id)
      { return Node23 (Id); }

   INLINE N Linker_Section_Pragma (E Id)
      { return Node33 (Id); }

   INLINE E Lit_Indexes (E Id)
      { return Node18 (Id); }

   INLINE E Lit_Strings (E Id)
      { return Node16 (Id); }

   INLINE B Low_Bound_Tested (E Id)
      { return Flag205 (Id); }

   INLINE B Machine_Radix_10 (E Id)
      { return Flag84 (Id); }

   INLINE E Master_Id (E Id)
      { return Node17 (Id); }

   INLINE B Materialize_Entity (E Id)
      { return Flag168 (Id); }

   INLINE B May_Inherit_Delayed_Rep_Aspects (E Id)
      { return Flag262 (Id); }

   INLINE M Mechanism (E Id)
      { return UI_To_Int (Uint8 (Id)); }

   INLINE Uint Modulus (E Id)
      { return Uint17 (Base_Type (Id)); }

   INLINE B Must_Be_On_Byte_Boundary (E Id)
      { return Flag183 (Id); }

   INLINE B Must_Have_Preelab_Init (E Id)
      { return Flag208 (Id); }

   INLINE B Needs_Debug_Info (E Id)
      { return Flag147 (Id); }

   INLINE B Needs_No_Actuals (E Id)
      { return Flag22 (Id); }

   INLINE B Never_Set_In_Source (E Id)
      { return Flag115 (Id); }

   INLINE E Next_Inlined_Subprogram (E Id)
      { return Node12 (Id); }

   INLINE Boolean No_Dynamic_Predicate_On_Actual (E Id)
      { return Flag276 (Id); }

   INLINE B No_Pool_Assigned (E Id)
      { return Flag131 (Root_Type (Id)); }

   INLINE Boolean No_Predicate_On_Actual (E Id)
      { return Flag275 (Id); }

   INLINE B No_Return (E Id)
      { return Flag113 (Id); }

   INLINE B No_Strict_Aliasing (E Id)
      { return Flag136 (Base_Type (Id)); }

   INLINE N No_Tagged_Streams_Pragma (E Id)
      { return Node32 (Id); }

   INLINE B Non_Binary_Modulus (E Id)
      { return Flag58 (Base_Type (Id)); }

   INLINE E Non_Limited_View (E Id)
      { return Node19 (Id); }

   INLINE B Nonzero_Is_True (E Id)
      { return Flag162 (Base_Type (Id)); }

   INLINE U Normalized_First_Bit (E Id)
      { return Uint8 (Id); }

   INLINE U Normalized_Position (E Id)
      { return Uint14 (Id); }

   INLINE U Normalized_Position_Max (E Id)
      { return Uint10 (Id); }

   INLINE B OK_To_Rename (E Id)
      { return Flag247 (Id); }

   INLINE B OK_To_Reorder_Components (E Id)
      { return Flag239 (Base_Type (Id)); }

   INLINE B Optimize_Alignment_Space (E Id)
      { return Flag241 (Id); }

   INLINE B Optimize_Alignment_Time (E Id)
      { return Flag242 (Id); }

   INLINE E Original_Access_Type (E Id)
      { return Node28 (Id); }

   INLINE E Original_Array_Type (E Id)
      { return Node21 (Id); }

   INLINE N Original_Protected_Subprogram (E Id)
      { return Node41 (Id); }

   INLINE E Original_Record_Component (E Id)
      { return Node22 (Id); }

   INLINE B Overlays_Constant (E Id)
      { return Flag243 (Id); }

   INLINE E Overridden_Operation (E Id)
      { return Node26 (Id); }

   INLINE N Package_Instantiation (E Id)
      { return Node26 (Id); }

   INLINE E Packed_Array_Impl_Type (E Id)
      { return Node23 (Id); }

   INLINE E Parent_Subtype (E Id)
      { return Node19 (Base_Type (Id)); }

   INLINE L Part_Of_Constituents (E Id)
      { return Elist10 (Id); }

   INLINE L Part_Of_References (E Id)
      { return Elist11 (Id); }

   INLINE B Partial_View_Has_Unknown_Discr (E Id)
      { return Flag280 (Id); }

   INLINE L Pending_Access_Types (E Id)
      { return Elist15 (Id); }

   INLINE E Postconditions_Proc (E Id)
      { return Node14 (Id); }

   INLINE B Predicates_Ignored (E Id)
      { return Flag288 (Id); }

   INLINE E Prival (E Id)
      { return Node17 (Id); }

   INLINE E Prival_Link (E Id)
      { return Node20 (Id); }

   INLINE L Private_Dependents (E Id)
      { return Elist18 (Id); }

   INLINE N Private_View (E Id)
      { return Node22 (Id); }

   INLINE E Protected_Body_Subprogram (E Id)
      { return Node11 (Id); }

   INLINE E Protected_Formal (E Id)
      { return Node22 (Id); }

   INLINE E Protection_Object (E Id)
      { return Node23 (Id); }

   INLINE B Reachable (E Id)
      { return Flag49 (Id); }

   INLINE B Referenced (E Id)
      { return Flag156 (Id); }

   INLINE B Referenced_As_LHS (E Id)
      { return Flag36 (Id); }

   INLINE B Referenced_As_Out_Parameter (E Id)
      { return Flag227 (Id); }

   INLINE L Refinement_Constituents (E Id)
      { return Elist8 (Id); }

   INLINE N Register_Exception_Call (E Id)
      { return Node20 (Id); }

   INLINE E Related_Array_Object (E Id)
      { return Node25 (Id); }

   INLINE N Related_Expression (E Id)
      { return Node24 (Id); }

   INLINE E Related_Instance (E Id)
      { return Node15 (Id); }

   INLINE E Related_Type (E Id)
      { return Node27 (Id); }

   INLINE E Relative_Deadline_Variable (E Id)
      { return Node28 (Implementation_Base_Type (Id)); }

   INLINE N Renamed_Entity (E Id)
      { return Node18 (Id); }

   INLINE B Renamed_In_Spec (E Id)
      { return Flag231 (Id); }

   INLINE N Renamed_Object (E Id)
      { return Node18 (Id); }

   INLINE U Renaming_Map (E Id)
      { return Uint9 (Id); }

   INLINE B Requires_Overriding (E Id)
      { return Flag213 (Id); }

   INLINE B Return_Present (E Id)
      { return Flag54 (Id); }

   INLINE N Return_Applies_To (E Id)
      { return Node8 (Id); }

   INLINE B Returns_By_Ref (E Id)
      { return Flag90 (Id); }

   INLINE B Reverse_Bit_Order (E Id)
      { return Flag164 (Base_Type (Id)); }

   INLINE B Reverse_Storage_Order (E Id)
      { return Flag93 (Base_Type (Id)); }

   INLINE B Rewritten_For_C (E Id)
      { return Flag287 (Id); }

   INLINE U RM_Size (E Id)
      { return Uint13 (Id); }

   INLINE N Scalar_Range (E Id)
      { return Node20 (Id); }

   INLINE U Scale_Value (E Id)
      { return Uint16 (Id); }

   INLINE U Scope_Depth_Value (E Id)
      { return Uint22 (Id); }

   INLINE B Sec_Stack_Needed_For_Return (E Id)
      { return Flag167 (Id); }

   INLINE S Shadow_Entities (E Id)
      { return List14 (Id); }

   INLINE E Shared_Var_Procs_Instance (E Id)
      { return Node22 (Id); }

   INLINE N Size_Check_Code (E Id)
      { return Node19 (Id); }

   INLINE B Size_Depends_On_Discriminant (E Id)
      { return Flag177 (Id); }

   INLINE B Size_Known_At_Compile_Time (E Id)
      { return Flag92 (Id); }

   INLINE R Small_Value (E Id)
      { return Ureal21 (Id); }

   INLINE N SPARK_Aux_Pragma (E Id)
      { return Node41 (Id); }

   INLINE B SPARK_Aux_Pragma_Inherited (E Id)
      { return Flag266 (Id); }

   INLINE N SPARK_Pragma (E Id)
      { return Node40 (Id); }

   INLINE B SPARK_Pragma_Inherited (E Id)
      { return Flag265 (Id); }

   INLINE E Spec_Entity (E Id)
      { return Node19 (Id); }

   INLINE B SSO_Set_High_By_Default (E Id)
      { return Flag273 (Base_Type (Id)); }

   INLINE B SSO_Set_Low_By_Default (E Id)
      { return Flag272 (Base_Type (Id)); }

   INLINE S Static_Discrete_Predicate (E Id)
      { return List25 (Id); }

   INLINE N Static_Real_Or_String_Predicate (E Id)
      { return Node25 (Id); }

   INLINE N Status_Flag_Or_Transient_Decl (E Id)
      { return Node15 (Id); }

   INLINE E Storage_Size_Variable (E Id)
      { return Node26 (Implementation_Base_Type (Id)); }

   INLINE B Static_Elaboration_Desired (E Id)
      { return Flag77 (Id); }

   INLINE N Static_Initialization (E Id)
      { return Node30 (Id); }

   INLINE L Stored_Constraint (E Id)
      { return Elist23 (Id); }

   INLINE B Stores_Attribute_Old_Prefix (E Id)
      { return Flag270 (Id); }

   INLINE B Strict_Alignment (E Id)
      { return Flag145 (Implementation_Base_Type (Id)); }

   INLINE U String_Literal_Length (E Id)
      { return Uint16 (Id); }

   INLINE N String_Literal_Low_Bound (E Id)
      { return Node18 (Id); }

   INLINE L Subprograms_For_Type (E Id)
      { return Elist29 (Id); }

   INLINE U Subps_Index (E Id)
      { return Uint24 (Id); }

   INLINE B Suppress_Elaboration_Warnings (E Id)
      { return Flag148 (Id); }

   INLINE B Suppress_Initialization (E Id)
      { return Flag105 (Id); }

   INLINE B Suppress_Style_Checks (E Id)
      { return Flag165 (Id); }

   INLINE B Suppress_Value_Tracking_On_Call (E Id)
      { return Flag217 (Id); }

   INLINE N Task_Body_Procedure (E Id)
      { return Node25 (Id); }

   INLINE E Thunk_Entity (E Id)
      { return Node31 (Id); }

   INLINE B Treat_As_Volatile (E Id)
      { return Flag41 (Id); }

   INLINE E Underlying_Full_View (E Id)
      { return Node19 (Id); }

   INLINE E Underlying_Record_View (E Id)
      { return Node28 (Id); }

   INLINE B Universal_Aliasing (E Id)
      { return Flag216 (Implementation_Base_Type (Id)); }

   INLINE N Unset_Reference (E Id)
      { return Node16 (Id); }

   INLINE B Used_As_Generic_Actual (E Id)
      { return Flag222 (Id); }

   INLINE B Uses_Lock_Free (E Id)
      { return Flag188 (Id); }

   INLINE B Uses_Sec_Stack (E Id)
      { return Flag95 (Id); }

   INLINE B Warnings_Off (E Id)
      { return Flag96 (Id); }

   INLINE B Warnings_Off_Used (E Id)
      { return Flag236 (Id); }

   INLINE B Warnings_Off_Used_Unmodified (E Id)
      { return Flag237 (Id); }

   INLINE B Warnings_Off_Used_Unreferenced (E Id)
      { return Flag238 (Id); }

   INLINE E Wrapped_Entity (E Id)
      { return Node27 (Id); }

   INLINE B Was_Hidden (E Id)
      { return Flag196 (Id); }

   INLINE B Is_Access_Type                      (E Id)
      { return IN (Ekind (Id), Access_Kind); }

   INLINE B Is_Access_Protected_Subprogram_Type (E Id)
      { return IN (Ekind (Id), Access_Protected_Kind); }

   INLINE B Is_Access_Subprogram_Type           (E Id)
      { return IN (Ekind (Id), Access_Subprogram_Kind); }

   INLINE B Is_Aggregate_Type                   (E Id)
      { return IN (Ekind (Id), Aggregate_Kind); }

   INLINE B Is_Array_Type                       (E Id)
      { return IN (Ekind (Id), Array_Kind); }

   INLINE B Is_Assignable                       (E Id)
      { return IN (Ekind (Id), Assignable_Kind); }

   INLINE B Is_Class_Wide_Type                  (E Id)
      { return IN (Ekind (Id), Class_Wide_Kind); }

   INLINE B Is_Composite_Type                   (E Id)
      { return IN (Ekind (Id), Composite_Kind); }

   INLINE B Is_Concurrent_Body                  (E Id)
      { return IN (Ekind (Id), Concurrent_Body_Kind); }

   INLINE B Is_Concurrent_Record_Type           (E Id)
      { return Flag20 (Id); }

   INLINE B Is_Concurrent_Type                  (E Id)
      { return IN (Ekind (Id), Concurrent_Kind); }

   INLINE B Is_Decimal_Fixed_Point_Type         (E Id)
      { return IN (Ekind (Id), Decimal_Fixed_Point_Kind); }

   INLINE B Is_Digits_Type                      (E Id)
      { return IN (Ekind (Id), Digits_Kind); }

   INLINE B Is_Discrete_Or_Fixed_Point_Type     (E Id)
      { return IN (Ekind (Id), Discrete_Or_Fixed_Point_Kind); }

   INLINE B Is_Discrete_Type                    (E Id)
      { return IN (Ekind (Id), Discrete_Kind); }

   INLINE B Is_Elementary_Type                  (E Id)
      { return IN (Ekind (Id), Elementary_Kind); }

   INLINE B Is_Entry                            (E Id)
      { return IN (Ekind (Id), Entry_Kind); }

   INLINE B Is_Enumeration_Type                 (E Id)
      { return IN (Ekind (Id), Enumeration_Kind); }

   INLINE B Is_Fixed_Point_Type                 (E Id)
      { return IN (Ekind (Id), Fixed_Point_Kind); }

   INLINE B Is_Floating_Point_Type              (E Id)
      { return IN (Ekind (Id), Float_Kind); }

   INLINE B Is_Formal                           (E Id)
      { return IN (Ekind (Id), Formal_Kind); }

   INLINE B Is_Formal_Object                    (E Id)
      { return IN (Ekind (Id), Formal_Object_Kind); }

   INLINE B Is_Generic_Subprogram               (E Id)
      { return IN (Ekind (Id), Generic_Subprogram_Kind); }

   INLINE B Is_Generic_Unit                     (E Id)
      { return IN (Ekind (Id), Generic_Unit_Kind); }

   INLINE Boolean Is_Ghost_Entity (Entity_Id Id)
      { return Is_Checked_Ghost_Entity (Id) || Is_Ignored_Ghost_Entity (Id); }

   INLINE B Is_Incomplete_Or_Private_Type       (E Id)
      { return IN (Ekind (Id), Incomplete_Or_Private_Kind); }

   INLINE B Is_Incomplete_Type                  (E Id)
      { return IN (Ekind (Id), Incomplete_Kind); }

   INLINE B Is_Integer_Type                     (E Id)
      { return IN (Ekind (Id), Integer_Kind); }

   INLINE B Is_Modular_Integer_Type             (E Id)
      { return IN (Ekind (Id), Modular_Integer_Kind); }

   INLINE B Is_Named_Number                     (E Id)
      { return IN (Ekind (Id), Named_Kind); }

   INLINE B Is_Numeric_Type                     (E Id)
      { return IN (Ekind (Id), Numeric_Kind); }

   INLINE B Is_Object                           (E Id)
      { return IN (Ekind (Id), Object_Kind); }

   INLINE B Is_Ordinary_Fixed_Point_Type        (E Id)
      { return IN (Ekind (Id), Ordinary_Fixed_Point_Kind); }

   INLINE B Is_Overloadable                     (E Id)
      { return IN (Ekind (Id), Overloadable_Kind); }

   INLINE B Is_Private_Type                     (E Id)
      { return IN (Ekind (Id), Private_Kind); }

   INLINE B Is_Protected_Type                   (E Id)
      { return IN (Ekind (Id), Protected_Kind); }

   INLINE B Is_Real_Type                        (E Id)
      { return IN (Ekind (Id), Real_Kind); }

   INLINE B Is_Record_Type                      (E Id)
      { return IN (Ekind (Id), Record_Kind); }

   INLINE B Is_Scalar_Type                      (E Id)
      { return IN (Ekind (Id), Scalar_Kind); }

   INLINE B Is_Signed_Integer_Type              (E Id)
      { return IN (Ekind (Id), Signed_Integer_Kind); }

   INLINE B Is_Subprogram                       (E Id)
      { return IN (Ekind (Id), Subprogram_Kind); }

   INLINE B Is_Task_Type                        (E Id)
      { return IN (Ekind (Id), Task_Kind); }

   INLINE B Is_Type                             (E Id)
      { return IN (Ekind (Id), Type_Kind); }

   INLINE N Entry_Index_Type (E Id)
      { return Etype (Discrete_Subtype_Definition (Parent (Id))); }

   INLINE B Is_Atomic_Or_VFA (E Id)
      { return Is_Atomic (Id) || Is_Volatile_Full_Access (Id); }

   INLINE Node_Id Next_Index (Node_Id Id)
      { return Next (Id); }

   INLINE E Next_Literal (E Id)
      { return Next (Id); }

   INLINE Formal_Kind Parameter_Mode (E Id)
      { return Ekind (Id); }

#ifdef __cplusplus
}
#endif
/* End of einfo.h (C version of Einfo package specification) */
