/* ConfigURLPart.c generated by valac 0.30.2, the Vala compiler
 * generated from ConfigURLPart.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "deja.h"
#include <stdlib.h>
#include <string.h>
#include "uriutils.h"


#define DEJA_DUP_TYPE_CONFIG_WIDGET (deja_dup_config_widget_get_type ())
#define DEJA_DUP_CONFIG_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_WIDGET, DejaDupConfigWidget))
#define DEJA_DUP_CONFIG_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_WIDGET, DejaDupConfigWidgetClass))
#define DEJA_DUP_IS_CONFIG_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_WIDGET))
#define DEJA_DUP_IS_CONFIG_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_WIDGET))
#define DEJA_DUP_CONFIG_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_WIDGET, DejaDupConfigWidgetClass))

typedef struct _DejaDupConfigWidget DejaDupConfigWidget;
typedef struct _DejaDupConfigWidgetClass DejaDupConfigWidgetClass;
typedef struct _DejaDupConfigWidgetPrivate DejaDupConfigWidgetPrivate;

#define DEJA_DUP_TYPE_CONFIG_ENTRY (deja_dup_config_entry_get_type ())
#define DEJA_DUP_CONFIG_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_ENTRY, DejaDupConfigEntry))
#define DEJA_DUP_CONFIG_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_ENTRY, DejaDupConfigEntryClass))
#define DEJA_DUP_IS_CONFIG_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_ENTRY))
#define DEJA_DUP_IS_CONFIG_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_ENTRY))
#define DEJA_DUP_CONFIG_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_ENTRY, DejaDupConfigEntryClass))

typedef struct _DejaDupConfigEntry DejaDupConfigEntry;
typedef struct _DejaDupConfigEntryClass DejaDupConfigEntryClass;
typedef struct _DejaDupConfigEntryPrivate DejaDupConfigEntryPrivate;

#define DEJA_DUP_TYPE_CONFIG_URL_PART (deja_dup_config_url_part_get_type ())
#define DEJA_DUP_CONFIG_URL_PART(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_URL_PART, DejaDupConfigURLPart))
#define DEJA_DUP_CONFIG_URL_PART_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_URL_PART, DejaDupConfigURLPartClass))
#define DEJA_DUP_IS_CONFIG_URL_PART(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_URL_PART))
#define DEJA_DUP_IS_CONFIG_URL_PART_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_URL_PART))
#define DEJA_DUP_CONFIG_URL_PART_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_URL_PART, DejaDupConfigURLPartClass))

typedef struct _DejaDupConfigURLPart DejaDupConfigURLPart;
typedef struct _DejaDupConfigURLPartClass DejaDupConfigURLPartClass;
typedef struct _DejaDupConfigURLPartPrivate DejaDupConfigURLPartPrivate;

#define DEJA_DUP_CONFIG_URL_PART_TYPE_PART (deja_dup_config_url_part_part_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DejaDupConfigUrlPartSetFromConfigData DejaDupConfigUrlPartSetFromConfigData;
#define _deja_dup_decoded_uri_free0(var) ((var == NULL) ? NULL : (var = (deja_dup_decoded_uri_free (var), NULL)))

struct _DejaDupConfigWidget {
	GtkEventBox parent_instance;
	DejaDupConfigWidgetPrivate * priv;
	gboolean syncing;
	DejaDupFilteredSettings* settings;
	GList* all_settings;
};

struct _DejaDupConfigWidgetClass {
	GtkEventBoxClass parent_class;
	void (*set_from_config) (DejaDupConfigWidget* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_from_config_finish) (DejaDupConfigWidget* self, GAsyncResult* _res_);
};

struct _DejaDupConfigEntry {
	DejaDupConfigWidget parent_instance;
	DejaDupConfigEntryPrivate * priv;
	GtkEntry* entry;
};

struct _DejaDupConfigEntryClass {
	DejaDupConfigWidgetClass parent_class;
	void (*write_to_config) (DejaDupConfigEntry* self);
};

struct _DejaDupConfigURLPart {
	DejaDupConfigEntry parent_instance;
	DejaDupConfigURLPartPrivate * priv;
};

struct _DejaDupConfigURLPartClass {
	DejaDupConfigEntryClass parent_class;
};

typedef enum  {
	DEJA_DUP_CONFIG_URL_PART_PART_SCHEME,
	DEJA_DUP_CONFIG_URL_PART_PART_SERVER,
	DEJA_DUP_CONFIG_URL_PART_PART_PORT,
	DEJA_DUP_CONFIG_URL_PART_PART_USER,
	DEJA_DUP_CONFIG_URL_PART_PART_FOLDER,
	DEJA_DUP_CONFIG_URL_PART_PART_DOMAIN
} DejaDupConfigURLPartPart;

struct _DejaDupConfigURLPartPrivate {
	DejaDupConfigURLPartPart _part;
};

struct _DejaDupConfigUrlPartSetFromConfigData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupConfigURLPart* self;
	gchar* userval;
	DejaDupFilteredSettings* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	DejaDupConfigURLPartPart _tmp3_;
	gchar* _tmp4_;
	GtkEntry* _tmp5_;
};


static gpointer deja_dup_config_url_part_parent_class = NULL;

GType deja_dup_config_widget_get_type (void) G_GNUC_CONST;
GType deja_dup_config_entry_get_type (void) G_GNUC_CONST;
GType deja_dup_config_url_part_get_type (void) G_GNUC_CONST;
GType deja_dup_config_url_part_part_get_type (void) G_GNUC_CONST;
#define DEJA_DUP_CONFIG_URL_PART_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_CONFIG_URL_PART, DejaDupConfigURLPartPrivate))
enum  {
	DEJA_DUP_CONFIG_URL_PART_DUMMY_PROPERTY,
	DEJA_DUP_CONFIG_URL_PART_PART
};
DejaDupConfigURLPart* deja_dup_config_url_part_new (DejaDupConfigURLPartPart part, const gchar* key, const gchar* ns);
DejaDupConfigURLPart* deja_dup_config_url_part_construct (GType object_type, DejaDupConfigURLPartPart part, const gchar* key, const gchar* ns);
static void deja_dup_config_url_part_real_set_from_config_data_free (gpointer _data);
static void deja_dup_config_url_part_real_set_from_config (DejaDupConfigWidget* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_config_url_part_real_set_from_config_co (DejaDupConfigUrlPartSetFromConfigData* _data_);
gchar* deja_dup_config_url_part_read_uri_part (DejaDupFilteredSettings* settings, const gchar* key, DejaDupConfigURLPartPart part);
const gchar* deja_dup_config_widget_get_key (DejaDupConfigWidget* self);
DejaDupConfigURLPartPart deja_dup_config_url_part_get_part (DejaDupConfigURLPart* self);
static void deja_dup_config_url_part_real_write_to_config (DejaDupConfigEntry* base);
void deja_dup_config_url_part_write_uri_part (DejaDupFilteredSettings* settings, const gchar* key, DejaDupConfigURLPartPart part, const gchar* userval);
static DejaDupDecodedUri* deja_dup_config_url_part_get_current_uri (DejaDupFilteredSettings* settings, const gchar* key);
static gchar* deja_dup_config_url_part_userinfo_get_user (const gchar* scheme, const gchar* userinfo);
static gchar* deja_dup_config_url_part_userinfo_get_domain (const gchar* scheme, const gchar* userinfo);
static gchar* deja_dup_config_url_part_userinfo_set_user (const gchar* scheme, const gchar* userinfo, const gchar* user);
static gchar* deja_dup_config_url_part_userinfo_set_domain (const gchar* scheme, const gchar* userinfo, const gchar* domain);
static void deja_dup_config_url_part_scrub_uri (DejaDupDecodedUri* uri);
static void deja_dup_config_url_part_set_part (DejaDupConfigURLPart* self, DejaDupConfigURLPartPart value);
static GObject * deja_dup_config_url_part_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void deja_dup_config_url_part_finalize (GObject* obj);
static void _vala_deja_dup_config_url_part_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_deja_dup_config_url_part_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType deja_dup_config_url_part_part_get_type (void) {
	static volatile gsize deja_dup_config_url_part_part_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_config_url_part_part_type_id__volatile)) {
		static const GEnumValue values[] = {{DEJA_DUP_CONFIG_URL_PART_PART_SCHEME, "DEJA_DUP_CONFIG_URL_PART_PART_SCHEME", "scheme"}, {DEJA_DUP_CONFIG_URL_PART_PART_SERVER, "DEJA_DUP_CONFIG_URL_PART_PART_SERVER", "server"}, {DEJA_DUP_CONFIG_URL_PART_PART_PORT, "DEJA_DUP_CONFIG_URL_PART_PART_PORT", "port"}, {DEJA_DUP_CONFIG_URL_PART_PART_USER, "DEJA_DUP_CONFIG_URL_PART_PART_USER", "user"}, {DEJA_DUP_CONFIG_URL_PART_PART_FOLDER, "DEJA_DUP_CONFIG_URL_PART_PART_FOLDER", "folder"}, {DEJA_DUP_CONFIG_URL_PART_PART_DOMAIN, "DEJA_DUP_CONFIG_URL_PART_PART_DOMAIN", "domain"}, {0, NULL, NULL}};
		GType deja_dup_config_url_part_part_type_id;
		deja_dup_config_url_part_part_type_id = g_enum_register_static ("DejaDupConfigURLPartPart", values);
		g_once_init_leave (&deja_dup_config_url_part_part_type_id__volatile, deja_dup_config_url_part_part_type_id);
	}
	return deja_dup_config_url_part_part_type_id__volatile;
}


DejaDupConfigURLPart* deja_dup_config_url_part_construct (GType object_type, DejaDupConfigURLPartPart part, const gchar* key, const gchar* ns) {
	DejaDupConfigURLPart * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	DejaDupConfigURLPartPart _tmp2_ = 0;
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (ns != NULL, NULL);
	_tmp0_ = key;
	_tmp1_ = ns;
	_tmp2_ = part;
	self = (DejaDupConfigURLPart*) g_object_new (object_type, "key", _tmp0_, "ns", _tmp1_, "part", _tmp2_, NULL);
	return self;
}


DejaDupConfigURLPart* deja_dup_config_url_part_new (DejaDupConfigURLPartPart part, const gchar* key, const gchar* ns) {
	return deja_dup_config_url_part_construct (DEJA_DUP_TYPE_CONFIG_URL_PART, part, key, ns);
}


static void deja_dup_config_url_part_real_set_from_config_data_free (gpointer _data) {
	DejaDupConfigUrlPartSetFromConfigData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupConfigUrlPartSetFromConfigData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void deja_dup_config_url_part_real_set_from_config (DejaDupConfigWidget* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupConfigURLPart * self;
	DejaDupConfigUrlPartSetFromConfigData* _data_;
	DejaDupConfigURLPart* _tmp0_ = NULL;
	self = (DejaDupConfigURLPart*) base;
	_data_ = g_slice_new0 (DejaDupConfigUrlPartSetFromConfigData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_config_url_part_real_set_from_config);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_config_url_part_real_set_from_config_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_config_url_part_real_set_from_config_co (_data_);
}


static void deja_dup_config_url_part_real_set_from_config_finish (DejaDupConfigWidget* base, GAsyncResult* _res_) {
	DejaDupConfigUrlPartSetFromConfigData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean deja_dup_config_url_part_real_set_from_config_co (DejaDupConfigUrlPartSetFromConfigData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = ((DejaDupConfigWidget*) _data_->self)->settings;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = deja_dup_config_widget_get_key ((DejaDupConfigWidget*) _data_->self);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = 0;
	_data_->_tmp3_ = _data_->self->priv->_part;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = deja_dup_config_url_part_read_uri_part (_data_->_tmp0_, _data_->_tmp2_, _data_->_tmp3_);
	_data_->userval = _data_->_tmp4_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = ((DejaDupConfigEntry*) _data_->self)->entry;
	gtk_entry_set_text (_data_->_tmp5_, _data_->userval);
	_g_free0 (_data_->userval);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void deja_dup_config_url_part_real_write_to_config (DejaDupConfigEntry* base) {
	DejaDupConfigURLPart * self;
	gchar* userval = NULL;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	DejaDupFilteredSettings* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	DejaDupConfigURLPartPart _tmp6_ = 0;
	self = (DejaDupConfigURLPart*) base;
	_tmp0_ = ((DejaDupConfigEntry*) self)->entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	userval = _tmp2_;
	_tmp3_ = ((DejaDupConfigWidget*) self)->settings;
	_tmp4_ = deja_dup_config_widget_get_key ((DejaDupConfigWidget*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_part;
	deja_dup_config_url_part_write_uri_part (_tmp3_, _tmp5_, _tmp6_, userval);
	_g_free0 (userval);
}


gchar* deja_dup_config_url_part_read_uri_part (DejaDupFilteredSettings* settings, const gchar* key, DejaDupConfigURLPartPart part) {
	gchar* result = NULL;
	DejaDupDecodedUri* uri = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	DejaDupDecodedUri* _tmp2_ = NULL;
	gchar* text = NULL;
	DejaDupConfigURLPartPart _tmp3_ = 0;
	const gchar* _tmp28_ = NULL;
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = settings;
	_tmp1_ = key;
	_tmp2_ = deja_dup_config_url_part_get_current_uri (_tmp0_, _tmp1_);
	uri = _tmp2_;
	text = NULL;
	_tmp3_ = part;
	switch (_tmp3_) {
		case DEJA_DUP_CONFIG_URL_PART_PART_SCHEME:
		{
			DejaDupDecodedUri* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			_tmp4_ = uri;
			_tmp5_ = _tmp4_->scheme;
			_tmp6_ = g_strdup (_tmp5_);
			_g_free0 (text);
			text = _tmp6_;
			break;
		}
		case DEJA_DUP_CONFIG_URL_PART_PART_SERVER:
		{
			DejaDupDecodedUri* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			_tmp7_ = uri;
			_tmp8_ = _tmp7_->host;
			_tmp9_ = g_strdup (_tmp8_);
			_g_free0 (text);
			text = _tmp9_;
			break;
		}
		case DEJA_DUP_CONFIG_URL_PART_PART_PORT:
		{
			DejaDupDecodedUri* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			_tmp10_ = uri;
			_tmp11_ = _tmp10_->port;
			if (_tmp11_ >= 0) {
				DejaDupDecodedUri* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gchar* _tmp14_ = NULL;
				_tmp12_ = uri;
				_tmp13_ = _tmp12_->port;
				_tmp14_ = g_strdup_printf ("%i", _tmp13_);
				_g_free0 (text);
				text = _tmp14_;
			}
			break;
		}
		case DEJA_DUP_CONFIG_URL_PART_PART_FOLDER:
		{
			DejaDupDecodedUri* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			_tmp15_ = uri;
			_tmp16_ = _tmp15_->path;
			_tmp17_ = g_strdup (_tmp16_);
			_g_free0 (text);
			text = _tmp17_;
			break;
		}
		case DEJA_DUP_CONFIG_URL_PART_PART_USER:
		{
			DejaDupDecodedUri* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			DejaDupDecodedUri* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			_tmp18_ = uri;
			_tmp19_ = _tmp18_->scheme;
			_tmp20_ = uri;
			_tmp21_ = _tmp20_->userinfo;
			_tmp22_ = deja_dup_config_url_part_userinfo_get_user (_tmp19_, _tmp21_);
			_g_free0 (text);
			text = _tmp22_;
			break;
		}
		case DEJA_DUP_CONFIG_URL_PART_PART_DOMAIN:
		{
			DejaDupDecodedUri* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			DejaDupDecodedUri* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			_tmp23_ = uri;
			_tmp24_ = _tmp23_->scheme;
			_tmp25_ = uri;
			_tmp26_ = _tmp25_->userinfo;
			_tmp27_ = deja_dup_config_url_part_userinfo_get_domain (_tmp24_, _tmp26_);
			_g_free0 (text);
			text = _tmp27_;
			break;
		}
		default:
		break;
	}
	_tmp28_ = text;
	if (_tmp28_ == NULL) {
		gchar* _tmp29_ = NULL;
		_tmp29_ = g_strdup ("");
		_g_free0 (text);
		text = _tmp29_;
	}
	result = text;
	_deja_dup_decoded_uri_free0 (uri);
	return result;
}


void deja_dup_config_url_part_write_uri_part (DejaDupFilteredSettings* settings, const gchar* key, DejaDupConfigURLPartPart part, const gchar* userval) {
	DejaDupDecodedUri* uri = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	DejaDupDecodedUri* _tmp2_ = NULL;
	DejaDupConfigURLPartPart _tmp3_ = 0;
	DejaDupDecodedUri* _tmp38_ = NULL;
	gchar* val = NULL;
	DejaDupDecodedUri* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	DejaDupFilteredSettings* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (userval != NULL);
	_tmp0_ = settings;
	_tmp1_ = key;
	_tmp2_ = deja_dup_config_url_part_get_current_uri (_tmp0_, _tmp1_);
	uri = _tmp2_;
	_tmp3_ = part;
	switch (_tmp3_) {
		case DEJA_DUP_CONFIG_URL_PART_PART_SCHEME:
		{
			DejaDupDecodedUri* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			_tmp4_ = uri;
			_tmp5_ = userval;
			_tmp6_ = g_strdup (_tmp5_);
			_g_free0 (_tmp4_->scheme);
			_tmp4_->scheme = _tmp6_;
			break;
		}
		case DEJA_DUP_CONFIG_URL_PART_PART_SERVER:
		{
			DejaDupDecodedUri* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			_tmp7_ = uri;
			_tmp8_ = userval;
			_tmp9_ = g_strdup (_tmp8_);
			_g_free0 (_tmp7_->host);
			_tmp7_->host = _tmp9_;
			break;
		}
		case DEJA_DUP_CONFIG_URL_PART_PART_PORT:
		{
			DejaDupDecodedUri* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			DejaDupDecodedUri* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			_tmp10_ = uri;
			_tmp11_ = userval;
			_tmp12_ = atoi (_tmp11_);
			_tmp10_->port = _tmp12_;
			_tmp13_ = uri;
			_tmp14_ = _tmp13_->port;
			if (_tmp14_ == 0) {
				DejaDupDecodedUri* _tmp15_ = NULL;
				_tmp15_ = uri;
				_tmp15_->port = -1;
			}
			break;
		}
		case DEJA_DUP_CONFIG_URL_PART_PART_FOLDER:
		{
			const gchar* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			_tmp16_ = userval;
			_tmp17_ = g_str_has_prefix (_tmp16_, "/");
			if (_tmp17_) {
				DejaDupDecodedUri* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				_tmp18_ = uri;
				_tmp19_ = userval;
				_tmp20_ = g_strdup (_tmp19_);
				_g_free0 (_tmp18_->path);
				_tmp18_->path = _tmp20_;
			} else {
				DejaDupDecodedUri* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				_tmp21_ = uri;
				_tmp22_ = userval;
				_tmp23_ = g_strconcat ("/", _tmp22_, NULL);
				_g_free0 (_tmp21_->path);
				_tmp21_->path = _tmp23_;
			}
			break;
		}
		case DEJA_DUP_CONFIG_URL_PART_PART_USER:
		{
			DejaDupDecodedUri* _tmp24_ = NULL;
			DejaDupDecodedUri* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			DejaDupDecodedUri* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			gchar* _tmp30_ = NULL;
			_tmp24_ = uri;
			_tmp25_ = uri;
			_tmp26_ = _tmp25_->scheme;
			_tmp27_ = uri;
			_tmp28_ = _tmp27_->userinfo;
			_tmp29_ = userval;
			_tmp30_ = deja_dup_config_url_part_userinfo_set_user (_tmp26_, _tmp28_, _tmp29_);
			_g_free0 (_tmp24_->userinfo);
			_tmp24_->userinfo = _tmp30_;
			break;
		}
		case DEJA_DUP_CONFIG_URL_PART_PART_DOMAIN:
		{
			DejaDupDecodedUri* _tmp31_ = NULL;
			DejaDupDecodedUri* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
			DejaDupDecodedUri* _tmp34_ = NULL;
			const gchar* _tmp35_ = NULL;
			const gchar* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
			_tmp31_ = uri;
			_tmp32_ = uri;
			_tmp33_ = _tmp32_->scheme;
			_tmp34_ = uri;
			_tmp35_ = _tmp34_->userinfo;
			_tmp36_ = userval;
			_tmp37_ = deja_dup_config_url_part_userinfo_set_domain (_tmp33_, _tmp35_, _tmp36_);
			_g_free0 (_tmp31_->userinfo);
			_tmp31_->userinfo = _tmp37_;
			break;
		}
		default:
		break;
	}
	_tmp38_ = uri;
	deja_dup_config_url_part_scrub_uri (_tmp38_);
	_tmp39_ = uri;
	_tmp40_ = deja_dup_decoded_uri_encode_uri (_tmp39_, TRUE);
	val = _tmp40_;
	_tmp41_ = settings;
	_tmp42_ = key;
	deja_dup_filtered_settings_set_string (_tmp41_, _tmp42_, val);
	_g_free0 (val);
	_deja_dup_decoded_uri_free0 (uri);
}


static DejaDupDecodedUri* deja_dup_config_url_part_get_current_uri (DejaDupFilteredSettings* settings, const gchar* key) {
	DejaDupDecodedUri* result = NULL;
	gchar* val = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	DejaDupDecodedUri* uri = NULL;
	const gchar* _tmp3_ = NULL;
	DejaDupDecodedUri* _tmp4_ = NULL;
	DejaDupDecodedUri* _tmp5_ = NULL;
	DejaDupDecodedUri* _tmp12_ = NULL;
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = settings;
	_tmp1_ = key;
	_tmp2_ = deja_dup_filtered_settings_get_uri (_tmp0_, _tmp1_);
	val = _tmp2_;
	_tmp3_ = val;
	_tmp4_ = deja_dup_decoded_uri_decode_uri (_tmp3_);
	uri = _tmp4_;
	_tmp5_ = uri;
	if (_tmp5_ == NULL) {
		GFile* file = NULL;
		const gchar* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		DejaDupDecodedUri* _tmp11_ = NULL;
		_tmp6_ = val;
		_tmp7_ = g_file_parse_name (_tmp6_);
		file = _tmp7_;
		_tmp8_ = file;
		_tmp9_ = g_file_get_uri (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = deja_dup_decoded_uri_decode_uri (_tmp10_);
		_deja_dup_decoded_uri_free0 (uri);
		uri = _tmp11_;
		_g_free0 (_tmp10_);
		_g_object_unref0 (file);
	}
	_tmp12_ = uri;
	if (_tmp12_ == NULL) {
		DejaDupDecodedUri* _tmp13_ = NULL;
		_tmp13_ = deja_dup_decoded_uri_new ();
		_deja_dup_decoded_uri_free0 (uri);
		uri = _tmp13_;
	}
	result = uri;
	_g_free0 (val);
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gchar* deja_dup_config_url_part_userinfo_get_user (const gchar* scheme, const gchar* userinfo) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	_tmp0_ = userinfo;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp2_ = scheme;
	if (g_strcmp0 (_tmp2_, "smb") == 0) {
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = userinfo;
		_tmp4_ = string_contains (_tmp3_, ";");
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp5_ = NULL;
		gchar** _tmp6_ = NULL;
		gchar** _tmp7_ = NULL;
		gchar** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp5_ = userinfo;
		_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, ";", 2);
		_tmp8_ = _tmp7_;
		_tmp8__length1 = _vala_array_length (_tmp6_);
		_tmp9_ = _tmp8_[1];
		_tmp10_ = g_strdup (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
		result = _tmp11_;
		return result;
	}
	_tmp12_ = userinfo;
	_tmp13_ = g_strdup (_tmp12_);
	result = _tmp13_;
	return result;
}


static gchar* deja_dup_config_url_part_userinfo_get_domain (const gchar* scheme, const gchar* userinfo) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	_tmp0_ = userinfo;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp2_ = scheme;
	if (g_strcmp0 (_tmp2_, "smb") == 0) {
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = userinfo;
		_tmp4_ = string_contains (_tmp3_, ";");
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp5_ = NULL;
		gchar** _tmp6_ = NULL;
		gchar** _tmp7_ = NULL;
		gchar** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp5_ = userinfo;
		_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, ";", 2);
		_tmp8_ = _tmp7_;
		_tmp8__length1 = _vala_array_length (_tmp6_);
		_tmp9_ = _tmp8_[0];
		_tmp10_ = g_strdup (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
		result = _tmp11_;
		return result;
	}
	result = NULL;
	return result;
}


static gchar* deja_dup_config_url_part_userinfo_set_user (const gchar* scheme, const gchar* userinfo, const gchar* user) {
	gchar* result = NULL;
	gchar* domain = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	g_return_val_if_fail (user != NULL, NULL);
	_tmp0_ = scheme;
	_tmp1_ = userinfo;
	_tmp2_ = deja_dup_config_url_part_userinfo_get_domain (_tmp0_, _tmp1_);
	domain = _tmp2_;
	_tmp3_ = domain;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp4_ = domain;
		_tmp5_ = user;
		_tmp6_ = g_strdup_printf ("%s;%s", _tmp4_, _tmp5_);
		result = _tmp6_;
		_g_free0 (domain);
		return result;
	}
	_tmp7_ = user;
	_tmp8_ = g_strdup (_tmp7_);
	result = _tmp8_;
	_g_free0 (domain);
	return result;
}


static gchar* deja_dup_config_url_part_userinfo_set_domain (const gchar* scheme, const gchar* userinfo, const gchar* domain) {
	gchar* result = NULL;
	gchar* user = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	g_return_val_if_fail (domain != NULL, NULL);
	_tmp0_ = scheme;
	_tmp1_ = userinfo;
	_tmp2_ = deja_dup_config_url_part_userinfo_get_user (_tmp0_, _tmp1_);
	user = _tmp2_;
	_tmp3_ = user;
	if (_tmp3_ == NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = g_strdup ("");
		_g_free0 (user);
		user = _tmp4_;
	}
	_tmp5_ = domain;
	if (g_strcmp0 (_tmp5_, "") == 0) {
		result = user;
		return result;
	}
	_tmp6_ = domain;
	_tmp7_ = user;
	_tmp8_ = g_strdup_printf ("%s;%s", _tmp6_, _tmp7_);
	result = _tmp8_;
	_g_free0 (user);
	return result;
}


static void deja_dup_config_url_part_scrub_uri (DejaDupDecodedUri* uri) {
	DejaDupDecodedUri* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	DejaDupDecodedUri* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	DejaDupDecodedUri* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	DejaDupDecodedUri* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GQuark _tmp15_ = 0U;
	static GQuark _tmp14_label0 = 0;
	static GQuark _tmp14_label1 = 0;
	g_return_if_fail (uri != NULL);
	_tmp0_ = uri;
	_tmp1_ = _tmp0_->scheme;
	if (_tmp1_ == NULL) {
		DejaDupDecodedUri* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = uri;
		_tmp3_ = g_strdup ("file");
		_g_free0 (_tmp2_->scheme);
		_tmp2_->scheme = _tmp3_;
	}
	_tmp4_ = uri;
	_tmp5_ = _tmp4_->userinfo;
	if (g_strcmp0 (_tmp5_, "") == 0) {
		DejaDupDecodedUri* _tmp6_ = NULL;
		_tmp6_ = uri;
		_g_free0 (_tmp6_->userinfo);
		_tmp6_->userinfo = NULL;
	}
	_tmp7_ = uri;
	_tmp8_ = _tmp7_->path;
	if (_tmp8_ == NULL) {
		DejaDupDecodedUri* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp9_ = uri;
		_tmp10_ = g_strdup ("");
		_g_free0 (_tmp9_->path);
		_tmp9_->path = _tmp10_;
	}
	_tmp11_ = uri;
	_tmp12_ = _tmp11_->scheme;
	_tmp13_ = _tmp12_;
	_tmp15_ = (NULL == _tmp13_) ? 0 : g_quark_from_string (_tmp13_);
	if (_tmp15_ == ((0 != _tmp14_label0) ? _tmp14_label0 : (_tmp14_label0 = g_quark_from_static_string ("file")))) {
		switch (0) {
			default:
			{
				DejaDupDecodedUri* _tmp16_ = NULL;
				DejaDupDecodedUri* _tmp17_ = NULL;
				DejaDupDecodedUri* _tmp18_ = NULL;
				_tmp16_ = uri;
				_tmp16_->port = -1;
				_tmp17_ = uri;
				_g_free0 (_tmp17_->host);
				_tmp17_->host = NULL;
				_tmp18_ = uri;
				_g_free0 (_tmp18_->userinfo);
				_tmp18_->userinfo = NULL;
				break;
			}
		}
	} else if (_tmp15_ == ((0 != _tmp14_label1) ? _tmp14_label1 : (_tmp14_label1 = g_quark_from_static_string ("smb")))) {
		switch (0) {
			default:
			{
				DejaDupDecodedUri* _tmp19_ = NULL;
				_tmp19_ = uri;
				_tmp19_->port = -1;
				break;
			}
		}
	}
}


DejaDupConfigURLPartPart deja_dup_config_url_part_get_part (DejaDupConfigURLPart* self) {
	DejaDupConfigURLPartPart result;
	DejaDupConfigURLPartPart _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_part;
	result = _tmp0_;
	return result;
}


static void deja_dup_config_url_part_set_part (DejaDupConfigURLPart* self, DejaDupConfigURLPartPart value) {
	DejaDupConfigURLPartPart _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_part = _tmp0_;
	g_object_notify ((GObject *) self, "part");
}


static GObject * deja_dup_config_url_part_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DejaDupConfigURLPart * self;
	DejaDupConfigURLPartPart _tmp0_ = 0;
	parent_class = G_OBJECT_CLASS (deja_dup_config_url_part_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_TYPE_CONFIG_URL_PART, DejaDupConfigURLPart);
	_tmp0_ = self->priv->_part;
	if (_tmp0_ == DEJA_DUP_CONFIG_URL_PART_PART_PORT) {
		GtkEntry* _tmp1_ = NULL;
		_tmp1_ = ((DejaDupConfigEntry*) self)->entry;
		gtk_entry_set_input_purpose (_tmp1_, GTK_INPUT_PURPOSE_NUMBER);
	}
	return obj;
}


static void deja_dup_config_url_part_class_init (DejaDupConfigURLPartClass * klass) {
	deja_dup_config_url_part_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupConfigURLPartPrivate));
	((DejaDupConfigWidgetClass *) klass)->set_from_config = deja_dup_config_url_part_real_set_from_config;
	((DejaDupConfigWidgetClass *) klass)->set_from_config_finish = deja_dup_config_url_part_real_set_from_config_finish;
	((DejaDupConfigEntryClass *) klass)->write_to_config = deja_dup_config_url_part_real_write_to_config;
	G_OBJECT_CLASS (klass)->get_property = _vala_deja_dup_config_url_part_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_deja_dup_config_url_part_set_property;
	G_OBJECT_CLASS (klass)->constructor = deja_dup_config_url_part_constructor;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_config_url_part_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_CONFIG_URL_PART_PART, g_param_spec_enum ("part", "part", "part", DEJA_DUP_CONFIG_URL_PART_TYPE_PART, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void deja_dup_config_url_part_instance_init (DejaDupConfigURLPart * self) {
	self->priv = DEJA_DUP_CONFIG_URL_PART_GET_PRIVATE (self);
}


static void deja_dup_config_url_part_finalize (GObject* obj) {
	DejaDupConfigURLPart * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_TYPE_CONFIG_URL_PART, DejaDupConfigURLPart);
	G_OBJECT_CLASS (deja_dup_config_url_part_parent_class)->finalize (obj);
}


GType deja_dup_config_url_part_get_type (void) {
	static volatile gsize deja_dup_config_url_part_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_config_url_part_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupConfigURLPartClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_config_url_part_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupConfigURLPart), 0, (GInstanceInitFunc) deja_dup_config_url_part_instance_init, NULL };
		GType deja_dup_config_url_part_type_id;
		deja_dup_config_url_part_type_id = g_type_register_static (DEJA_DUP_TYPE_CONFIG_ENTRY, "DejaDupConfigURLPart", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_config_url_part_type_id__volatile, deja_dup_config_url_part_type_id);
	}
	return deja_dup_config_url_part_type_id__volatile;
}


static void _vala_deja_dup_config_url_part_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupConfigURLPart * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DEJA_DUP_TYPE_CONFIG_URL_PART, DejaDupConfigURLPart);
	switch (property_id) {
		case DEJA_DUP_CONFIG_URL_PART_PART:
		g_value_set_enum (value, deja_dup_config_url_part_get_part (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_deja_dup_config_url_part_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupConfigURLPart * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DEJA_DUP_TYPE_CONFIG_URL_PART, DejaDupConfigURLPart);
	switch (property_id) {
		case DEJA_DUP_CONFIG_URL_PART_PART:
		deja_dup_config_url_part_set_part (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



