/* MountOperationAssistant.c generated by valac 0.30.2, the Vala compiler
 * generated from MountOperationAssistant.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include "widgets.h"
#include <float.h>
#include <math.h>


#define TYPE_MOUNT_OPERATION_ASSISTANT (mount_operation_assistant_get_type ())
#define MOUNT_OPERATION_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistant))
#define MOUNT_OPERATION_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantClass))
#define IS_MOUNT_OPERATION_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_OPERATION_ASSISTANT))
#define IS_MOUNT_OPERATION_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_OPERATION_ASSISTANT))
#define MOUNT_OPERATION_ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantClass))

typedef struct _MountOperationAssistant MountOperationAssistant;
typedef struct _MountOperationAssistantClass MountOperationAssistantClass;
typedef struct _MountOperationAssistantPrivate MountOperationAssistantPrivate;

#define TYPE_ASSISTANT (assistant_get_type ())
#define ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT, Assistant))
#define ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT, AssistantClass))
#define IS_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT))
#define IS_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT))
#define ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT, AssistantClass))

typedef struct _Assistant Assistant;
typedef struct _AssistantClass AssistantClass;

#define TYPE_ASSISTANT_OPERATION (assistant_operation_get_type ())
#define ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperation))
#define ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))
#define IS_ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_OPERATION))
#define IS_ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_OPERATION))
#define ASSISTANT_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))

typedef struct _AssistantOperation AssistantOperation;
typedef struct _AssistantOperationClass AssistantOperationClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define ASSISTANT_TYPE_TYPE (assistant_type_get_type ())

struct _MountOperationAssistant {
	GMountOperation parent_instance;
	MountOperationAssistantPrivate * priv;
};

struct _MountOperationAssistantClass {
	GMountOperationClass parent_class;
};

struct _MountOperationAssistantPrivate {
	gchar* _label_button;
	gchar* _label_help;
	gchar* _label_title;
	gchar* _label_username;
	gchar* _label_password;
	gchar* _label_show_password;
	gchar* _label_remember_password;
	gboolean _go_forward;
	AssistantOperation* _assist;
	GtkBin* password_page;
	GtkBox* layout;
	GtkGrid* table;
	GtkRadioButton* anonymous_w;
	GtkCheckButton* remember_w;
	GtkEntry* username_w;
	GtkEntry* domain_w;
	GtkEntry* password_w;
	gboolean looping;
};

typedef enum  {
	ASSISTANT_TYPE_NORMAL,
	ASSISTANT_TYPE_INTERRUPT,
	ASSISTANT_TYPE_CHECK,
	ASSISTANT_TYPE_SUMMARY,
	ASSISTANT_TYPE_PROGRESS,
	ASSISTANT_TYPE_FINISH
} AssistantType;


static gpointer mount_operation_assistant_parent_class = NULL;

GType mount_operation_assistant_get_type (void) G_GNUC_CONST;
GType assistant_get_type (void) G_GNUC_CONST;
GType assistant_operation_get_type (void) G_GNUC_CONST;
#define MOUNT_OPERATION_ASSISTANT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantPrivate))
enum  {
	MOUNT_OPERATION_ASSISTANT_DUMMY_PROPERTY,
	MOUNT_OPERATION_ASSISTANT_LABEL_BUTTON,
	MOUNT_OPERATION_ASSISTANT_LABEL_HELP,
	MOUNT_OPERATION_ASSISTANT_LABEL_TITLE,
	MOUNT_OPERATION_ASSISTANT_LABEL_USERNAME,
	MOUNT_OPERATION_ASSISTANT_LABEL_PASSWORD,
	MOUNT_OPERATION_ASSISTANT_LABEL_SHOW_PASSWORD,
	MOUNT_OPERATION_ASSISTANT_LABEL_REMEMBER_PASSWORD,
	MOUNT_OPERATION_ASSISTANT_GO_FORWARD,
	MOUNT_OPERATION_ASSISTANT_ASSIST
};
MountOperationAssistant* mount_operation_assistant_new (AssistantOperation* assist);
MountOperationAssistant* mount_operation_assistant_construct (GType object_type, AssistantOperation* assist);
static void mount_operation_assistant_do_prepare (MountOperationAssistant* self, Assistant* assist, GtkWidget* page);
static void _mount_operation_assistant_do_prepare_assistant_prepare (Assistant* _sender, GtkWidget* page, gpointer self);
static void mount_operation_assistant_do_backward (MountOperationAssistant* self, Assistant* assist);
static void _mount_operation_assistant_do_backward_assistant_backward (Assistant* _sender, gpointer self);
static void mount_operation_assistant_do_forward (MountOperationAssistant* self, Assistant* assist);
static void _mount_operation_assistant_do_forward_assistant_forward (Assistant* _sender, gpointer self);
static void mount_operation_assistant_do_close (MountOperationAssistant* self, AssistantOperation* op, gboolean success);
static void _mount_operation_assistant_do_close_assistant_operation_closing (AssistantOperation* _sender, gboolean success, gpointer self);
static void mount_operation_assistant_add_password_page (MountOperationAssistant* self);
static void mount_operation_assistant_go_forward_changed (MountOperationAssistant* mop);
gboolean mount_operation_assistant_get_go_forward (MountOperationAssistant* self);
AssistantOperation* mount_operation_assistant_get_assist (MountOperationAssistant* self);
void assistant_go_forward (Assistant* self);
static void mount_operation_assistant_real_aborted (GMountOperation* base);
void assistant_operation_show_error (AssistantOperation* self, const gchar* _error_, const gchar* detail);
static void mount_operation_assistant_real_ask_password (GMountOperation* base, const gchar* message, const gchar* default_user, const gchar* default_domain, GAskPasswordFlags flags);
static void mount_operation_assistant_flesh_out_password_page (MountOperationAssistant* self, const gchar* message, const gchar* default_user, const gchar* default_domain, GAskPasswordFlags flags);
void assistant_interrupt (Assistant* self, GtkWidget* page, gboolean can_continue);
static void mount_operation_assistant_check_valid_inputs (MountOperationAssistant* self);
void assistant_set_header_icon (Assistant* self, const gchar* name);
void assistant_operation_force_visible (AssistantOperation* self, gboolean user_click);
static void mount_operation_assistant_real_ask_question (GMountOperation* base, const gchar* message, gchar** choices);
static void __lambda28_ (MountOperationAssistant* self, GMountOperation* t, GMountOperationResult r);
static void mount_operation_assistant_send_reply (MountOperationAssistant* self, GMountOperationResult _result_);
static void ___lambda28__g_mount_operation_reply (GMountOperation* _sender, GMountOperationResult _result_, gpointer self);
GType assistant_type_get_type (void) G_GNUC_CONST;
void assistant_append_page (Assistant* self, GtkWidget* page, AssistantType type);
void assistant_set_page_title (Assistant* self, GtkWidget* page, const gchar* title);
const gchar* mount_operation_assistant_get_label_title (MountOperationAssistant* self);
const gchar* mount_operation_assistant_get_label_help (MountOperationAssistant* self);
const gchar* mount_operation_assistant_get_label_button (MountOperationAssistant* self);
static void ___lambda23_ (MountOperationAssistant* self);
static void ____lambda23__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda24_ (MountOperationAssistant* self, GtkToggleButton* b);
static void ____lambda24__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void ___lambda25_ (MountOperationAssistant* self, GtkToggleButton* b);
static void ____lambda25__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void ___lambda26_ (MountOperationAssistant* self, GtkEditable* e);
static void ____lambda26__gtk_editable_changed (GtkEditable* _sender, gpointer self);
const gchar* mount_operation_assistant_get_label_username (MountOperationAssistant* self);
static void ___lambda27_ (MountOperationAssistant* self, GtkEditable* e);
static void ____lambda27__gtk_editable_changed (GtkEditable* _sender, gpointer self);
const gchar* mount_operation_assistant_get_label_password (MountOperationAssistant* self);
const gchar* mount_operation_assistant_get_label_show_password (MountOperationAssistant* self);
const gchar* mount_operation_assistant_get_label_remember_password (MountOperationAssistant* self);
static gboolean mount_operation_assistant_is_valid_entry (MountOperationAssistant* self, GtkEntry* e);
static gboolean mount_operation_assistant_is_anonymous (MountOperationAssistant* self);
void assistant_allow_forward (Assistant* self, gboolean allow);
void mount_operation_assistant_set_label_button (MountOperationAssistant* self, const gchar* value);
void mount_operation_assistant_set_label_help (MountOperationAssistant* self, const gchar* value);
void mount_operation_assistant_set_label_title (MountOperationAssistant* self, const gchar* value);
void mount_operation_assistant_set_label_username (MountOperationAssistant* self, const gchar* value);
void mount_operation_assistant_set_label_password (MountOperationAssistant* self, const gchar* value);
void mount_operation_assistant_set_label_show_password (MountOperationAssistant* self, const gchar* value);
void mount_operation_assistant_set_label_remember_password (MountOperationAssistant* self, const gchar* value);
void mount_operation_assistant_set_go_forward (MountOperationAssistant* self, gboolean value);
static void mount_operation_assistant_set_assist (MountOperationAssistant* self, AssistantOperation* value);
static GObject * mount_operation_assistant_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void mount_operation_assistant_finalize (GObject* obj);
static void _vala_mount_operation_assistant_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_mount_operation_assistant_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static gint _vala_array_length (gpointer array);


static void _mount_operation_assistant_do_prepare_assistant_prepare (Assistant* _sender, GtkWidget* page, gpointer self) {
	mount_operation_assistant_do_prepare ((MountOperationAssistant*) self, _sender, page);
}


static void _mount_operation_assistant_do_backward_assistant_backward (Assistant* _sender, gpointer self) {
	mount_operation_assistant_do_backward ((MountOperationAssistant*) self, _sender);
}


static void _mount_operation_assistant_do_forward_assistant_forward (Assistant* _sender, gpointer self) {
	mount_operation_assistant_do_forward ((MountOperationAssistant*) self, _sender);
}


static void _mount_operation_assistant_do_close_assistant_operation_closing (AssistantOperation* _sender, gboolean success, gpointer self) {
	mount_operation_assistant_do_close ((MountOperationAssistant*) self, _sender, success);
}


MountOperationAssistant* mount_operation_assistant_construct (GType object_type, AssistantOperation* assist) {
	MountOperationAssistant * self = NULL;
	AssistantOperation* _tmp0_ = NULL;
	AssistantOperation* _tmp1_ = NULL;
	AssistantOperation* _tmp2_ = NULL;
	AssistantOperation* _tmp3_ = NULL;
	AssistantOperation* _tmp4_ = NULL;
	AssistantOperation* _tmp5_ = NULL;
	g_return_val_if_fail (assist != NULL, NULL);
	_tmp0_ = assist;
	self = (MountOperationAssistant*) g_object_new (object_type, "assist", _tmp0_, NULL);
	_tmp1_ = assist;
	g_signal_connect_object ((Assistant*) _tmp1_, "prepare", (GCallback) _mount_operation_assistant_do_prepare_assistant_prepare, self, 0);
	_tmp2_ = assist;
	g_signal_connect_object ((Assistant*) _tmp2_, "backward", (GCallback) _mount_operation_assistant_do_backward_assistant_backward, self, 0);
	_tmp3_ = assist;
	g_signal_connect_object ((Assistant*) _tmp3_, "forward", (GCallback) _mount_operation_assistant_do_forward_assistant_forward, self, 0);
	_tmp4_ = assist;
	g_signal_connect_object (_tmp4_, "closing", (GCallback) _mount_operation_assistant_do_close_assistant_operation_closing, self, 0);
	mount_operation_assistant_add_password_page (self);
	_tmp5_ = assist;
	gtk_widget_realize ((GtkWidget*) _tmp5_);
	return self;
}


MountOperationAssistant* mount_operation_assistant_new (AssistantOperation* assist) {
	return mount_operation_assistant_construct (TYPE_MOUNT_OPERATION_ASSISTANT, assist);
}


static void mount_operation_assistant_go_forward_changed (MountOperationAssistant* mop) {
	MountOperationAssistant* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (mop != NULL);
	_tmp0_ = mop;
	_tmp1_ = _tmp0_->priv->_go_forward;
	if (_tmp1_) {
		MountOperationAssistant* _tmp2_ = NULL;
		AssistantOperation* _tmp3_ = NULL;
		_tmp2_ = mop;
		_tmp3_ = _tmp2_->priv->_assist;
		assistant_go_forward ((Assistant*) _tmp3_);
	}
}


static void mount_operation_assistant_real_aborted (GMountOperation* base) {
	MountOperationAssistant * self;
	AssistantOperation* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	self = (MountOperationAssistant*) base;
	_tmp0_ = self->priv->_assist;
	_tmp1_ = _ ("Location not available");
	assistant_operation_show_error (_tmp0_, _tmp1_, NULL);
}


static void mount_operation_assistant_real_ask_password (GMountOperation* base, const gchar* message, const gchar* default_user, const gchar* default_domain, GAskPasswordFlags flags) {
	MountOperationAssistant * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GAskPasswordFlags _tmp3_ = 0;
	AssistantOperation* _tmp4_ = NULL;
	GtkBin* _tmp5_ = NULL;
	AssistantOperation* _tmp6_ = NULL;
	AssistantOperation* _tmp7_ = NULL;
	self = (MountOperationAssistant*) base;
	g_return_if_fail (message != NULL);
	g_return_if_fail (default_user != NULL);
	g_return_if_fail (default_domain != NULL);
	_tmp0_ = message;
	_tmp1_ = default_user;
	_tmp2_ = default_domain;
	_tmp3_ = flags;
	mount_operation_assistant_flesh_out_password_page (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
	_tmp4_ = self->priv->_assist;
	_tmp5_ = self->priv->password_page;
	assistant_interrupt ((Assistant*) _tmp4_, (GtkWidget*) _tmp5_, TRUE);
	self->priv->looping = TRUE;
	mount_operation_assistant_check_valid_inputs (self);
	_tmp6_ = self->priv->_assist;
	assistant_set_header_icon ((Assistant*) _tmp6_, "dialog-password");
	_tmp7_ = self->priv->_assist;
	assistant_operation_force_visible (_tmp7_, FALSE);
	gtk_main ();
}


static void __lambda28_ (MountOperationAssistant* self, GMountOperation* t, GMountOperationResult r) {
	GMountOperation* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GMountOperationResult _tmp3_ = 0;
	g_return_if_fail (t != NULL);
	_tmp0_ = t;
	_tmp1_ = g_mount_operation_get_choice (_tmp0_);
	_tmp2_ = _tmp1_;
	g_mount_operation_set_choice ((GMountOperation*) self, _tmp2_);
	_tmp3_ = r;
	mount_operation_assistant_send_reply (self, _tmp3_);
}


static void ___lambda28__g_mount_operation_reply (GMountOperation* _sender, GMountOperationResult _result_, gpointer self) {
	__lambda28_ ((MountOperationAssistant*) self, _sender, _result_);
}


static void mount_operation_assistant_real_ask_question (GMountOperation* base, const gchar* message, gchar** choices) {
	MountOperationAssistant * self;
	GtkMountOperation* t = NULL;
	AssistantOperation* _tmp0_ = NULL;
	GtkMountOperation* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	self = (MountOperationAssistant*) base;
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->_assist;
	_tmp1_ = (GtkMountOperation*) gtk_mount_operation_new ((GtkWindow*) _tmp0_);
	t = _tmp1_;
	g_signal_connect_object ((GMountOperation*) t, "reply", (GCallback) ___lambda28__g_mount_operation_reply, self, 0);
	self->priv->looping = TRUE;
	_tmp2_ = message;
	_tmp3_ = choices;
	_tmp3__length1 = _vala_array_length (choices);
	g_signal_emit_by_name ((GMountOperation*) t, "ask-question", _tmp2_, _tmp3_);
	gtk_main ();
	_g_object_unref0 (t);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void mount_operation_assistant_add_password_page (MountOperationAssistant* self) {
	GtkEventBox* page = NULL;
	GtkEventBox* _tmp0_ = NULL;
	AssistantOperation* _tmp1_ = NULL;
	GtkBin* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp0_);
	page = _tmp0_;
	_tmp1_ = self->priv->_assist;
	assistant_append_page ((Assistant*) _tmp1_, (GtkWidget*) page, ASSISTANT_TYPE_INTERRUPT);
	_tmp2_ = _g_object_ref0 ((GtkBin*) page);
	_g_object_unref0 (self->priv->password_page);
	self->priv->password_page = _tmp2_;
	_g_object_unref0 (page);
}


static void ___lambda23_ (MountOperationAssistant* self) {
	g_signal_emit_by_name (self, "button-clicked");
}


static void ____lambda23__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda23_ ((MountOperationAssistant*) self);
}


static void ___lambda24_ (MountOperationAssistant* self, GtkToggleButton* b) {
	g_return_if_fail (b != NULL);
	mount_operation_assistant_check_valid_inputs (self);
}


static void ____lambda24__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	___lambda24_ ((MountOperationAssistant*) self, _sender);
}


static void ___lambda25_ (MountOperationAssistant* self, GtkToggleButton* b) {
	GtkGrid* _tmp0_ = NULL;
	GtkToggleButton* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (b != NULL);
	_tmp0_ = self->priv->table;
	_tmp1_ = b;
	_tmp2_ = gtk_toggle_button_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, !_tmp3_);
}


static void ____lambda25__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	___lambda25_ ((MountOperationAssistant*) self, _sender);
}


static void ___lambda26_ (MountOperationAssistant* self, GtkEditable* e) {
	g_return_if_fail (e != NULL);
	mount_operation_assistant_check_valid_inputs (self);
}


static void ____lambda26__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	___lambda26_ ((MountOperationAssistant*) self, _sender);
}


static void ___lambda27_ (MountOperationAssistant* self, GtkEditable* e) {
	g_return_if_fail (e != NULL);
	mount_operation_assistant_check_valid_inputs (self);
}


static void ____lambda27__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	___lambda27_ ((MountOperationAssistant*) self, _sender);
}


static void mount_operation_assistant_flesh_out_password_page (MountOperationAssistant* self, const gchar* message, const gchar* default_user, const gchar* default_domain, GAskPasswordFlags flags) {
	GtkBox* _tmp0_ = NULL;
	GtkBox* _tmp2_ = NULL;
	GtkBox* _tmp3_ = NULL;
	GtkGrid* _tmp4_ = NULL;
	GtkGrid* _tmp5_ = NULL;
	GtkBin* _tmp6_ = NULL;
	GtkBox* _tmp7_ = NULL;
	gint rows = 0;
	gint ucol = 0;
	GtkLabel* label = NULL;
	AssistantOperation* _tmp8_ = NULL;
	GtkBin* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	GtkLabel* _tmp15_ = NULL;
	GtkBox* _tmp16_ = NULL;
	GtkLabel* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	GtkLabel* _tmp26_ = NULL;
	GtkBox* _tmp27_ = NULL;
	GtkLabel* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	GAskPasswordFlags _tmp38_ = 0;
	GAskPasswordFlags _tmp61_ = 0;
	GAskPasswordFlags _tmp81_ = 0;
	GAskPasswordFlags _tmp101_ = 0;
	GAskPasswordFlags _tmp130_ = 0;
	GtkBin* _tmp139_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (default_user != NULL);
	g_return_if_fail (default_domain != NULL);
	_tmp0_ = self->priv->layout;
	if (_tmp0_ != NULL) {
		GtkBox* _tmp1_ = NULL;
		_tmp1_ = self->priv->layout;
		deja_dup_destroy_widget ((GtkWidget*) _tmp1_);
	}
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->layout);
	self->priv->layout = _tmp2_;
	_tmp3_ = self->priv->layout;
	g_object_set ((GObject*) _tmp3_, "border-width", 12, NULL);
	_tmp4_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->table);
	self->priv->table = _tmp4_;
	_tmp5_ = self->priv->table;
	g_object_set ((GObject*) _tmp5_, "row-spacing", 6, "column-spacing", 6, NULL);
	_tmp6_ = self->priv->password_page;
	_tmp7_ = self->priv->layout;
	gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp7_);
	rows = 0;
	ucol = 0;
	_tmp8_ = self->priv->_assist;
	_tmp9_ = self->priv->password_page;
	_tmp10_ = self->priv->_label_title;
	assistant_set_page_title ((Assistant*) _tmp8_, (GtkWidget*) _tmp9_, _tmp10_);
	_tmp11_ = message;
	_tmp12_ = (GtkLabel*) gtk_label_new (_tmp11_);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (label);
	label = _tmp12_;
	_tmp13_ = label;
	gtk_label_set_xalign (_tmp13_, 0.0f);
	_tmp14_ = label;
	g_object_set (_tmp14_, "wrap", TRUE, NULL);
	_tmp15_ = label;
	gtk_label_set_max_width_chars (_tmp15_, 25);
	_tmp16_ = self->priv->layout;
	_tmp17_ = label;
	gtk_box_pack_start (_tmp16_, (GtkWidget*) _tmp17_, FALSE, FALSE, (guint) 0);
	_tmp18_ = self->priv->_label_help;
	if (_tmp18_ != NULL) {
		const gchar* _tmp19_ = NULL;
		GtkLabel* _tmp20_ = NULL;
		GtkLabel* _tmp21_ = NULL;
		GtkLabel* _tmp22_ = NULL;
		GtkLabel* _tmp23_ = NULL;
		GtkBox* _tmp24_ = NULL;
		GtkLabel* _tmp25_ = NULL;
		_tmp19_ = self->priv->_label_help;
		_tmp20_ = (GtkLabel*) gtk_label_new (_tmp19_);
		g_object_ref_sink (_tmp20_);
		_g_object_unref0 (label);
		label = _tmp20_;
		_tmp21_ = label;
		gtk_label_set_use_markup (_tmp21_, TRUE);
		_tmp22_ = label;
		gtk_label_set_track_visited_links (_tmp22_, FALSE);
		_tmp23_ = label;
		g_object_set ((GObject*) _tmp23_, "xalign", 0.f, NULL);
		_tmp24_ = self->priv->layout;
		_tmp25_ = label;
		gtk_box_pack_start (_tmp24_, (GtkWidget*) _tmp25_, FALSE, FALSE, (guint) 0);
	}
	_tmp26_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (label);
	label = _tmp26_;
	_tmp27_ = self->priv->layout;
	_tmp28_ = label;
	gtk_box_pack_start (_tmp27_, (GtkWidget*) _tmp28_, FALSE, FALSE, (guint) 0);
	_tmp29_ = self->priv->_label_button;
	if (_tmp29_ != NULL) {
		GtkAlignment* alignment = NULL;
		GtkAlignment* _tmp30_ = NULL;
		GtkButton* button = NULL;
		const gchar* _tmp31_ = NULL;
		GtkButton* _tmp32_ = NULL;
		GtkButton* _tmp33_ = NULL;
		GtkAlignment* _tmp34_ = NULL;
		GtkButton* _tmp35_ = NULL;
		GtkBox* _tmp36_ = NULL;
		GtkAlignment* _tmp37_ = NULL;
		_tmp30_ = (GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, (gfloat) 0, (gfloat) 0);
		g_object_ref_sink (_tmp30_);
		alignment = _tmp30_;
		_tmp31_ = self->priv->_label_button;
		_tmp32_ = (GtkButton*) gtk_button_new_with_mnemonic (_tmp31_);
		g_object_ref_sink (_tmp32_);
		button = _tmp32_;
		_tmp33_ = button;
		g_signal_connect_object (_tmp33_, "clicked", (GCallback) ____lambda23__gtk_button_clicked, self, 0);
		_tmp34_ = alignment;
		_tmp35_ = button;
		gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) _tmp35_);
		_tmp36_ = self->priv->layout;
		_tmp37_ = alignment;
		gtk_box_pack_start (_tmp36_, (GtkWidget*) _tmp37_, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (button);
		_g_object_unref0 (alignment);
	}
	_tmp38_ = flags;
	if ((_tmp38_ & G_ASK_PASSWORD_ANONYMOUS_SUPPORTED) != 0) {
		const gchar* _tmp39_ = NULL;
		GtkRadioButton* _tmp40_ = NULL;
		GtkRadioButton* _tmp41_ = NULL;
		GtkBox* _tmp42_ = NULL;
		GtkRadioButton* _tmp43_ = NULL;
		GtkRadioButton* w = NULL;
		GtkRadioButton* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
		GtkRadioButton* _tmp46_ = NULL;
		GtkRadioButton* _tmp47_ = NULL;
		GtkGrid* _tmp48_ = NULL;
		GtkBox* _tmp49_ = NULL;
		GtkRadioButton* _tmp50_ = NULL;
		GtkBox* hbox = NULL;
		GtkBox* _tmp51_ = NULL;
		GtkBox* _tmp52_ = NULL;
		GtkLabel* _tmp53_ = NULL;
		GtkLabel* _tmp54_ = NULL;
		GtkBox* _tmp55_ = NULL;
		GtkGrid* _tmp56_ = NULL;
		GtkBox* _tmp57_ = NULL;
		GtkBox* _tmp58_ = NULL;
		_tmp39_ = _ ("Connect _anonymously");
		_tmp40_ = (GtkRadioButton*) gtk_radio_button_new_with_mnemonic (NULL, _tmp39_);
		g_object_ref_sink (_tmp40_);
		_g_object_unref0 (self->priv->anonymous_w);
		self->priv->anonymous_w = _tmp40_;
		_tmp41_ = self->priv->anonymous_w;
		g_signal_connect_object ((GtkToggleButton*) _tmp41_, "toggled", (GCallback) ____lambda24__gtk_toggle_button_toggled, self, 0);
		_tmp42_ = self->priv->layout;
		_tmp43_ = self->priv->anonymous_w;
		gtk_box_pack_start (_tmp42_, (GtkWidget*) _tmp43_, FALSE, FALSE, (guint) 0);
		_tmp44_ = self->priv->anonymous_w;
		_tmp45_ = _ ("Connect as u_ser");
		_tmp46_ = (GtkRadioButton*) gtk_radio_button_new_with_mnemonic_from_widget (_tmp44_, _tmp45_);
		g_object_ref_sink (_tmp46_);
		w = _tmp46_;
		_tmp47_ = self->priv->anonymous_w;
		g_signal_connect_object ((GtkToggleButton*) _tmp47_, "toggled", (GCallback) ____lambda25__gtk_toggle_button_toggled, self, 0);
		_tmp48_ = self->priv->table;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp48_, FALSE);
		_tmp49_ = self->priv->layout;
		_tmp50_ = w;
		gtk_box_pack_start (_tmp49_, (GtkWidget*) _tmp50_, FALSE, FALSE, (guint) 0);
		_tmp51_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
		g_object_ref_sink (_tmp51_);
		hbox = _tmp51_;
		_tmp52_ = hbox;
		_tmp53_ = (GtkLabel*) gtk_label_new ("    ");
		g_object_ref_sink (_tmp53_);
		_tmp54_ = _tmp53_;
		gtk_box_pack_start (_tmp52_, (GtkWidget*) _tmp54_, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (_tmp54_);
		_tmp55_ = hbox;
		_tmp56_ = self->priv->table;
		gtk_box_pack_start (_tmp55_, (GtkWidget*) _tmp56_, TRUE, TRUE, (guint) 0);
		_tmp57_ = self->priv->layout;
		_tmp58_ = hbox;
		gtk_box_pack_start (_tmp57_, (GtkWidget*) _tmp58_, FALSE, FALSE, (guint) 0);
		ucol = 1;
		_g_object_unref0 (hbox);
		_g_object_unref0 (w);
	} else {
		GtkBox* _tmp59_ = NULL;
		GtkGrid* _tmp60_ = NULL;
		_g_object_unref0 (self->priv->anonymous_w);
		self->priv->anonymous_w = NULL;
		_tmp59_ = self->priv->layout;
		_tmp60_ = self->priv->table;
		gtk_box_pack_start (_tmp59_, (GtkWidget*) _tmp60_, FALSE, FALSE, (guint) 0);
	}
	_tmp61_ = flags;
	if ((_tmp61_ & G_ASK_PASSWORD_NEED_USERNAME) != 0) {
		GtkEntry* _tmp62_ = NULL;
		GtkEntry* _tmp63_ = NULL;
		const gchar* _tmp64_ = NULL;
		GtkEntry* _tmp65_ = NULL;
		GtkEntry* _tmp66_ = NULL;
		const gchar* _tmp67_ = NULL;
		GtkLabel* _tmp68_ = NULL;
		GtkLabel* _tmp69_ = NULL;
		GtkEntry* _tmp70_ = NULL;
		GtkGrid* _tmp71_ = NULL;
		GtkLabel* _tmp72_ = NULL;
		gint _tmp73_ = 0;
		gint _tmp74_ = 0;
		GtkGrid* _tmp75_ = NULL;
		GtkEntry* _tmp76_ = NULL;
		gint _tmp77_ = 0;
		gint _tmp78_ = 0;
		gint _tmp79_ = 0;
		gint _tmp80_ = 0;
		_tmp62_ = (GtkEntry*) gtk_entry_new ();
		g_object_ref_sink (_tmp62_);
		_g_object_unref0 (self->priv->username_w);
		self->priv->username_w = _tmp62_;
		_tmp63_ = self->priv->username_w;
		_tmp64_ = default_user;
		g_object_set ((GObject*) _tmp63_, "activates-default", TRUE, "text", _tmp64_, NULL);
		_tmp65_ = self->priv->username_w;
		gtk_widget_set_hexpand ((GtkWidget*) _tmp65_, TRUE);
		_tmp66_ = self->priv->username_w;
		g_signal_connect_object ((GtkEditable*) _tmp66_, "changed", (GCallback) ____lambda26__gtk_editable_changed, self, 0);
		_tmp67_ = self->priv->_label_username;
		_tmp68_ = (GtkLabel*) gtk_label_new (_tmp67_);
		g_object_ref_sink (_tmp68_);
		_g_object_unref0 (label);
		label = _tmp68_;
		_tmp69_ = label;
		_tmp70_ = self->priv->username_w;
		g_object_set ((GObject*) _tmp69_, "mnemonic-widget", _tmp70_, "use-underline", TRUE, "xalign", 1.0f, NULL);
		_tmp71_ = self->priv->table;
		_tmp72_ = label;
		_tmp73_ = ucol;
		_tmp74_ = rows;
		gtk_grid_attach (_tmp71_, (GtkWidget*) _tmp72_, _tmp73_, _tmp74_, 1, 1);
		_tmp75_ = self->priv->table;
		_tmp76_ = self->priv->username_w;
		_tmp77_ = ucol;
		_tmp78_ = rows;
		_tmp79_ = ucol;
		gtk_grid_attach (_tmp75_, (GtkWidget*) _tmp76_, _tmp77_ + 1, _tmp78_, 2 - _tmp79_, 1);
		_tmp80_ = rows;
		rows = _tmp80_ + 1;
	} else {
		_g_object_unref0 (self->priv->username_w);
		self->priv->username_w = NULL;
	}
	_tmp81_ = flags;
	if ((_tmp81_ & G_ASK_PASSWORD_NEED_DOMAIN) != 0) {
		GtkEntry* _tmp82_ = NULL;
		GtkEntry* _tmp83_ = NULL;
		const gchar* _tmp84_ = NULL;
		GtkEntry* _tmp85_ = NULL;
		GtkEntry* _tmp86_ = NULL;
		const gchar* _tmp87_ = NULL;
		GtkLabel* _tmp88_ = NULL;
		GtkLabel* _tmp89_ = NULL;
		GtkEntry* _tmp90_ = NULL;
		GtkGrid* _tmp91_ = NULL;
		GtkLabel* _tmp92_ = NULL;
		gint _tmp93_ = 0;
		gint _tmp94_ = 0;
		GtkGrid* _tmp95_ = NULL;
		GtkEntry* _tmp96_ = NULL;
		gint _tmp97_ = 0;
		gint _tmp98_ = 0;
		gint _tmp99_ = 0;
		gint _tmp100_ = 0;
		_tmp82_ = (GtkEntry*) gtk_entry_new ();
		g_object_ref_sink (_tmp82_);
		_g_object_unref0 (self->priv->domain_w);
		self->priv->domain_w = _tmp82_;
		_tmp83_ = self->priv->domain_w;
		_tmp84_ = default_domain;
		g_object_set ((GObject*) _tmp83_, "activates-default", TRUE, "text", _tmp84_, NULL);
		_tmp85_ = self->priv->domain_w;
		gtk_widget_set_hexpand ((GtkWidget*) _tmp85_, TRUE);
		_tmp86_ = self->priv->domain_w;
		g_signal_connect_object ((GtkEditable*) _tmp86_, "changed", (GCallback) ____lambda27__gtk_editable_changed, self, 0);
		_tmp87_ = _ ("_Domain");
		_tmp88_ = (GtkLabel*) gtk_label_new (_tmp87_);
		g_object_ref_sink (_tmp88_);
		_g_object_unref0 (label);
		label = _tmp88_;
		_tmp89_ = label;
		_tmp90_ = self->priv->domain_w;
		g_object_set ((GObject*) _tmp89_, "mnemonic-widget", _tmp90_, "use-underline", TRUE, "xalign", 1.0f, NULL);
		_tmp91_ = self->priv->table;
		_tmp92_ = label;
		_tmp93_ = ucol;
		_tmp94_ = rows;
		gtk_grid_attach (_tmp91_, (GtkWidget*) _tmp92_, _tmp93_, _tmp94_, 1, 1);
		_tmp95_ = self->priv->table;
		_tmp96_ = self->priv->domain_w;
		_tmp97_ = ucol;
		_tmp98_ = rows;
		_tmp99_ = ucol;
		gtk_grid_attach (_tmp95_, (GtkWidget*) _tmp96_, _tmp97_ + 1, _tmp98_, 2 - _tmp99_, 1);
		_tmp100_ = rows;
		rows = _tmp100_ + 1;
	} else {
		_g_object_unref0 (self->priv->domain_w);
		self->priv->domain_w = NULL;
	}
	_tmp101_ = flags;
	if ((_tmp101_ & G_ASK_PASSWORD_NEED_PASSWORD) != 0) {
		GtkEntry* _tmp102_ = NULL;
		GtkEntry* _tmp103_ = NULL;
		GtkEntry* _tmp104_ = NULL;
		GtkEntry* _tmp105_ = NULL;
		const gchar* _tmp106_ = NULL;
		GtkLabel* _tmp107_ = NULL;
		GtkLabel* _tmp108_ = NULL;
		GtkEntry* _tmp109_ = NULL;
		GtkGrid* _tmp110_ = NULL;
		GtkLabel* _tmp111_ = NULL;
		gint _tmp112_ = 0;
		gint _tmp113_ = 0;
		GtkGrid* _tmp114_ = NULL;
		GtkEntry* _tmp115_ = NULL;
		gint _tmp116_ = 0;
		gint _tmp117_ = 0;
		gint _tmp118_ = 0;
		gint _tmp119_ = 0;
		GtkCheckButton* w = NULL;
		const gchar* _tmp120_ = NULL;
		GtkCheckButton* _tmp121_ = NULL;
		GtkCheckButton* _tmp122_ = NULL;
		GtkEntry* _tmp123_ = NULL;
		GtkGrid* _tmp124_ = NULL;
		GtkCheckButton* _tmp125_ = NULL;
		gint _tmp126_ = 0;
		gint _tmp127_ = 0;
		gint _tmp128_ = 0;
		gint _tmp129_ = 0;
		_tmp102_ = (GtkEntry*) gtk_entry_new ();
		g_object_ref_sink (_tmp102_);
		_g_object_unref0 (self->priv->password_w);
		self->priv->password_w = _tmp102_;
		_tmp103_ = self->priv->password_w;
		gtk_entry_set_input_purpose (_tmp103_, GTK_INPUT_PURPOSE_PASSWORD);
		_tmp104_ = self->priv->password_w;
		g_object_set ((GObject*) _tmp104_, "activates-default", TRUE, NULL);
		_tmp105_ = self->priv->password_w;
		gtk_widget_set_hexpand ((GtkWidget*) _tmp105_, TRUE);
		_tmp106_ = self->priv->_label_password;
		_tmp107_ = (GtkLabel*) gtk_label_new (_tmp106_);
		g_object_ref_sink (_tmp107_);
		_g_object_unref0 (label);
		label = _tmp107_;
		_tmp108_ = label;
		_tmp109_ = self->priv->password_w;
		g_object_set ((GObject*) _tmp108_, "mnemonic-widget", _tmp109_, "use-underline", TRUE, "xalign", 1.0f, NULL);
		_tmp110_ = self->priv->table;
		_tmp111_ = label;
		_tmp112_ = ucol;
		_tmp113_ = rows;
		gtk_grid_attach (_tmp110_, (GtkWidget*) _tmp111_, _tmp112_, _tmp113_, 1, 1);
		_tmp114_ = self->priv->table;
		_tmp115_ = self->priv->password_w;
		_tmp116_ = ucol;
		_tmp117_ = rows;
		_tmp118_ = ucol;
		gtk_grid_attach (_tmp114_, (GtkWidget*) _tmp115_, _tmp116_ + 1, _tmp117_, 2 - _tmp118_, 1);
		_tmp119_ = rows;
		rows = _tmp119_ + 1;
		_tmp120_ = self->priv->_label_show_password;
		_tmp121_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp120_);
		g_object_ref_sink (_tmp121_);
		w = _tmp121_;
		_tmp122_ = w;
		_tmp123_ = self->priv->password_w;
		g_object_bind_property_with_closures ((GObject*) _tmp122_, "active", (GObject*) _tmp123_, "visibility", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
		_tmp124_ = self->priv->table;
		_tmp125_ = w;
		_tmp126_ = ucol;
		_tmp127_ = rows;
		_tmp128_ = ucol;
		gtk_grid_attach (_tmp124_, (GtkWidget*) _tmp125_, _tmp126_ + 1, _tmp127_, 2 - _tmp128_, 1);
		_tmp129_ = rows;
		rows = _tmp129_ + 1;
		_g_object_unref0 (w);
	} else {
		_g_object_unref0 (self->priv->password_w);
		self->priv->password_w = NULL;
	}
	_tmp130_ = flags;
	if ((_tmp130_ & G_ASK_PASSWORD_SAVING_SUPPORTED) != 0) {
		const gchar* _tmp131_ = NULL;
		GtkCheckButton* _tmp132_ = NULL;
		GtkGrid* _tmp133_ = NULL;
		GtkCheckButton* _tmp134_ = NULL;
		gint _tmp135_ = 0;
		gint _tmp136_ = 0;
		gint _tmp137_ = 0;
		gint _tmp138_ = 0;
		_tmp131_ = self->priv->_label_remember_password;
		_tmp132_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp131_);
		g_object_ref_sink (_tmp132_);
		_g_object_unref0 (self->priv->remember_w);
		self->priv->remember_w = _tmp132_;
		_tmp133_ = self->priv->table;
		_tmp134_ = self->priv->remember_w;
		_tmp135_ = ucol;
		_tmp136_ = rows;
		_tmp137_ = ucol;
		gtk_grid_attach (_tmp133_, (GtkWidget*) _tmp134_, _tmp135_ + 1, _tmp136_, 2 - _tmp137_, 1);
		_tmp138_ = rows;
		rows = _tmp138_ + 1;
	} else {
		_g_object_unref0 (self->priv->remember_w);
		self->priv->remember_w = NULL;
	}
	_tmp139_ = self->priv->password_page;
	gtk_widget_show_all ((GtkWidget*) _tmp139_);
	_g_object_unref0 (label);
}


static gboolean mount_operation_assistant_is_valid_entry (MountOperationAssistant* self, GtkEntry* e) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GtkEntry* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = e;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		GtkEntry* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_tmp3_ = e;
		_tmp4_ = gtk_entry_get_text (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ != NULL) {
			GtkEntry* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			_tmp6_ = e;
			_tmp7_ = gtk_entry_get_text (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp2_ = g_strcmp0 (_tmp8_, "") != 0;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	result = _tmp0_;
	return result;
}


static gboolean mount_operation_assistant_is_anonymous (MountOperationAssistant* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GtkRadioButton* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->anonymous_w;
	if (_tmp1_ != NULL) {
		GtkRadioButton* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = self->priv->anonymous_w;
		_tmp3_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void mount_operation_assistant_check_valid_inputs (MountOperationAssistant* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean valid = FALSE;
	const gchar* _tmp7_ = NULL;
	AssistantOperation* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = mount_operation_assistant_is_anonymous (self);
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		GtkEntry* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = self->priv->username_w;
		_tmp4_ = mount_operation_assistant_is_valid_entry (self, _tmp3_);
		if (_tmp4_) {
			GtkEntry* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			_tmp5_ = self->priv->domain_w;
			_tmp6_ = mount_operation_assistant_is_valid_entry (self, _tmp5_);
			_tmp2_ = _tmp6_;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	valid = _tmp0_;
	_tmp7_ = self->priv->_label_button;
	if (_tmp7_ != NULL) {
		valid = FALSE;
	}
	_tmp8_ = self->priv->_assist;
	_tmp9_ = valid;
	assistant_allow_forward ((Assistant*) _tmp8_, _tmp9_);
}


static void mount_operation_assistant_send_reply (MountOperationAssistant* self, GMountOperationResult _result_) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->looping;
	if (_tmp0_) {
		GMountOperationResult _tmp1_ = 0;
		gtk_main_quit ();
		self->priv->looping = FALSE;
		_tmp1_ = _result_;
		g_mount_operation_reply ((GMountOperation*) self, _tmp1_);
	}
}


static void mount_operation_assistant_do_close (MountOperationAssistant* self, AssistantOperation* op, gboolean success) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	mount_operation_assistant_send_reply (self, G_MOUNT_OPERATION_ABORTED);
}


static void mount_operation_assistant_do_backward (MountOperationAssistant* self, Assistant* assist) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (assist != NULL);
	mount_operation_assistant_send_reply (self, G_MOUNT_OPERATION_ABORTED);
}


static void mount_operation_assistant_do_forward (MountOperationAssistant* self, Assistant* assist) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (assist != NULL);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void mount_operation_assistant_do_prepare (MountOperationAssistant* self, Assistant* assist, GtkWidget* page) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (assist != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = self->priv->looping;
	if (_tmp0_) {
		GtkEntry* _tmp1_ = NULL;
		GtkEntry* _tmp8_ = NULL;
		GtkEntry* _tmp15_ = NULL;
		GtkRadioButton* _tmp22_ = NULL;
		GtkCheckButton* _tmp25_ = NULL;
		_tmp1_ = self->priv->username_w;
		if (_tmp1_ != NULL) {
			gchar* txt = NULL;
			GtkEntry* _tmp2_ = NULL;
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			_tmp2_ = self->priv->username_w;
			_tmp3_ = gtk_entry_get_text (_tmp2_);
			_tmp4_ = g_strdup (_tmp3_);
			txt = _tmp4_;
			_tmp5_ = txt;
			_tmp6_ = string_strip (_tmp5_);
			_tmp7_ = _tmp6_;
			g_mount_operation_set_username ((GMountOperation*) self, _tmp7_);
			_g_free0 (_tmp7_);
			_g_free0 (txt);
		}
		_tmp8_ = self->priv->domain_w;
		if (_tmp8_ != NULL) {
			gchar* txt = NULL;
			GtkEntry* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			_tmp9_ = self->priv->domain_w;
			_tmp10_ = gtk_entry_get_text (_tmp9_);
			_tmp11_ = g_strdup (_tmp10_);
			txt = _tmp11_;
			_tmp12_ = txt;
			_tmp13_ = string_strip (_tmp12_);
			_tmp14_ = _tmp13_;
			g_mount_operation_set_domain ((GMountOperation*) self, _tmp14_);
			_g_free0 (_tmp14_);
			_g_free0 (txt);
		}
		_tmp15_ = self->priv->password_w;
		if (_tmp15_ != NULL) {
			gchar* txt = NULL;
			GtkEntry* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			_tmp16_ = self->priv->password_w;
			_tmp17_ = gtk_entry_get_text (_tmp16_);
			_tmp18_ = g_strdup (_tmp17_);
			txt = _tmp18_;
			_tmp19_ = txt;
			_tmp20_ = string_strip (_tmp19_);
			_tmp21_ = _tmp20_;
			g_mount_operation_set_password ((GMountOperation*) self, _tmp21_);
			_g_free0 (_tmp21_);
			_g_free0 (txt);
		}
		_tmp22_ = self->priv->anonymous_w;
		if (_tmp22_ != NULL) {
			GtkRadioButton* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			_tmp23_ = self->priv->anonymous_w;
			_tmp24_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp23_);
			g_mount_operation_set_anonymous ((GMountOperation*) self, _tmp24_);
		}
		_tmp25_ = self->priv->remember_w;
		if (_tmp25_ != NULL) {
			GPasswordSave _tmp26_ = 0;
			GtkCheckButton* _tmp27_ = NULL;
			gboolean _tmp28_ = FALSE;
			_tmp27_ = self->priv->remember_w;
			_tmp28_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp27_);
			if (_tmp28_) {
				_tmp26_ = G_PASSWORD_SAVE_PERMANENTLY;
			} else {
				_tmp26_ = G_PASSWORD_SAVE_NEVER;
			}
			g_mount_operation_set_password_save ((GMountOperation*) self, _tmp26_);
		}
		mount_operation_assistant_send_reply (self, G_MOUNT_OPERATION_HANDLED);
	}
}


const gchar* mount_operation_assistant_get_label_button (MountOperationAssistant* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label_button;
	result = _tmp0_;
	return result;
}


void mount_operation_assistant_set_label_button (MountOperationAssistant* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_label_button);
	self->priv->_label_button = _tmp1_;
	g_object_notify ((GObject *) self, "label-button");
}


const gchar* mount_operation_assistant_get_label_help (MountOperationAssistant* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label_help;
	result = _tmp0_;
	return result;
}


void mount_operation_assistant_set_label_help (MountOperationAssistant* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_label_help);
	self->priv->_label_help = _tmp1_;
	g_object_notify ((GObject *) self, "label-help");
}


const gchar* mount_operation_assistant_get_label_title (MountOperationAssistant* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label_title;
	result = _tmp0_;
	return result;
}


void mount_operation_assistant_set_label_title (MountOperationAssistant* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_label_title);
	self->priv->_label_title = _tmp1_;
	g_object_notify ((GObject *) self, "label-title");
}


const gchar* mount_operation_assistant_get_label_username (MountOperationAssistant* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label_username;
	result = _tmp0_;
	return result;
}


void mount_operation_assistant_set_label_username (MountOperationAssistant* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_label_username);
	self->priv->_label_username = _tmp1_;
	g_object_notify ((GObject *) self, "label-username");
}


const gchar* mount_operation_assistant_get_label_password (MountOperationAssistant* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label_password;
	result = _tmp0_;
	return result;
}


void mount_operation_assistant_set_label_password (MountOperationAssistant* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_label_password);
	self->priv->_label_password = _tmp1_;
	g_object_notify ((GObject *) self, "label-password");
}


const gchar* mount_operation_assistant_get_label_show_password (MountOperationAssistant* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label_show_password;
	result = _tmp0_;
	return result;
}


void mount_operation_assistant_set_label_show_password (MountOperationAssistant* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_label_show_password);
	self->priv->_label_show_password = _tmp1_;
	g_object_notify ((GObject *) self, "label-show-password");
}


const gchar* mount_operation_assistant_get_label_remember_password (MountOperationAssistant* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label_remember_password;
	result = _tmp0_;
	return result;
}


void mount_operation_assistant_set_label_remember_password (MountOperationAssistant* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_label_remember_password);
	self->priv->_label_remember_password = _tmp1_;
	g_object_notify ((GObject *) self, "label-remember-password");
}


gboolean mount_operation_assistant_get_go_forward (MountOperationAssistant* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_go_forward;
	result = _tmp0_;
	return result;
}


void mount_operation_assistant_set_go_forward (MountOperationAssistant* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_go_forward = _tmp0_;
	g_object_notify ((GObject *) self, "go-forward");
}


AssistantOperation* mount_operation_assistant_get_assist (MountOperationAssistant* self) {
	AssistantOperation* result;
	AssistantOperation* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_assist;
	result = _tmp0_;
	return result;
}


static void mount_operation_assistant_set_assist (MountOperationAssistant* self, AssistantOperation* value) {
	AssistantOperation* _tmp0_ = NULL;
	AssistantOperation* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_assist);
	self->priv->_assist = _tmp1_;
	g_object_notify ((GObject *) self, "assist");
}


static GObject * mount_operation_assistant_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	MountOperationAssistant * self;
	parent_class = G_OBJECT_CLASS (mount_operation_assistant_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistant);
	g_signal_connect (self, "notify::go-forward", (GCallback) mount_operation_assistant_go_forward_changed, self);
	return obj;
}


static void mount_operation_assistant_class_init (MountOperationAssistantClass * klass) {
	mount_operation_assistant_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MountOperationAssistantPrivate));
	((GMountOperationClass *) klass)->aborted = mount_operation_assistant_real_aborted;
	((GMountOperationClass *) klass)->ask_password = mount_operation_assistant_real_ask_password;
	((GMountOperationClass *) klass)->ask_question = mount_operation_assistant_real_ask_question;
	G_OBJECT_CLASS (klass)->get_property = _vala_mount_operation_assistant_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mount_operation_assistant_set_property;
	G_OBJECT_CLASS (klass)->constructor = mount_operation_assistant_constructor;
	G_OBJECT_CLASS (klass)->finalize = mount_operation_assistant_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_LABEL_BUTTON, g_param_spec_string ("label-button", "label-button", "label-button", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_LABEL_HELP, g_param_spec_string ("label-help", "label-help", "label-help", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_LABEL_TITLE, g_param_spec_string ("label-title", "label-title", "label-title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_LABEL_USERNAME, g_param_spec_string ("label-username", "label-username", "label-username", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_LABEL_PASSWORD, g_param_spec_string ("label-password", "label-password", "label-password", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_LABEL_SHOW_PASSWORD, g_param_spec_string ("label-show-password", "label-show-password", "label-show-password", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_LABEL_REMEMBER_PASSWORD, g_param_spec_string ("label-remember-password", "label-remember-password", "label-remember-password", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_GO_FORWARD, g_param_spec_boolean ("go-forward", "go-forward", "go-forward", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_ASSIST, g_param_spec_object ("assist", "assist", "assist", TYPE_ASSISTANT_OPERATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("button_clicked", TYPE_MOUNT_OPERATION_ASSISTANT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void mount_operation_assistant_instance_init (MountOperationAssistant * self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	self->priv = MOUNT_OPERATION_ASSISTANT_GET_PRIVATE (self);
	_tmp0_ = _ ("Connect to Server");
	_tmp1_ = g_strdup (_tmp0_);
	self->priv->_label_title = _tmp1_;
	_tmp2_ = _ ("_Username");
	_tmp3_ = g_strdup (_tmp2_);
	self->priv->_label_username = _tmp3_;
	_tmp4_ = _ ("_Password");
	_tmp5_ = g_strdup (_tmp4_);
	self->priv->_label_password = _tmp5_;
	_tmp6_ = _ ("S_how password");
	_tmp7_ = g_strdup (_tmp6_);
	self->priv->_label_show_password = _tmp7_;
	_tmp8_ = _ ("_Remember password");
	_tmp9_ = g_strdup (_tmp8_);
	self->priv->_label_remember_password = _tmp9_;
	self->priv->_go_forward = FALSE;
	self->priv->looping = FALSE;
}


static void mount_operation_assistant_finalize (GObject* obj) {
	MountOperationAssistant * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistant);
	_g_free0 (self->priv->_label_button);
	_g_free0 (self->priv->_label_help);
	_g_free0 (self->priv->_label_title);
	_g_free0 (self->priv->_label_username);
	_g_free0 (self->priv->_label_password);
	_g_free0 (self->priv->_label_show_password);
	_g_free0 (self->priv->_label_remember_password);
	_g_object_unref0 (self->priv->_assist);
	_g_object_unref0 (self->priv->password_page);
	_g_object_unref0 (self->priv->layout);
	_g_object_unref0 (self->priv->table);
	_g_object_unref0 (self->priv->anonymous_w);
	_g_object_unref0 (self->priv->remember_w);
	_g_object_unref0 (self->priv->username_w);
	_g_object_unref0 (self->priv->domain_w);
	_g_object_unref0 (self->priv->password_w);
	G_OBJECT_CLASS (mount_operation_assistant_parent_class)->finalize (obj);
}


/**
 * This class can be used by backends in one of two ways:
 * 1) Traditional way, by having this ask the user for info and then sending
 *    a reply signal.
 * 2) Or by driving the authentication themselves in some secret way.  If so,
 *    they will ask for a button to be shown to start the authentication.
 *    When they are done, they will set the 'go_forward' property to true.
 *    This was used by the U1 backend.
 */
GType mount_operation_assistant_get_type (void) {
	static volatile gsize mount_operation_assistant_type_id__volatile = 0;
	if (g_once_init_enter (&mount_operation_assistant_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MountOperationAssistantClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mount_operation_assistant_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MountOperationAssistant), 0, (GInstanceInitFunc) mount_operation_assistant_instance_init, NULL };
		GType mount_operation_assistant_type_id;
		mount_operation_assistant_type_id = g_type_register_static (g_mount_operation_get_type (), "MountOperationAssistant", &g_define_type_info, 0);
		g_once_init_leave (&mount_operation_assistant_type_id__volatile, mount_operation_assistant_type_id);
	}
	return mount_operation_assistant_type_id__volatile;
}


static void _vala_mount_operation_assistant_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MountOperationAssistant * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistant);
	switch (property_id) {
		case MOUNT_OPERATION_ASSISTANT_LABEL_BUTTON:
		g_value_set_string (value, mount_operation_assistant_get_label_button (self));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_HELP:
		g_value_set_string (value, mount_operation_assistant_get_label_help (self));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_TITLE:
		g_value_set_string (value, mount_operation_assistant_get_label_title (self));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_USERNAME:
		g_value_set_string (value, mount_operation_assistant_get_label_username (self));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_PASSWORD:
		g_value_set_string (value, mount_operation_assistant_get_label_password (self));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_SHOW_PASSWORD:
		g_value_set_string (value, mount_operation_assistant_get_label_show_password (self));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_REMEMBER_PASSWORD:
		g_value_set_string (value, mount_operation_assistant_get_label_remember_password (self));
		break;
		case MOUNT_OPERATION_ASSISTANT_GO_FORWARD:
		g_value_set_boolean (value, mount_operation_assistant_get_go_forward (self));
		break;
		case MOUNT_OPERATION_ASSISTANT_ASSIST:
		g_value_set_object (value, mount_operation_assistant_get_assist (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_mount_operation_assistant_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MountOperationAssistant * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistant);
	switch (property_id) {
		case MOUNT_OPERATION_ASSISTANT_LABEL_BUTTON:
		mount_operation_assistant_set_label_button (self, g_value_get_string (value));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_HELP:
		mount_operation_assistant_set_label_help (self, g_value_get_string (value));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_TITLE:
		mount_operation_assistant_set_label_title (self, g_value_get_string (value));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_USERNAME:
		mount_operation_assistant_set_label_username (self, g_value_get_string (value));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_PASSWORD:
		mount_operation_assistant_set_label_password (self, g_value_get_string (value));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_SHOW_PASSWORD:
		mount_operation_assistant_set_label_show_password (self, g_value_get_string (value));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_REMEMBER_PASSWORD:
		mount_operation_assistant_set_label_remember_password (self, g_value_get_string (value));
		break;
		case MOUNT_OPERATION_ASSISTANT_GO_FORWARD:
		mount_operation_assistant_set_go_forward (self, g_value_get_boolean (value));
		break;
		case MOUNT_OPERATION_ASSISTANT_ASSIST:
		mount_operation_assistant_set_assist (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



