/* AssistantRestoreMissing.c generated by valac 0.30.2, the Vala compiler
 * generated from AssistantRestoreMissing.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <gtk/gtk.h>
#include "deja.h"
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include "widgets.h"
#include <gobject/gvaluecollector.h>


#define TYPE_DELETED_FILE (deleted_file_get_type ())
#define DELETED_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELETED_FILE, DeletedFile))
#define DELETED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELETED_FILE, DeletedFileClass))
#define IS_DELETED_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELETED_FILE))
#define IS_DELETED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELETED_FILE))
#define DELETED_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELETED_FILE, DeletedFileClass))

typedef struct _DeletedFile DeletedFile;
typedef struct _DeletedFileClass DeletedFileClass;
typedef struct _DeletedFilePrivate DeletedFilePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecDeletedFile ParamSpecDeletedFile;

#define TYPE_ASSISTANT (assistant_get_type ())
#define ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT, Assistant))
#define ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT, AssistantClass))
#define IS_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT))
#define IS_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT))
#define ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT, AssistantClass))

typedef struct _Assistant Assistant;
typedef struct _AssistantClass AssistantClass;
typedef struct _AssistantPrivate AssistantPrivate;

#define ASSISTANT_TYPE_PAGE_INFO (assistant_page_info_get_type ())
#define ASSISTANT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfo))
#define ASSISTANT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))
#define ASSISTANT_IS_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_IS_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))

typedef struct _AssistantPageInfo AssistantPageInfo;
typedef struct _AssistantPageInfoClass AssistantPageInfoClass;

#define TYPE_ASSISTANT_OPERATION (assistant_operation_get_type ())
#define ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperation))
#define ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))
#define IS_ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_OPERATION))
#define IS_ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_OPERATION))
#define ASSISTANT_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))

typedef struct _AssistantOperation AssistantOperation;
typedef struct _AssistantOperationClass AssistantOperationClass;
typedef struct _AssistantOperationPrivate AssistantOperationPrivate;

#define TYPE_STATUS_ICON (status_icon_get_type ())
#define STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATUS_ICON, StatusIcon))
#define STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATUS_ICON, StatusIconClass))
#define IS_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATUS_ICON))
#define IS_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATUS_ICON))
#define STATUS_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATUS_ICON, StatusIconClass))

typedef struct _StatusIcon StatusIcon;
typedef struct _StatusIconClass StatusIconClass;

#define TYPE_ASSISTANT_RESTORE (assistant_restore_get_type ())
#define ASSISTANT_RESTORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_RESTORE, AssistantRestore))
#define ASSISTANT_RESTORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_RESTORE, AssistantRestoreClass))
#define IS_ASSISTANT_RESTORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_RESTORE))
#define IS_ASSISTANT_RESTORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_RESTORE))
#define ASSISTANT_RESTORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_RESTORE, AssistantRestoreClass))

typedef struct _AssistantRestore AssistantRestore;
typedef struct _AssistantRestoreClass AssistantRestoreClass;
typedef struct _AssistantRestorePrivate AssistantRestorePrivate;

#define TYPE_ASSISTANT_RESTORE_MISSING (assistant_restore_missing_get_type ())
#define ASSISTANT_RESTORE_MISSING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_RESTORE_MISSING, AssistantRestoreMissing))
#define ASSISTANT_RESTORE_MISSING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_RESTORE_MISSING, AssistantRestoreMissingClass))
#define IS_ASSISTANT_RESTORE_MISSING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_RESTORE_MISSING))
#define IS_ASSISTANT_RESTORE_MISSING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_RESTORE_MISSING))
#define ASSISTANT_RESTORE_MISSING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_RESTORE_MISSING, AssistantRestoreMissingClass))

typedef struct _AssistantRestoreMissing AssistantRestoreMissing;
typedef struct _AssistantRestoreMissingClass AssistantRestoreMissingClass;
typedef struct _AssistantRestoreMissingPrivate AssistantRestoreMissingPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_sequence_free0(var) ((var == NULL) ? NULL : (var = (g_sequence_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define ASSISTANT_TYPE_TYPE (assistant_type_get_type ())
#define _deleted_file_unref0(var) ((var == NULL) ? NULL : (var = (deleted_file_unref (var), NULL)))
#define _deja_dup_operation_state_unref0(var) ((var == NULL) ? NULL : (var = (deja_dup_operation_state_unref (var), NULL)))

struct _DeletedFile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DeletedFilePrivate * priv;
};

struct _DeletedFileClass {
	GTypeClass parent_class;
	void (*finalize) (DeletedFile *self);
};

struct _DeletedFilePrivate {
	gchar* _name;
	struct tm _deleted;
	gboolean _restore;
};

struct _ParamSpecDeletedFile {
	GParamSpec parent_instance;
};

struct _Assistant {
	GtkWindow parent_instance;
	AssistantPrivate * priv;
	GtkImage* header_icon;
	GtkEventBox* page_box;
	GList* current;
};

struct _AssistantClass {
	GtkWindowClass parent_class;
};

struct _AssistantOperation {
	Assistant parent_instance;
	AssistantOperationPrivate * priv;
	StatusIcon* status_icon;
	gboolean succeeded;
	gboolean nagged;
	GtkLabel* summary_label;
	GtkWidget* detail_widget;
	DejaDupOperation* op;
};

struct _AssistantOperationClass {
	AssistantClass parent_class;
	GtkWidget* (*make_confirm_page) (AssistantOperation* self);
	void (*add_setup_pages) (AssistantOperation* self);
	void (*add_custom_config_pages) (AssistantOperation* self);
	DejaDupOperation* (*create_op) (AssistantOperation* self);
	gchar* (*get_progress_file_prefix) (AssistantOperation* self);
	GtkWidget* (*make_progress_page) (AssistantOperation* self);
	void (*show_error) (AssistantOperation* self, const gchar* _error_, const gchar* detail);
	GtkWidget* (*make_summary_page) (AssistantOperation* self);
	void (*apply_finished) (AssistantOperation* self, DejaDupOperation* op, gboolean success, gboolean cancelled, const gchar* detail);
	void (*do_prepare) (AssistantOperation* self, Assistant* assist, GtkWidget* page);
	void (*do_cancel) (AssistantOperation* self);
	void (*do_close) (AssistantOperation* self);
};

struct _AssistantRestore {
	AssistantOperation parent_instance;
	AssistantRestorePrivate * priv;
	GList* _restore_files;
	DejaDupOperationStatus* query_op;
	DejaDupOperationState* op_state;
};

struct _AssistantRestoreClass {
	AssistantOperationClass parent_class;
	void (*handle_collection_dates) (AssistantRestore* self, DejaDupOperationStatus* op, GList* dates);
	void (*query_finished) (AssistantRestore* self, DejaDupOperation* op, gboolean success, gboolean cancelled, const gchar* detail);
};

struct _AssistantRestoreMissing {
	AssistantRestore parent_instance;
	AssistantRestoreMissingPrivate * priv;
};

struct _AssistantRestoreMissingClass {
	AssistantRestoreClass parent_class;
};

struct _AssistantRestoreMissingPrivate {
	GFile* list_directory;
	gboolean backups_queue_filled;
	gboolean scan_queue;
	gboolean cancel_assistant;
	GSequence* backups_queue;
	GHashTable* allfiles_prev;
	GList* restore_files_remaining;
	DejaDupOperationFiles* query_op_files;
	GtkWidget* listfiles_page;
	GtkTreeIter deleted_iter;
	GtkListStore* listmodel;
	GtkLabel* list_dir_label;
	GtkLabel* current_scan_date;
	GtkSpinner* spinner;
};

typedef enum  {
	ASSISTANT_TYPE_NORMAL,
	ASSISTANT_TYPE_INTERRUPT,
	ASSISTANT_TYPE_CHECK,
	ASSISTANT_TYPE_SUMMARY,
	ASSISTANT_TYPE_PROGRESS,
	ASSISTANT_TYPE_FINISH
} AssistantType;


static gpointer deleted_file_parent_class = NULL;
static gpointer assistant_restore_missing_parent_class = NULL;

gpointer deleted_file_ref (gpointer instance);
void deleted_file_unref (gpointer instance);
GParamSpec* param_spec_deleted_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_deleted_file (GValue* value, gpointer v_object);
void value_take_deleted_file (GValue* value, gpointer v_object);
gpointer value_get_deleted_file (const GValue* value);
GType deleted_file_get_type (void) G_GNUC_CONST;
#define DELETED_FILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DELETED_FILE, DeletedFilePrivate))
enum  {
	DELETED_FILE_DUMMY_PROPERTY
};
DeletedFile* deleted_file_new (const gchar* name, struct tm* deleted);
DeletedFile* deleted_file_construct (GType object_type, const gchar* name, struct tm* deleted);
void deleted_file_set_name (DeletedFile* self, const gchar* value);
void deleted_file_set_deleted (DeletedFile* self, struct tm* value);
gchar* deleted_file_filename (DeletedFile* self);
const gchar* deleted_file_get_name (DeletedFile* self);
gchar* deleted_file_queue_format (DeletedFile* self);
void deleted_file_get_deleted (DeletedFile* self, struct tm* result);
gboolean deleted_file_get_restore (DeletedFile* self);
void deleted_file_set_restore (DeletedFile* self, gboolean value);
static void deleted_file_finalize (DeletedFile* obj);
GType assistant_get_type (void) G_GNUC_CONST;
gpointer assistant_page_info_ref (gpointer instance);
void assistant_page_info_unref (gpointer instance);
GParamSpec* assistant_param_spec_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void assistant_value_set_page_info (GValue* value, gpointer v_object);
void assistant_value_take_page_info (GValue* value, gpointer v_object);
gpointer assistant_value_get_page_info (const GValue* value);
GType assistant_page_info_get_type (void) G_GNUC_CONST;
GType assistant_operation_get_type (void) G_GNUC_CONST;
GType status_icon_get_type (void) G_GNUC_CONST;
GType assistant_restore_get_type (void) G_GNUC_CONST;
GType assistant_restore_missing_get_type (void) G_GNUC_CONST;
#define ASSISTANT_RESTORE_MISSING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ASSISTANT_RESTORE_MISSING, AssistantRestoreMissingPrivate))
enum  {
	ASSISTANT_RESTORE_MISSING_DUMMY_PROPERTY
};
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static gint assistant_restore_missing_compare_time (struct tm* a, struct tm* b);
AssistantRestoreMissing* assistant_restore_missing_new (GFile* list_dir);
AssistantRestoreMissing* assistant_restore_missing_construct (GType object_type, GFile* list_dir);
AssistantRestore* assistant_restore_new (void);
AssistantRestore* assistant_restore_construct (GType object_type);
static void assistant_restore_missing_real_add_custom_config_pages (AssistantOperation* base);
void assistant_operation_add_custom_config_pages (AssistantOperation* self);
static gchar* assistant_restore_missing_get_ui_file (AssistantRestoreMissing* self, const gchar* ui_file);
static gchar** _vala_array_dup1 (gchar** self, int length);
static GtkWidget* assistant_restore_missing_make_listfiles_page (AssistantRestoreMissing* self);
static void ___lambda36_ (AssistantRestoreMissing* self, GtkCellRendererToggle* toggle, const gchar* path);
static gint ___lambda37_ (GFile* a, GFile* b);
static gint ____lambda37__gcompare_func (gconstpointer a, gconstpointer b);
void assistant_allow_forward (Assistant* self, gboolean allow);
GList* assistant_restore_get_restore_files (AssistantRestore* self);
static void ____lambda36__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self);
static void assistant_restore_missing_add_listfiles_page (AssistantRestoreMissing* self);
GType assistant_type_get_type (void) G_GNUC_CONST;
void assistant_append_page (Assistant* self, GtkWidget* page, AssistantType type);
void assistant_set_page_title (Assistant* self, GtkWidget* page, const gchar* title);
static void assistant_restore_missing_real_add_setup_pages (AssistantOperation* base);
static void assistant_restore_missing_real_do_prepare (AssistantOperation* base, Assistant* assist, GtkWidget* page);
GtkWidget* assistant_operation_get_confirm_page (AssistantOperation* self);
void assistant_restore_missing_do_query_files_at_date (AssistantRestoreMissing* self);
void assistant_operation_provide_password (AssistantOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void assistant_operation_provide_password_finish (AssistantOperation* self, GAsyncResult* _res_);
void assistant_restore_do_query (AssistantRestore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void assistant_restore_do_query_finish (AssistantRestore* self, GAsyncResult* _res_);
static gboolean ____lambda39_ (AssistantRestoreMissing* self);
static gboolean _____lambda39__gsource_func (gpointer self);
void assistant_operation_do_prepare (AssistantOperation* self, Assistant* assist, GtkWidget* page);
void assistant_restore_missing_handle_listed_files (AssistantRestoreMissing* self, DejaDupOperationFiles* op, const gchar* date, const gchar* file);
static void assistant_restore_missing_real_handle_collection_dates (AssistantRestore* base, DejaDupOperationStatus* op, GList* dates);
static struct tm* _g_time_dup (struct tm* self);
static void _deleted_file_unref0_ (gpointer var);
void assistant_operation_do_close (AssistantOperation* self);
void assistant_restore_missing_query_files_finished (AssistantRestoreMissing* self, DejaDupOperation* op, gboolean success, gboolean cancelled, const gchar* detail);
static void _assistant_restore_missing_handle_listed_files_deja_dup_operation_files_listed_current_files (DejaDupOperationFiles* _sender, const gchar* date, const gchar* file, gpointer self);
static void _assistant_restore_missing_query_files_finished_deja_dup_operation_done (DejaDupOperation* _sender, gboolean success, gboolean cancelled, const gchar* detail, gpointer self);
void assistant_operation_get_passphrase (AssistantOperation* self);
static void _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required (DejaDupOperation* _sender, gpointer self);
static void __lambda38_ (AssistantRestoreMissing* self, DejaDupOperation* o, const gchar* e, const gchar* d);
void assistant_operation_show_error (AssistantOperation* self, const gchar* _error_, const gchar* detail);
static void ___lambda38__deja_dup_operation_raise_error (DejaDupOperation* _sender, const gchar* errstr, const gchar* detail, gpointer self);
static void assistant_restore_missing_real_query_finished (AssistantRestore* base, DejaDupOperation* op, gboolean success, gboolean cancelled, const gchar* detail);
static void assistant_restore_missing_real_do_cancel (AssistantOperation* base);
void assistant_operation_do_cancel (AssistantOperation* self);
static void assistant_restore_missing_real_apply_finished (AssistantOperation* base, DejaDupOperation* op, gboolean success, gboolean cancelled, const gchar* detail);
void assistant_operation_do_apply (AssistantOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void assistant_operation_do_apply_finish (AssistantOperation* self, GAsyncResult* _res_);
void assistant_go_to_page (Assistant* self, GtkWidget* page);
GtkWidget* assistant_operation_get_summary_page (AssistantOperation* self);
void assistant_operation_force_visible (AssistantOperation* self, gboolean user_click);
static DejaDupOperation* assistant_restore_missing_real_create_op (AssistantOperation* base);
static void assistant_restore_missing_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


DeletedFile* deleted_file_construct (GType object_type, const gchar* name, struct tm* deleted) {
	DeletedFile* self = NULL;
	const gchar* _tmp0_ = NULL;
	struct tm _tmp1_ = {0};
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (deleted != NULL, NULL);
	self = (DeletedFile*) g_type_create_instance (object_type);
	_tmp0_ = name;
	deleted_file_set_name (self, _tmp0_);
	_tmp1_ = *deleted;
	deleted_file_set_deleted (self, &_tmp1_);
	return self;
}


DeletedFile* deleted_file_new (const gchar* name, struct tm* deleted) {
	return deleted_file_construct (TYPE_DELETED_FILE, name, deleted);
}


gchar* deleted_file_filename (DeletedFile* self) {
	gchar* result = NULL;
	gchar** splited_fn = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint splited_fn_length1 = 0;
	gint _splited_fn_size_ = 0;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "/", 0);
	splited_fn = _tmp2_;
	splited_fn_length1 = _vala_array_length (_tmp1_);
	_splited_fn_size_ = splited_fn_length1;
	_tmp3_ = splited_fn[splited_fn_length1 - 1];
	_tmp4_ = g_strdup (_tmp3_);
	result = _tmp4_;
	splited_fn = (_vala_array_free (splited_fn, splited_fn_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gchar* g_time_format (struct tm *self, const gchar* format) {
	gchar* result = NULL;
	gchar* buffer = NULL;
	gchar* _tmp0_ = NULL;
	gint buffer_length1 = 0;
	gint _buffer_size_ = 0;
	gchar* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (format != NULL, NULL);
	_tmp0_ = g_new0 (gchar, 64);
	buffer = _tmp0_;
	buffer_length1 = 64;
	_buffer_size_ = buffer_length1;
	_tmp1_ = buffer;
	_tmp1__length1 = buffer_length1;
	_tmp2_ = format;
	strftime (_tmp1_, _tmp1__length1, _tmp2_, &(*self));
	_tmp3_ = buffer;
	_tmp3__length1 = buffer_length1;
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
	result = _tmp4_;
	buffer = (g_free (buffer), NULL);
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


gchar* deleted_file_queue_format (DeletedFile* self) {
	gchar* result = NULL;
	gchar* file = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* time = NULL;
	struct tm _tmp2_ = {0};
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = g_strdup (_tmp0_);
	file = _tmp1_;
	_tmp2_ = self->priv->_deleted;
	_tmp3_ = g_time_format (&_tmp2_, "%s");
	time = _tmp3_;
	_tmp4_ = string_to_string (file);
	_tmp5_ = string_to_string (time);
	_tmp6_ = g_strconcat (_tmp4_, " ", _tmp5_, NULL);
	result = _tmp6_;
	_g_free0 (time);
	_g_free0 (file);
	return result;
}


const gchar* deleted_file_get_name (DeletedFile* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


void deleted_file_set_name (DeletedFile* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
}


void deleted_file_get_deleted (DeletedFile* self, struct tm* result) {
	struct tm _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_deleted;
	*result = _tmp0_;
	return;
}


void deleted_file_set_deleted (DeletedFile* self, struct tm* value) {
	struct tm _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = *value;
	self->priv->_deleted = _tmp0_;
}


gboolean deleted_file_get_restore (DeletedFile* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_restore;
	result = _tmp0_;
	return result;
}


void deleted_file_set_restore (DeletedFile* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_restore = _tmp0_;
}


static void value_deleted_file_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_deleted_file_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		deleted_file_unref (value->data[0].v_pointer);
	}
}


static void value_deleted_file_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = deleted_file_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_deleted_file_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_deleted_file_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		DeletedFile* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = deleted_file_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_deleted_file_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DeletedFile** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = deleted_file_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_deleted_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecDeletedFile* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DELETED_FILE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_deleted_file (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DELETED_FILE), NULL);
	return value->data[0].v_pointer;
}


void value_set_deleted_file (GValue* value, gpointer v_object) {
	DeletedFile* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DELETED_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DELETED_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		deleted_file_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		deleted_file_unref (old);
	}
}


void value_take_deleted_file (GValue* value, gpointer v_object) {
	DeletedFile* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DELETED_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DELETED_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		deleted_file_unref (old);
	}
}


static void deleted_file_class_init (DeletedFileClass * klass) {
	deleted_file_parent_class = g_type_class_peek_parent (klass);
	((DeletedFileClass *) klass)->finalize = deleted_file_finalize;
	g_type_class_add_private (klass, sizeof (DeletedFilePrivate));
}


static void deleted_file_instance_init (DeletedFile * self) {
	self->priv = DELETED_FILE_GET_PRIVATE (self);
	self->priv->_restore = FALSE;
	self->ref_count = 1;
}


static void deleted_file_finalize (DeletedFile* obj) {
	DeletedFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DELETED_FILE, DeletedFile);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_name);
}


GType deleted_file_get_type (void) {
	static volatile gsize deleted_file_type_id__volatile = 0;
	if (g_once_init_enter (&deleted_file_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_deleted_file_init, value_deleted_file_free_value, value_deleted_file_copy_value, value_deleted_file_peek_pointer, "p", value_deleted_file_collect_value, "p", value_deleted_file_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DeletedFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deleted_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DeletedFile), 0, (GInstanceInitFunc) deleted_file_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType deleted_file_type_id;
		deleted_file_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DeletedFile", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&deleted_file_type_id__volatile, deleted_file_type_id);
	}
	return deleted_file_type_id__volatile;
}


gpointer deleted_file_ref (gpointer instance) {
	DeletedFile* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void deleted_file_unref (gpointer instance) {
	DeletedFile* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DELETED_FILE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _g_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_free (var), NULL));
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gint assistant_restore_missing_compare_time (struct tm* a, struct tm* b) {
	gint result = 0;
	gint a_epoch = 0;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint b_epoch = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = g_time_format (a, "%s");
	_tmp1_ = _tmp0_;
	_tmp2_ = atoi (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	a_epoch = _tmp3_;
	_tmp4_ = g_time_format (b, "%s");
	_tmp5_ = _tmp4_;
	_tmp6_ = atoi (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	b_epoch = _tmp7_;
	_tmp8_ = a_epoch;
	_tmp9_ = b_epoch;
	if (_tmp8_ < _tmp9_) {
		result = 1;
		return result;
	} else {
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		_tmp10_ = a_epoch;
		_tmp11_ = b_epoch;
		if (_tmp10_ == _tmp11_) {
			result = 0;
			return result;
		} else {
			result = -1;
			return result;
		}
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


AssistantRestoreMissing* assistant_restore_missing_construct (GType object_type, GFile* list_dir) {
	AssistantRestoreMissing * self = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	g_return_val_if_fail (list_dir != NULL, NULL);
	self = (AssistantRestoreMissing*) assistant_restore_construct (object_type);
	_tmp0_ = list_dir;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->list_directory);
	self->priv->list_directory = _tmp1_;
	return self;
}


AssistantRestoreMissing* assistant_restore_missing_new (GFile* list_dir) {
	return assistant_restore_missing_construct (TYPE_ASSISTANT_RESTORE_MISSING, list_dir);
}


static void assistant_restore_missing_real_add_custom_config_pages (AssistantOperation* base) {
	AssistantRestoreMissing * self;
	gboolean _tmp0_ = FALSE;
	self = (AssistantRestoreMissing*) base;
	_tmp0_ = deja_dup_has_seen_settings ();
	if (!_tmp0_) {
		ASSISTANT_OPERATION_CLASS (assistant_restore_missing_parent_class)->add_custom_config_pages ((AssistantOperation*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ASSISTANT_RESTORE, AssistantRestore));
	}
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar* assistant_restore_missing_get_ui_file (AssistantRestoreMissing* self, const gchar* ui_file) {
	gchar* result = NULL;
	gchar** sysdatadirs = NULL;
	gchar** _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint sysdatadirs_length1 = 0;
	gint _sysdatadirs_size_ = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ui_file != NULL, NULL);
	_tmp1_ = _tmp0_ = g_get_system_data_dirs ();
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup1 (_tmp1_, _vala_array_length (_tmp0_)) : ((gpointer) _tmp1_);
	_tmp2__length1 = _vala_array_length (_tmp0_);
	sysdatadirs = _tmp2_;
	sysdatadirs_length1 = _tmp2__length1;
	_sysdatadirs_size_ = sysdatadirs_length1;
	_tmp3_ = sysdatadirs;
	_tmp3__length1 = sysdatadirs_length1;
	{
		gchar** sysdir_collection = NULL;
		gint sysdir_collection_length1 = 0;
		gint _sysdir_collection_size_ = 0;
		gint sysdir_it = 0;
		sysdir_collection = _tmp3_;
		sysdir_collection_length1 = _tmp3__length1;
		for (sysdir_it = 0; sysdir_it < _tmp3__length1; sysdir_it = sysdir_it + 1) {
			gchar* _tmp4_ = NULL;
			gchar* sysdir = NULL;
			_tmp4_ = g_strdup (sysdir_collection[sysdir_it]);
			sysdir = _tmp4_;
			{
				gchar* p = NULL;
				const gchar* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				GFile* file = NULL;
				const gchar* _tmp8_ = NULL;
				GFile* _tmp9_ = NULL;
				GFile* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
				_tmp5_ = sysdir;
				_tmp6_ = ui_file;
				_tmp7_ = g_build_filename (_tmp5_, PACKAGE, "ui", _tmp6_, NULL);
				p = _tmp7_;
				_tmp8_ = p;
				_tmp9_ = g_file_new_for_path (_tmp8_);
				file = _tmp9_;
				_tmp10_ = file;
				_tmp11_ = g_file_query_exists (_tmp10_, NULL);
				if (_tmp11_) {
					result = p;
					_g_object_unref0 (file);
					_g_free0 (sysdir);
					sysdatadirs = (_vala_array_free (sysdatadirs, sysdatadirs_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_g_object_unref0 (file);
				_g_free0 (p);
				_g_free0 (sysdir);
			}
		}
	}
	result = NULL;
	sysdatadirs = (_vala_array_free (sysdatadirs, sysdatadirs_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gint ___lambda37_ (GFile* a, GFile* b) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GFile* _tmp2_ = NULL;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp2_ = a;
	if (_tmp2_ != NULL) {
		GFile* _tmp3_ = NULL;
		_tmp3_ = b;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GFile* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = a;
		_tmp5_ = b;
		_tmp6_ = g_file_equal (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, G_TYPE_FILE) ? ((GFile*) _tmp4_) : NULL, G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, G_TYPE_FILE) ? ((GFile*) _tmp5_) : NULL);
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	} else {
		result = 1;
		return result;
	}
}


static gint ____lambda37__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = ___lambda37_ ((GFile*) a, (GFile*) b);
	return result;
}


static void ___lambda36_ (AssistantRestoreMissing* self, GtkCellRendererToggle* toggle, const gchar* path) {
	gboolean active = FALSE;
	GtkCellRendererToggle* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkTreePath* tree_path = NULL;
	const gchar* _tmp3_ = NULL;
	GtkTreePath* _tmp4_ = NULL;
	GtkListStore* _tmp5_ = NULL;
	GtkTreePath* _tmp6_ = NULL;
	GtkTreeIter _tmp7_ = {0};
	GtkListStore* _tmp8_ = NULL;
	GtkTreeIter _tmp9_ = {0};
	gboolean _tmp10_ = FALSE;
	gchar* name = NULL;
	GtkListStore* _tmp11_ = NULL;
	GtkTreeIter _tmp12_ = {0};
	GFile* file = NULL;
	GFile* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GFile* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	GList* _tmp22_ = NULL;
	GList* _tmp23_ = NULL;
	g_return_if_fail (toggle != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = toggle;
	_tmp1_ = gtk_cell_renderer_toggle_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	active = !_tmp2_;
	_tmp3_ = path;
	_tmp4_ = gtk_tree_path_new_from_string (_tmp3_);
	tree_path = _tmp4_;
	_tmp5_ = self->priv->listmodel;
	_tmp6_ = tree_path;
	gtk_tree_model_get_iter ((GtkTreeModel*) _tmp5_, &_tmp7_, _tmp6_);
	self->priv->deleted_iter = _tmp7_;
	_tmp8_ = self->priv->listmodel;
	_tmp9_ = self->priv->deleted_iter;
	_tmp10_ = active;
	gtk_list_store_set (_tmp8_, &_tmp9_, 0, _tmp10_, -1);
	_tmp11_ = self->priv->listmodel;
	_tmp12_ = self->priv->deleted_iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp11_, &_tmp12_, 1, &name, -1);
	_tmp13_ = self->priv->list_directory;
	_tmp14_ = name;
	_tmp15_ = g_file_get_child (_tmp13_, _tmp14_);
	file = _tmp15_;
	_tmp16_ = active;
	if (_tmp16_) {
		GFile* _tmp17_ = NULL;
		GFile* _tmp18_ = NULL;
		_tmp17_ = file;
		_tmp18_ = _g_object_ref0 (_tmp17_);
		((AssistantRestore*) self)->_restore_files = g_list_prepend (((AssistantRestore*) self)->_restore_files, _tmp18_);
	} else {
		GList* _tmp19_ = NULL;
		GFile* _tmp20_ = NULL;
		GList* _tmp21_ = NULL;
		_tmp19_ = ((AssistantRestore*) self)->_restore_files;
		_tmp20_ = file;
		_tmp21_ = g_list_find_custom (_tmp19_, _tmp20_, ____lambda37__gcompare_func);
		((AssistantRestore*) self)->_restore_files = g_list_remove_link (((AssistantRestore*) self)->_restore_files, _tmp21_);
	}
	_tmp22_ = assistant_restore_get_restore_files ((AssistantRestore*) self);
	_tmp23_ = _tmp22_;
	assistant_allow_forward ((Assistant*) self, _tmp23_ != NULL);
	_g_object_unref0 (file);
	_g_free0 (name);
	_gtk_tree_path_free0 (tree_path);
}


static void ____lambda36__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self) {
	___lambda36_ ((AssistantRestoreMissing*) self, _sender, path);
}


static GtkWidget* assistant_restore_missing_make_listfiles_page (AssistantRestoreMissing* self) {
	GtkWidget* result = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_builder_new ();
	builder = _tmp0_;
	{
		gchar* gf = NULL;
		gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		GtkBuilder* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GtkBuilder* _tmp5_ = NULL;
		GtkWidget* page = NULL;
		GtkBuilder* _tmp6_ = NULL;
		GObject* _tmp7_ = NULL;
		GtkWidget* _tmp8_ = NULL;
		GtkScrolledWindow* filelistwindow = NULL;
		GtkBuilder* _tmp9_ = NULL;
		GObject* _tmp10_ = NULL;
		GtkScrolledWindow* _tmp11_ = NULL;
		GtkBox* status_table = NULL;
		GtkBuilder* _tmp12_ = NULL;
		GObject* _tmp13_ = NULL;
		GtkBox* _tmp14_ = NULL;
		GtkBox* progress_table = NULL;
		GtkBuilder* _tmp15_ = NULL;
		GObject* _tmp16_ = NULL;
		GtkBox* _tmp17_ = NULL;
		GtkBuilder* _tmp18_ = NULL;
		GObject* _tmp19_ = NULL;
		GtkLabel* _tmp20_ = NULL;
		GtkLabel* _tmp21_ = NULL;
		GtkLabel* _tmp22_ = NULL;
		GtkBox* _tmp23_ = NULL;
		GtkLabel* _tmp24_ = NULL;
		GtkBox* _tmp25_ = NULL;
		GtkSpinner* _tmp26_ = NULL;
		GtkSpinner* _tmp27_ = NULL;
		GtkListStore* _tmp28_ = NULL;
		GtkTreeView* treeview = NULL;
		GtkListStore* _tmp29_ = NULL;
		GtkTreeView* _tmp30_ = NULL;
		GtkCellRendererToggle* toggle = NULL;
		GtkCellRendererToggle* _tmp31_ = NULL;
		GtkCellRendererToggle* _tmp32_ = NULL;
		GtkTreeView* _tmp33_ = NULL;
		GtkCellRendererToggle* _tmp34_ = NULL;
		GtkTreeView* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		GtkCellRendererText* _tmp37_ = NULL;
		GtkCellRendererText* _tmp38_ = NULL;
		GtkTreeView* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		GtkCellRendererText* _tmp41_ = NULL;
		GtkCellRendererText* _tmp42_ = NULL;
		GtkTreeView* _tmp43_ = NULL;
		GtkScrolledWindow* _tmp44_ = NULL;
		GtkTreeView* _tmp45_ = NULL;
		_tmp1_ = assistant_restore_missing_get_ui_file (self, "restore-missing.ui");
		gf = _tmp1_;
		_tmp2_ = gf;
		if (_tmp2_ == NULL) {
			g_warning ("AssistantRestoreMissing.vala:150: Error: Could not find interface file" \
".");
			result = NULL;
			_g_free0 (gf);
			_g_object_unref0 (builder);
			return result;
		}
		_tmp3_ = builder;
		_tmp4_ = gf;
		gtk_builder_add_from_file (_tmp3_, _tmp4_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (gf);
			goto __catch5_g_error;
		}
		_tmp5_ = builder;
		gtk_builder_connect_signals (_tmp5_, self);
		_tmp6_ = builder;
		_tmp7_ = gtk_builder_get_object (_tmp6_, "restore-missing-files");
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp7_) : NULL);
		page = _tmp8_;
		_tmp9_ = builder;
		_tmp10_ = gtk_builder_get_object (_tmp9_, "file-list-window");
		_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, gtk_scrolled_window_get_type ()) ? ((GtkScrolledWindow*) _tmp10_) : NULL);
		filelistwindow = _tmp11_;
		_tmp12_ = builder;
		_tmp13_ = gtk_builder_get_object (_tmp12_, "folder-box");
		_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, gtk_box_get_type ()) ? ((GtkBox*) _tmp13_) : NULL);
		status_table = _tmp14_;
		_tmp15_ = builder;
		_tmp16_ = gtk_builder_get_object (_tmp15_, "status-box");
		_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, gtk_box_get_type ()) ? ((GtkBox*) _tmp16_) : NULL);
		progress_table = _tmp17_;
		_tmp18_ = builder;
		_tmp19_ = gtk_builder_get_object (_tmp18_, "status-label");
		_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp19_) : NULL);
		_g_object_unref0 (self->priv->current_scan_date);
		self->priv->current_scan_date = _tmp20_;
		_tmp21_ = (GtkLabel*) gtk_label_new ("");
		g_object_ref_sink (_tmp21_);
		_g_object_unref0 (self->priv->list_dir_label);
		self->priv->list_dir_label = _tmp21_;
		_tmp22_ = self->priv->list_dir_label;
		g_object_set ((GObject*) _tmp22_, "xalign", 0.0f, NULL);
		_tmp23_ = status_table;
		_tmp24_ = self->priv->list_dir_label;
		gtk_box_pack_start (_tmp23_, (GtkWidget*) _tmp24_, TRUE, TRUE, (guint) 0);
		_tmp25_ = progress_table;
		_tmp26_ = self->priv->spinner;
		gtk_box_pack_end (_tmp25_, (GtkWidget*) _tmp26_, FALSE, FALSE, (guint) 0);
		_tmp27_ = self->priv->spinner;
		gtk_widget_set_size_request ((GtkWidget*) _tmp27_, 20, 20);
		_tmp28_ = gtk_list_store_new (3, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_STRING, -1);
		_g_object_unref0 (self->priv->listmodel);
		self->priv->listmodel = _tmp28_;
		_tmp29_ = self->priv->listmodel;
		_tmp30_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp29_);
		g_object_ref_sink (_tmp30_);
		treeview = _tmp30_;
		_tmp31_ = (GtkCellRendererToggle*) gtk_cell_renderer_toggle_new ();
		g_object_ref_sink (_tmp31_);
		toggle = _tmp31_;
		_tmp32_ = toggle;
		g_signal_connect_object (_tmp32_, "toggled", (GCallback) ____lambda36__gtk_cell_renderer_toggle_toggled, self, 0);
		_tmp33_ = treeview;
		_tmp34_ = toggle;
		gtk_tree_view_insert_column_with_attributes (_tmp33_, -1, "    ", (GtkCellRenderer*) _tmp34_, "active", 0, NULL);
		_tmp35_ = treeview;
		_tmp36_ = _ ("File");
		_tmp37_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
		g_object_ref_sink (_tmp37_);
		_tmp38_ = _tmp37_;
		gtk_tree_view_insert_column_with_attributes (_tmp35_, -1, _tmp36_, (GtkCellRenderer*) _tmp38_, "text", 1, NULL);
		_g_object_unref0 (_tmp38_);
		_tmp39_ = treeview;
		_tmp40_ = _ ("Last seen");
		_tmp41_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
		g_object_ref_sink (_tmp41_);
		_tmp42_ = _tmp41_;
		gtk_tree_view_insert_column_with_attributes (_tmp39_, -1, _tmp40_, (GtkCellRenderer*) _tmp42_, "text", 2, NULL);
		_g_object_unref0 (_tmp42_);
		_tmp43_ = treeview;
		gtk_tree_view_set_headers_visible (_tmp43_, TRUE);
		_tmp44_ = filelistwindow;
		_tmp45_ = treeview;
		gtk_scrolled_window_add_with_viewport (_tmp44_, (GtkWidget*) _tmp45_);
		result = page;
		_g_object_unref0 (toggle);
		_g_object_unref0 (treeview);
		_g_object_unref0 (progress_table);
		_g_object_unref0 (status_table);
		_g_object_unref0 (filelistwindow);
		_g_free0 (gf);
		_g_object_unref0 (builder);
		return result;
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* err = NULL;
		GError* _tmp46_ = NULL;
		const gchar* _tmp47_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp46_ = err;
		_tmp47_ = _tmp46_->message;
		g_warning ("AssistantRestoreMissing.vala:207: %s", _tmp47_);
		result = NULL;
		_g_error_free0 (err);
		_g_object_unref0 (builder);
		return result;
	}
	__finally5:
	_g_object_unref0 (builder);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static void assistant_restore_missing_add_listfiles_page (AssistantRestoreMissing* self) {
	GtkWidget* page = NULL;
	GtkWidget* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_restore_missing_make_listfiles_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_NORMAL);
	_tmp1_ = _ ("Restore which Files?");
	assistant_set_page_title ((Assistant*) self, page, _tmp1_);
	_tmp2_ = _g_object_ref0 (page);
	_g_object_unref0 (self->priv->listfiles_page);
	self->priv->listfiles_page = _tmp2_;
	_g_object_unref0 (page);
}


static void assistant_restore_missing_real_add_setup_pages (AssistantOperation* base) {
	AssistantRestoreMissing * self;
	self = (AssistantRestoreMissing*) base;
	assistant_restore_missing_add_listfiles_page (self);
}


static gboolean ____lambda39_ (AssistantRestoreMissing* self) {
	gboolean result = FALSE;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	_tmp0_ = assistant_restore_get_restore_files ((AssistantRestore*) self);
	_tmp1_ = _tmp0_;
	assistant_allow_forward ((Assistant*) self, _tmp1_ != NULL);
	result = FALSE;
	return result;
}


static gboolean _____lambda39__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda39_ ((AssistantRestoreMissing*) self);
	return result;
}


static void assistant_restore_missing_real_do_prepare (AssistantOperation* base, Assistant* assist, GtkWidget* page) {
	AssistantRestoreMissing * self;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	Assistant* _tmp24_ = NULL;
	GtkWidget* _tmp25_ = NULL;
	self = (AssistantRestoreMissing*) base;
	g_return_if_fail (assist != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page;
	_tmp1_ = assistant_operation_get_confirm_page ((AssistantOperation*) self);
	_tmp2_ = _tmp1_;
	if (_tmp0_ == _tmp2_) {
		GList* _tmp3_ = NULL;
		GList* _tmp4_ = NULL;
		GList* _tmp5_ = NULL;
		self->priv->scan_queue = FALSE;
		_tmp3_ = assistant_restore_get_restore_files ((AssistantRestore*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_list_copy (_tmp4_);
		__g_list_free__g_object_unref0_0 (self->priv->restore_files_remaining);
		self->priv->restore_files_remaining = _tmp5_;
	} else {
		GtkWidget* _tmp6_ = NULL;
		GtkWidget* _tmp7_ = NULL;
		_tmp6_ = page;
		_tmp7_ = self->priv->listfiles_page;
		if (_tmp6_ == _tmp7_) {
			GtkLabel* _tmp8_ = NULL;
			GFile* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			_tmp8_ = self->priv->list_dir_label;
			_tmp9_ = self->priv->list_directory;
			_tmp10_ = g_file_get_parse_name (_tmp9_);
			_tmp11_ = _tmp10_;
			gtk_label_set_label (_tmp8_, _tmp11_);
			_g_free0 (_tmp11_);
			_tmp12_ = self->priv->scan_queue;
			if (!_tmp12_) {
				assistant_restore_missing_do_query_files_at_date (self);
				self->priv->scan_queue = TRUE;
			} else {
				gboolean _tmp13_ = FALSE;
				DejaDupOperationStatus* _tmp14_ = NULL;
				_tmp14_ = ((AssistantRestore*) self)->query_op;
				if (_tmp14_ != NULL) {
					DejaDupOperationStatus* _tmp15_ = NULL;
					gboolean _tmp16_ = FALSE;
					gboolean _tmp17_ = FALSE;
					_tmp15_ = ((AssistantRestore*) self)->query_op;
					_tmp16_ = deja_dup_operation_get_needs_password ((DejaDupOperation*) _tmp15_);
					_tmp17_ = _tmp16_;
					_tmp13_ = _tmp17_;
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					assistant_operation_provide_password ((AssistantOperation*) self, NULL, NULL);
				} else {
					gboolean _tmp18_ = FALSE;
					DejaDupOperationFiles* _tmp19_ = NULL;
					_tmp19_ = self->priv->query_op_files;
					if (_tmp19_ != NULL) {
						DejaDupOperationFiles* _tmp20_ = NULL;
						gboolean _tmp21_ = FALSE;
						gboolean _tmp22_ = FALSE;
						_tmp20_ = self->priv->query_op_files;
						_tmp21_ = deja_dup_operation_get_needs_password ((DejaDupOperation*) _tmp20_);
						_tmp22_ = _tmp21_;
						_tmp18_ = _tmp22_;
					} else {
						_tmp18_ = FALSE;
					}
					if (_tmp18_) {
						assistant_operation_provide_password ((AssistantOperation*) self, NULL, NULL);
					} else {
						gboolean _tmp23_ = FALSE;
						_tmp23_ = self->priv->backups_queue_filled;
						if (!_tmp23_) {
							assistant_restore_do_query ((AssistantRestore*) self, NULL, NULL);
						}
					}
				}
			}
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _____lambda39__gsource_func, g_object_ref (self), g_object_unref);
		}
	}
	_tmp24_ = assist;
	_tmp25_ = page;
	ASSISTANT_OPERATION_CLASS (assistant_restore_missing_parent_class)->do_prepare ((AssistantOperation*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ASSISTANT_RESTORE, AssistantRestore), _tmp24_, _tmp25_);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gpointer _deleted_file_ref0 (gpointer self) {
	return self ? deleted_file_ref (self) : NULL;
}


void assistant_restore_missing_handle_listed_files (AssistantRestoreMissing* self, DejaDupOperationFiles* op, const gchar* date, const gchar* file) {
	gchar* filestr = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (date != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("/", _tmp1_, NULL);
	filestr = _tmp2_;
	_tmp4_ = filestr;
	_tmp5_ = self->priv->list_directory;
	_tmp6_ = g_file_get_path (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = string_contains (_tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	if (_tmp9_) {
		GFile* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		_tmp10_ = self->priv->list_directory;
		_tmp11_ = g_file_get_path (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = filestr;
		_tmp3_ = g_strcmp0 (_tmp12_, _tmp13_) != 0;
		_g_free0 (_tmp12_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GFile* fileobj = NULL;
		const gchar* _tmp14_ = NULL;
		GFile* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		GFile* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		_tmp14_ = filestr;
		_tmp15_ = g_file_new_for_path (_tmp14_);
		fileobj = _tmp15_;
		_tmp17_ = fileobj;
		_tmp18_ = g_file_query_exists (_tmp17_, NULL);
		if (!_tmp18_) {
			GHashTable* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			gboolean _tmp21_ = FALSE;
			_tmp19_ = self->priv->allfiles_prev;
			_tmp20_ = filestr;
			_tmp21_ = g_hash_table_lookup_extended (_tmp19_, _tmp20_, NULL, NULL);
			_tmp16_ = !_tmp21_;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			GFile* _tmp22_ = NULL;
			GFile* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			_tmp22_ = fileobj;
			_tmp23_ = self->priv->list_directory;
			_tmp24_ = g_file_has_parent (_tmp22_, _tmp23_);
			if (_tmp24_) {
				DeletedFile* fs = NULL;
				const gchar* _tmp25_ = NULL;
				DejaDupOperationFiles* _tmp26_ = NULL;
				struct tm _tmp27_ = {0};
				struct tm _tmp28_ = {0};
				DeletedFile* _tmp29_ = NULL;
				GtkListStore* _tmp30_ = NULL;
				GtkTreeIter _tmp31_ = {0};
				GtkListStore* _tmp32_ = NULL;
				GtkTreeIter _tmp33_ = {0};
				DeletedFile* _tmp34_ = NULL;
				gchar* _tmp35_ = NULL;
				gchar* _tmp36_ = NULL;
				DejaDupOperationFiles* _tmp37_ = NULL;
				struct tm _tmp38_ = {0};
				struct tm _tmp39_ = {0};
				gchar* _tmp40_ = NULL;
				gchar* _tmp41_ = NULL;
				GHashTable* _tmp42_ = NULL;
				GFile* _tmp43_ = NULL;
				gchar* _tmp44_ = NULL;
				DeletedFile* _tmp45_ = NULL;
				DeletedFile* _tmp46_ = NULL;
				_tmp25_ = filestr;
				_tmp26_ = op;
				deja_dup_operation_files_get_time (_tmp26_, &_tmp27_);
				_tmp28_ = _tmp27_;
				_tmp29_ = deleted_file_new (_tmp25_, &_tmp28_);
				fs = _tmp29_;
				_tmp30_ = self->priv->listmodel;
				gtk_list_store_append (_tmp30_, &_tmp31_);
				self->priv->deleted_iter = _tmp31_;
				_tmp32_ = self->priv->listmodel;
				_tmp33_ = self->priv->deleted_iter;
				_tmp34_ = fs;
				_tmp35_ = deleted_file_filename (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = op;
				deja_dup_operation_files_get_time (_tmp37_, &_tmp38_);
				_tmp39_ = _tmp38_;
				_tmp40_ = g_time_format (&_tmp39_, "%c");
				_tmp41_ = _tmp40_;
				gtk_list_store_set (_tmp32_, &_tmp33_, 0, FALSE, 1, _tmp36_, 2, _tmp41_, -1);
				_g_free0 (_tmp41_);
				_g_free0 (_tmp36_);
				_tmp42_ = self->priv->allfiles_prev;
				_tmp43_ = fileobj;
				_tmp44_ = g_file_get_path (_tmp43_);
				_tmp45_ = fs;
				_tmp46_ = _deleted_file_ref0 (_tmp45_);
				g_hash_table_insert (_tmp42_, _tmp44_, _tmp46_);
				_deleted_file_unref0 (fs);
			}
		}
		_g_object_unref0 (fileobj);
	}
	_g_free0 (filestr);
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	localtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


static struct tm* _g_time_dup (struct tm* self) {
	struct tm* dup;
	dup = g_new0 (struct tm, 1);
	memcpy (dup, self, sizeof (struct tm));
	return dup;
}


static gpointer __g_time_dup0 (gpointer self) {
	return self ? _g_time_dup (self) : NULL;
}


static void _deleted_file_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (deleted_file_unref (var), NULL));
}


static void assistant_restore_missing_real_handle_collection_dates (AssistantRestore* base, DejaDupOperationStatus* op, GList* dates) {
	AssistantRestoreMissing * self;
	GTimeVal tv = {0};
	gboolean _tmp0_ = FALSE;
	self = (AssistantRestoreMissing*) base;
	g_return_if_fail (op != NULL);
	g_get_current_time (&tv);
	_tmp0_ = self->priv->backups_queue_filled;
	if (!_tmp0_) {
		GList* _tmp1_ = NULL;
		GHashFunc _tmp12_ = NULL;
		GEqualFunc _tmp13_ = NULL;
		GHashTable* _tmp14_ = NULL;
		GtkSpinner* _tmp15_ = NULL;
		_tmp1_ = dates;
		{
			GList* date_collection = NULL;
			GList* date_it = NULL;
			date_collection = _tmp1_;
			for (date_it = date_collection; date_it != NULL; date_it = date_it->next) {
				gchar* _tmp2_ = NULL;
				gchar* date = NULL;
				_tmp2_ = g_strdup ((const gchar*) date_it->data);
				date = _tmp2_;
				{
					const gchar* _tmp3_ = NULL;
					gboolean _tmp4_ = FALSE;
					_tmp3_ = date;
					_tmp4_ = g_time_val_from_iso8601 (_tmp3_, &tv);
					if (_tmp4_) {
						struct tm t = {0};
						GTimeVal _tmp5_ = {0};
						glong _tmp6_ = 0L;
						struct tm _tmp7_ = {0};
						GSequence* _tmp8_ = NULL;
						struct tm _tmp9_ = {0};
						struct tm* _tmp10_ = NULL;
						GSequenceIter* _tmp11_ = NULL;
						_tmp5_ = tv;
						_tmp6_ = _tmp5_.tv_sec;
						g_time_local ((time_t) _tmp6_, &_tmp7_);
						t = _tmp7_;
						_tmp8_ = self->priv->backups_queue;
						_tmp9_ = t;
						_tmp10_ = __g_time_dup0 (&_tmp9_);
						_tmp11_ = g_sequence_insert_sorted (_tmp8_, _tmp10_, (GCompareDataFunc) assistant_restore_missing_compare_time, NULL);
					}
					_g_free0 (date);
				}
			}
		}
		_tmp12_ = g_str_hash;
		_tmp13_ = g_str_equal;
		_tmp14_ = g_hash_table_new_full (_tmp12_, _tmp13_, _g_free0_, _deleted_file_unref0_);
		_g_hash_table_unref0 (self->priv->allfiles_prev);
		self->priv->allfiles_prev = _tmp14_;
		self->priv->backups_queue_filled = TRUE;
		_tmp15_ = self->priv->spinner;
		gtk_spinner_start (_tmp15_);
	}
}


static void _assistant_restore_missing_handle_listed_files_deja_dup_operation_files_listed_current_files (DejaDupOperationFiles* _sender, const gchar* date, const gchar* file, gpointer self) {
	assistant_restore_missing_handle_listed_files ((AssistantRestoreMissing*) self, _sender, date, file);
}


static void _assistant_restore_missing_query_files_finished_deja_dup_operation_done (DejaDupOperation* _sender, gboolean success, gboolean cancelled, const gchar* detail, gpointer self) {
	assistant_restore_missing_query_files_finished ((AssistantRestoreMissing*) self, _sender, success, cancelled, detail);
}


static void _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required (DejaDupOperation* _sender, gpointer self) {
	assistant_operation_get_passphrase ((AssistantOperation*) self);
}


static void __lambda38_ (AssistantRestoreMissing* self, DejaDupOperation* o, const gchar* e, const gchar* d) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (o != NULL);
	g_return_if_fail (e != NULL);
	_tmp0_ = e;
	_tmp1_ = d;
	assistant_operation_show_error ((AssistantOperation*) self, _tmp0_, _tmp1_);
}


static void ___lambda38__deja_dup_operation_raise_error (DejaDupOperation* _sender, const gchar* errstr, const gchar* detail, gpointer self) {
	__lambda38_ ((AssistantRestoreMissing*) self, _sender, errstr, detail);
}


void assistant_restore_missing_do_query_files_at_date (AssistantRestoreMissing* self) {
	gboolean _tmp0_ = FALSE;
	GSequence* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GSequenceIter* begin = NULL;
	GSequence* _tmp4_ = NULL;
	GSequenceIter* _tmp5_ = NULL;
	struct tm* etime = NULL;
	GSequenceIter* _tmp6_ = NULL;
	gconstpointer _tmp7_ = NULL;
	struct tm* _tmp8_ = NULL;
	GSequenceIter* _tmp9_ = NULL;
	gint tepoch = 0;
	struct tm* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	GTimeVal ttoday = {0};
	gint ttodayi = 0;
	GTimeVal _tmp15_ = {0};
	glong _tmp16_ = 0L;
	gchar* worddiff = NULL;
	gint tdiff = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	GtkLabel* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	struct tm* _tmp43_ = NULL;
	GFile* _tmp44_ = NULL;
	DejaDupOperationFiles* _tmp45_ = NULL;
	DejaDupOperationFiles* _tmp46_ = NULL;
	DejaDupOperationFiles* _tmp47_ = NULL;
	DejaDupOperationFiles* _tmp48_ = NULL;
	DejaDupOperation* _tmp49_ = NULL;
	DejaDupOperation* _tmp50_ = NULL;
	DejaDupOperation* _tmp51_ = NULL;
	DejaDupOperation* _tmp52_ = NULL;
	DejaDupOperationState* _tmp53_ = NULL;
	DejaDupOperationFiles* _tmp54_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cancel_assistant;
	if (_tmp0_) {
		assistant_operation_do_close ((AssistantOperation*) self);
		return;
	}
	_tmp1_ = self->priv->backups_queue;
	_tmp2_ = g_sequence_get_length (_tmp1_);
	if (_tmp2_ == 0) {
		DejaDupOperationFiles* _tmp3_ = NULL;
		_tmp3_ = self->priv->query_op_files;
		assistant_restore_missing_query_files_finished (self, (DejaDupOperation*) _tmp3_, TRUE, FALSE, NULL);
		return;
	}
	_tmp4_ = self->priv->backups_queue;
	_tmp5_ = g_sequence_get_begin_iter (_tmp4_);
	begin = _tmp5_;
	_tmp6_ = begin;
	_tmp7_ = g_sequence_get (_tmp6_);
	_tmp8_ = __g_time_dup0 ((struct tm*) _tmp7_);
	etime = _tmp8_;
	_tmp9_ = begin;
	g_sequence_remove (_tmp9_);
	_tmp10_ = etime;
	_tmp11_ = g_time_format (_tmp10_, "%s");
	_tmp12_ = _tmp11_;
	_tmp13_ = atoi (_tmp12_);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	tepoch = _tmp14_;
	g_get_current_time (&ttoday);
	g_get_current_time (&ttoday);
	_tmp15_ = ttoday;
	_tmp16_ = _tmp15_.tv_sec;
	ttodayi = (gint) _tmp16_;
	_tmp17_ = ttodayi;
	_tmp18_ = tepoch;
	tdiff = ((_tmp17_ - _tmp18_) / 60) / 60;
	_tmp19_ = tdiff;
	if ((_tmp19_ / 24) == 0) {
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		_tmp20_ = _ ("Scanning for files from up to a day ago…");
		_tmp21_ = g_strdup (_tmp20_);
		_g_free0 (worddiff);
		worddiff = _tmp21_;
	} else {
		gint _tmp22_ = 0;
		_tmp22_ = tdiff;
		if (((_tmp22_ / 24) / 7) == 0) {
			const gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			_tmp23_ = _ ("Scanning for files from up to a week ago…");
			_tmp24_ = g_strdup (_tmp23_);
			_g_free0 (worddiff);
			worddiff = _tmp24_;
		} else {
			gint _tmp25_ = 0;
			_tmp25_ = tdiff;
			if (((_tmp25_ / 24) / 30) == 0) {
				const gchar* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				_tmp26_ = _ ("Scanning for files from up to a month ago…");
				_tmp27_ = g_strdup (_tmp26_);
				_g_free0 (worddiff);
				worddiff = _tmp27_;
			} else {
				gboolean _tmp28_ = FALSE;
				gint _tmp29_ = 0;
				_tmp29_ = tdiff;
				if (((_tmp29_ / 24) / 30) >= 1) {
					gint _tmp30_ = 0;
					_tmp30_ = tdiff;
					_tmp28_ = ((_tmp30_ / 24) / 30) <= 12;
				} else {
					_tmp28_ = FALSE;
				}
				if (_tmp28_) {
					gint n = 0;
					gint _tmp31_ = 0;
					gint _tmp32_ = 0;
					const gchar* _tmp33_ = NULL;
					gint _tmp34_ = 0;
					gchar* _tmp35_ = NULL;
					_tmp31_ = tdiff;
					n = (_tmp31_ / 24) / 30;
					_tmp32_ = n;
					_tmp33_ = g_dngettext (GETTEXT_PACKAGE, "Scanning for files from about a month ago…", "Scanning for files from about %d months ago…", (gulong) _tmp32_);
					_tmp34_ = n;
					_tmp35_ = g_strdup_printf (_tmp33_, _tmp34_);
					_g_free0 (worddiff);
					worddiff = _tmp35_;
				} else {
					gint n = 0;
					gint _tmp36_ = 0;
					gint _tmp37_ = 0;
					const gchar* _tmp38_ = NULL;
					gint _tmp39_ = 0;
					gchar* _tmp40_ = NULL;
					_tmp36_ = tdiff;
					n = ((_tmp36_ / 24) / 30) / 12;
					_tmp37_ = n;
					_tmp38_ = g_dngettext (GETTEXT_PACKAGE, "Scanning for files from about a year ago…", "Scanning for files from about %d years ago…", (gulong) _tmp37_);
					_tmp39_ = n;
					_tmp40_ = g_strdup_printf (_tmp38_, _tmp39_);
					_g_free0 (worddiff);
					worddiff = _tmp40_;
				}
			}
		}
	}
	_tmp41_ = self->priv->current_scan_date;
	_tmp42_ = worddiff;
	gtk_label_set_text (_tmp41_, _tmp42_);
	gtk_widget_realize ((GtkWidget*) self);
	_tmp43_ = etime;
	_tmp44_ = self->priv->list_directory;
	_tmp45_ = deja_dup_operation_files_new (_tmp43_, _tmp44_);
	_g_object_unref0 (self->priv->query_op_files);
	self->priv->query_op_files = _tmp45_;
	_tmp46_ = self->priv->query_op_files;
	g_signal_connect_object (_tmp46_, "listed-current-files", (GCallback) _assistant_restore_missing_handle_listed_files_deja_dup_operation_files_listed_current_files, self, 0);
	_tmp47_ = self->priv->query_op_files;
	g_signal_connect_object ((DejaDupOperation*) _tmp47_, "done", (GCallback) _assistant_restore_missing_query_files_finished_deja_dup_operation_done, self, 0);
	_tmp48_ = self->priv->query_op_files;
	_tmp49_ = _g_object_ref0 ((DejaDupOperation*) _tmp48_);
	_g_object_unref0 (((AssistantOperation*) self)->op);
	((AssistantOperation*) self)->op = _tmp49_;
	_tmp50_ = ((AssistantOperation*) self)->op;
	g_signal_connect_object (_tmp50_, "passphrase-required", (GCallback) _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required, (AssistantOperation*) self, 0);
	_tmp51_ = ((AssistantOperation*) self)->op;
	g_signal_connect_object (_tmp51_, "raise-error", (GCallback) ___lambda38__deja_dup_operation_raise_error, self, 0);
	_tmp52_ = ((AssistantOperation*) self)->op;
	_tmp53_ = ((AssistantRestore*) self)->op_state;
	deja_dup_operation_set_state (_tmp52_, _tmp53_);
	_tmp54_ = self->priv->query_op_files;
	deja_dup_operation_start ((DejaDupOperation*) _tmp54_, TRUE, NULL, NULL);
	_g_free0 (worddiff);
	_g_free0 (etime);
}


static void assistant_restore_missing_real_query_finished (AssistantRestore* base, DejaDupOperation* op, gboolean success, gboolean cancelled, const gchar* detail) {
	AssistantRestoreMissing * self;
	DejaDupOperation* _tmp0_ = NULL;
	DejaDupOperationState* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	self = (AssistantRestoreMissing*) base;
	g_return_if_fail (op != NULL);
	_g_object_unref0 (((AssistantRestore*) self)->query_op);
	((AssistantRestore*) self)->query_op = NULL;
	_tmp0_ = ((AssistantOperation*) self)->op;
	_tmp1_ = deja_dup_operation_get_state (_tmp0_);
	_deja_dup_operation_state_unref0 (((AssistantRestore*) self)->op_state);
	((AssistantRestore*) self)->op_state = _tmp1_;
	_g_object_unref0 (((AssistantOperation*) self)->op);
	((AssistantOperation*) self)->op = NULL;
	_tmp2_ = cancelled;
	if (_tmp2_) {
		assistant_operation_do_close ((AssistantOperation*) self);
	} else {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = success;
		if (_tmp3_) {
			assistant_restore_missing_do_query_files_at_date (self);
		}
	}
}


static void assistant_restore_missing_real_do_cancel (AssistantOperation* base) {
	AssistantRestoreMissing * self;
	self = (AssistantRestoreMissing*) base;
	self->priv->cancel_assistant = TRUE;
	ASSISTANT_OPERATION_CLASS (assistant_restore_missing_parent_class)->do_cancel ((AssistantOperation*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ASSISTANT_RESTORE, AssistantRestore));
}


static void assistant_restore_missing_real_apply_finished (AssistantOperation* base, DejaDupOperation* op, gboolean success, gboolean cancelled, const gchar* detail) {
	AssistantRestoreMissing * self;
	DejaDupOperation* _tmp0_ = NULL;
	DejaDupOperationState* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	self = (AssistantRestoreMissing*) base;
	g_return_if_fail (op != NULL);
	_tmp0_ = ((AssistantOperation*) self)->op;
	_tmp1_ = deja_dup_operation_get_state (_tmp0_);
	_deja_dup_operation_state_unref0 (((AssistantRestore*) self)->op_state);
	((AssistantRestore*) self)->op_state = _tmp1_;
	_g_object_unref0 (((AssistantOperation*) self)->op);
	((AssistantOperation*) self)->op = NULL;
	_tmp2_ = cancelled;
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = success;
		if (_tmp3_) {
			gtk_main_quit ();
		} else {
			assistant_operation_do_close ((AssistantOperation*) self);
		}
	} else {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = success;
		if (_tmp4_) {
			GList* _tmp5_ = NULL;
			((AssistantOperation*) self)->succeeded = TRUE;
			_tmp5_ = self->priv->restore_files_remaining;
			if (_tmp5_ != NULL) {
				assistant_operation_do_apply ((AssistantOperation*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ASSISTANT_RESTORE, AssistantRestore), NULL, NULL);
			} else {
				GtkWidget* _tmp6_ = NULL;
				GtkWidget* _tmp7_ = NULL;
				_tmp6_ = assistant_operation_get_summary_page ((AssistantOperation*) self);
				_tmp7_ = _tmp6_;
				assistant_go_to_page ((Assistant*) self, _tmp7_);
			}
		} else {
			assistant_operation_force_visible ((AssistantOperation*) self, FALSE);
		}
	}
}


void assistant_restore_missing_query_files_finished (AssistantRestoreMissing* self, DejaDupOperation* op, gboolean success, gboolean cancelled, const gchar* detail) {
	GSequence* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->query_op_files);
	self->priv->query_op_files = NULL;
	_g_object_unref0 (((AssistantOperation*) self)->op);
	((AssistantOperation*) self)->op = NULL;
	_tmp0_ = self->priv->backups_queue;
	_tmp1_ = g_sequence_get_length (_tmp0_);
	if (_tmp1_ == 0) {
		GtkSpinner* _tmp2_ = NULL;
		GtkSpinner* _tmp3_ = NULL;
		GtkLabel* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_tmp2_ = self->priv->spinner;
		gtk_spinner_stop (_tmp2_);
		_tmp3_ = self->priv->spinner;
		deja_dup_destroy_widget ((GtkWidget*) _tmp3_);
		_tmp4_ = self->priv->current_scan_date;
		_tmp5_ = _ ("Scanning finished");
		gtk_label_set_text (_tmp4_, _tmp5_);
		self->priv->scan_queue = FALSE;
	} else {
		gboolean _tmp6_ = FALSE;
		_tmp6_ = self->priv->scan_queue;
		if (_tmp6_) {
			assistant_restore_missing_do_query_files_at_date (self);
		}
	}
}


static DejaDupOperation* assistant_restore_missing_real_create_op (AssistantOperation* base) {
	AssistantRestoreMissing * self;
	DejaDupOperation* result = NULL;
	gboolean _tmp0_ = FALSE;
	GList* _tmp1_ = NULL;
	DeletedFile* restore_file = NULL;
	GHashTable* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	gconstpointer _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gconstpointer _tmp11_ = NULL;
	DeletedFile* _tmp12_ = NULL;
	DeletedFile* _tmp13_ = NULL;
	GList* _tmp14_ = NULL;
	GList* file_list = NULL;
	DeletedFile* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	GFile* _tmp18_ = NULL;
	DejaDupOperationRestore* rest_op = NULL;
	DeletedFile* _tmp19_ = NULL;
	struct tm _tmp20_ = {0};
	struct tm _tmp21_ = {0};
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	GList* _tmp24_ = NULL;
	DejaDupOperationRestore* _tmp25_ = NULL;
	DejaDupOperationRestore* _tmp26_ = NULL;
	DejaDupOperationRestore* _tmp27_ = NULL;
	DejaDupOperationState* _tmp28_ = NULL;
	self = (AssistantRestoreMissing*) base;
	gtk_widget_realize ((GtkWidget*) self);
	_tmp1_ = self->priv->restore_files_remaining;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GList* _tmp2_ = NULL;
		gconstpointer _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp2_ = self->priv->restore_files_remaining;
		_tmp3_ = _tmp2_->data;
		_tmp4_ = g_file_get_path ((GFile*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_ == NULL;
		_g_free0 (_tmp5_);
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp6_ = self->priv->allfiles_prev;
	_tmp7_ = self->priv->restore_files_remaining;
	_tmp8_ = _tmp7_->data;
	_tmp9_ = g_file_get_path ((GFile*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_hash_table_lookup (_tmp6_, _tmp10_);
	_tmp12_ = _deleted_file_ref0 ((DeletedFile*) _tmp11_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp10_);
	restore_file = _tmp13_;
	_tmp14_ = self->priv->restore_files_remaining;
	self->priv->restore_files_remaining = g_list_remove_link (self->priv->restore_files_remaining, _tmp14_);
	file_list = NULL;
	_tmp15_ = restore_file;
	_tmp16_ = deleted_file_get_name (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_file_new_for_path (_tmp17_);
	file_list = g_list_append (file_list, _tmp18_);
	_tmp19_ = restore_file;
	deleted_file_get_deleted (_tmp19_, &_tmp20_);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_time_format (&_tmp21_, "%s");
	_tmp23_ = _tmp22_;
	_tmp24_ = file_list;
	_tmp25_ = deja_dup_operation_restore_new ("/", _tmp23_, _tmp24_);
	_tmp26_ = _tmp25_;
	_g_free0 (_tmp23_);
	rest_op = _tmp26_;
	_tmp27_ = rest_op;
	_tmp28_ = ((AssistantRestore*) self)->op_state;
	deja_dup_operation_set_state ((DejaDupOperation*) _tmp27_, _tmp28_);
	result = (DejaDupOperation*) rest_op;
	__g_list_free__g_object_unref0_0 (file_list);
	_deleted_file_unref0 (restore_file);
	return result;
}


static void assistant_restore_missing_class_init (AssistantRestoreMissingClass * klass) {
	assistant_restore_missing_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AssistantRestoreMissingPrivate));
	((AssistantOperationClass *) klass)->add_custom_config_pages = assistant_restore_missing_real_add_custom_config_pages;
	((AssistantOperationClass *) klass)->add_setup_pages = assistant_restore_missing_real_add_setup_pages;
	((AssistantOperationClass *) klass)->do_prepare = assistant_restore_missing_real_do_prepare;
	((AssistantRestoreClass *) klass)->handle_collection_dates = assistant_restore_missing_real_handle_collection_dates;
	((AssistantRestoreClass *) klass)->query_finished = assistant_restore_missing_real_query_finished;
	((AssistantOperationClass *) klass)->do_cancel = assistant_restore_missing_real_do_cancel;
	((AssistantOperationClass *) klass)->apply_finished = assistant_restore_missing_real_apply_finished;
	((AssistantOperationClass *) klass)->create_op = assistant_restore_missing_real_create_op;
	G_OBJECT_CLASS (klass)->finalize = assistant_restore_missing_finalize;
}


static void assistant_restore_missing_instance_init (AssistantRestoreMissing * self) {
	GSequence* _tmp0_ = NULL;
	GtkSpinner* _tmp1_ = NULL;
	self->priv = ASSISTANT_RESTORE_MISSING_GET_PRIVATE (self);
	self->priv->backups_queue_filled = FALSE;
	self->priv->scan_queue = TRUE;
	self->priv->cancel_assistant = FALSE;
	_tmp0_ = g_sequence_new (_g_free0_);
	self->priv->backups_queue = _tmp0_;
	_tmp1_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp1_);
	self->priv->spinner = _tmp1_;
}


static void assistant_restore_missing_finalize (GObject* obj) {
	AssistantRestoreMissing * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ASSISTANT_RESTORE_MISSING, AssistantRestoreMissing);
	_g_object_unref0 (self->priv->list_directory);
	_g_sequence_free0 (self->priv->backups_queue);
	_g_hash_table_unref0 (self->priv->allfiles_prev);
	__g_list_free__g_object_unref0_0 (self->priv->restore_files_remaining);
	_g_object_unref0 (self->priv->query_op_files);
	_g_object_unref0 (self->priv->listfiles_page);
	_g_object_unref0 (self->priv->listmodel);
	_g_object_unref0 (self->priv->list_dir_label);
	_g_object_unref0 (self->priv->current_scan_date);
	_g_object_unref0 (self->priv->spinner);
	G_OBJECT_CLASS (assistant_restore_missing_parent_class)->finalize (obj);
}


GType assistant_restore_missing_get_type (void) {
	static volatile gsize assistant_restore_missing_type_id__volatile = 0;
	if (g_once_init_enter (&assistant_restore_missing_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AssistantRestoreMissingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assistant_restore_missing_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssistantRestoreMissing), 0, (GInstanceInitFunc) assistant_restore_missing_instance_init, NULL };
		GType assistant_restore_missing_type_id;
		assistant_restore_missing_type_id = g_type_register_static (TYPE_ASSISTANT_RESTORE, "AssistantRestoreMissing", &g_define_type_info, 0);
		g_once_init_leave (&assistant_restore_missing_type_id__volatile, assistant_restore_missing_type_id);
	}
	return assistant_restore_missing_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



