; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11,SDAG-GFX11,SDAG-GFX11-TRUE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11,SDAG-GFX11,SDAG-GFX11-FAKE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX9,SDAG-GFX9 %s
; RUN: llc -mtriple=amdgcn -mcpu=fiji -verify-machineinstrs < %s | FileCheck -check-prefixes=VI,SDAG-VI %s
; RUN: llc -mtriple=amdgcn -mcpu=hawaii -verify-machineinstrs < %s | FileCheck -check-prefixes=SDAG-CI %s

; FIXME-TRUE16. fix gisel
; XUN: llc -global-isel -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11,GISEL-GFX11,GISEL-GFX11-TRUE16 %s
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11,GISEL-GFX11,GISEL-GFX11-FAKE16 %s
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX9,GISEL-GFX9 %s
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=fiji -verify-machineinstrs < %s | FileCheck -check-prefixes=VI,GISEL-VI %s
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=hawaii -verify-machineinstrs < %s | FileCheck -check-prefixes=GISEL-CI %s

define <2 x half> @v_mad_mixhi_f16_f16lo_f16lo_f16lo_undeflo(half %src0, half %src1, half %src2) #0 {
; GFX11-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_undeflo:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_fma_mixhi_f16 v0, v0, v1, v2 op_sel_hi:[1,1,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_undeflo:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mad_mixhi_f16 v0, v0, v1, v2 op_sel_hi:[1,1,1]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_undeflo:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; VI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; VI-NEXT:    v_mac_f32_e32 v2, v0, v1
; VI-NEXT:    v_cvt_f16_f32_sdwa v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-CI-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_undeflo:
; SDAG-CI:       ; %bb.0:
; SDAG-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-CI-NEXT:    v_mac_f32_e32 v2, v0, v1
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v1, v0
; SDAG-CI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-CI-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_undeflo:
; GISEL-CI:       ; %bb.0:
; GISEL-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GISEL-CI-NEXT:    v_mac_f32_e32 v2, v0, v1
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v2
; GISEL-CI-NEXT:    s_setpc_b64 s[30:31]
  %src0.ext = fpext half %src0 to float
  %src1.ext = fpext half %src1 to float
  %src2.ext = fpext half %src2 to float
  %result = tail call float @llvm.fmuladd.f32(float %src0.ext, float %src1.ext, float %src2.ext)
  %cvt.result = fptrunc float %result to half
  %vec.result = insertelement <2 x half> poison, half %cvt.result, i32 1
  ret <2 x half> %vec.result
}

define <2 x half> @v_mad_mixhi_f16_f16lo_f16lo_f16lo_constlo(half %src0, half %src1, half %src2) #0 {
; SDAG-GFX11-TRUE16-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_constlo:
; SDAG-GFX11-TRUE16:       ; %bb.0:
; SDAG-GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-GFX11-TRUE16-NEXT:    v_mov_b16_e32 v3.l, 0x3c00
; SDAG-GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; SDAG-GFX11-TRUE16-NEXT:    v_fma_mixhi_f16 v3, v0, v1, v2 op_sel_hi:[1,1,1]
; SDAG-GFX11-TRUE16-NEXT:    v_mov_b32_e32 v0, v3
; SDAG-GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-GFX11-FAKE16-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_constlo:
; SDAG-GFX11-FAKE16:       ; %bb.0:
; SDAG-GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-GFX11-FAKE16-NEXT:    v_mov_b32_e32 v3, 0x3c00
; SDAG-GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; SDAG-GFX11-FAKE16-NEXT:    v_fma_mixhi_f16 v3, v0, v1, v2 op_sel_hi:[1,1,1]
; SDAG-GFX11-FAKE16-NEXT:    v_mov_b32_e32 v0, v3
; SDAG-GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_constlo:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v3, 0x3c00
; GFX9-NEXT:    v_mad_mixhi_f16 v3, v0, v1, v2 op_sel_hi:[1,1,1]
; GFX9-NEXT:    v_mov_b32_e32 v0, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_constlo:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; VI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; VI-NEXT:    v_mac_f32_e32 v2, v0, v1
; VI-NEXT:    v_cvt_f16_f32_sdwa v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, 0x3c00, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-CI-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_constlo:
; SDAG-CI:       ; %bb.0:
; SDAG-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-CI-NEXT:    v_mac_f32_e32 v2, v0, v1
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v1, v0
; SDAG-CI-NEXT:    v_mov_b32_e32 v0, 1.0
; SDAG-CI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-GFX11-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_constlo:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v3, 0x3c00
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_fma_mixhi_f16 v3, v0, v1, v2 op_sel_hi:[1,1,1]
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GISEL-GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-CI-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_constlo:
; GISEL-CI:       ; %bb.0:
; GISEL-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GISEL-CI-NEXT:    v_mac_f32_e32 v2, v0, v1
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v2
; GISEL-CI-NEXT:    v_mov_b32_e32 v0, 0x3c00
; GISEL-CI-NEXT:    s_setpc_b64 s[30:31]
  %src0.ext = fpext half %src0 to float
  %src1.ext = fpext half %src1 to float
  %src2.ext = fpext half %src2 to float
  %result = tail call float @llvm.fmuladd.f32(float %src0.ext, float %src1.ext, float %src2.ext)
  %cvt.result = fptrunc float %result to half
  %vec.result = insertelement <2 x half> <half 1.0, half poison>, half %cvt.result, i32 1
  ret <2 x half> %vec.result
}

define <2 x half> @v_mad_mixhi_f16_f16lo_f16lo_f16lo_reglo(half %src0, half %src1, half %src2, half %lo) #0 {
; GFX11-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_reglo:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_fma_mixhi_f16 v3, v0, v1, v2 op_sel_hi:[1,1,1]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_reglo:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mad_mixhi_f16 v3, v0, v1, v2 op_sel_hi:[1,1,1]
; GFX9-NEXT:    v_mov_b32_e32 v0, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_reglo:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; VI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; VI-NEXT:    v_mac_f32_e32 v2, v0, v1
; VI-NEXT:    v_cvt_f16_f32_sdwa v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-CI-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_reglo:
; SDAG-CI:       ; %bb.0:
; SDAG-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-CI-NEXT:    v_mac_f32_e32 v2, v0, v1
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v1, v0
; SDAG-CI-NEXT:    v_mov_b32_e32 v0, v3
; SDAG-CI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-CI-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_reglo:
; GISEL-CI:       ; %bb.0:
; GISEL-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GISEL-CI-NEXT:    v_mac_f32_e32 v2, v0, v1
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v2
; GISEL-CI-NEXT:    v_mov_b32_e32 v0, v3
; GISEL-CI-NEXT:    s_setpc_b64 s[30:31]
  %src0.ext = fpext half %src0 to float
  %src1.ext = fpext half %src1 to float
  %src2.ext = fpext half %src2 to float
  %result = tail call float @llvm.fmuladd.f32(float %src0.ext, float %src1.ext, float %src2.ext)
  %cvt.result = fptrunc float %result to half
  %vec = insertelement <2 x half> poison, half %lo, i32 0
  %vec.result = insertelement <2 x half> %vec, half %cvt.result, i32 1
  ret <2 x half> %vec.result
}

define i32 @v_mad_mixhi_f16_f16lo_f16lo_f16lo_intpack(half %src0, half %src1, half %src2) #0 {
; SDAG-GFX11-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_intpack:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_fma_mixlo_f16 v0, v0, v1, v2 op_sel_hi:[1,1,1]
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SDAG-GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-GFX9-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_intpack:
; SDAG-GFX9:       ; %bb.0:
; SDAG-GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-GFX9-NEXT:    v_mad_mixlo_f16 v0, v0, v1, v2 op_sel_hi:[1,1,1]
; SDAG-GFX9-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SDAG-GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_intpack:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; VI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; VI-NEXT:    v_mac_f32_e32 v2, v0, v1
; VI-NEXT:    v_cvt_f16_f32_sdwa v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-CI-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_intpack:
; SDAG-CI:       ; %bb.0:
; SDAG-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-CI-NEXT:    v_mac_f32_e32 v2, v0, v1
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; SDAG-CI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SDAG-CI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-GFX11-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_intpack:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_fma_mixlo_f16 v0, v0, v1, v2 op_sel_hi:[1,1,1]
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GISEL-GFX11-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GISEL-GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-GFX9-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_intpack:
; GISEL-GFX9:       ; %bb.0:
; GISEL-GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-GFX9-NEXT:    v_mad_mixlo_f16 v0, v0, v1, v2 op_sel_hi:[1,1,1]
; GISEL-GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GISEL-GFX9-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GISEL-GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-CI-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_intpack:
; GISEL-CI:       ; %bb.0:
; GISEL-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GISEL-CI-NEXT:    v_mac_f32_e32 v2, v0, v1
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; GISEL-CI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GISEL-CI-NEXT:    s_setpc_b64 s[30:31]
  %src0.ext = fpext half %src0 to float
  %src1.ext = fpext half %src1 to float
  %src2.ext = fpext half %src2 to float
  %result = tail call float @llvm.fmuladd.f32(float %src0.ext, float %src1.ext, float %src2.ext)
  %cvt.result = fptrunc float %result to half
  %bc = bitcast half %cvt.result to i16
  %ext = zext i16 %bc to i32
  %shr = shl i32 %ext, 16
  ret i32 %shr
}

define i32 @v_mad_mixhi_f16_f16lo_f16lo_f16lo_intpack_sext(half %src0, half %src1, half %src2) #0 {
; SDAG-GFX11-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_intpack_sext:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-GFX11-NEXT:    v_fma_mixlo_f16 v0, v0, v1, v2 op_sel_hi:[1,1,1]
; SDAG-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; SDAG-GFX11-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SDAG-GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-GFX9-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_intpack_sext:
; SDAG-GFX9:       ; %bb.0:
; SDAG-GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-GFX9-NEXT:    v_mad_mixlo_f16 v0, v0, v1, v2 op_sel_hi:[1,1,1]
; SDAG-GFX9-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SDAG-GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-VI-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_intpack_sext:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SDAG-VI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SDAG-VI-NEXT:    v_mac_f32_e32 v2, v0, v1
; SDAG-VI-NEXT:    v_cvt_f16_f32_sdwa v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; SDAG-VI-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-CI-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_intpack_sext:
; SDAG-CI:       ; %bb.0:
; SDAG-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-CI-NEXT:    v_mac_f32_e32 v2, v0, v1
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; SDAG-CI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SDAG-CI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-GFX11-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_intpack_sext:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_fma_mixlo_f16 v0, v0, v1, v2 op_sel_hi:[1,1,1]
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GISEL-GFX11-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GISEL-GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-GFX9-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_intpack_sext:
; GISEL-GFX9:       ; %bb.0:
; GISEL-GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-GFX9-NEXT:    v_mad_mixlo_f16 v0, v0, v1, v2 op_sel_hi:[1,1,1]
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v1, 16
; GISEL-GFX9-NEXT:    v_lshlrev_b32_sdwa v0, v1, sext(v0) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GISEL-GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-VI-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_intpack_sext:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-VI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GISEL-VI-NEXT:    v_mac_f32_e32 v2, v0, v1
; GISEL-VI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, 16
; GISEL-VI-NEXT:    v_lshlrev_b32_sdwa v0, v1, sext(v0) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GISEL-VI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-CI-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_intpack_sext:
; GISEL-CI:       ; %bb.0:
; GISEL-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GISEL-CI-NEXT:    v_mac_f32_e32 v2, v0, v1
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; GISEL-CI-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GISEL-CI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GISEL-CI-NEXT:    s_setpc_b64 s[30:31]
  %src0.ext = fpext half %src0 to float
  %src1.ext = fpext half %src1 to float
  %src2.ext = fpext half %src2 to float
  %result = tail call float @llvm.fmuladd.f32(float %src0.ext, float %src1.ext, float %src2.ext)
  %cvt.result = fptrunc float %result to half
  %bc = bitcast half %cvt.result to i16
  %ext = sext i16 %bc to i32
  %shr = shl i32 %ext, 16
  ret i32 %shr
}

define <2 x half> @v_mad_mixhi_f16_f16lo_f16lo_f16lo_undeflo_clamp_precvt(half %src0, half %src1, half %src2) #0 {
; SDAG-GFX11-TRUE16-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_undeflo_clamp_precvt:
; SDAG-GFX11-TRUE16:       ; %bb.0:
; SDAG-GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-GFX11-TRUE16-NEXT:    v_fma_mix_f32 v0, v0, v1, v2 op_sel_hi:[1,1,1] clamp
; SDAG-GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; SDAG-GFX11-TRUE16-NEXT:    v_cvt_f16_f32_e32 v0.l, v0
; SDAG-GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SDAG-GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-GFX11-FAKE16-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_undeflo_clamp_precvt:
; SDAG-GFX11-FAKE16:       ; %bb.0:
; SDAG-GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-GFX11-FAKE16-NEXT:    v_fma_mix_f32 v0, v0, v1, v2 op_sel_hi:[1,1,1] clamp
; SDAG-GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; SDAG-GFX11-FAKE16-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SDAG-GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SDAG-GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_undeflo_clamp_precvt:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mad_mix_f32 v0, v0, v1, v2 op_sel_hi:[1,1,1] clamp
; GFX9-NEXT:    v_cvt_f16_f32_sdwa v0, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_undeflo_clamp_precvt:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; VI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; VI-NEXT:    v_mad_f32 v0, v0, v1, v2 clamp
; VI-NEXT:    v_cvt_f16_f32_sdwa v0, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-CI-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_undeflo_clamp_precvt:
; SDAG-CI:       ; %bb.0:
; SDAG-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-CI-NEXT:    v_mad_f32 v0, v0, v1, v2 clamp
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SDAG-CI-NEXT:    v_cvt_f32_f16_e32 v1, v0
; SDAG-CI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-GFX11-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_undeflo_clamp_precvt:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-GFX11-NEXT:    v_fma_mix_f32 v0, v0, v1, v2 op_sel_hi:[1,1,1] clamp
; GISEL-GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GISEL-GFX11-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GISEL-GFX11-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GISEL-GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-CI-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_undeflo_clamp_precvt:
; GISEL-CI:       ; %bb.0:
; GISEL-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GISEL-CI-NEXT:    v_mad_f32 v0, v0, v1, v2 clamp
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v0
; GISEL-CI-NEXT:    s_setpc_b64 s[30:31]
  %src0.ext = fpext half %src0 to float
  %src1.ext = fpext half %src1 to float
  %src2.ext = fpext half %src2 to float
  %result = tail call float @llvm.fmuladd.f32(float %src0.ext, float %src1.ext, float %src2.ext)
  %max = call float @llvm.maxnum.f32(float %result, float 0.0)
  %clamp = call float @llvm.minnum.f32(float %max, float 1.0)
  %cvt.result = fptrunc float %clamp to half
  %vec.result = insertelement <2 x half> poison, half %cvt.result, i32 1
  ret <2 x half> %vec.result
}

define <2 x half> @v_mad_mixhi_f16_f16lo_f16lo_f16lo_undeflo_clamp_postcvt(half %src0, half %src1, half %src2) #0 {
; GFX11-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_undeflo_clamp_postcvt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_fma_mixhi_f16 v0, v0, v1, v2 op_sel_hi:[1,1,1] clamp
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_undeflo_clamp_postcvt:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mad_mixhi_f16 v0, v0, v1, v2 op_sel_hi:[1,1,1] clamp
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_undeflo_clamp_postcvt:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; VI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; VI-NEXT:    v_mac_f32_e32 v2, v0, v1
; VI-NEXT:    v_cvt_f16_f32_sdwa v0, v2 clamp dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-CI-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_undeflo_clamp_postcvt:
; SDAG-CI:       ; %bb.0:
; SDAG-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-CI-NEXT:    v_mac_f32_e32 v2, v0, v1
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; SDAG-CI-NEXT:    v_cvt_f32_f16_e64 v1, v0 clamp
; SDAG-CI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-CI-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_undeflo_clamp_postcvt:
; GISEL-CI:       ; %bb.0:
; GISEL-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GISEL-CI-NEXT:    v_mac_f32_e32 v2, v0, v1
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, 0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_max_f32_e32 v0, v0, v1
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, 1.0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_min_f32_e32 v0, v0, v1
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v0
; GISEL-CI-NEXT:    s_setpc_b64 s[30:31]
  %src0.ext = fpext half %src0 to float
  %src1.ext = fpext half %src1 to float
  %src2.ext = fpext half %src2 to float
  %result = tail call float @llvm.fmuladd.f32(float %src0.ext, float %src1.ext, float %src2.ext)
  %cvt.result = fptrunc float %result to half
  %max = call half @llvm.maxnum.f16(half %cvt.result, half 0.0)
  %clamp = call half @llvm.minnum.f16(half %max, half 1.0)
  %vec.result = insertelement <2 x half> poison, half %clamp, i32 1
  ret <2 x half> %vec.result
}

define <2 x half> @v_mad_mixhi_f16_f16lo_f16lo_f16lo_undeflo_clamp_postcvt_multi_use(half %src0, half %src1, half %src2) #0 {
; GFX11-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_undeflo_clamp_postcvt_multi_use:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_fma_mixlo_f16 v3, v0, v1, v2 op_sel_hi:[1,1,1]
; GFX11-NEXT:    v_fma_mixhi_f16 v0, v0, v1, v2 op_sel_hi:[1,1,1] clamp
; GFX11-NEXT:    global_store_b16 v[0:1], v3, off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_undeflo_clamp_postcvt_multi_use:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mad_mixlo_f16 v3, v0, v1, v2 op_sel_hi:[1,1,1]
; GFX9-NEXT:    global_store_short v[0:1], v3, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mad_mixhi_f16 v0, v0, v1, v2 op_sel_hi:[1,1,1] clamp
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_undeflo_clamp_postcvt_multi_use:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; VI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; VI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; VI-NEXT:    v_mac_f32_e32 v2, v0, v1
; VI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; VI-NEXT:    flat_store_short v[0:1], v0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_max_f16_sdwa v0, v0, v0 clamp dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; SDAG-CI-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_undeflo_clamp_postcvt_multi_use:
; SDAG-CI:       ; %bb.0:
; SDAG-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SDAG-CI-NEXT:    v_mac_f32_e32 v2, v0, v1
; SDAG-CI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; SDAG-CI-NEXT:    s_mov_b32 s7, 0xf000
; SDAG-CI-NEXT:    s_mov_b32 s6, -1
; SDAG-CI-NEXT:    v_cvt_f32_f16_e64 v1, v0 clamp
; SDAG-CI-NEXT:    buffer_store_short v0, off, s[4:7], 0
; SDAG-CI-NEXT:    s_waitcnt vmcnt(0)
; SDAG-CI-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-CI-LABEL: v_mad_mixhi_f16_f16lo_f16lo_f16lo_undeflo_clamp_postcvt_multi_use:
; GISEL-CI:       ; %bb.0:
; GISEL-CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GISEL-CI-NEXT:    s_mov_b32 s6, -1
; GISEL-CI-NEXT:    s_mov_b32 s7, 0xf000
; GISEL-CI-NEXT:    v_mac_f32_e32 v2, v0, v1
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v0, v2
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, 0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GISEL-CI-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GISEL-CI-NEXT:    s_waitcnt vmcnt(0)
; GISEL-CI-NEXT:    v_max_f32_e32 v1, v2, v1
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v2, 1.0
; GISEL-CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GISEL-CI-NEXT:    v_min_f32_e32 v1, v1, v2
; GISEL-CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GISEL-CI-NEXT:    s_setpc_b64 s[30:31]
  %src0.ext = fpext half %src0 to float
  %src1.ext = fpext half %src1 to float
  %src2.ext = fpext half %src2 to float
  %result = tail call float @llvm.fmuladd.f32(float %src0.ext, float %src1.ext, float %src2.ext)
  %cvt.result = fptrunc float %result to half
  store volatile half %cvt.result, ptr addrspace(1) poison
  %max = call half @llvm.maxnum.f16(half %cvt.result, half 0.0)
  %clamp = call half @llvm.minnum.f16(half %max, half 1.0)
  %vec.result = insertelement <2 x half> poison, half %clamp, i32 1
  ret <2 x half> %vec.result
}

declare half @llvm.minnum.f16(half, half) #1
declare half @llvm.maxnum.f16(half, half) #1
declare float @llvm.minnum.f32(float, float) #1
declare float @llvm.maxnum.f32(float, float) #1
declare float @llvm.fmuladd.f32(float, float, float) #1
declare <2 x float> @llvm.fmuladd.v2f32(<2 x float>, <2 x float>, <2 x float>) #1

attributes #0 = { nounwind "denormal-fp-math-f32"="preserve-sign,preserve-sign" }
attributes #1 = { nounwind readnone speculatable }
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GISEL-GFX11-FAKE16: {{.*}}
