/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(TOUCH_EVENTS)

#include "JSTouchEvent.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMWindow.h"
#include "JSTouchList.h"
#include "TouchEvent.h"
#include "TouchList.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSTouchEventTableValues[] =
{
    { "touches", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEventTouches), (intptr_t)0, NoIntrinsic },
    { "targetTouches", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEventTargetTouches), (intptr_t)0, NoIntrinsic },
    { "changedTouches", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEventChangedTouches), (intptr_t)0, NoIntrinsic },
    { "ctrlKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEventCtrlKey), (intptr_t)0, NoIntrinsic },
    { "shiftKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEventShiftKey), (intptr_t)0, NoIntrinsic },
    { "altKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEventAltKey), (intptr_t)0, NoIntrinsic },
    { "metaKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEventMetaKey), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTouchEventTable = { 19, 15, JSTouchEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSTouchEventConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTouchEventConstructorTable = { 1, 0, JSTouchEventConstructorTableValues, 0 };
const ClassInfo JSTouchEventConstructor::s_info = { "TouchEventConstructor", &Base::s_info, &JSTouchEventConstructorTable, 0, CREATE_METHOD_TABLE(JSTouchEventConstructor) };

JSTouchEventConstructor::JSTouchEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSTouchEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSTouchEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSTouchEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTouchEventConstructor, JSDOMWrapper>(exec, &JSTouchEventConstructorTable, jsCast<JSTouchEventConstructor*>(cell), propertyName, slot);
}

bool JSTouchEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSTouchEventConstructor, JSDOMWrapper>(exec, &JSTouchEventConstructorTable, jsCast<JSTouchEventConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSTouchEventPrototypeTableValues[] =
{
    { "initTouchEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTouchEventPrototypeFunctionInitTouchEvent), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTouchEventPrototypeTable = { 2, 1, JSTouchEventPrototypeTableValues, 0 };
const ClassInfo JSTouchEventPrototype::s_info = { "TouchEventPrototype", &Base::s_info, &JSTouchEventPrototypeTable, 0, CREATE_METHOD_TABLE(JSTouchEventPrototype) };

JSObject* JSTouchEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTouchEvent>(exec, globalObject);
}

bool JSTouchEventPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSTouchEventPrototype* thisObject = jsCast<JSTouchEventPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSTouchEventPrototypeTable, thisObject, propertyName, slot);
}

bool JSTouchEventPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSTouchEventPrototype* thisObject = jsCast<JSTouchEventPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSTouchEventPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSTouchEvent::s_info = { "TouchEvent", &Base::s_info, &JSTouchEventTable, 0 , CREATE_METHOD_TABLE(JSTouchEvent) };

JSTouchEvent::JSTouchEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<TouchEvent> impl)
    : JSUIEvent(structure, globalObject, impl)
{
}

void JSTouchEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSTouchEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSTouchEventPrototype::create(exec->vm(), globalObject, JSTouchEventPrototype::createStructure(exec->vm(), globalObject, JSUIEventPrototype::self(exec, globalObject)));
}

bool JSTouchEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSTouchEvent* thisObject = jsCast<JSTouchEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSTouchEvent, Base>(exec, &JSTouchEventTable, thisObject, propertyName, slot);
}

bool JSTouchEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSTouchEvent* thisObject = jsCast<JSTouchEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSTouchEvent, Base>(exec, &JSTouchEventTable, thisObject, propertyName, descriptor);
}

JSValue jsTouchEventTouches(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTouchEvent* castedThis = jsCast<JSTouchEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TouchEvent* impl = static_cast<TouchEvent*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->touches()));
    return result;
}


JSValue jsTouchEventTargetTouches(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTouchEvent* castedThis = jsCast<JSTouchEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TouchEvent* impl = static_cast<TouchEvent*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->targetTouches()));
    return result;
}


JSValue jsTouchEventChangedTouches(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTouchEvent* castedThis = jsCast<JSTouchEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TouchEvent* impl = static_cast<TouchEvent*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->changedTouches()));
    return result;
}


JSValue jsTouchEventCtrlKey(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTouchEvent* castedThis = jsCast<JSTouchEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TouchEvent* impl = static_cast<TouchEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->ctrlKey());
    return result;
}


JSValue jsTouchEventShiftKey(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTouchEvent* castedThis = jsCast<JSTouchEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TouchEvent* impl = static_cast<TouchEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->shiftKey());
    return result;
}


JSValue jsTouchEventAltKey(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTouchEvent* castedThis = jsCast<JSTouchEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TouchEvent* impl = static_cast<TouchEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->altKey());
    return result;
}


JSValue jsTouchEventMetaKey(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTouchEvent* castedThis = jsCast<JSTouchEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TouchEvent* impl = static_cast<TouchEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->metaKey());
    return result;
}


JSValue jsTouchEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTouchEvent* domObject = jsCast<JSTouchEvent*>(asObject(slotBase));
    return JSTouchEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSTouchEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTouchEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsTouchEventPrototypeFunctionInitTouchEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTouchEvent::s_info))
        return throwVMTypeError(exec);
    JSTouchEvent* castedThis = jsCast<JSTouchEvent*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTouchEvent::s_info);
    TouchEvent* impl = static_cast<TouchEvent*>(castedThis->impl());
    TouchList* touches(toTouchList(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    TouchList* targetTouches(toTouchList(exec->argument(1)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    TouchList* changedTouches(toTouchList(exec->argument(2)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& type(exec->argument(3).isEmpty() ? String() : exec->argument(3).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    DOMWindow* view(toDOMWindow(exec->argument(4)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int screenX(toInt32(exec, exec->argument(5), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int screenY(toInt32(exec, exec->argument(6), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int clientX(toInt32(exec, exec->argument(7), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int clientY(toInt32(exec, exec->argument(8), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool ctrlKey(exec->argument(9).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool altKey(exec->argument(10).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool shiftKey(exec->argument(11).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool metaKey(exec->argument(12).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->initTouchEvent(touches, targetTouches, changedTouches, type, view, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey);
    return JSValue::encode(jsUndefined());
}


}

#endif // ENABLE(TOUCH_EVENTS)
