/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(TOUCH_EVENTS)

#include "JSTouch.h"

#include "EventTarget.h"
#include "JSEventTarget.h"
#include "Touch.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSTouchTableValues[] =
{
    { "clientX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchClientX), (intptr_t)0, NoIntrinsic },
    { "clientY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchClientY), (intptr_t)0, NoIntrinsic },
    { "screenX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchScreenX), (intptr_t)0, NoIntrinsic },
    { "screenY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchScreenY), (intptr_t)0, NoIntrinsic },
    { "pageX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchPageX), (intptr_t)0, NoIntrinsic },
    { "pageY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchPageY), (intptr_t)0, NoIntrinsic },
    { "target", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchTarget), (intptr_t)0, NoIntrinsic },
    { "identifier", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchIdentifier), (intptr_t)0, NoIntrinsic },
    { "webkitRadiusX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchWebkitRadiusX), (intptr_t)0, NoIntrinsic },
    { "webkitRadiusY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchWebkitRadiusY), (intptr_t)0, NoIntrinsic },
    { "webkitRotationAngle", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchWebkitRotationAngle), (intptr_t)0, NoIntrinsic },
    { "webkitForce", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchWebkitForce), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTouchTable = { 33, 31, JSTouchTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSTouchConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTouchConstructorTable = { 1, 0, JSTouchConstructorTableValues, 0 };
const ClassInfo JSTouchConstructor::s_info = { "TouchConstructor", &Base::s_info, &JSTouchConstructorTable, 0, CREATE_METHOD_TABLE(JSTouchConstructor) };

JSTouchConstructor::JSTouchConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSTouchConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSTouchPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSTouchConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTouchConstructor, JSDOMWrapper>(exec, &JSTouchConstructorTable, jsCast<JSTouchConstructor*>(cell), propertyName, slot);
}

bool JSTouchConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSTouchConstructor, JSDOMWrapper>(exec, &JSTouchConstructorTable, jsCast<JSTouchConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSTouchPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTouchPrototypeTable = { 1, 0, JSTouchPrototypeTableValues, 0 };
const ClassInfo JSTouchPrototype::s_info = { "TouchPrototype", &Base::s_info, &JSTouchPrototypeTable, 0, CREATE_METHOD_TABLE(JSTouchPrototype) };

JSObject* JSTouchPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTouch>(exec, globalObject);
}

const ClassInfo JSTouch::s_info = { "Touch", &Base::s_info, &JSTouchTable, 0 , CREATE_METHOD_TABLE(JSTouch) };

JSTouch::JSTouch(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Touch> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSTouch::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSTouch::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSTouchPrototype::create(exec->vm(), globalObject, JSTouchPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSTouch::destroy(JSC::JSCell* cell)
{
    JSTouch* thisObject = static_cast<JSTouch*>(cell);
    thisObject->JSTouch::~JSTouch();
}

JSTouch::~JSTouch()
{
    releaseImplIfNotNull();
}

bool JSTouch::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSTouch* thisObject = jsCast<JSTouch*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSTouch, Base>(exec, &JSTouchTable, thisObject, propertyName, slot);
}

bool JSTouch::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSTouch* thisObject = jsCast<JSTouch*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSTouch, Base>(exec, &JSTouchTable, thisObject, propertyName, descriptor);
}

JSValue jsTouchClientX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTouch* castedThis = jsCast<JSTouch*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Touch* impl = static_cast<Touch*>(castedThis->impl());
    JSValue result = jsNumber(impl->clientX());
    return result;
}


JSValue jsTouchClientY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTouch* castedThis = jsCast<JSTouch*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Touch* impl = static_cast<Touch*>(castedThis->impl());
    JSValue result = jsNumber(impl->clientY());
    return result;
}


JSValue jsTouchScreenX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTouch* castedThis = jsCast<JSTouch*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Touch* impl = static_cast<Touch*>(castedThis->impl());
    JSValue result = jsNumber(impl->screenX());
    return result;
}


JSValue jsTouchScreenY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTouch* castedThis = jsCast<JSTouch*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Touch* impl = static_cast<Touch*>(castedThis->impl());
    JSValue result = jsNumber(impl->screenY());
    return result;
}


JSValue jsTouchPageX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTouch* castedThis = jsCast<JSTouch*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Touch* impl = static_cast<Touch*>(castedThis->impl());
    JSValue result = jsNumber(impl->pageX());
    return result;
}


JSValue jsTouchPageY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTouch* castedThis = jsCast<JSTouch*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Touch* impl = static_cast<Touch*>(castedThis->impl());
    JSValue result = jsNumber(impl->pageY());
    return result;
}


JSValue jsTouchTarget(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTouch* castedThis = jsCast<JSTouch*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Touch* impl = static_cast<Touch*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->target()));
    return result;
}


JSValue jsTouchIdentifier(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTouch* castedThis = jsCast<JSTouch*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Touch* impl = static_cast<Touch*>(castedThis->impl());
    JSValue result = jsNumber(impl->identifier());
    return result;
}


JSValue jsTouchWebkitRadiusX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTouch* castedThis = jsCast<JSTouch*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Touch* impl = static_cast<Touch*>(castedThis->impl());
    JSValue result = jsNumber(impl->webkitRadiusX());
    return result;
}


JSValue jsTouchWebkitRadiusY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTouch* castedThis = jsCast<JSTouch*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Touch* impl = static_cast<Touch*>(castedThis->impl());
    JSValue result = jsNumber(impl->webkitRadiusY());
    return result;
}


JSValue jsTouchWebkitRotationAngle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTouch* castedThis = jsCast<JSTouch*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Touch* impl = static_cast<Touch*>(castedThis->impl());
    JSValue result = jsNumber(impl->webkitRotationAngle());
    return result;
}


JSValue jsTouchWebkitForce(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTouch* castedThis = jsCast<JSTouch*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Touch* impl = static_cast<Touch*>(castedThis->impl());
    JSValue result = jsNumber(impl->webkitForce());
    return result;
}


JSValue jsTouchConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTouch* domObject = jsCast<JSTouch*>(asObject(slotBase));
    return JSTouch::getConstructor(exec, domObject->globalObject());
}

JSValue JSTouch::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTouchConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSTouch* jsTouch)
{
    if (jsTouch->hasCustomProperties())
        return true;
    return false;
}

bool JSTouchOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSTouch* jsTouch = jsCast<JSTouch*>(handle.get().asCell());
    if (!isObservable(jsTouch))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSTouchOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSTouch* jsTouch = jsCast<JSTouch*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsTouch->impl(), jsTouch);
    jsTouch->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Touch* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSTouch>(exec, impl))
        return result;
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to Touch.
    COMPILE_ASSERT(!__is_polymorphic(Touch), Touch_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<Touch>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSTouch>(exec, globalObject, impl);
}

Touch* toTouch(JSC::JSValue value)
{
    return value.inherits(&JSTouch::s_info) ? jsCast<JSTouch*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(TOUCH_EVENTS)
