/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGPolylineElement.h"

#include "JSSVGPointList.h"
#include "SVGPointList.h"
#include "SVGPolylineElement.h"
#include <wtf/GetPtr.h>

#if ENABLE(SVG)
#include "JSSVGAnimatedBoolean.h"
#endif

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGPolylineElementTableValues[] =
{
    { "points", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolylineElementPoints), (intptr_t)0, NoIntrinsic },
    { "animatedPoints", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolylineElementAnimatedPoints), (intptr_t)0, NoIntrinsic },
#if ENABLE(SVG)
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolylineElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
#endif
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolylineElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPolylineElementTable = { 9, 7, JSSVGPolylineElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGPolylineElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPolylineElementConstructorTable = { 1, 0, JSSVGPolylineElementConstructorTableValues, 0 };
const ClassInfo JSSVGPolylineElementConstructor::s_info = { "SVGPolylineElementConstructor", &Base::s_info, &JSSVGPolylineElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGPolylineElementConstructor) };

JSSVGPolylineElementConstructor::JSSVGPolylineElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGPolylineElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGPolylineElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGPolylineElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPolylineElementConstructor, JSDOMWrapper>(exec, &JSSVGPolylineElementConstructorTable, jsCast<JSSVGPolylineElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGPolylineElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGPolylineElementConstructor, JSDOMWrapper>(exec, &JSSVGPolylineElementConstructorTable, jsCast<JSSVGPolylineElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGPolylineElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPolylineElementPrototypeTable = { 1, 0, JSSVGPolylineElementPrototypeTableValues, 0 };
const ClassInfo JSSVGPolylineElementPrototype::s_info = { "SVGPolylineElementPrototype", &Base::s_info, &JSSVGPolylineElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGPolylineElementPrototype) };

JSObject* JSSVGPolylineElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGPolylineElement>(exec, globalObject);
}

const ClassInfo JSSVGPolylineElement::s_info = { "SVGPolylineElement", &Base::s_info, &JSSVGPolylineElementTable, 0 , CREATE_METHOD_TABLE(JSSVGPolylineElement) };

JSSVGPolylineElement::JSSVGPolylineElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGPolylineElement> impl)
    : JSSVGGraphicsElement(structure, globalObject, impl)
{
}

void JSSVGPolylineElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGPolylineElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGPolylineElementPrototype::create(exec->vm(), globalObject, JSSVGPolylineElementPrototype::createStructure(exec->vm(), globalObject, JSSVGGraphicsElementPrototype::self(exec, globalObject)));
}

bool JSSVGPolylineElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGPolylineElement* thisObject = jsCast<JSSVGPolylineElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGPolylineElement, Base>(exec, &JSSVGPolylineElementTable, thisObject, propertyName, slot);
}

bool JSSVGPolylineElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGPolylineElement* thisObject = jsCast<JSSVGPolylineElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGPolylineElement, Base>(exec, &JSSVGPolylineElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGPolylineElementPoints(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolylineElement* castedThis = jsCast<JSSVGPolylineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPolylineElement* impl = static_cast<SVGPolylineElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(static_cast<SVGListPropertyTearOff<SVGPointList>*>(impl->points().get())));
    return result;
}


JSValue jsSVGPolylineElementAnimatedPoints(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolylineElement* castedThis = jsCast<JSSVGPolylineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPolylineElement* impl = static_cast<SVGPolylineElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(static_cast<SVGListPropertyTearOff<SVGPointList>*>(impl->animatedPoints().get())));
    return result;
}


#if ENABLE(SVG)
JSValue jsSVGPolylineElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolylineElement* castedThis = jsCast<JSSVGPolylineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPolylineElement* impl = static_cast<SVGPolylineElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}

#endif

JSValue jsSVGPolylineElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolylineElement* domObject = jsCast<JSSVGPolylineElement*>(asObject(slotBase));
    return JSSVGPolylineElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGPolylineElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPolylineElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG)
